
/* This file is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option) */
/* any later version. */

/* This file is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with GNU Emacs; see the file COPYING.  If not, write to */
/* the Free Software Foundation, Inc., 59 Temple Place - Suite 330, */
/* Boston, MA 02111-1307, USA. */

/* Copyright (C) 2004 California Digital Corporation */

/* $Id: object.h,v 1.4 2004/03/31 22:26:31 itz Exp $ */

#ifndef OBJECT_H_INCLUDED
#define OBJECT_H_INCLUDED

#include <inttypes.h>
#include <stdio.h>

struct ident
{
  char* name;
  int line;
  int column;
};

typedef struct ident ident_t;

struct enum_value
{
  ident_t* name;
  uint32_t value;
  struct enum_value* next;
};

typedef struct enum_value enum_value_t;

struct enumeration
{
  ident_t* name;
  enum_value_t* values;
  struct enumeration* next;
};

typedef struct enumeration enumeration_t;

struct bank
{
  ident_t* name;
  uint16_t address_port;
  uint16_t data_port;
  int length;
  struct bank* next;
};

typedef struct bank bank_t;

struct checksum;
typedef struct checksum checksum_t;

struct backpatch
{
  int filled;
  union
  {
    ident_t* name;
    bank_t* pbank;
    checksum_t* pchecksum;
    enumeration_t* penum;
  }
  u;
  struct backpatch* next;
};

typedef struct backpatch backpatch_t;

enum checksum_type
  {
    single_byte,
    low_first,
    high_first,
    ct_none = -1
  };

typedef enum checksum_type checksum_type_t;

struct checksum
{
  ident_t* name;
  backpatch_t bp_bank;
  int start;
  checksum_type_t type;
  struct checksum* next;
};

struct region
{
  ident_t* name;
  backpatch_t bp_bank;
  int start_byte;
  int byte_length;
  struct region* next;
};

typedef struct region region_t;

enum entry_type
  {
    reserved,
    numeric,
    enumtype,
    et_none = -1
  };

typedef enum entry_type entry_type_t;

struct cmentry
{
  ident_t* name;
  backpatch_t bp_bank;
  int start_bit;
  int bit_length;
  entry_type_t type;
  backpatch_t bp_enum;
  backpatch_t* pbp_checksums;
  struct cmentry* next;
};

typedef struct cmentry cmentry_t;

struct bios_info
{
  ident_t* name;
  char* vendor;
  char* version;
  char* date;
  struct bios_info* next;
};

typedef struct bios_info bios_info_t;

struct layout
{
  bios_info_t* compat;
  bank_t* banks;
  checksum_t* checksums;
  cmentry_t* entries;
  region_t* regions;
  enumeration_t* enums;
  void* tree;
};

typedef struct layout layout_t;

extern ident_t* maybe_insert_ident (void** tree, const char* name, int line, int column);

extern void analyze_layout (layout_t* lp);

extern cmentry_t* find_entry (char* name, layout_t* lp);

extern uint32_t lookup_value (cmentry_t* pe,  char* val_name, layout_t* lp);

extern void print_value (FILE* fp, cmentry_t* pe, uint32_t val, layout_t* lp);

#endif
