
/* This file is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option) */
/* any later version. */

/* This file is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with GNU Emacs; see the file COPYING.  If not, write to */
/* the Free Software Foundation, Inc., 59 Temple Place - Suite 330, */
/* Boston, MA 02111-1307, USA. */

/* Copyright (C) 2004 California Digital Corporation */
/* $Id: valuefile.c,v 1.8 2004/04/29 22:51:20 summerisle Exp $ */

#include "valuefile.h"
#include "regexp.h"

#ifdef HAVE_ERROR_H
#include <error.h>
#endif

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <regex.h>
#include <errno.h>

#if (!defined(strndup) && !defined(HAVE_STRNDUP))
extern char* strndup (const char* str, size_t size);
#endif

/* read_value_fp - given an open FILE pointer, read name/value pairs from it */
/* fp = FILE pointer to read from */
/* fname = file name for error reporting purposes */
/* return : singly linked list of name/value pairs */

value_pair_t*
read_value_fp (FILE* fp, char* fname)
{
  char* line;
  size_t size;
  value_pair_t* ppair;
  int lineno;

  line = NULL;
  ppair = NULL;
  lineno = 0;
  while (getline (&line, &size, fp) != EOF)
    {
      regmatch_t matches[3];

      lineno++;
      if (regexec (&blank_or_comment_regex, line, 3, matches, 0) == 0) continue;
      else if (regexec (&assignment_regex, line, 3, matches, 0) == 0)
        {
          value_pair_t* last;

          last = ppair;
          ppair = malloc (sizeof(value_pair_t));
          if (!ppair) error (1, errno, "read_value_fp");
          ppair->next = last;
          ppair->name = strndup (line + matches[1].rm_so,
                                 matches[1].rm_eo - matches[1].rm_so);
          ppair->value = strndup (line + matches[2].rm_so,
                                  matches[2].rm_eo - matches[2].rm_so);
          if (!ppair->name || !ppair->value) error (1, errno, "read_value_fp");
        }
      else
          error_at_line (1, 0, fname, lineno, "invalid line `%s'", line);
    }
  if (!feof (fp)) error (1, errno, "read_value_fp: %s", fname);
  if (line) free (line);
  return ppair;
}

/* read_value_file - given a file name (or "-" for stdin), read name/value pairs from it */
/* fname = file name to read from */
/* return : singly linked list of name/value pairs */

value_pair_t*
read_value_file (char* fname)
{
  FILE* fp;

  if (strcmp (fname, "-") == 0)
    return read_value_fp (stdin, "(standard input)");
  
  if (!(fp = fopen (fname, "r")))
    {
      error (0, errno, "read_value_file: %s", fname);
      return NULL;
    }
  else
    {
      value_pair_t* ppair;

      ppair = read_value_fp (fp, fname);
      fclose (fp);
      return ppair;
    }
}
