# 珍视社区和你的自由

\newpage
## 避免破坏性的妥协

> Copyright © 2008, 2009, 2014, 2015 理查德·斯托曼（Richard Stallman）。本文最早于 2008 年发表于 <http://gnu.org>

> 1983 年 9 月 27 日，我发起了一项计划，致力于创造一个完全自由的操作系统，它称作 GNU —— 意为 GNU 不是 Unix （GNU's Not Unix）。为了纪念 GNU 操作系统 25 周年，我写出了这篇文章，旨在阐述我们的社区怎样才能避开破坏性的妥协。除了避开这类妥协之外，您还可通过很多其他方式帮助 GNU 和自由软件。其中一条基本方式是以合作成员的身份加入自由软件基金会（FSF）[^compromise-1]。

自由软件运动致力于带来一场社会变革：让所有软件成为自由的[^compromise-2]，这样所有软件用户将获得自由，并且将会成为协作化社区的一部分。与之相反，任何一个非自由的程序赋予了其开发者凌驾于用户之上的不公权力。我们的目标是终结这种不公。

自由之路，路漫漫兮[^compromise-3]。这需要经历很多步骤，花费很多年的时间才能达到这样一种境地：软件用户拥有自由成为一种常态。这些步骤当中的一些可能会非常艰难，甚至需要为之付出一些牺牲。而其中有些步骤可能会变得简单，如果我们与其他拥有不同最终目标的人们达成某种妥协。

因此，自由软件基金会做出了一些妥协——甚至是重大妥协。例如，我们在 GNU 通用公共许可证（GNU GPL）第三版的专利提供条款中做出了妥协，使得主要的商业软件公司可以贡献并发布基于 GPL v3 的软件，并藉此将部分软件专利置于此条款的效力之下。

> 在生活中的另一个领域存在这样一种类似的观点，例如文章“‘Nudge’ Is Not Enough, It’s True. But We Already Knew That” [http://guardian.co.uk/commentisfree/2011/jul/19/nudge-
is-not-enough-behaviour-change](http://guardian.co.uk/commentisfree/2011/jul/19/nudge-is-not-enough-behaviour-change)（Jonathan Rowson，2011年7月19日）所指出的观点：除了温和的劝说，我们还需要态度和视角方面的转变。

GNU 宽通用公共许可证（GNU LGPL）的目的在于一种妥协，我们将它用于一些选定的自由程序库，以便允许将它们用于私有软件中。这是由于我们认为如果在法律层面禁止这样做只会迫使开发者转向使用私有程序库。我们在 GNU 软件中接受并安装某种代码使得它们能够与常见的私有软件协同工作，并且我们对这种行为以这样的方式进行描述和宣传，鼓励私有软件用户安装并使用 GNU 软件而不是相反。我们也会支持我们所认同的一些特定的运动，即使我们并不完全认同那些支持这些运动的组织。

但是，我们会坚决拒绝某些妥协，即使我们的社区中的很多其他人愿意做出这样的妥协。例如，我们仅仅支持并推广这样的 GNU/Linux 发行版[^compromise-4]：它们的发行策略不会在其中包含私有软件，也不会引导用户安装私有软件。支持并推广非自由的发行版将会是一种破坏性的妥协。

我们称某种妥协是破坏性的，如果从长期来看，它们将会对实现我们的终极目标起到反作用。这种破坏性的妥协可以发生在想法的层面，也可以发生在行动的层面。

在想法层面，破坏性的妥协将会增强而非削弱那些我们所致力于改变的不利条件。我们的最终目的是实现这样一种境地，即软件用户成为自由的。但是时至今日，大部分计算机用户甚至不认可“自由”是一件重要的事。他们仅仅重视“消费者”价值。也就是说，他们评估任何软件时，仅仅基于实践上的特性，诸如价格和易用性。

戴尔•卡耐基的经典自立书籍《怎样赢得朋友并且影响人们》（How to Win Friends and Influence People）所建议的说服某人做某事最有效的方式是提供那些满足对方价值观的论证。我们可以通过多种方式满足我们社会中典型的消费者价值观。很多自由软件也是兼具易用性与可靠性的。通过援引这些实践层面的好处，我们已经成功地说服诸多用户采纳多种自由软件，其中的一些已经大获成功。

但是，如果长远目标仅仅限于使更多的人使用某些自由软件，您可能会选择对“自由”这一概念保持沉默，并且将目光仅仅集中在那些实践上对消费者价值有意义的好处上。而这正是“开源”这一概念以及与之关联的一些术语所处的状态。

然而，这样一条路径只能将我们带到通往自由的终极目标的半路上。如果人们仅仅因为易用性而去使用某个自由软件，那么这些人将会仅仅在这款自由软件仍然易用的情况下继续坚持使用它。接下来，他们就再也找不到理由不去使用与这款自由软件共存但更加易用的私有软件。

“开源”的哲学满足于消费者价值并且以此为前提，肯定并且强化这些消费者价值，这就是我们不能支持“开源”的原因。

为了完全地、长久地建立一个自由社区，我们要做的绝不仅限于让人们使用某些自由软件。我们需要宣传按照公民价值评估软件（及其他事物）的理念，即基于它们是否尊重用户的自由和社区，而非仅限于所谓的“易用性”。这样人们就不会落入以吸引人、易用的特性作为诱饵的私有软件的陷阱之中。

为了推广公民价值，我们必须讨论它们并且说明它们怎样才能成为我们的行为准则。我们必须拒绝戴尔•卡耐基式的妥协，因为这将通过强调人们的消费者价值而影响他们的行为。

不过，这并不意味着我们完全不能援引实践上的好处——我们可以适度地这样做，并且我们也确实正在这样做。只有当这种实践上的好处占据了用户的注意力并且让“自由”沦为背景时，这才成为问题。因此，当我们援引自由软件实际的好处时，我们必须不厌其烦地反复强调这些实践上的好处只是用户应该倾向于使用自由软件*附加的、次要的*原因。

仅仅让我们的口号与我们的理念保持一致并不够，我们的行动也必须与理念保持一致。因此，我们必须避免做出这样的妥协，它们会做那些我们所致力于终结的事情，或者使之合法化。

例如，经验已经表明，您可以通过包含某些私有软件以吸引某些用户使用 GNU/Linux。这些私有软件可能是一个小巧的、吸引用户眼球的私有应用程序，或者一种私有的编程平台，例如 Java[^compromise-5]（曾经是这样）或者 Flash 运行时（仍然是这样），或者某种用于支持特定硬件型号的私有设备驱动程序。

这些妥协无疑是诱人的，但它们会在无形之中毁掉我们的终极目标。如果您发布私有软件或者引导用户使用私有软件，您将会觉得自己没有底气说出“私有软件是一种不公，一种社会问题，我们必须终结它们”这样的话。而且即使您嘴上能够继续这样说，您的行动也会最终毁掉您的誓言。

这里的问题不在于用户是否应该*能够*或者*被允许*安装私有软件；一个通用目的的系统应当允许并使用户能够去做他们所想要去做的任何事情。问题在于我们是否应当引导用户投向私有软件。用户独立自主地去做什么事情是他们的责任，而我们为他们做了什么，以及我们引导他们去做什么则是我们的责任。我们无论如何不应该将用户导向私有软件，即使它看起来像是一种解决方案。因为私有软件正是问题的根源。

破坏性的妥协不仅仅是对他人的不良影响，它还会通过认知上的不一致扭曲您自己的价值观。如果您抱有某种价值观，但是您的行动表现出来的是与之相冲突的其他价值观，您很可能将会试图改变您的价值观或者行动，以便解决这种矛盾。因此，那些仅仅争论实践上的好处的，或者引导用户转向某些私有软件的项目，几乎不可避免地羞于哪怕只是*暗示*“私有软件是不符合伦理的”。对于它们的参与者，以及对于公众，它们只能强化消费者价值。我们必须拒绝这些妥协，如果我们想要坚持我们自己的价值观不动摇。

如果您想要转向自由软件并且是为了自由的终极目标而不会做出妥协，您可以查阅自由软件基金会的相关资源，它们位于<http://www.fsf.org/resources>。这里列出了能够与自由软件协同工作的硬件和机器配置列表，可供安装的完全自由的 GNU/Linux 发行版的列表，以及能够在百分之百自由软件环境下工作的数千款自由软件包[^compromise-6]。如果您想要帮助社区走在通往自由的正确道路上，很重要的一点就是公开支持公民价值。当人们正在讨论什么是好或者坏，或者要做什么事情的时候，您可以援引自由和社区的价值观并与他们争论。

一条能够让您更快前行的道路有时并不是一条更好的道路，如果它通往错误的目的地。为了成就一个充满雄心壮志的目标，做出一些妥协是必需的。但是，一定要警惕那些将您引离最终目标的妥协。


 [^compromise-1]: 您可以在此通过加入会员的方式支持自由软件基金会：<http://my.fsf.org/join>. 

 [^compromise-2]: 这里的“自由”应理解为 freedom 中的自由，参见《什么是自由软件？》一文以获得自由软件的完整定义。 

 [^compromise-3]: 参见自由软件基金会执行董事 John Sullivan 于 2008 年发表的文章：“The Last Mile Is Always the Hardest,”，位于[http://fsf.org/bulletin/2008/spring/the-last-mile-is-always-the-hardest](http://fsf.org/bulletin/2008/spring/the-last-mile-is-always-the-hardest)，所提及的他本人对于这一问题的看法。 

 [^compromise-4]: 您可以在这里找到自由操作系统发行版准则（GNU FSDG）：<http://gnu.org/philosophy/free-system-distribution-guidelines.html>。 

 [^compromise-5]: 参见 <http://gnu.org/philosophy/java-trap.html> 获取更多细节。 

 [^compromise-6]: 自由软件目录，位于 <http://directory.fsf.org>，这里列出了我们所知的所有自由软件。 

