\newpage
##  计算机网络时代的版权与社区之争

> 本文是 Richard Stallman 所做主题演讲之抄本，该主题演讲于 2009 年十月在新西兰基督城（克赖斯特彻奇）会展中心所举行的新西兰奥特亚罗瓦图书馆与信息协会（LIANZA）会议上进行。

> Copyright © 2009 自由软件基金会，感谢 Bookman 为此原始抄本所做的贡献。

> **Brenda Chawner：** 今天，本人荣幸介绍 Richard Stallman，他的主题演讲由惠灵顿维多利亚大学信息管理学院所赞助。
>
> Richard 致力于推进软件自由已逾 25 年。他曾于 1983 年创始 GNU 计划以开发一种自由的操作系统（GNU 操作系统），并且于 1985 年创立自由软件基金会（FSF）。每当您读取或发送一条 nz-libs 信息时，您就在使用 Mailman 软件，它是 GNU 计划的一部分。因此无论您是否意识到这一点，Richard 的创作已经深入我们每个人的生活。
>
> 我想将他描述为最有影响力却不为大多数人所熟知的人物，尽管他曾对我说，这不可能是真的，由于它们的正确性不可能被证实。
>
> **RMS：** 不能这样说。
>
> **BC：** 我是想说——我仍然喜欢这样说。他关于软件自由以及信息应当可自由获取的理念被 Tim Berners-Lee 用于创建世界上第一台网络服务器，并且他在 1999 年对于一部自由的在线百科全书的深入思考启发了 Jimmy Wales，后者创立了现在的 Wikipedia。
>
> 今天，Richard 将为我们带来关于计算机网络时代的版权与社区之争，以及它们对于图书馆的启示的演讲。有请 Richard。
>
> **RMS：** 我来到新西兰已有两周时间，在北岛的大部分时间都在下雨。现在我可以理解为何他们将长筒橡胶靴子称为“惠灵顿靴”。而后我看到了一位使用银叶蕨的木材制造桌椅的工匠，他将其称为蕨类家具（fern-iture）。然后我们乘坐渡船来到此地，当我们下船时，人们立即开始嘲笑我们；但他们没有任何恶意，只是想让我们感受皮克顿当地的风情。

人们邀请我演讲的原因通常是基于我为自由软件所做的工作。而今天这场演讲并非关于自由软件；而是要回答这样一个问题，即自由软件的理念是否可以延伸至其他类型的作品。但为了使这个问题有意义，我最好还是简要介绍一下自由软件意味着什么。

自由软件关乎的是自由而非价格，因此请思考“自由言论”而非“免费啤酒”。自由软件是尊重用户自由的软件，而这里有四项特定的自由是用户总是应当拥有的：

-   自由之零：以您所希望的任何方式运行该程序的自由；

-   自由之一：研究程序的源代码并对其进行修改使程序能够满足您的需求的自由；

-   自由之二：帮助您的邻居——即再分发该程序原始副本的自由；

-   自由之三：贡献您的社区——即再分发您对该程序的改进版本的自由。

如果程序赋予您这四项基本自由，那么它就是自由软件，也就是意味着它的发布和使用所构成的社会体系属于一种尊重用户自由以及用户社区的社会协作伦理体系。但如果以上自由中的任意一条缺失或是不充分，则它称为私有软件、非自由软件或者迫使用户屈从的软件。这是不符合伦理的，也不能称其为对社会的贡献，而是一种权力的攫取。这种不符合伦理的实践不应当存在；自由软件运动的最终目标是终结这种行径。所有软件应当是自由的，于是所有用户也就因此获得自由。

私有软件使得用户陷入孤立无援的困境：所谓孤立，是由于用户被禁止分享；所谓无援，是由于用户不能拥有源代码，因此不能对其进行修改，他们甚至不能研究它以便确定它真正是在对他们做什么，而且众多私有软件拥有恶意功能用于窥探用户、限制用户、甚至为对用户的攻击提供后门。

例如，微软 Windows 操作系统拥有后门使得微软可以强制安装软件更改而无需得到理应作为计算机的拥有者——用户的许可。您可能认为它仍是属于您的计算机，但如果您犯了用它运行 Windows 的错误，实际上是微软拥有了您的计算机。这样计算机应当被扔出窗外，意即要么将 Windows 从计算机中扔出去，要么将这台计算机从房间的窗户中扔出去。

但是，任何私有软件都赋予了其开发者凌驾于用户之上的不公权力。开发者们或多或少地滥用这种权力，但他们都不应该拥有这种权力。您理应拥有对您所进行的计算的控制权，并且不必屈从于任何一家特定的公司。因此，您应当使用自由软件。

在关于自由软件的演说结束时，人们有时会问，这些相同的自由和理念是否也适用于其他事物。如果您在自己的计算机上拥有一份已发表作品的副本，提问您是否应当拥有同样的四项基本自由是有意义的——即您是否拥有这些自由在伦理上是否重要。这就是我今天将要着重论述的问题。

如果您拥有一份除了软件以外的某种东西的副本，对于大多数情况，唯一可能拒绝您的任何一种自由的东西就是版权法。而对于软件则不是这样。使软件成为私有的主要途径是利用合同以及拒绝对用户公开源代码，而版权只是某种次要的备选方案。而对于其他东西，并没有源代码和可执行代码这样的区分。

例如，我们谈论一篇文本，如果您能够看到该文本以便阅读它，那么该文本就没有您所不能看到的东西。因此这并不是存在于软件中的同类问题。大多数情况下，只有版权可以拒绝您的这些自由。

于是这个问题可以被转述为：“版权法应当允许您对已发布的作品做些什么？版权法应当说些什么？”

版权随着复制技术一起发展，因此有必要回顾一下复制技术的发展史。在古代世界，只要您能在书写表面上使用书写工具，那里就有复制技术的发展。您可以阅读一份副本并且抄写另一份。

这种复制技术的效率相当低下，但它的一个特性就是没有经济规模效应。为了抄写 10 份副本，您需要花费 10 倍于抄写一份副本的时间，它除了书写工具以外并不需要其他特殊设备，同时除了识字以外您也不需要其他的特殊技能。其结果是任何一本书的副本都是以一种去中心化的方式创作的。只要有一份副本，只要某人想要复制它，他就可以这样去做。

古代世界没有像版权这样的东西的存在。如果您有一份副本并且想要复制它，无人会告知您您不被允许如此做——除非当地的首领不喜欢书中的内容，此时他可能会因为您复制了这本书而对您进行处罚。但这不是版权，而是与之紧密相关的其他东西，称为审查。而如今版权通常被用于对人们进行审查的企图。

这种情况持续了数千年，然而，此后复制技术发生了巨大进步，这称为印刷机。印刷机使得复制过程更有效率，但这并不具有一致性。由于批量复制的效率得到巨大提升，但每次仅仅印制一份副本并不会由于印刷机的存在而变得高效。事实上，您最好还是自己进行手抄，这将会比用印刷机印制一份副本更快。

印刷机具有经济规模效应：需要花费大量工作来进行排版，但您随后就可以快速复制很多份副本。同时，印刷机和字模都属于相对昂贵的设备，大多数人并不拥有它们；而且大部分识字的人们也不知道如何使用它们。使用印刷机是一种不同于书写的技术。其结果是一种中心化的复制方式：任何给定的书本的副本只能在少数地方被印制，它们随后可以被运输到有人想要购买副本的任何地方。

版权始于印刷机的时代。从 16 世纪开始，英格兰的版权制度开始成为一种审查体系。我相信其最初的本意只是审查新教徒，但其随后改为审查天主教徒，并且很可能也被用于审查许多其他人。根据这一法律，为了发行一本书，您必须得到皇家许可，而这种许可是以永久垄断权的形式被授予的。这种制度我相信一直被允许存在直到 17 世纪 80 年代（根据 Wikipedia 相关词条，它于 1695 年被废止）。出版商想要重新得到这项权利，但它们实际得到的是与之不同的东西。安娜法令赋予了作者一份版权，并且仅持续 14 年，尽管作者可以续期一次。

这是一种完全不同的理念——出版商的永久垄断权变成了作者的临时垄断权。这一理念使版权成为了一种促进创作的方式。

起草美国宪法时，一些人希望作者被授予版权权利，但这被否决了。与之相反，美国宪法声明国会可以有选择地采纳一种版权法，并且如果真的要有一部版权法，其目标必须是促进进步。换言之，其目标不是版权持有人或者与他们进行交易的其他人的利益，而是为了公众的利益。版权必须仅仅持续一段有限的时间；而出版商一直都在盼望我们忘记这一点。

这里，我们有了关于版权的这样一种理念，它是一种约束出版商的行业规范，由作者所控制，并且被设计为最终能够为公众带来利益。它能够以这种方式发挥作用，由于它并不限制读者。

在印刷时代的最初几个世纪，我相信直到 18 世纪 90 年代还是这样，大部分读者仍然采用手抄方式进行复制，由于他们买不起印刷的副本。从未有人期望版权法变成行业规范以外的东西，它的本意是约束出版商。正因为此，它容易被强制执行、不会引起争议、并且可以认为是对社会有益的。

它是容易强制执行的，由于它只需针对出版商强制执行。并且想要找出未经许可的出版商也是容易的——您可以前往一家书店并且说：“这些副本来自哪里？”您无需入侵某人的住宅或者某人的计算机以实现这一目的。

它不会引起争议，由于读者并未被限制，他们无需担心什么。从理论上说，他们被禁止从事出版，但由于他们不是出版商，并且没有印刷机可用，他们无论如何不能从事出版。而在他们实际上可以做的事情当中，他们并未受到什么限制。

它可以被认为是有益的，由于根据版权法的概念，公众所出让的是一种他们所不能行使的、仅存在于理论上的权利。作为回报，他们从更多的作品中得到了好处。

现在，如果您出让的是一些您没有任何办法使用的东西，而得到的回报是一些您可以使用的东西，这是一笔有利的交易。不论您是否能够通过其他方式得到一笔更加划算的交易，那是另外一个问题，但至少这是一笔不亏的交易。

因此，如果现在仍然处在印刷机时代，我想我不会抱怨版权法。但是，印刷机时代正在逐步让位于计算机网络时代——复制技术的另一次革命，它使得复制更加高效，同时也更加不那么具有一致性。

这是我们曾经在印刷机时代拥有的东西：批量复制非常高效，而一次复制一本时仍然和古代一样慢。数字技术为我们带来了这些：它们都得到了提升，然而一次一本的复制方式所得到的效率提升最大。

我们由此来到了一种更像古代世界的境地，彼时一次复制一本的行为相对于批量复制并不显得非常低效（困难），它只是略微低效，但它的成本足够低，以至于数以亿计的人们都能够进行这样的复制操作。想想看有多少人可以不时地烧录光盘（CD），即使是在欠发达的国家。您可能没有一台 CD 刻录机，不过您可以前往一家可提供此服务的商店。

这意味着版权不再像过去那样适应技术的发展。即使版权法中的词句保持不变，它也不会再产生与之前相同的效果。此时的版权不再是一种由作者控制的针对出版商的行业规范，并且由此使公众受益。它已经成为了主要由出版商控制，以作者之名对公众的限制。

换言之，这是一种暴政，这是不可容忍的，我们决不能允许它以这种方式发展下去。

由于这种性质上的转变，版权不再容易被强制执行、不再没有争议、也不再有益。

它不再容易强制执行，由于现在是那些出版商想要针对每个人强制执行。而要达到这一目的，需要严酷的措施、德拉古式的严厉刑罚、对隐私的侵犯以及废除我们关于公平的基本理念。目前看来，他们将会在发动“消灭分享之战”的道路上走多远，一时还看不到界限。

它不再没有争议。在一些国家已经出现了这样一些政党，其基本立场是“分享自由”。

它也不再有益，由于我们曾经在概念上出让（由于那时我们不能行使它们）的自由现在是我们可以行使的了。它们是那么地重要，以至于我们现在想要行使它们。

那么，一个民主政府在这种情况下应当做些什么呢？

它应当减少版权权力。它应当说：“我们在以公民之名进行的交易中出让的那部分自由是现在他们所需要的，这是不可容忍的。我们必须改变这一切；我们不能轻易出让这种至关重要的自由。”我们可以如此衡量民主的欠缺，通过考察世界各国政府做出与民主背道而驰的事情的倾向性，即它们在本应减少版权权力的时候反而不断延伸版权权力。

一个例子是版权的时间尺度。放眼全世界，我们看到各种压力使得版权持续时间更长、更长、更长。

一波此类事件于 1998 年发生在美国。过去和将来的作品的版权期限都延长了 20 年。我不明白他们怎样才能指望使得那些活跃于 20 世纪 20 至 30 年代的已经去世或者年迈的作家相信，通过在今天延长他们的作品的版权能够促使他们在当时创作更多的作品。如果他们拥有一台可用于在当时通知他们的时光机器，他们也从未使用过它。我们的历史教材也从未说过，在 20 世纪 20 年代曾经发生过文科创作活力的爆发式增长，由于当时所有的艺术家预知他们的作品的版权将会在 1998 年被延长 20 年。

为未来的作品延长 20 年的版权期限将会说服人们为创作这些作品付出更多努力。这在理论上是可信的，但这不能说服那些有理性的人们，由于在未来 75 年——如果这篇作品是出资聘人完成的——如果该作品拥有一位独立版权持有人，可能还会更长一些，在此基础上额外增加的 20 年版权期限的存在价值将会大打折扣，其存在价值小到不能说服任何有理性的人们为此去做一些不同的事情。任何想要宣称事情并非如此的商业公司应当被要求出示它在未来 75 年中的财务状况表，然而它们当然做不到这一点，由于它们当中没有一家会真正看问题看得那么远。

这条法律的真正原因，以及驱使不同的商业公司向美国国会购买这条法律（国会在很大程度上有权决定法律）的原因在于它们已经拥有使其大大得利的垄断权，并且想让这种垄断权持续下去。

例如，迪士尼意识到米老鼠首次出现的那部电影将会在几年内进入公有领域，然后任何人都可以自由地绘制相同的角色以用于其他作品。迪士尼不希望这件事发生。此前，迪士尼曾经从公有领域借鉴了很多东西供自己使用，但它决定永远也不向公有领域做出哪怕是最微薄的回馈。于是迪士尼买来了这条法律，我们称之为米老鼠版权法案。

电影公司说它们想要永久版权，但是美国宪法不会让它们以官方的方式得到它。于是它们想出了一种方式以便以非官方形式达到同样的结果：“永久版权无限续期方案”。每隔 20 年，它们会将版权期限再次延长 20 年。因此，在任意给定的时间，对于任意给定的作品，都存在这样一个日期，它们应当在此日期进入公有领域。但是，这个日期就如同明日复明日，永远不会到来。当您等到那一天的时候，它们又将其延后了，除非我们能够在下一次阻止它们这样做。

以上这些是一个方面，即版权期限的方面。但是更重要的一个方面是宽度：即版权会覆盖作品在哪些方面的使用。

在印刷机时代，版权不应覆盖一篇作品的所有应用场景。由于版权所管制的某些应用同时也是一系列更宽泛的未受管制的应用中的一些例外。您很自然地被许可利用您的某本书的副本去做某些特定的事情。

现在，出版商有了这样的理念，它们可以使得我们的计算机背叛我们，并且利用它们攫取对于已发布作品的所有使用可能的绝对控制权力。它们想要建立一种按次付费点播的通用规则。它们正在通过数字限制管理（DRM）来实现这一点——软件的功能被故意设计为限制用户。而且计算机本身也通常被设计为限制用户。

公众首次见识到它的方式是通过数码多功能影音光盘（DVD）。保存于 DVD 上的电影通常是加密的，并且其格式是私密的。DVD 阴谋集团保守这一秘密，因为它们宣称任何人想要制造 DVD 播放器必须加入这一阴谋集团，并且承诺保守这一秘密，同时还要承诺设计出的 DVD 播放器必须根据规则限制用户，也就是说，它必须阻止用户做这件事、还有那件事、还有那件事——一系列精准的要求，对我们都是恶意的。

虽然花费了一些时间，但随后某些人还是破解了这种私密的格式，并且发布了可用于读取并播放 DVD 电影的自由软件。然后出版商说：“既然我们不能在事实上阻止他们，我们必须让这件事成为罪行。”它们于 1998 年在美国利用数字千年版权法案（DMCA）开始这么做，这一法案对能实现上述功能的软件强制实施了审查。

因此，这一类特定的自由软件被诉诸法庭案例。它们在美国的分发被禁止；美国对其实施了审查。

电影公司意识到它们不能真正使得那个程序彻底消失——它仍然很容易被搜索到。于是它们设计出了另一套加密系统，并且希望它更难被破解，它被称为高级访问信息系统（AACS），或者“战斧”。

AACS 阴谋集团为所有播放器制定了细致的规则。例如在 2011 年，它将会禁止模拟视频输出。因此所有视频输出将必须是数字式的，它们将会把信号以加密形式传输到一台特别设计为使这些内容对用户保持私密的显示器上。那是一种恶意硬件。它们宣称如此做的目的是“修补模拟漏洞”（*Stallman 摘下眼镜*）。这里有一个，那里还有一个，而它们想让这些漏洞永久消失[^copyright-community-1]。

我是如何知道这些阴谋的呢？其原因是它们并不是秘密——它们有其官方网站。AACS 网站骄傲地展示了生产商必须签署的霸王条款，这就是我之所以会知道这些限制条件。它还骄傲地展示了共同建立了这一阴谋集团的商业公司的名字，包括微软、苹果、英特尔、索尼、迪士尼、IBM 等。

这些公司所设计的阴谋旨在限制公众对技术的访问，这应当作为一项重罪被起诉，就像操纵价格的阴谋那样，只是这比操纵价格更坏而已。因此，这种罪行的刑期应当更长。但是，那些公司信心满满，由于政府站在它们那边共同压制我们。它们丝毫不担心可能会因为这些阴谋而被起诉，这就是它们为何甚至不屑于掩饰这一点的原因。

通常，DRM 是由一些公司组成的阴谋集团所实施的。有时一家单独的公司也能这么做，但通常这需要在技术公司和出版商之间达成某种阴谋，因此它几乎总是阴谋。

它们认为无人能够破解 AACS，但是大约在 3 年半之前，某人发布了一款可以解密那种格式的自由软件。然而，这是完全无用的，因为如果您想要运行它，您需要知道它的密钥。

然后在 6 个月后，我看到了一幅照片，里面有两只可爱的小狗，每只小狗身上有 32 位的十六进制数，我当时觉得奇怪：“为何将这两样东西放在一起？我怀疑这些十六进制数是否可能是某个重要的密钥，而某人可能是将这些十六进制数和小狗放在一起，希望人们复制这张小狗的照片，由于它们是那么可爱。这也许能够保护该密钥免遭被抹除的厄运。”

事实上，它就是——破解“战斧”的密钥。人们发布它，然后网站编辑删除它，由于现在很多国家的法律动员他们对这类信息实施审查。它再次被发布，他们又将其删除；最后他们放弃了，这组密钥在两周之内被发布到了 70 多万个网站上。

这是公众对 DRM 的不满的一次大规模爆发。但这并未赢得这场战争，由于出版商更换了密钥。不仅如此，对于高清 DVD（HD DVD），这种方式足以破解其 DRM，但对于蓝光（Blu-ray）光盘则不行。蓝光光盘拥有一个额外层级的 DRM，至今没有自由软件可以破解它，这意味着您必须将蓝光光盘看做某种与您自己的自由完全不兼容的东西。它们是您所不可能与之共存的敌人，至少对于我们当前的知识水平是如此。

永远不要接受任何被设计为用于攻击您自由的产品。如果您没有可用于播放 DVD 的自由软件，您必须不要购买或者租用任何 DVD，或者以礼物的形式接受它们，除非是稀有的未加密的 DVD，并且确实存在少数这样的东西。我确实拥有几片——但我没有任何加密的 DVD，我不会设法获得它们。

以上这些就是视频方面的情况，但我们也已经遇到了音乐中的 DRM。

例如，大约 10 年前，我们开始见到一种形似音乐光盘（CD）的东西，但是它们的烧录方式和 CD 并不相似。它们不遵守标准。我们称之为“损坏的光盘”，它们所遵循的理念是它们可以用某种音频播放器进行播放，但不可能在计算机上读取。这些不同的方法具有不同的问题。

最终，索尼想出了一个奸诈的主意。它将一个程序存储在盘片上，于是当您将盘片放入计算机中时，该盘片将会安装该程序。这个程序被设计为像病毒一样取得系统的控制权。它被称为“root kit”，这意味着它拥有破解系统安全措施的能力，使得它可以将软件植入系统深处，并且修改系统。

例如，它修改了您可用于查看系统状态以获知某个软件是否存在的命令，因此它隐藏了自己的存在。它修改了您可用于删除它的某些文件的命令，因此这些命令并不能真正删除它们。现在，所有这些都是严重的罪行，但这还不是索尼所犯下的唯一罪行，由于该软件同时包含自由软件代码——这些代码是以 GNU 通用公共许可证（GNU GPL）发布的。

现在，GNU GPL 是一种左版（copyleft）许可证，这如同说：“是的，您拥有将此代码整合到其他程序中的自由，但如果您决定这么做，您将此代码整合到其中的整个程序也必须以相同的许可证作为自由软件发布。并且您必须保证用户可获得源代码，以及为了保证他们对于自己的权利拥有知情权，您必须在他们得到软件的同时为他们提供一份此许可证的副本。”

索尼并未完全遵守这些。这属于商业版权侵犯行为，是一种重罪。这两种行为都是重罪，但索尼并未因此被起诉，由于政府明白，政府和法律的目的是维护这些公司凌驾于用户之上的权力，而非以任何方式帮助用户捍卫他们的自由。

不堪忍受的人们起诉了索尼。然而他们犯了一个错误。他们并未将谴责集中于这一阴谋的邪恶目的之上，而是仅仅局限于索尼将其次要罪恶付诸实现的不同方法上。于是索尼化解了这些法律诉讼，并承诺在未来继续侵犯我们的自由的时候，它将不会再次采用这些方法。

事实上，这种“损坏的光盘”的阴谋并不是非常地坏，由于只要您不用 Windows，它不会对您产生任何影响。甚至即使您正在使用 Windows，在您的键盘上有这样一个键——如果您每次都记着按住它，该盘片就不会安装那个软件。但是，每次都记着按住那个键显然不是一件容易做到的事情；您总有一天会疏忽。这展示了我们必须去设法应对的某种事情。

幸运的是，音乐所受的 DRM 威胁正在减少。即使是大型唱片公司也会销售不带 DRM 的下载版。但是，我们又看到了一波试图为电子书强行施加 DRM 的攻势。

您应该看到了，出版商想要剥夺读者的传统阅读自由——诸如从公共图书馆借阅；或者将书借给朋友；或者将书卖给旧书商店；或者使用现金匿名购书等自由（这是我购书的唯一方式——我们必须抵御各种诱惑，不让当权者知道我们所做的每一件事情）。

甚至是您想要保有该书任意长的时间，或者阅读该书任意多次的自由，它们也计划剥夺。

它们通过 DRM 的方式做到这一点。它们知道有那么多的人读书，如果直接剥夺他们的这些自由，他们将会强烈反对，因此它们不认为自己能够简单地通过购买一条法律来特定地废除这些自由——这将会招致太多反对。民主是有缺陷的，但有时人们也能要求得到某些东西。于是它们想出了一种两步走的方案。

首先，剥夺电子书的这些阅读自由，然后，迫使用户从纸版书转向电子书。它们已经成功做到了第一步。

在美国，它们通过 DMCA 做到了这一点，而在新西兰，这是版权法案（2008 年）的一部分，即对于可用于破解 DRM 的软件实施审查。这是一种不公平的条款，它应当被废除。

第二步是说服人们从纸版书转向电子书；这项进展并不十分顺利。

2001 年，一家出版商想出了一种方法，如果它能够以我的传记开头，它的系列电子书将会变得非常流行。于是它们找到一位作者，后者询问我是否愿意合作，我说：“除非该电子书以未加密并且无 DRM 的形式发布。”出版商不愿意接受这一条，而我则强烈要求这样——我最终拒绝了。最后我们找到了另一家出版商，它愿意如此做——事实上是希望使用自由许可证发布该书以赋予您四项基本自由——于是该书最终出版，并且售出了很多份纸版副本[^copyright-community-2]。

但不管怎么说，电子书在这十年之初并未取得预期成果。人们并不十分愿意阅读它们。我曾说过：“它们将会卷土重来。”我们见到了数量可观的关于类似电子墨水的新闻文章（或者称为电子纸，我记不清是哪个了），我认为之所以会有那么多文章，很可能是由于出版商想让我们考虑这种载体。它们希望我们迫切地想要成为下一代电子书的读者。

现在，它们终于来了。诸如索尼碎纸机（Shreader，它的官方名字是 reader，但是如果您加上 sh 两个字母，这就能很好地解释它是被设计用于对您的书做什么的了）和亚马逊诈骗（Swindle）这样的设备是被设计为用于在您毫无戒备的情况下骗走您的传统阅读自由的。当然，亚马逊将其称为 Kindle（焚烧）恰如其分地解释了它将会对您的书做些什么。

亚马逊焚书机（Kindle）是一款极端恶意的设备，几乎和微软 Windows 操作系统一样坏。它们都拥有间谍功能，都拥有 DRM，都拥有后门。

对于 Kindle，您唯一可能的购书方式就是从亚马逊购买，它要求您提供所有个人信息，于是它们知道关于您所购买的东西的所有信息。

由于存在 DRM，您不能将书借出或是卖给旧书商店，图书馆也不能将书借出。

由于存在后门，我们是在大约 3 个月前知道的它的存在，由于亚马逊使用了它。亚马逊向所有 Kindle 发送了一条指令以删除一本特定的书，即乔治·奥威尔（George Orwell）的《一九八四》。是的，它们找不出另一本更具讽刺意味的书来删除了。这就是我们如何知道亚马逊拥有某种后门并且通过它远程删除电子书的。

它还能做出什么事情来呢？谁知道。也许它就像微软 Windows。也许亚马逊可以远程升级它的软件，这意味着所有那些今天还没有的恶意功能，它们都可能在明天被带来。

这是不可容忍的——这其中的任何一条限制都是不可容忍的。它们想要创造这样一个世界，再也无人能够将书籍借给他人。

假设您前去拜访一位朋友，他的书架上并没有一本书，这并不是由于您的朋友从来不读书，而是由于他的所有书都保存在某一台设备中，他当然不能将那些书借给您。他所能够借给您任意一本书的唯一方式是借给您他的整个图书馆。请求他人如此做显然是荒唐的。因此，热爱读书的人们之间的友谊将不复存在。

请您确保告诉人们这种设备意味着什么。它意味着其他读者不再是您的朋友，因为您在他们面前表现得像个傻瓜。一定要先发制人地传播这句话。这款设备是您的敌人，它是任何读者的敌人。那些尚未意识到这一点的人们是那些思想短视，未能看穿这一点的人们。我们的任务是帮助他们透过眼前的易用性看穿这款设备的本质。

我绝不反对以数字形式发布书籍，如果它们并非被设计用于剥夺我们的自由。严格地说，要想拥有这样一款电子书阅读器是可能的：

-   不是被设计用于攻击您；

-   运行自由软件而非私有软件；

-   不带 DRM；

-   不要求用户购书时提供身份信息；

-   不带后门；

-   不限制您可以用它对您的计算机上的文件做什么事情。

这是可能的，但是，真正推广电子书的大型出版公司如此做的目的都是侵犯我们的自由，这是我们无论如何不能容忍和支持的。这正是政府和大型出版企业正在合谋所做的事情，通过使得版权变得越来越严酷和龌龊，越来越具有约束性来侵犯我们的自由。

但是，它们应该做些什么呢？政府应该减少版权权力。以下是我的一些特别建议。

首先，是关于版权的时间尺度。我提议版权应该仅仅持续 10 年，从作品发布的日期计算。

为何从作品发布的日期开始计算？由于在此之前，我们并没有任何副本。我们是否被允许复制那些我们尚未拥有的作品副本并不重要，因此我认为我们同样可以允许作者拥有足够的时间来安排作品的发行，然后再开始计时。

那么为何是 10 年？我不知道这个国家（新西兰）情况如何，但在美国，出版周期正在变得越来越短。现在几乎所有的书都只在 2 年内被廉价出售，并且会在 3 年内绝版。因此，10 年的期限是通常出版周期的 3 倍有余——这应当足以令人满意。

但是并非所有人都同意这一点。我曾在一次同科幻作家的研讨会上提出这一观点，而坐在我身边的一位获奖科幻作家说道：“10 年？不可能。超过 5 年的任何东西都是不可容忍的。”您可以看到，他与他的出版商之间进行了与法律有关的争论。他的书似乎将要绝版，但是出版商并不同意。该出版商正在使用此人自己所著的书的版权来禁止此人自行分发其副本，而他则希望如此做以使得人们可以阅读此书。

这正是每位作者正在开始要求的——他们想要分发自己的作品使其被人们阅读和感激。极少有人能赚得盆满钵满。这很小的一部分大发横财的人正在面临道德败坏的风险，比如 JK Rowling。

在加拿大，JK Rowling 取得了一项针对那些从某家书店购买了她所著的书的人们的禁令，强行要求这些读者不得阅读该书。作为回应，我号召发动了一场抵制《哈利波特》丛书的运动。但我并未说您不应该阅读它们，我将这种抵制留给作者和出版商。我只是说，您不应该购买它们。

只有少数作者能够赚到足以使得他们腐化堕落的钱。他们中的大多数远未达到这种境地，并且继续要求那些他们从一开始就在诉求的东西：他们想要自己的作品受到感激。

他想要分发自己的书，但版权禁止他如此。他意识到超过 5 年的版权期限不可能为他带来任何好处。

如果人们更想让版权仅仅持续 5 年，我不会反对。我只是提议将 10 年作为解决问题的第一步。首先让我们将其缩短到 10 年，然后观望一段时间，接下来我们就可以继续调整它。我并没有说我认为 10 年就刚好是恰当的数字——我也不知道到底应该是多少。

那么，关于版权的宽度又如何呢？版权应当覆盖哪些活动？我在此区分三大类作品。

首先，有一些功能性的作品是您可以在您的生活中将其用于执行一项实践任务的。这包括软件、菜谱、教材、参考文献、字体、以及您所能想到的其他东西。这些作品应当是自由的。

如果您在生活中使用这样一件作品来完成一项任务，那么如果您不能修改该作品以使其适合您的需求，您就不能控制您的生活。一旦您更改了该作品以适应您的需求，那么您应该拥有发布它的自由——发布您的版本——因为将会有其他人想要得到您所做的修改。

这很快就能推出结论，用户必须拥有同样的四项基本自由（对于所有功能性的作品）而非仅限于软件。并且您将会注意到，对于菜谱，或者从实践角度讲，烹饪的行为总是在分享并且改进菜谱，如同菜谱是自由的一般。设想一下，人们将会作何反应，如果政府试图禁止所谓的“菜谱盗版”。

“盗版”一词完全是一种鼓吹的概念。当人们问我关于音乐盗版的看法时，我会说：“就我所知，当海盗们发动攻击时，他们并非采取拙劣地演奏乐器的方式，而是使用武力。因此这不是音乐‘盗版’，由于海盗行为是攻击船只，而分享和攻击船只的行为在道德上相去甚远。”攻击船只是坏事，而与他人分享则是好事，因此我们应当在我们听到“盗版”这一鼓吹的概念的时候给予坚决的揭露。

早在 20 多年前，人们可能会反对这一点：“如果我们不放弃自己的自由，如果我们不让这些作品的出版商支配我们，这些作品就没有机会被创作出来，这是一种恐怖的灾难。”现在，请看自由软件社区，还有那些广为流传的菜谱，还有诸如 Wikipedia 这样的参考文献——我们甚至还开始见到自由的教科书的发布——我们就可以知道这种恐惧是被误导的结果。

完全没有必要因为想到若非如此作品就不会被创作出来而感到绝望并且因此放弃我们的自由。还有很多方式可以鼓励作者来创作这些作品，如果我们想要更多的作品——很多方式都可以维持并且尊重我们的自由。对于这一大类作品，它们都应当是自由的。

那么，对于第二大类作品又如何呢？即对于那些包含人们的思想的作品，诸如回忆录、议论文、科研论文[^copyright-community-3]以及其他不同形式的作品。发布某些其他人对其自身思想的论述的修改版本将会曲解此人的本意，这绝不是对社会的贡献。

因此，创立这样一种在一定程度上弱化的版权体系是可行并且可接受的，在此体系中，所有商业应用受版权限制，所有对原作的修改受版权限制，但是任何人都拥有对原始版本的副本进行非商业性再分发的自由。

这些自由是我们必须建立起来的针对所有已发布作品的最低限度自由，因为正是对这些自由的否定发动了“消灭分享之战”——它创造恶毒的鼓吹的概念：分享就是盗窃，分享（盗版）行为就像海盗攻击船只的行为。这是荒谬的，但是这种由金钱支撑的荒谬理念腐化了我们的政府。我们需要终结“消灭分享之战”；我们需要使得分享任何已发布作品的原始版本合法化。

对于这第二大类作品，以上这些就是我们所需要的；我们不必须使其成为自由的。因此我认为拥有一种覆盖了商业应用以及任何修改的弱化的版权体系是可以接受的。这可以为作者提供一种收入来源（通常是不足以体现其应得收入的），以某种与现有体系或多或少地相同的方式。您应当留意在现有体系中，除了少数明星大腕，绝大多数作者完全没有得到应得的收入。

那么对于艺术娱乐作品又如何呢？在此，我花费了一些时间来决定如何看待对作品的修改。

您可以看到，一方面，一幅艺术作品可能具有某种艺术上的完整性，对其进行修改可能会破坏这种完整性。当然，版权并不会必然地防止作品以这种方式被糟蹋。好莱坞就一直在这样干。另一方面，修改一幅作品也可能成为对艺术的一种贡献，它使得民间传承的素材也能变得富有美感和意蕴。

即使我们仅仅着眼于著名的作家：比如莎士比亚，他从几十年前发布的作品中借鉴故事情节并且以其他方式进行呈现，最终创作出了文学史上的巨著。如果今天的版权法在当时也存在，这种创作方式将被禁止，那些剧本也不可能被创作出来。

但是，我最终意识到修改一幅艺术作品可能成为对艺术的贡献，然而这在大多数情况下并非急迫需求。如果您必须等上 10 年使得版权过期，您是可以等上那么长时间的。不像现在的版权法迫使您等上 75 年或是 95 年。在墨西哥，有时您可能不得不等上将近 200 年，由于墨西哥的版权将会在作者去世 100 年后过期。这是极其不理智的，但是如我所提议的 10 年，作为版权应该持续的时间，是人们可以在有生之年等到的。

因此我提议相同的弱化版权覆盖商业应用和作品修改，但每个人都应当拥有对其原始版本进行非商业性再分发的自由。10 年之后，它将进入公有领域，人们可以通过发布他们的修改版本来继续为艺术发展做出贡献。

还有一件事情，如果您想要从一系列作品中挑选一些片断并且将其整合为某种全新的作品，这应当是合法的，由于版权的初衷是促进艺术发展，而非阻碍艺术发展。使用版权来禁止这种使用作品片断的创作方式是愚蠢的——它是自相矛盾的。这是一种扭曲，只有当政府被那些现存成功作品的出版商所支配的时候才会发生这种事情，并且这已经完全迷失了其初衷。

这就是我所提议的，特别要指出的是，这意味着在互联网上分享副本必须是合法的。分享是美好的。分享构建了社会的契约。反对分享就是反对社会。

因此，每当政府提议新的措施以制裁分享作品的人们并且强行禁止他们分享时，我们必须认识到这是一种罪恶。不仅仅是因为这些被提议的制裁措施无一例外地侵害了公平这一基本理念。但这并非巧合；其原因是这种提议的目的是罪恶的。分享是美好的，政府应当鼓励分享。

但不管怎么说，版权确实有其有用的目的。只是版权作为实现该目的的手段在当下遇到了问题，由于它不能适应当今我们所使用的技术。它干涉了读者、听众、观众及其他人的所有基本自由，但它促进艺术发展的目标仍然是美好的。因此，版权系统将继续作为版权系统而存在，除了在一定限度上减少它的权力。我提议两种其他方式。

其一是（通过）征税（来实现）——直接将税金分发给作者。这可以是一种特殊税收，可以是对于互联网连接服务的税收，也可以来自一般性的收入，由于它的总量不会非常大，如果它是通过某种有效的方式进行分发的。以促进艺术发展为目的对其进行有效分发意味着不是按照作品流行度的线性比例进行分发。它应当基于流行度，由于我们不希望由官僚主义者独断决定哪些作者应该得到支持而哪些作者将会被无视。但是，基于流行度并不必然意味着按照线性比例进行分发。

我所提议的是统计不同作品的流行度，您可以通过投票（样本统计）做到这一点，并且不是每个人都被强制参与，然后取其立方根。立方根就像这样：它基本意味着（收入）增加值将会逐渐变小。

如果某位明星大腕 A 的流行度是某位成功艺术家 B 的 1000 倍，按照这种体系，A 将得到 10 倍于 B 的收入，而非 1000 倍。

如果按照线性比例，A 将得到 1000 倍于 B 的收入，这意味着如果我们想让 B 得到足以维持其生计的钱，我们必须使 A 赚得盆满钵满。这是一种对税金的浪费——不应该这样做。

但如果我们使得收入增量逐渐变小，那么是的，每位明星仍将得到比普通的成功艺术家多得多的收入，但所有这些明星的收入总和将只占税金（总额）的一小部分。大部分税金将会被用于支持一大批相对成功、相对受欢迎、相对流行的艺术家。因此，相对于现有的体系，这一体系将能够更有效地利用这笔税金。

现有的体系是倒退的。它实际上，例如对每张唱片，给予明星大腕的钱远远超过给予其他任何人的。这种花钱的方式非常不合理。其结果是我们按照这种方式所实际花费的钱要少得多。我希望这足以安慰那些对税收有着如同膝跳反应般的敌意的人们——我并不分享税收，因为我信任一个福利国家。

我还有一个建议是关于志愿者捐助的。假设每台播放器都有这样一个按钮，您可以通过按下它来向您正在播放的作品或者已经播放的上一部作品的作者发送 1 美元。这笔钱将会被匿名地发送给作者。我相信会有很多人比较经常地按下那个按钮。

例如，我们当中的所有人应当能够负担得起每天按一次按钮的费用，这不会花费我们那么多钱。这笔钱对于我们是可接受的，我非常确信。当然，也会有贫困的人们不能负担按一下按钮的费用，然而即使他们不去按下按钮也没关系。我们不需要从穷人身上榨取钱财来支持作者。有足够多的经济状况尚可的人们，他们可以很好地完成这件事。我相信您已经注意到，有很多人确实喜爱某种艺术，并且非常乐意支持作者。

于是我又有了一个想法。播放器还可以给您一份证书，表示您曾经支持过某位无名作者，它甚至还可以统计您曾经送出多少次支持，并且给您这样一份证书：“我为这些艺术家付出了这么多。”总之，我们可以通过很多方式鼓励那些想要这么做的人们。

例如，我们可以开展一场友善的 PR 活动：“您今天向某位艺术家捐助 1 美元了吗？为什么不呢？这只是 1 美元——您将永远不会失去它，您难道不喜爱他们所创作的作品吗？现在就按下按钮！”这将使人们产生好感，他们将会想：“是的，我喜爱我所观看的作品，我将要捐助 1 美元。”

这在一定程度上已经开始产生效果。有一位曾经叫做 Jane Siberry 的加拿大歌手。她将自己的音乐放在自己的网站上，邀请人们下载并且捐助他们所愿意支付的任意金额。她曾经报道收到了平均每份副本多于 1 美元的收入，这是有趣的事情，由于大型唱片公司的收费还不到每份副本 1 美元。通过让人们自行决定是否捐助与捐助多少，她实际上得到了更多——如果按照实际下载了某些东西的访问者来统计，她通过每位访问者得到的甚至更多。但这可能还没有考虑是否存在这样一种效应，即吸引更多人访问，从而增大了这一平均值所对应的分母。

因此，这是可行的，但在当前环境下是一种令人头痛的事。首先您必须拥有一张信用卡，这意味着您不能进行匿名捐助。并且您必须找到去哪里进行支付，而对于小额支付，现有的支付系统并不非常高效，因此艺术家们只是成功了一半。如果我们能够建立一种理想的支付系统，它将能够更好地实现我们的目的。

在 [mecenat-global.org](mecenat-global.org) 网站[^copyright-community-4]，您可以找到结合了这两条建议思想的另一种方案，它由 Francis Muguet 发明，并且被设计为旨在更好地适应现存法律体系以使其更容易实施。

当心这种关于“补偿版权持有人”的鬼话，由于当他们在说“补偿”的时候，他们是在试图假设如果您感激一篇作品，您已经欠下了某人一笔特殊的债务，并且您必须“补偿”此人。当他们说“版权持有人”的时候，它应该是在迫使您认为这是在支持艺术家，而实际上这是在支持出版商——正是那些从根本上剥削了所有艺术家的出版商（除了少数各位都听说过的艺术家，由于他们那么出名，以至于他们拥有了某种势力）。

我们并不欠任何人任何东西；我们没有“补偿”任何人的理由和义务。但是，支持艺术发展仍然是有益的事情。这曾经是版权的动机，彼时的版权仍然是适应那个时代的技术发展水平的。而今天，版权对于支持艺术发展成了一种坏的实施方式。但以尊重我们的自由的方式来实施它，这还是好的。

我们想要利用它们改变新西兰版权法案中的两大邪恶部分，它们不应取代“三振出局法”[^copyright-community-4]，由于分享是美好的，它们应当摆脱针对用于破解 DRM 的软件的审查。当心反假冒贸易协定（ACTA），它们试图在不同国家之间商定一种条约，使这些国家可以攻击它们的国民，我们不知道如何攻击，由于它们不会告诉我们。

 [^copyright-community-1]: 在 2010 年，关于数字视频输出的加密系统被正式破解。参见 Mark Hachman 的文章“HDCP Master Key Confirmed; Blu-Ray Content Vulnerable”（2010年9月16日），位于 <http://pcmag.com/article2/0,2817,2369280,00.asp> 以获得更多信息) 。

 [^copyright-community-2]: 此书即《Free as in Freedom》。中文译名《若为自由故：自由软件之父理查德·斯托曼传》，邓楠、李凡希翻译，人民邮电出版社2015年出版。——译者注。

 [^copyright-community-3]:  在 2015 年，我加入了科研论文这一条，由于我认为发布他人的论文的修改版本是有害的；然而，将物理和数学论文以创作共用：署名许可证发布在 arxiv.org 或是众多其他自由期刊上似乎并不会带来什么问题。于是，我随后得出结论，科研论文应当是自由的。

 [^copyright-community-4]: 此网页不再可访问，请移步至 [https://stallman.org/mecenat/global-patronage.html](https://stallman.org/mecenat/global-patronage.html) 

 [^copyright-community-5]: 新西兰实施了一种未经审判的刑罚系统，对于被指控进行复制的互联网用户；然后，迫于大众的抗议，政府并未立即实施，而是宣布了一项计划以实施一种修订过的但仍然不公平的刑罚系统。本文此处的观点是，它们不应实施一种替代方案——与之相反，它们不应拥有这类系统。然而，我的用词未能清楚地表达这一点。新西兰政府随后实施了一种与原本计划的或多或少相同的刑罚方案。
