\newpage
## 为什么学校应该只使用自由软件

> Copyright © 2003, 2009, 2014 Richard Stallman 此文最早于2003年发布在 <http://gnu.org>。

教育性的活动（包括学校里的）有道义责任应该只教授自由软件。

所有计算机用户都应该坚持使用自由软件：这会让你获得控制你自己计算机的权利——专有软件，更愿意做其拥有者或开发者想要做的事情，而不是用户想让它们做的事情。自由软件还会赋予用户自由协作的权利，这将会引领一种积极向上的生活方式。这些理由适用于学校，而且也适用于每个人。但是，本文的目的不仅限于此，还会讲到专门适用于教育领域的特殊原因。

自由软件可以帮助学校节省经费只是一个连带好处。节省经费盖是因为自由软件赋予学校，如同赋予其他个人用户那样，自由复制和分发软件的权利。教育系统可以给每一所学校一份副本，而且每一所学校都可以将其安装在学校的每一台电脑上，这样做无需支付任何费用。

尽管这项好处很有用，但我们坚定地拒绝将其置于首位，因为与道义层面性命攸关的重要问题相比，它显得微不足道。推动学校使用自由软件，不只是让教育变得稍微“好一点”的一个方法，也是一件让好教育替代烂教育的大事。所以，我们来探讨一下这个更深层次的问题。

学校有一项社会使命：要教导学生成为一个坚强、有才能，独立、相互协作并且自由的社会中的一名公民。学校应该像推广保育和选举一样推广自由软件的使用。通过教授自由软件，学生能成为自由的数字化时代的合格公民。这项工作能帮助社会从整体上脱离大集团公司的统治。

相比之下，如果我们教学生使用非自由软件，就等同于培养依赖性，这将违背学校的社会使命，学校应该极力避免这种事情的发生。

为什么呢？毕竟一些专有软件开发者可以免费给学校的提供非自由程序的副本。那是因为，就像烟草公司免费向学生发放香烟一样，他们希望*利用*学校给学生灌输这种对他们产品的依赖性[^edu-1]。

当学生毕业之后，他们就会终止这种免费行为，而且，他们也不会为毕业生就职的公司或机构提供免费服务。你一旦对这些软件形成了依赖，你很可能就会付费，并且之后的升级可能会很昂贵。

自由软件可以让学生了解和掌握这些软件的工作原理。有些学生，或者那些天才程序员，青少年时代就对计算机和软件充满好奇心，他们急切地想要获知他们想要知道的一切。他们非常渴望阅读那些他们每天都在使用的软件的源代码。

专有软件阻抑了学生对知识的渴望：他们被告知，“你想要获得的知识是一个秘密，禁止学习！” 专有软件是教育精神的敌人，所以，除非作为逆向工程的目的，学校应该拒绝使用它们。

自由软件鼓励每个人学习。自由软件社区反对“高高在上的技术”——这会让大众对技术的基本原理敬而远之。我们鼓励任何年龄层次学生或个人阅读源代码，而且，我们希望他们学得越多越好。

使用自由软件的学校将会成为那些喜爱编程学生的乐土。你知道喜欢编程的学生是怎样成为优秀的程序员的吗？他们必须要阅读和理解人们真实使用的软件的源代码。通过阅读和编写大量的代码，你才有可能写出高质量清晰的计算机程序。目前来看，只有自由软件允许你这样做。

如何学习为大型软件项目编写代码？最好的办法就是为现有的大型项目编写大量代码。自由软件鼓励你这样做，但专有软件会禁止如此。任何学校都可以给学生提供这种掌握编程技术的机会，但只有使用自由软件的学校才真正有这个可能。

学校使用自由软件最深层次原因是可以进行德育教育。我们希望学校教给学生基本的知识和有用的技巧，但是这只是学校工作的一部分。学校最根本的一项职能，就是培养好公民——其中包括助人为乐的习惯。在计算机领域，这就意味着我们需要教授学生分享软件的精神。从幼儿园开始，学校就应该告诉学生，“如果你把软件带到学校来，你应该与其他同学一起分享。一旦有人想要学习一下它的工作原理，你就应该把源代码展示给大家。所以说，非自由软件最好不要带到学校来，除非出于反向工程的目的。”

当然，学校必须履行其诺言：在课堂上只允许自由软件出现（除非为了逆向工程的目的），在分享软件的同时，源代码也应该一并分享，这样的话，学生们就能复制它们，把它们带回家，甚至还可以将它们再次分享给其他人。

教授学生使用自由软件，让他们参与自由软件社区，就是一门生动鲜活的公民教育课程。这门课程教授将会把学生培养成为具有公共服务精神的行为模范，而不是垄断企业的超级大亨。所有学校都应该使用自由软件。

如果你和学校有一定联系——如果你是一名学生、一名教师、一位员工、一名管理者、一位捐赠人，或者这些人的父母——你有义务和责任向学校推广自由软件。如果私人请求无法解决这个问题，可将这个问题公开出来提交到社区。这样就能让更多的人意识到这件事情的重要性。你可以寻找同盟，让大家一起发起这项推广自由软件的运动。


[^edu-1]: 参见 《雷诺烟草公司因向儿童发放卷烟样品，于2002年被罚1500万美元》（RJ Reynolds Tobacco Company was fined \$15m in 2002 for handing out free samples of cigarettes at events attended by children）<http://bbc.co.uk/worldservice/sci_tech/features/health/tobaccotrial/usa.htm>
