\newpage
## 为什么自由软件需要自由的文档

>Copyright © 1996–2007,2009 自由软件基金会。

自由的操作系统最大的不足并不在于软件——而是缺乏可以收录其中的优秀自由手册。我们很多重要的程序还没有完善的手册。文档是任何软件包的重要组成部分；当一个重要的自由软件包发布，却没有附带自由的手册，这会是一个严重的缺陷。而这样的缺陷现在有很多。 

曾几何时，多年以前，我想学习一下 Perl。并得到了一份自由手册，但我发现很难读懂。当我寻问 Perl 用户有没有替代品，他们告诉我，有更好的入门手册，但那些不是自由的。 

为什么会如此？作者为 O'Reilly 协会编写了优秀的手册，而 O'Reilly 附加了限制条款出版这些手册——不能复制、不能修改、不能获得源文件——这使得它们被排除在自由软件社区之外。

这类事情绝不是第一次发生，而且（对我们社区是巨大的损失）远非最后一次。专有手册出版商诱使许多作者限制他们的手册。很多次我听到 GNU 用户急切的告诉我他正在写一本手册，他希望以此来帮助 GNU 计划，但是随后我的希望破灭了，因为他接着解释说，他已经与出版商签署了一项限制它的合同，所以我们不能使用它。

鉴于编写好的英文手册是程序员中难得的技巧，因此我们就更承担不起因此而失去手册。

和自由软件一样，自由文档是一个关乎自由的问题，并非价格。这些手册相关的问题不是因为 O'Reilly 对印本收取了费用——这本身不是问题（自由软件基金会也销售自由的 GNU 手册印刷版[^freedoc-1]）。但 GNU 手册能以源代码形式获得，而这些（专有）手册只能以纸张的形式获得。GNU 手册允许复制和修改；Perl 的手册则不可以，这些限制就是问题所在。

自由手册的规范与自由软件的规范大致一样：它给所有的用户一定的自由。必须允许重新发布（包括重新商业发布），因此手册可以随着每一份程序，发布到网络上或发行印刷版。允许修改手册也是十分关键的。

作为一般准则，我不认为允许人们修改各种文章和书籍是必要的。写作问题不一定和软件问题相同。例如，我不认为你或我有权利去修改像这样一篇表明我们行为和看法的文章。

不过，自由软件文档的修改对自由很重要，这里有个特殊的原因。当人们行使他们修改软件的权力的时候，添加或是修改软件功能时，若有责任心的人，他们也会同时修改软件的手册——以便为修改后的软件提供准确可用的文档。不允许编程人员有责任心地完成他的工作，或更确切地要求程序员修改程序之后重新写一份手册，那么这样的手册是满足不了我们社区的需求的。

尽管全面禁止修改是不可接受的，但一些受限的修改方法还是可以接受的。例如，要求保留原作者的版权声明，发布条款或是作者名单，上述这些都是可以的。要告知版本已经被修改，甚至不许删除或修改整个章节，只要这些章节处理的是一些非技术性话题，像这些要求都没问题（一些 GNU 手册就是如此）。

这类限制不是问题所在，因为作为一个实际问题，他们没有阻挡有责任心的程序员去修改手册以适应修改过的程序。换句话说，他们没有阻止自由软件社区充分利用该手册。

然而，它必须能修改手册所有的*技术*内容，且随后通过所有常规渠道，在所有常规媒介中发布结果。否则，这些限制一定会阻碍社区，将手册变得不自由，而因此我们将会需要另一本手册。

很不幸的是，在专有手册存在的情况下往往很难发现有人写了另一本手册。问题在于很多用户认为专有手册已经足够好，因此他们没有意识到撰写自由手册的必要性。他们没有意识到自由操作系统还有缺陷仍需完善。

为什么用户认为专有手册足够好了呢？因为有些人不考虑这个问题。我希望本文将为改变这种状况做点贡献。

其他用户认为，专有手册可以被接受和许多人认为专有软件可以被接受有着同样的原因：他们纯粹是以实际需求来评判，而不将自由作为一项判断依据。这些人有权表达观点，但由于这些观点滋生于不自由的价值观，所以无法指导我们这些切实重视自由的人。

请将这个问题公之于众。我们仍然认为需要减少专有手册的出版量。如果我们传播专有手册不够好的言论，也许下一个愿意帮助 GNU 写文档的人将会在不是太晚的时候认识到，他必须首先使它自由。

我们也可以鼓励商业出版商销售自由、Copyleft 的手册以代替专有手册[^freedoc-2]。而帮助这项事业的方法是在购买之前检查手册的分发条款，尽量购买 copyleft 的手册，而不是非 copyleft 的手册。

[^freedoc-1]: 参见<http://shop.fsf.org/category/books/>和<http://gnu.org/doc/doc.html>

[^freedoc-2]: 其他出版商的自由图书可见此列表：<http://gnu.org/doc/other-free-books.html>

