\newpage
## 自由还是权力？

> Copyright © 2001, 2009 Bradley M. Kuhn 和 Richard Stallman 本文最初于 2001 年发表于 <http://gnu.org>。

> 本文由 Bradley M. Kuhn 和 Richard Stallman 撰写。

*对自由的爱是对他人的爱；对权力的爱是对自己的爱。——William Hazlitt*

在自由软件运动中，我们主张的是软件用户的自由。我们在规划视角的时候审视了哪些自由是美好的生活方式所必需的，并且使得实用的程序能够帮助一个友善、合力、协作的社区成长。我们对于自由软件的评价尺度[^free-or-power-1]指出了软件用户赖以同社区协作所需的自由。

我们主张程序员的自由，同对待其他用户一样。我们中的大部分人是程序员，在赋予您自由的同时也需要拥有我们自己的自由。但我们中的每个人都需要使用由他人编写的软件，并且我们需要在使用那些软件的时候拥有自由，而不仅仅是使用我们自己编写的代码的自由。我们代表所有用户的自由，不论他们经常、偶尔还是从不进行编程。

然而，有一种所谓的自由是我们绝不提倡的，即“为您所编写的软件随意选择授权许可的自由”。我们拒绝承认这一条的原因在于它实际上是一种权力而非自由。

这种时常被忽视的差别是至关重要的。自由是指能够做出主要是影响自己的决定；而权力是指能够做出影响他人甚于自己的决定。如果我们将权力和自由相混淆，我们将不能支持真正的自由。

使一个程序成为私有软件的行为是一种行使权力的行为。当今的版权法律赋予了软件开发者这样的权力，因此他们，也只有他们，可以选择施加于他人的规则——相对少数人替所有用户做出了关于软件的基本决定，通常是否定了用户的自由。当用户缺少定义了自由软件的那些基本自由的时候，他们不能获知自己所用的软件到底在做什么，不能检查软件的后门，不能监视可能存在的病毒或蠕虫，不能找出哪些个人信息正在被泄露（或者即使能够知道也无法阻止泄露）。如果软件不能正常工作，他们不能修复错误，而只能等待开发者行使他们的权力来进行修复。如果软件本身不能如同用户所需要的那样工作，他们将受困于此。他们不能帮助他人改进这些软件。

私有软件的开发者往往也是商业公司。在自由软件运动中，我们并不反对商业行为，但我们也看到了，当一家软件公司拥有对其用户施加任意规则的“自由”的时候将会发生什么。关于拒绝用户的自由是如何导致直接危害的，微软是一个极坏的例子，但还不是唯一。即使是在没有垄断的情况下，私有软件也会对社会造成危害。被迫在众多主宰者中选择一个的权利并不能称之为自由。

关于软件权利和规则的讨论往往专注于程序员的利益。世界上只有少数人经常编写程序，更少的人是私有软件公司的拥有者。但是如今整个发展着的世界都需要并且使用软件，因此现今的软件开发者实际控制了整个世界的生活、经营、通讯和娱乐的方式。伦理和政治上的问题并不是一句口号“选择的自由（仅对开发者适用）”就能解决的。

如果“代码就是法律”[^free-or-power-2]，那么我们所面对的真正问题就是：您所使用的代码究竟应该由谁来控制——您，还是少数菁英人士。我们相信您应该有权控制您所使用的软件，并且赋予您这样的控制权正是自由软件的终极目标。

我们坚信您应该有权决定您要使用软件做什么；然而，这不是当今的法律所表达的。当前的版权法律将我们置于这样的境地：权力凌驾于代码用户之上，不论我们是否喜欢这样。对于这种情况的伦理回应是宣示每一位用户的自由，如同权利法案要求以保证每位公民的自由为前提来行使政府的权力。这正是 GNU 通用公共许可证所致力于实现的：它使您能够控制您对软件的使用，同时保护您不被他人剥夺您做出决定的权利。[^free-or-power-3]

随着越来越多的人意识到代码就是法律，并且开始感受到他们也应当拥有自由，他们将会看到我们所主张的自由是多么重要，如同越来越多的用户开始感激我们所开发的自由软件带来的实际价值。

 [^free-or-power-1]: 关于自由软件的评价标准可参见《什么是自由软件》一文。

 [^free-or-power-2]:  William J. Mitchell, *City of Bits: Space, Place, and the Infobahn* (Cambridge, Mass.: MIT Press, 1995), p. 111, as quoted by Lawrence Lessig in *Code and Other Laws of Cyberspace, Version 2.0* (New York, NY: Basic Books, 2006), p. 5. 

 [^free-or-power-3]: 参见《为什么 Copyleft》获得更多信息。 

