\newpage
## 如何为你的作品选择一份许可证

> Copyright © 2011, 2013, 2014 自由软件基金会。此文于2011年首发于<http://gnu.org>。

### 前言

人们经常问我们，为他们的项目向他们推荐什么许可证。我们过去已经公开地写了关于这个的文章，但信息在不同的文章、FAQ 条目和许可证注释之间分散开了。这篇文章收集所有的信息至一个单一的来源中，让人们更简单地跟着做并可以重新引用。

这些推荐是用于设计来做实用工作的作品的。那些包括了软件、文档和一些其他的东西。艺术作品、以及表达一种观点的作品，则不一样；GNU项目对它们该怎么发布没有通用的立场，除了它们应该在没有非自由软件的情况下可以使用（特别是没有DRM[^recon-1]）。然而，对于和某个程序在一起的艺术作品，你可能需要听从这些推荐。

这些推荐可以用于许可一个你创建的作品——不论是已有作品的修改版还是原创作品。它们不用解决结合已有不同许可证的材料的问题。如果你在寻求那方面的帮助，请查看 GPL FAQ[^recon-2].

在你看了我们的推荐之后，如果你想要建议，你可以写邮件到<licensing@gnu.org>。注意许可证小组的回信可能需要几个星期；如果你在一个月内没有得到回复，请再写一次。

### 贡献到一个已有的项目

当你贡献到一个已有的项目时，你通常应该在和原有工作相同的许可证之下发布你修改过的版本。和项目的维护者合作是件好事，而为你的修改使用不同的许可证经常会让合作变得困难。你只应在有强大理由支持的时候才那样做。

一种可以支持使用不同许可证的情形，是当你在非 copyleft 许可证下的作品上做出了主要修改。如果你创建的这个版本比原来的版本有用得多，那么就值得让你的作品 copyleft 化，就和我们通常推荐 copyleft 的原因一样。如果你是在这种情况下，请遵循以下用于许可一个新项目的建议。

无论是什么理由，如果你选择以不同许可证发布你的贡献，你必须确保原有的许可证允许素材可以在你选择的许可证之下使用。安全起见，请明确地表示哪部分的工作是在哪种许可证之下。

### 软件

对不同的项目我们推荐不同的许可证，主要依据软件的目的。通常来说，我们推荐使用最 copyleft 而不影响那种目的的许可证。我们的文章“什么是copyleft?”更详细地解释了 copyleft 的概念，以及为什么它通常是最好的许可方案。

对大多数程序，我们推荐你为你的项目使用最新版的 GPL。它强大的 copyleft 适合所有类型的软件，并对用户的自由有很多保护。

现在看看例外情形。

#### 小程序

对大多数小程序，使用 copyleft 是不值得的。我们用300行作为基准：当一个软件包的源码比这个短，copyleft 带来的好处通常太小，来对抗确保许可证的复本总是伴随软件的不便。

对那些程序，我们推荐 Apache 2.0 许可证[^recon-3]。这是一个 pushover（非copyleft）软件许可证，它有用于避免贡献者和分发者起诉专利侵权的条目。这并不会让软件避免来自专利的威胁（一个软件许可证是做不到的），但它避免了专利持有者以自由为障目发布软件，这种情况下专利持有者会相当于做了一次“诱导转向”，然后要求接受者同意专利证书中的非自由条目。

在不严格的 pushover 许可证中，Apache 2.0 是最好的；所以如果你要用一个不严格的 pushover 许可证，不论什么原因，我们推荐用那一个。

#### 库

对于库，我们分三种情形。

一些实现了自由标准的库与那些限制性标准竞争，例如 Ogg Vorbis（和 MP3 音频竞争）和 WebM（和 MPEG-4 视频竞争）。对于这些项目，代码的广泛使用对于推进自由软件事业非常重要，会比在项目代码上的 copyleft 有更多的好处。

在这些特殊的情况，我们推荐 Apache 2.0 许可证。

对所有其他的库，我们推荐某种 copyleft 许可证。如果开发者已经正在现成的在非自由或不严格的 pushover 许可证，那么我们建议使用 GNU 宽通用公共许可证（LGPL）。

不像第一种情形，在那种情形中这个库实现了一个伦理上更优秀的标准，在这里让他自身承受风险并不会达成实际好处，所以没有理由完全避免 copyleft。然而，如果你要求用库的开发者在 copyleft 下发布整个程序，它们会简单地用另一个可用的库，那样也不会推进我们的事业。较为宽松的 GPL 是设计于填补这些情形中间地带的，允许私有软件开发者使用其保护起来的库，但考虑到库代码本身，提供了一些给用户自由的 copyleft。

对于提供了特别设计，并且不会与现有非 copyleft 或非自由库竞争的，我们推荐使用原始的 GNU GPL。要知道原因，请阅读“为什么你不应该为你下一个库用宽松的 GPL”<http://gnu.org/licenses/why-not-lgpl.html>。

#### 服务器软件

如果其他人很有可能会给你在服务器上跑的软件制作改进版并且不会向其他人分发他们的版本，而且你担心这将把你的版本置于一个不利的地位，我们推荐 GNU Affero 通用公共许可证（AGPL[^recon-4]）。AGPL 的条目和 GPL 几乎相同；唯一实质的区别是它有一个额外的条件确保通过网络用这个软件的人们可以获得它的源代码。

AGPL 的要求没有解决当*用户们*信赖其计算或者发送数据到别人的服务器时，会产生的问题。例如，它不会制止服务作为软件替代品（SaaSS）拒绝给予用户的自由[^recon-5]——但大多数服务器不做 SaaSS。要想知道更多关于这些的问题，请在 <http://gnu.org/licenses/why-affero-gpl.html> 阅读“为什么用 Affero GPL”。

### 文档

对教程、参考手册和其他大型文档工作，我们推荐 GNU 自由文档许可证。对教育型工作，这是个很强的 copyleft 许可证，最早为软件文档而编写，并包含特别说明，即当这些作品被分发或修改时的常见问题。

对于短的、次要的文档工作，例如参考卡片，最好使用 GNU 宽松的许可证[^recon-6]，因为一份 GFDL 的复本难以放进一张参考卡片里面。不要用CC-BY，因为它和 GFDL 不兼容。

对于 man 手册页面，如果页面很长，我们推荐 GFDL，而如果它很短，则推荐 GNU 宽松许可证。

一些文档包括了软件源代码。例如，一个编程语言的的手册可能包括让用户遵循的例子。你应当既在 FDL 之下在手册中包含它们，又在另一个适合软件的许可证下发布它们。这样做使得在其他项目中用这些代码变得简单。我们推荐你用 CC0[^recon-7] 贡献小段的代码到公有领域，并在有关软件项目使用的相同的许可证之下分发大段的代码。

### 其他用于程序的数据

这段讨论你会包括在软件中的所有其他实用工作。为了给你一些例子，这包括图表和其他功能性或有用的图像、字体和地理数据等。你也可以在艺术中遵循这些，尽管你不这样做我们也不会批评你。

如果你正特意为一个软件项目创作这些作品，我们通常推荐你在和软件使用相同的许可证下发布你的作品。用我们推荐的许可证这样做不会有问题：GPLv3、LGPLv3、AGPLv3 和 GPLv2 都可以用于任何类型——不只是软件——受版权保护并为修改版澄清首选的形式。使用与软件相同的许可证对分发者而言会让合规性更简单，并可以避免任何潜在的兼容性问题。如果提供了一些特别的实用的好处，比如和其他自由项目更好地合作，使用一个不同的许可证可能是合适的。

如果你的作品不是为某个特定的软件项目而创作的，或者使用和项目相同的许可证不合适，那么我们只推荐你选择一个适合你作品的 copyleft 许可证。有一些在我们的许可证列表中列出[^recon-8]。如果没有许可证看起来合适的，创作共用署名-相同方式共享许可证（CC-BY-SA[^recon-9]）是一个可以用于很多不同种类作品的 copyleft 许可证。

 [^recon-1]: 参见我们对数字限制管理 Digital Restrictions Management 的斗争活动[DefectiveByDesign.org](DefectiveByDesign.org)。

 [^recon-2]: 参见 <http://gnu.org/licenses/gpl-faq.html>.

 [^recon-3]: 此许可证全文参见 <http://apache.org/licenses/LICENSE-2.0>

 [^recon-4]: 此许可证全文参见 <http://gnu.org/licenses/agpl.html>

 [^recon-5]: 有关 SaaSS 可参见《服务器真正为谁服务？》一文

 [^recon-6]: 参见 <http://gnu.org/licenses/license-list.html\#GNUAllPermissive>

 [^recon-7]: 关于此许可证可参见 <http://creativecommons.org/about/cc0> 

 [^recon-8]: 参见 <http://gnu.org/licenses/license-list.html\#OtherLicenses>

 [^recon-9]: 关于使用此许可证可参见 <http://gnu.org/licenses/license-list.html\#ccbysa>
