\newpage
## 保护软件领域免受专利困扰

> Copyright © 2012, 2013 自由软件基金会，本文的一个版本最初以标题 “Let’s Limit the Effect of Software Patents, Since We Can’t Eliminate Them” 发表于《连线》杂志 Wired 网站（Wired，2012 年 11 月 1 日。<http://wired.com/opinion/2012/11/richard-stallman-software-patents/>）。该版本于 2012 年发表于 <http://gnu.org>

> 另请参阅我的文章 “Patent Reform Is Not Enough” <http://gnu.org/philosophy/patent-reform-is-not-enough.html>。

专利会对每位软件开发者构成威胁，我们长久以来一直担忧的专利之争终于打响了。软件开发者和软件用户——我们社会中的大多数人——需要保证软件不受专利困扰。

对我们构成威胁的那一类专利通常称为“软件专利”，但这个短语是带有误导性的。这些专利并非针对任何具体的程序。与之相反，每一项专利描述了某种实践上的想法和创意，并且宣称任何人试图实现这样的思想将会被起诉。因此，将它们称为“计算思想专利”更清楚。

美国专利体系并不会为每一项专利贴标签，称这项专利属于软件专利而那项不属于。事实上，是由软件开发者来为我们区分那些将会对我们构成威胁的——那些覆盖了可能在软件开发过程中实现想法的专利——以及其他的专利。例如，如果一项专利所保护的想法是关于一种物理结构或者一种化学反应的，没有程序可以实现那种想法；这样的专利并不对软件领域构成威胁。但如果一项专利所保护的想法是一种计算过程，那么该专利的炮筒是对准软件开发者和用户的。

这并不意味着那些计算思想专利仅仅会禁止软件。这些想法也会被实施在硬件中——并且它们中的很多已经被实施在硬件中。每项专利通常同时覆盖关于某种想法的硬件*和*软件实现。

### 关于软件的特别问题

时至今日，软件领域仍然是计算思想专利会造成特殊问题的地方。在软件领域，在一个程序中实施数千种想法是很平常的。如果它们中的 10% 受到专利保护，这意味着该程序受到数百项专利的威胁。

当供职于公共专利基金会（PUBPAT）的 Dan Ravicher 于 2004 年对一款大型软件（Linux，即 GNU/Linux 操作系统的内核）进行研究时，发现了 283 项美国专利可能覆盖了该程序中实施的计算思想。同年，一家杂志预计 Linux 约占整个 GNU/Linux 操作系统的 0.25%。将 300 乘以 400，我们可以得到这样的数量级估计，即该系统作为一个整体正在受到*约 10 万项软件专利的威胁*。

如果这些专利中的半数由于“品质不良”——即由于专利系统本身的问题——而被判无效，这并不能真正带来改观。不论是 10 万项专利还是 5 万项专利，都是同样的灾难。这是为什么不应该将我们对于软件专利的批评局限于“专利流氓”或“劣质专利”的层面的原因。当今最坏的专利侵略者是苹果，它不仅仅是通常意义上的“专利流氓”；我不清楚苹果的专利是否属于“优质”，但是那些专利的“质量”越好，其所带来的威胁就越大。

我们需要解决全部的问题，而非部分。

关于解决这一问题的常见建议包括在立法层面修改专利授予的评价尺度——例如，禁止对计算实践以及实现它们的系统进行专利保护。这种方式有两个明显的缺陷。

其一，专利律师精于将专利换一种方式表达，使其能够适合任何规则；他们将任何旨在限制专利实质的尝试化解为仅仅是形式上的要求。例如，美国的很多计算思想专利描述了这样一种系统，它包括一个算术单元、一个指令排序器、一块内存、加上用于执行特定计算过程的控制器。这是对于一台计算机运行一个程序以进行某种计算的一种古怪描述；它是被设计用于使专利申请满足那些美国专利体系在一段时间内要求满足的评估标准。

其二，美国已经有了数千项计算思想专利，更改评估标准以阻止批准更多的专利并不能帮助我们摆脱已有的那些。我们不得不等上将近 20 年，才能等到这一问题随着那些已有专利过期而彻底解决。我们可以展望立法废除那些现存的专利，但这很可能是不符合宪法的（美国最高法院不顾一切地坚持要求国会有权以牺牲公共权利为代价扩展私人特权，而不是相反）。

### 另一种方式：限制专利的效力，而非专利的可获得性

我的建议是改变专利的*效力*。我们应当立法规定，在通用计算硬件上开发、发布、运行程序并不构成专利侵犯。这样有几个好处：

-   不再需要区分专利或者专利申请到底属于“软件专利”还是“非软件专利”；

-   可以对开发者和用户提供保护，不论对于现存的还是将来潜在的计算思想专利；

-   专利律师不能再通过以其他方式编写专利申请来消除这种有意而为的效力。

这种方式并不会使现存的计算思想专利完全失效，因为它们仍然可以被应用于基于使用特殊用途的硬件来实现。这是一种好处，由于它打消了有关这一计划的合法性的争论。几年之前，美国曾经通过一项法律，保护外科医生不受专利起诉，因此即使一些外科手术流程受专利保护，外科医生仍然是安全的。这样的实践为这种解决方案提供了先例。

软件开发者和软件用户需要得到对于专利威胁的保护。这是唯一能够提供对所有人全面保护的法律解决方案。然后我们可以重新回到竞争或合作……并且无需担心某些陌生人会抹除我们的工作成果。

