\newpage
## 对版权的错误解读——一系列错误

> Copyright © 2002, 2003, 2007, 2009–2011 自由软件基金会。本文最初于 2002 年发表于 <http://gnu.org>

版权法中发生了一些奇怪而又危险的事情。在美国宪法环境下，版权存在的意义是使用户获益——用户是指那些读书、听音乐、看电影或者运行软件的人们——而非为了出版商或作者。然而，即使人们越来越倾向于拒绝并且反抗那些“为了他们自己的好处”而强行施加给他们的各种版权限制，美国政府仍然正在施加更多的限制，并且试图以新的严厉惩罚措施来恐吓公众以迫使其服从。

那么，版权政策是如何一步一步地走到与其宣称的初衷背道而驰的地步的呢？而我们又如何才能使其重新回到与其初衷相符的正轨呢？为了理解这些，我们应当首先审视美国版权法的根基：美国宪法。

### 美国宪法中的版权

当美国宪法被起草之时，作者们应当被赋予某种版权垄断权这一想法被提出——然后又被拒绝了。我们国家的创始人采纳了另一种假设，即版权并非作者们的一种自然的权利，而是以进步之名，人为地为他们做出的一种认可。宪法通过这一条款（第 I 章，第 8 条，第 8 款）许可了这样一种版权体系：

> （国会应当拥有权力）通过在一段限定的时间内保证作者和发明者对其作品或发明拥有专属权利，以促进自然科学和实用艺术的进步。

美国最高法院已经一再强调，促进进步意味着保护那些版权作品的使用者的利益。例如，在*Fox Film 起诉 Doyal 的案例* [^mis-copyright-1]中，法庭说道：

> 美国的根本利益以及赋予（版权）垄断权的主要目的是基于那些由公众得来、通过作者的劳动获得的普遍利益。

这一根本性的决定解释了为何版权不是被宪法强制要求的，而只是作为一种选项而被许可——以及为何只应该在一段“限定的时间”内有效。如果版权是一种自然的权利，即某种作者们由于应当拥有它而拥有的东西，那么没有任何理由可以解释为何可以在一定时期之后终止这种权利，就如同不能解释为何每个人的房子在建成一定时期之后应当成为公共财产。

### 版权交易

版权体系通过为出版商和作者提供特权以保证其利益进而维持其自身运转；然而，这么做并非为了他们的利益。与之相反，它如此运作是为了改变他们的行为：即刺激作者们创作并且发表更多作品。事实上，政府是在以公众的名义消费公众的自然权利，作为交易的一部分为公众带来更多的发表作品。法学家们将这一概念称为“版权交易”。就如同政府花费纳税人的钱财以购买一条高速公路或者一架飞机，区别只是在于此处政府花费的是我们的自由而非我们的钱财。

但是，这种版权交易对于公众而言真的是一种公平的交易吗？众多其他交易方式都是可能的；哪一种方式最好呢？版权政策的每一个问题都是这个问题的一部分。如果我们对这个问题的本质产生误解，我们将会倾向于对这些问题做出不恰当的抉择。

宪法批准了将版权权力赋予作者。而实际上，作者们通常将其转让给出版商；因此实际上通常是出版商而非作者在行使这些权力从而得到大部分利益，尽管作者有时也能得到一小部分利益。因此通常只是那些出版商在游说政府以进一步增加版权权力。为了更好地反映关于版权的事实而非那些鬼话，本文将会把出版商而非作者称为版权权力的持有者，并且将有版权作品的使用者称为“读者”，即使对这些作品的使用并非只能是阅读，这是由于“用户”一词过于遥远和抽象。

### 第一个错误：寻求平衡

版权交易将公众置于首要地位：公众读者的利益是其一端；出版商的利益（如果有）只是达成这一目的的一种方式。因此，读者的利益和出版商的利益首先在质上是不对等的。对版权的目的的第一步错误解读是将出版商的利益的重要性提升到与读者的利益相同的级别上来。

通常有这样的说法，美国版权法旨在在出版商和读者的利益之间“寻求平衡”。那些援引这种解读方式的人们将其呈现为一种对宪法中所陈述的基本立场的复述，换言之，它应当与所谓的版权交易等价。

但是，这两种解读其实有着天壤之别；它们不仅在概念上截然不同，在涵义上也是完全不同的。这种“平衡”的概念假设读者和出版商的利益在重要性上的差别只是量上的，即我们应当分别给予它们多少*权重*，以及它们适用于哪些场合。“利益相关方”的概念通常被用于以这种方式描述这一问题。这种观点抹杀了读者和出版商的利益在质上的区别，而这种区别正是政府参与版权交易的基本点。

这种偷换概念的影响是深远的，由于在版权交易中对公众利益的强有力的保护——版权特权只能以读者之名被合理化，而绝非以出版商之名被合理化这一理念——被这种“平衡”的解读方式所抛弃了。由于出版商的利益也被视为其中一端，它也可以使版权特权合理化；换言之，“平衡”概念宣称版权特权可以以公众以外的某人之名被合理化。

从实践角度讲，这种“平衡”概念的结果是逆转了在版权法中做出更改所需正当理由的负担。版权交易将这种负担置于出版商一方，他们需要说服读者转让部分自由。而平衡概念逆转了这种负担，实事求是地说，由于对于出版商将会通过额外的特权得到好处这一点没有异议。除非这对读者造成的伤害能够被证实，并且这种伤害大到了已经超出读者所能得到的好处的程度，我们将会得出结论：出版商被赋予了它们要求的几乎所有特权。

由于在出版商和读者之间“寻求平衡”的理念否定了读者本应拥有的首要位置，我们必须坚决反对。

### 针对什么的平衡？

当政府为公众购买任何东西之时，它是在以公众的名义进行交易；它的责任是试图得到最佳的可能交易方式——对公众而言的最佳，而非对于交易中的另一方。

例如，当政府与建设公司签署合同以修建高速公路时，政府应当致力于花费尽可能少的公众资金。相关政府机构将会通过竞争性投标的方式来降低总价。

从实践角度讲，这一价格不可能为零，因为承包商不可能叫出那么低的价格。尽管没有获得特别报酬的资格，它们在自由社会中仍然享有通常的公民权利，包括拒绝对其不利的合同的权利；即使最低竞价也足以使某些承包商有利可图。因此，这里确实存在着某种平衡。但这并非由于利益双方各自要求得到特殊报酬而达成的一种蓄意的平衡。这是一种在公众目标和市场力量之间达成的平衡。政府试图为驾车的纳税人获得他们在自由社会和自由市场的大背景下可能得到的最佳交易。

在版权交易中，政府花费的是我们的自由而非我们的钱财。自由远比金钱更加珍贵，因此政府对于理性而节约地花费我们的自由的责任更重于花钱的责任。政府绝不应该将出版商的利益与公众的自由相提并论。

### 不是平衡，而是折中

将读者利益与出版商利益进行平衡是对版权政策的错误判断，但是，此处确实有两种利益需要被权衡：关于*读者*的两种利益。读者自身有其关于使用出版作品的自由的利益；取决于所处环境，他们还可能拥有通过某种激励系统鼓励发表作品的权利。

由于在讨论版权问题时，“平衡”一词被用于指代在读者和出版商之间“寻求平衡”这一理念。因此，对于读者自身的两种利益使用“平衡”一词将会产生歧义[^mis-copyright-2]。我们需要另一个术语。

通常意义上，当某一团体拥有两种部分冲突的目标而不能两全之时，我们称之为“折中”。因此，与其说在两个团体之间“寻求正确的平衡”，不如说“在花费与保留我们的自由之间寻求最佳的折中”。

### 第二个错误：最大化一项输出

版权政策中的第二个错误包括将最大化——而非仅仅是增加——出版作品数量作为最终目标。第一个错误概念“寻求平衡”将出版商的地位提升到与读者对等的位置，而这第二个错误则将它们的地位进一步提升到远在读者之上的位置。

当我们购买物品时，我们通常不会买空所有库存或者只买最贵的型号。与之相反，我们将会为其他购买需求预留资金，对于任意特定的物品，只买我们所需要的，并且选择一种能够满足需求的型号而非最高端的型号。根据报酬递减原理，将我们的所有可用资金花在某一特定物品上很可能是一种低效的资源分配方式；我们一般会选择将部分资金留作他用。

报酬递减原理也适用于版权交易，如同它适用于任何其他购买行为。我们应当最先卖出的自由是那些使我们失去得最少的那部分自由，并且这部分自由的牺牲能够换取对作品出版的最大激励。随着我们继续卖出的自由越来越关乎自身核心利益，我们将会发现每一笔新的交易相对于上一笔都是更大的牺牲，同时它们所能带来的出版活力增量越来越小。而当这种增量远未减到零之前，我们就会说不值得为之付出不断增加的代价；而后我们将会达成某种交易，其最终结果是增加了出版量，但并未达到可能的极限程度。

将最大化出版量作为最终目标将会预先拒绝所有这些更加明智、更加有利的交易方式——它强制规定公众必须出卖几乎全部自由来使用出版作品，而仅仅是为了换取一点点出版量的增加。

### 具有欺骗性的最大化

在实践中，将最大化出版量作为最终目标而全然不顾自由的代价这一理念是由一系列具有欺骗性的说法所支撑的。这种说法宣称公众对出版物进行复制的行为是非法、不公平、并且本质上错误的。例如，出版商将复制出版物的人们称为“盗版者”，这种诽谤性的称谓将与您的邻居分享信息的行为与攻击船只的行为等同起来（这一诽谤性的称谓最初被作者用于描述那些找到了以某种合法方式出版未经授权许可的版本的出版商；而它被出版商所使用的现代用法几乎与其原意完全相反）。这种欺骗性的说法直接抹杀了版权的宪法基础，而是如同表现美国法律体系中那些公认的传统那样呈现其自身。

“盗版”这一具有欺骗性的说法之所以被普遍接受，是由于它充斥于各种媒体，以至于极少有人意识到它到底有多么重要。它是如此地强有力，因为如果由公众进行复制是根本非法的，我们将完全不能对抗出版商强制要求我们牺牲自己的自由的行为。换言之，当公众被威胁给出理由以证明为何出版商不应获得某些额外权力之时，所有理由当中最重要的一条——“我们想要复制”——已经被预先否决了。

这封死了通过争论反对与日俱增的版权权力的所有出路，除了一些细枝末节的问题。因此，今天对于日益强大的版权权力的反对几乎只能援引一些旁枝问题，并且从来不敢援引本应作为一种合法公众价值的再分发副本的自由。

从实践角度讲，出版量最大化这一最终目标使得出版商可以如此论述：“某种行为正在削减我们的销量——或者我们认为它将会这样——因此，我们假定它使得出版量下降了一定的未知数量，因此它应当被禁止。”我们将会得到这样一种不可容忍的结论：公众的利益应当以出版商的销量来衡量，大凡对大众媒体公司有利的东西，对美国也都是好的。

### 第三个错误：最大化出版商的权力

一旦出版商得到了这样的许可，即为了达到出版输出最大化的政策目标可以不计任何代价，那么下一步就是推断出这需要赋予它们最大可能的权力——使得版权覆盖于一篇作品任何想象到的使用方式，或者应用某些其他法律工具诸如“拆封包装”许可证来实现同样的效果。这一目标涉及废除“合理使用”和“首次销售权”，它已经被各级政府强制执行，从美国各州到各个国际机构。

这一步骤是错误的，由于严酷的版权规则阻碍了新的有益作品的创作。例如，莎士比亚从其他人于数十年前发布的作品中借用情节用于自己的剧本，因此，如果今天的版权法在当时有效，他的剧本将成为非法。

即使我们真的想要最大可能的出版量而无视公众为之付出的代价，最大化出版商的权力也是达成这一目标的错误方式。作为一种本意在于促进进步的方式，这种做法是自相矛盾的。

### 三大错误的后果

当前的版权立法趋势是赋予出版商更宽泛的、持续时间更长的权力。而版权的概念基础自从被这一系列错误所扭曲之后，几乎没有给读者留下任何说“不”的权利。立法者口头上大肆鼓吹版权服务于公众这一理念，而实际上却一直在赋予出版商们想要的任何东西。

例如，参议员 Hatch 在介绍 S.483 法案[^mis-copyright-3]时如是说，这条于 1995 年通过的法案将版权的期限延长了 20 年。

> 我相信我们现在需要搞清楚这个问题：当前的版权期限是否足以保护作者的利益，以及与之相关的另一个问题：当前的版权保护期限是否足以继续为作者创作新作品提供足够的激励。[^mis-copyright-4]

这一法案延长了那些自 20 世纪 20 年代以后创作的已发表的作品的版权期限。这一改变是对出版商的慷慨赠予，而不可能为公众带来任何好处，由于现在不可能以任何方式逆动地增加当时的出版量。然而，这剥夺了公众的一项在今天看来非常有意义的自由——再分发当时出版的作品的自由。注意，他们所鼓吹的“保护”[^mis-copyright-5]一词的用法中包含了三大错误中的第二项。

这条法案同时延长了将要被创作的作品的版权期限，对于出资聘用作者创作的作品，版权期限将会持续 95 年而非当前的 75 年。理论上这将会增加对创作新作品的激励；但是，任何宣称需要这项额外刺激的出版商应当被要求以未来 75 年预期的财务状况表来证明这一要求的合理性。

不言而喻的是，国会并不会质疑出版商的论证：一项版权延长法律于 1998 年实施。它的官方名称是 Sonny Bono 版权期限延长法案，它是以一位当年早些时候去世的支持者命名的。我们通常称之为米老鼠版权法案，由于我们认为它的真实动机是防止米老鼠的形象的版权过期。Bono 的遗孀以他的名义完成了剩下的工作，并作了如下声明：

> 事实上，Sonny 希望版权保护期限持续到永远。我被一位工作人员告知这样一种改变将会违反宪法。我现在邀请各位与我共同努力，以所有可能的方式强化我们的版权法。你们应当知道，还有 Jack Valenti [^mis-copyright-6]的提案建议版权的保护期限为“比永远少一天”。也许委员会可以期待下一届国会。[^mis-copyright-7]

美国最高法院随后听说一个案例，这一案例试图在根本上推翻该版权法律，由于反动地延长版权期限未能符合宪法关于促进进步的终极目标。法庭以放弃其判决该问题的责任作为回应；在版权问题上，对宪法只需要空口应酬。

另一条于 1997 年通过的法律使得为任何已发表作品复制达到一定数量的副本成为一项重罪，即使您将它们送给遵纪守法的朋友。而在此之前，这在美国甚至不是一项罪行。

一条更坏的法律，数字千年版权法案（Digital Millennium Copyright Act，DMCA），被设计为重新带回一种当时被称为“复制保护”的东西——现在称之为数字限制管理（DRM）[^mis-copyright-8]——这是一种已经被用户所唾弃的东西，它使得破解这些限制规则，甚至只是发表关于如何破解它们的信息成为犯罪行为。这条法律应当被称作“媒体公司支配法案”（Domination by Media Corporations Act），由于它事实上赋予了出版商编写自家版权法的权力。它宣称它们可以对作品的使用强行施加任何限制，并且这些限制将具有法律效力，如果该作品包含某种加密或者许可证管理器之类的强制实行措施。

用于支持该法案的一种论证是它可以实现一种现代条约以增加版权权力。该条约由世界“知识产权”组织（WIPO）[^mis-copyright-9]所大肆宣扬，这一组织被版权与专利持有人的利益所支配，并且得到了克林顿政府以施压方式提供的支持；由于该条约只是强化了版权权力，至于它在任何国家是否有利于公众利益尚存争议。无论如何，这条法案的效力大大超出了这项条约所要求的。

图书馆曾经是反对此法案的重要来源，尤其针对该法案中禁止某种可被视为合理使用的复制行为这一方面。那么出版商一方是如何回应的呢？前代理人 Pat Schroeder，现在作为美国出版商协会（AAP）的说客如是说：“出版商与图书馆的诉求不共戴天”。由于图书馆的诉求只是维持部分现状，人们可以以此作为回应：出版商到底是怎样活到今天的。

国会议员 Barney Frank 在一次与我和其他反对该法案的人士举行会谈时，展示了美国宪法中关于版权的观点在多大程度上被无视了。他宣称由犯罪刑罚所支撑的新的版权权力是急迫需要的，由于“电影行业感到担忧”，同样还有“音乐行业”和其他“行业”。我问他：“但是，这是为了公众的利益吗？”他如此回应：“你有什么资格谈公众利益？那些富有创造性的人们不需要为了公众利益而牺牲他们的权利！”在这里“行业”被视同它所雇佣的“富有创造性的人们”，版权被视为它应有的权利，而宪法的本意则被彻底颠倒了。

DMCA 于 1998 年被实施。随之，它宣称合理使用在名义上尚属合法，但它允许出版商禁止所有那些您可能对其进行合理使用的软硬件。事实上，合理使用已被禁止。

基于这一法律，电影业对用于读取和播放数码多功能影音光盘（DVD）的自由软件，乃至关于如何读取它们的信息强行实施了审查。2001 年四月，普林斯顿大学 Edward Felten 教授受到来自美国唱片业协会（RIAA）的法律诉讼的威胁以撤销一篇关于他从一种被提议用于限制对录制音乐访问的加密系统中所学到的东西的科研论文。

我们同样开始见到那些剥夺了众多读者的传统阅读自由的电子书——例如，将书借给您的朋友，或是卖给二手书店，或是从图书馆借阅，或是无需将您的名字告知公司数据库便可购书，甚至是再次阅读某本书等等这些自由。加密的电子书通常限制了以上这些活动——您只能利用某种被设计用于限制您自由的特殊私密软件来读取它们。

我坚决不会购买任何一部这种加密、受限的电子书，并且我也希望您也能拒绝它们。如果一部电子书不能赋予您与纸版书相同的自由，就不要接受它！

任何人擅自发布可用于阅读受限的电子书的软件将面临被起诉的风险。一位俄国程序员 Dmitry Sklyarov 于 2001 年访问美国期间参加一次会议演讲时被逮捕，由于此人在俄国编写了一款这样的程序，而这当时在俄国尚属合法。现在俄国正准备通过一条法律以禁止这种行为，而欧盟最近已经采纳了这样的一条法律。

面向大量最终用户销售的电子书目前看来在商业上并不很成功，但这并非由于读者选择捍卫他们的自由；而是由于其他原因不受欢迎，例如计算机屏幕并不是一种适合于轻松阅读的平面。我们不可能长期依赖这种好的缺陷来保护我们自己；用于促销电子书的下一步尝试是使用电子纸——一种像书本一样的东西，可以向其中下载加密、受限的电子书。如果这种像纸一样的平面能够提供比现在的显示屏更有吸引力，我们将不得不捍卫我们的自由以便继续拥有它。与此同时，电子书正在利基市场（niche market）中觅得商机：纽约大学（NYU）和其他牙科学校要求其学生以受限的电子书格式购买它们的教材。

媒体公司对此仍不满足。2001 年，由迪士尼赞助的参议员 Hollings 提议了一条“安全系统标准与认证法案”（Security Systems Standardsand Certification Act，SSSCA）[^mis-copyright-10]，它要求所有计算机（及其他数字录制与回放设备）必须带有政府强制要求的限制复制系统。这是它们的最终目的，但它们日程上的第一件事是禁止任何可以调谐数字高清电视（HDTV）的设备，除非它被设计为使得公众不可能对其进行“恶意篡改”（即以公众自己的目的进行修改）。由于自由软件是用户可以修改的，我们在此首次遭遇了这样一种被提议的法律，它将明确禁止自由软件被用于某种特定任务。可以预见对于其他任务的自由软件禁令也一定会随之而来。如果美国联邦通信委员会（FCC）采纳这一规则，现存的自由软件诸如 GNU Radio 将会被审查。

阻止这些法案和规则的通过和实施需要政治行动[^mis-copyright-11]。

### 寻找正确的版权交易

那么，决定版权政策的恰当方式是什么呢？如果版权是一笔以公众为名进行的交易，它应当把服务于公众利益放在至高无上的地位。政府在消费公众自由的时候应尽的职责是只去花费那部分必须花费的，并且要换取尽可能多的回报。最起码的要求是，我们应当尽可能减少版权权力的程度，同时又能维持与之相适应的出版量级别。

既然我们不能通过竞标来找到自由的最小代价，如同我们在对待建设工程时那样。我们怎样才能找到正确的版权交易方式呢？

一种可能的方式是分阶段减少版权特权并且考察其效果，通过观察出版量是否发生了显著减少以及何时发生，我们可以获知为了达到公众预期的目标所真正必需的版权权力是多少。我们必须基于真实的观察来评估这一点，而非根据出版商所说将会发生什么来进行判断。由于它们会尽其所能做出夸张的悲观预期，如果它们的权力以任何形式受到限制。

版权政策包含多种独立的方面，它们可以被单独评估。当我们找到了它某一政策方面所必需的最低限度以后，仍然可能继续减少其他方面的版权限制，以维持理想的出版量水平。

版权的一个重要方面是它的持续时期，而现在的版权期限通常是以一个世纪作为数量级的。将这种对复制的垄断权缩短到 10 年，从该作品发表日期开始计算可能是一种合理的第一步。而版权的另一方面，即覆盖了创作其衍生作品的方面，可以持续稍长一段时间。

为何从作品发表之日开始计算？由于未发表的作品的版权并未直接限制读者的自由；我们是否拥有复制一篇作品的自由并不重要，如果我们还没有得到它的副本。因此，给予作者一段较长时间来发表作品并不会造成伤害。作者们（通常在作品发表之前确实拥有其版权）很少会仅仅为了推迟其版权终止的日期而选择延迟发布作品。

为何是 10 年？由于这是一种安全的提案；我们能够以基于实践的理由确信这一期限的减少并不会为当今的总体出版活力带来什么冲击。在大部分媒体和流派当中，成功的作品只在短短的几年之内能够带来丰厚利润，并且即使是成功的作品通常也会在远未到达 10 年期限之时绝版。即使是对于参考文献类的作品，它们的有用生命周期可能长达几十年，10 年的版权期限也是足够的：由于更新的版本还将正常出版，并且很多读者将会愿意购买仍然受到版权保护的当前版本而非复制一份已经处于公有领域中的，十多年前的旧版副本。

10 年也许仍然比真正必需的时间要长；一旦这个问题得到解决，我们可以尝试进一步缩短这一期限来对版权体系进行调整。在一次有关文学作品版权惯例的研讨会上，我提出了 10 年期限的提议，坐在我身旁的一位著名科幻作家表示强烈反对，他认为超过 5 年期限的任何限制条件都是不可容忍的。

但是，我们不必须对所有类别的作品都采用相同的时间期限。维持版权政策的绝对平均对于公众利益并非至关重要，并且版权法对于某些特殊应用场景和媒体类型已经有了很多例外条款。为每项高速公路工程都按照国内成本最高地区的最困难工程所必需的价格标准付费是愚蠢的，而为每种类型的艺术作品都按照我们所发现的对于任何一类作品所必需的自由代价中的最高标准来“花费”自由同样愚蠢。

因此也许小说、字典、计算机程序、歌曲、交响乐、电影等等应当具有不同的版权期限，于是我们可以将任何一类作品的版权期限缩短到众多待发表的同类作品所必需的程度。也许一小时以上的电影可以拥有 20 年的版权，考虑到创作它的开销。在我本人的领域，计算机编程，3 年应当足够，由于产品的生命周期远比这一时限更短。

版权政策的另一方面是合理使用的限度：对已发表的作品的全部或部分进行复制的某些方式为法律所许可，即使该作品受版权保护。减少这方面的版权权力的第一步自然是允许私人进行偶尔的小批量非商业性复制并且对个人用户分发。这将阻止版权警察对人们私人生活的入侵，但对于已发布的作品的销售很可能并不会造成什么影响（可能有必要采取其他法律步骤以保证拆封包装许可不能被用于取代版权并且藉此限制这种复制的权利）。Napster 的经验显示我们还应允许面向公众的非商业性逐字再分发——由于公众之中有那么多的人想要复制和分享，并且他们发现这是那么有用，只有德拉古式的暴政才会禁止这些，而公众理应得到他们想要的。

对于小说及其他用于消遣的一般作品形式，非商业性的逐字再分发可能足以保证读者的自由。计算机程序被用于功能性的目的（用于完成某项任务）需要在此基础上的更多自由，包括发布改进版本的自由。参见本书《什么是自由软件？》一文中“自由软件定义”章节以获知关于计算机软件用户应当享有的自由的解释。而在程序发布之后两三年才能使得这些自由全部可获得也不失为一种可接受的妥协。

以上这些改变将使得版权回归公众希望的，使用数字技术进行复制的意愿轨道上来。出版商将会毫无疑问地发现这些提案是“不公平”的；它们也许会威胁退出出版业，但却不会真正如此，由于这一行业仍然有利可图，并且仍将是最好的行业。

在我们思考如何减少版权权力的同时，我们必须保证媒体公司不会简单地将其改为最终用户许可协议（EULA）。有必要禁止使用合同来对版权范围以外的复制施加限制。对于面向大量最终客户的不可谈判合同所能要求的东西进行限制是美国法律体系中的一个标准组成部分。

### 个人注记

我是软件设计者而非法学学者。我之所以对版权问题感到担忧是由于这在计算机网络世界，例如互联网中，是无法回避的。作为一个用了计算机和网络 30 多年的用户，我衡量了我们已经失去的以及将要失去的自由的价值。作为一位作者，我有权拒绝将作者比作半神的创造者这一富有幻想性的神话，而出版商经常援引这一点作为依据以支持增加作者的版权权力——然而作者随后就会把这些权力出让给出版商。

本文的大部分内容包含了您可以查证的事实和推理，还有您可以用于构建您自己想法的提议。但是我再次请求您接受我个人的看法：诸如我这样的作者并不应该拥有凌驾于您之上的权力。如果您想要对我所编写的软件或书籍表示感谢，我将会心存感激地接受一张支票——但请您不要以我的名义放弃您的自由。

 [^mis-copyright-1]: Fox Film Corp. v. Doyal, 286 US 123, 1932. 

 [^mis-copyright-2]: 参见 Julian Sanchez 的文章 “The Trouble with ‘Balance’ Metaphors” (4 February 2011, <http://juliansanchez.com/2011/02/04/the-trouble-with-balance-metaphors/>以获得关于“合理判断与平衡权重之间的类比能够怎样以有害的方式限制我们的思考”这一问题的深入调查。

 [^mis-copyright-3]: Congressional Record, S. 483, “The Copyright Term Extension Act of 1995,” 2 March 1995, pp. S3390–4. 

 [^mis-copyright-4]: Congressional Record, “Statement on Introduced Bills and Joint Resolutions,” 2 March 1995, p. S3390, <http://gpo.gov/fdsys/pkg/CREC-1995-03-02/pdf/CREC-1995-03-02-pt1-PgS3390-2.pdf>. 

 [^mis-copyright-5]: 参见《应避免使用（或慎用）的词语》一文以获知为何在与版权相关联时应当避免使用“保护”一词。 

 [^mis-copyright-6]: Jack Valenti 是美国电影协会（MPAA）常任主席。 

 [^mis-copyright-7]: Congressional Record, remarks of Rep. Bono, 7 October 1998, p. H9952, <http://gpo.gov/fdsys/pkg/CREC-1998-10-07/pdf/CREC-1998-10-07-pt1-PgH9946.pdf>. 

 [^mis-copyright-8]: 参见 <http://gnu.org/proprietary/proprietary-drm.html> 以获得关于这一问题的更多信息。 

 [^mis-copyright-9]: 参见《您说过“知识产权”吗？这是一种迷惑性的幻景》一文以获知为何这一短语是有问题的。 

 [^mis-copyright-10]: 由于它被更名为不可拼读的 CBDTPA，一种有助于理解和记忆的解读是“消费但不要尝试编程法案”（Consume, But Don’t Try Programming Anything），而其真正名称是“消费者宽带和数字电视促进法案”（Consumer Broadband and Digital Television Promotion Act） 

 [^mis-copyright-11]: 如果您真的想要提供帮助，我推荐以下网站：<http://defectivebydesign.org>, <http://publicknowledge.org>, and <http://eff.org>.
