\newpage
## 您说过“知识产权”吗？这是一种迷惑的幻景

> Copyright © 2004, 2006, 2007, 2009, 2010, 2013, 2015 Richard Stallman。本文创作于 2004 年并且发表在 Policy Futures in Education, vol. 4, n. 4, pp. 334–336, 2006。

有这样一种时兴的趋势：将版权、专利、商标——三种相互独立而又不同，并且涉及三种独立而又不同的法律概念——再加上其他几十种法律一股脑地装进一个罐中，并称之为“知识产权”。这种涵义扭曲而又使人混淆的概念变得普遍流行并非偶然。从这种混淆中得利的商业公司推动了这种混淆。要想避免这种混淆，最明了的方式就是完全拒绝这一概念。

根据现在供职于斯坦福法学院的 Mark Lemley 教授的观点，对“知识产权”这一概念的广泛使用变得流行是始于 1967 年世界“知识产权”组织（WIPO）的成立，而这一概念只是在最近数年才变得真正普遍（WIPO 是联合国的正式机构之一，但它实际上代表的是版权、专利及商标持有人的利益）。这一概念的广泛使用始于 1990 年前后。

这一概念本身具有一种不难觉察的偏见：它暗示人们在思考版权、专利和商标的时候同实物的产权进行类比（这种类比与版权法、专利法、商标法存在矛盾，但只有专业人士了解这种矛盾）。这些法律实际上并不像物权法，但这一概念的滥用使得立法者将它们修改得越来越像后者。由于这种转变正是那些行使版权、专利和商标权力的商业公司所求之不得的，于是这种由“知识产权”这一概念所带来的偏见迎合了它们。

这种偏见已经足以成为拒绝这一概念的理由，并且人们经常建议我为这一整体类别起个别的名字——也有人提出了他们自己起的名字（通常是幽默的）。这些名字包括“小恶魔”（IMPs，意为 Imposed Monopoly Privileges，即“强制垄断特权”）以及“魔像”（GOLEMs，意为 Government-Originated Legally Enforced Monopolies，即“政府主导的合法强制垄断”），还有人说“专属权利王国”（exclusive rights regime，ERR），但将“限制”（restriction）指代为“权利”也是一种双关。

有些别名可能确实是更好的称谓，但是，使用它们中的任何一个来指代“知识产权”则是一种错误。由于其他名字都未能揭露这一概念的深层次问题：过度广义化。并不存在诸如“知识产权”这样高度统一的事物——它是一种幻景。人们之所以会误认为“知识产权”是一种合乎逻辑的分类，原因仅仅在于这一概念的广泛使用对于人们理解相关法律产生了误导。

“知识产权”这一概念充其量只是把不同类的法律混装在一起的杂物容器。非法律专业的人们在听到这一适用于不同法律的概念时，倾向于想象它们相似地基于某种共同的原则和功能。

然而，事实远非如此。这些法律是独立起草的，以不同方式演进的，覆盖不同的行为，拥有不同的规则，、并且由此带来了不同的公共政策问题。

例如，版权法被设计为提升作者身份和艺术，并且覆盖了作品表达的细节。专利法的本意是促进发表有用的想法，其代价是赋予想法的发表者关于此想法的暂时垄断权——这种代价对于某些领域是值得付出的，而对于其他领域则不然。

与之不同的是，商标法的本意并非提升任何行为方式，而只是让消费者知道他们所购买的东西是什么。受“知识产权”概念影响的立法者却将它变成了一种刺激广告行为的模式。而这些只是他们所谈论的众多法律里的三种。

由于这些法律是独立发展的，它们在任何细节上都是不同的。它们的基本目的和方法也是不同的。因此，如果您知道某些关于版权法的细节，并且您明智地想象专利法在这些方面与之不同，您将几乎不会犯任何错误！

事实上，您所遇到的那些基于“知识产权”所阐述的广义化的陈述几乎全部是错误的。例如，您可能会看到这样的宣传：“知识产权”的目的是“促进创新”，但这仅仅适用于专利法，也许还有植物品种垄断权。版权法与创新没有关系，一支流行歌曲或是一部小说即使没有任何创新也可以获得版权。商标法和创新也没有关系；如果我自营一家茶店并将其命名为“RMS 茶”，它将成为合法的商标，即使我以和任何其他人相同的方式贩卖茶饮。商业机密法和创新也没有关系，即使有，也只是稍微沾边；我的茶店客户清单可以成为商业机密，但这与创新没有关系。

您也会见到这样的论断，“知识产权”与创造力有关，但事实上这只适用于版权法。除了创造力之外，还需要其他东西才能打造出一件可获专利的发明。商标法和商业机密法与创造力没有关系；“RMS 茶”的名字并不体现任何创造力，我的茶店客户机密清单也和创造力无关。

当人们谈论“知识产权”时，他们通常真正想要表达的是或多或少一系列法律。例如，富国经常向穷国强行施加不平等法律以榨取其钱财。这些不平等法律中的一些也位于它们所称的“知识产权法”之中，而其他一些则不是；然而，对这一行为的批评通常也会使用“知识产权”这一标签，由于他们对此很熟悉。通过使用这一概念，他们对问题的本质进行了错误解读。最好能够使用一个准确的术语，诸如“立法殖民”，这样的术语可以切中要害。

非专业人士并不是被“知识产权”这一概念所迷惑的唯一人群。即使是讲授这些法律的法学教授也会被这一概念的迷惑性所引诱和误导，并且做出与其所知的事实相违背的广义化陈述。例如，一位教授在 2006 年写道：

> 与现在效力于 WIPO 的继承者不同，美国宪法的制定者对知识产权持有原则坚定、促进竞争的态度。他们知道权利可能是必需的，但是……他们束缚了国会的双手，并且以多种不同的方式限制它的权力。

这段陈述所指的是美国宪法第 I 章，第 8 条，第 8 款，它许可了版权法和专利法。但这一条款与商标法、商业机密法或是任何其他不同的法律无关。而“知识产权”这一概念诱使那位教授做出了错误的广义化。

“知识产权”这一概念也会导致过度简单化的思考。它促使人们仅仅关注这些不同类法律所拥有的，微小的，形式上的共同点——于是他们为某些群体创造了人为的特权——而无视那些构成它们基础的细节：每种法律为公众施加的特别的限制及其带来的后果。这种对形式的过度简单化关注助长了一种应对所有这些问题的“经济主义”方式。

如同它经常发挥作用的方式，经济在这里成为了未经检验的设想的载体。这包括了关于价值的设想，诸如产量与之有关，而自由和生活方式与之无关；以及那些经事实证明大部分是错误的设想，诸如音乐版权是在支持音乐家，或是药品专利是在支持救生药物的研究。

还有一个问题是，由于“知识产权”这一概念在很大程度上的含混不清，由不同法律引起的特定问题变得几乎不可见。这些特别的问题源自每一条特定的法律——而这恰恰是“知识产权”这一概念试图诱导人们所忽略的。例如，版权法所带来的问题之一是音乐分享是否应该被允许；而专利法与此无关。专利法引起的问题诸如穷国是否应该被允许生产救生药物并且以较低的价格出售以挽救生命，而版权法却与此无关。

这些问题究其本质都不是纯粹的经济问题，它们在非经济层面有着显著差别；基于经济方面的肤浅的过度广义化概念来试图思考这些问题，意味着忽略它们之间的区别。将两种法律一同装进“知识产权”的罐中将会阻碍对其任意一方清晰的思考。

因此，任何关于“知识产权问题”的观点以及任何关于这种假想类别的广义化几乎一定是愚蠢的。如果您认为所有这些法律都是一个问题，您就会倾向于从过于笼统的过度广义化概念中选择一种作为您的观点，而这些都是有百害无一利的。

如果您想要对专利法、版权法、商标法或是其他不同法律所引起的问题进行清晰的思考，第一步就是忘记将它们不分青红皂白地放在一起的想法，并且将它们作为独立的问题区别对待。第二步是拒绝“知识产权”这一概念所提示的狭隘视角和过度简单化的情景。只有对每个问题进行独立且完整的思考，您才能有机会清晰地思考它们。

### 注记

-   参见“The Curious History of Komongistan (Busting the Term ‘Intellectual Property’)”一文，位于<http://gnu.org/philosophy/komongistan.html>。

-   可以用非洲各国之间的关系类比这些法律之间的关系，并且“非洲”是一个合乎逻辑的地理概念；然而，谈论“非洲”而非某个特定的国家将会引发大量混乱[^ipr-1]。

-   Rickard Falkvinge 也支持拒绝使用“知识产权”这一概念[^ipr-2]。


 [^ipr-1]: Nicolas Kayser-Bril, “Africa Is Not a Country”，于 2014 年一月 24 日发表于<http://theguardian.com/world/2014/jan/24/africa-clinton>。

 [^ipr-2]: “Language Matters: Framing the Copyright Monopoly So We Can Keep Our Liberties”，于 2013 年七月 14 日发表于[http://torrentfreak.com/language-matters-framing-the-copyright-monopoly-so-we-can-keep-our-liberties-130714](http://torrentfreak.com/language-matters-framing-the-copyright-monopoly-so-we-can-keep-our-liberties-130714)。
