\newpage
## 为什么说开源漏掉了自由软件的要点

> Copyright © 2007, 2008,2010, 2012–2015 Richard Stallman 此文最早于2007年发布于 <http://gnu.org>

当我们说软件“自由”的时候，我们意指它尊重用户最根本的自由：即运行、学习和修改软件，或者重新发布软件副本（无论是否修改过）的自由[^open-1]。这是一个关于自由的问题，而非价格。因此我们应该理解为“言论自由”，而不是“免费啤酒”。

这些自由极其重要。它们是必要的，不仅是因为它们满足用户的个体利益，更是因为它们促进社会的团结——也就是分享与协作。由于我们的文化和生活变得越来越数字化，因此这些自由就变得越来越重要了。在一个由数字化的声音、图像和文字组成的世界里，自由软件正在逐渐地趋近于通常意义上的自由。

现在全世界有数以千万计的人使用自由软件；印度和西班牙的一些学校正在教授所有的学生使用自由的 GNU/Linux 操作系统[^open-2]。但是，大多数用户都没有听说过我们开发这个系统以及建立自由软件社区的伦理原因，因为现在这个系统和社区更多地被描述为“开放源代码”（简称“开源”），并将其归属为另一种不同的、几乎不提及自由的哲学。

自 1983 年以来，自由软件运动一直为计算机用户的自由而战。1984 年，我们发起开发自由的操作系统 GNU，避免那些否定用户自由的非自由操作系统。在（二十世纪）八十年代，我们开发出了这个系统的重要组件，还有 GNU 通用公共许可证（GNU GPL）——一个专门用于保护所有用户自由的许可证。

并不是所有的自由软件用户和开发人员都认同自由软件运动的目标。1998年，一部分人从自由软件社区中分裂出去，并且开始了以“开源”为旗号的运动。提出“开源”这个说法原本是为了避免“free software”可能产生的一些误解，但却很快就与自由软件运动的哲学观点分道扬镳了。

一些“开源”的支持者认为它是“自由软件的商业市场运动”，因为突出现实利益能吸引商业执行部门，并且避免纠缠于他们不想听的是非观点。其他支持者甚至断然否定自由软件运动的伦理和社会价值观。不管他们的观点是哪一种，“开源”运动中都没有谈起或提倡这种价值观。“开源”这个说法很快便与一些现实想法和论点勾连在一起了，比如构建强大而稳定的软件。从那时起许多“开源”的支持者也因此而加入其中，并持同样观点。

自由软件和“开源软件”这两个说法其实说的几乎都是同一类软件，但是它们所秉持的价值观是根本不同的。开源是一种开发方法论，自由软件是一场社会运动。对自由软件运动而言，自由软件是一种道义责任，尊重用户最根本的自由。而另一方面，开源的哲学更关注如何让软件“更好”——只关心实用价值。开源认为，非自由软件只是手边问题的欠妥解答，关于“开源”的大多数讨论并不关注对与错，只关注知名度和成功[^open-3]。

然而自由软件运动中，非自由软件是一个社会问题，解决方案就是停止使用并转向自由软件。

“自由软件”，“开放源代码”，如果指代的是同样（或几乎相同[^open-4]）的软件，你用什么名字很重要吗？是的，因为不同的文字传达了不同的理念。虽然现在一个以其他方式命名的自由程序能给你同样的自由，但是可持续的构筑自由依赖于教育人们珍惜自由。如果你愿意提供帮助，最基本的就是提到“自由软件”。

自由软件运动中我们并不把开源阵营看作敌人；敌人是专有（非自由）软件。但是我们希望人们知道我们代表自由，所以我们不能接受把我们和开源支持者混为一谈。

### 自由软件和开放源代码的实际差别

实际上，开源的标准比自由软件要弱一些。据我们所知，目前所有的自由软件都算是开源软件。几乎所有开源软件也都是自由软件，但也有例外。首先是一些开源许可证过于严苛，因此并不能认定为是自由许可证。比如“Open Watcom”的许可证就不是自由的，因为它不允许将修改后的软件私人使用。幸运的是，只有很少一些程序使用这样的许可证。

其次，实践中更重要的一点是，很多产品包含了计算机可以检查可执行程序签名的方法，以便禁用用户安装其他版本的可执行程序。只有这个有特权的公司可以允许所有设备运行，或允许用户访问其全部兼容设备。这种设备我们称之为“暴君”（Tyrants），而这种行为称之为“tivo 化”（tivoization），以我们第一次看见这样做的产品（Tivo）而得名。即使可执行文件是从自由的源代码构建出来，用户却无法运行修改版，所以这个可执行文件也是非自由的。

开源标准并没有认识到这个问题。它只关注源代码的许可证问题。因此，可执行文件是从比如像 Linux 这种开源且自由的源代码构建，却不可修改的只是开源软件但不是自由的。很多 Android 产品包含了这种基于 Linux 的非自由 tivo 化的可执行文件。

### 对“自由软件”和“开放源代码”的常见误解

术语“free software”容易被误解：一个下意识的理解，“你可以无偿得到的软件”，而其真正含义“给予用户真正自由的软件”同样与其名称相符。我们通过广为散播自由软件的定义和强调“理解 free 为‘自由的言论’，而并非‘免费啤酒’”，来解决这个问题。这不是一个完美的解决方法；它不能完全排除这个问题。如果它没有其它问题的话，也许一个没有歧义且正确的说法会更好一些。

然而很不幸，英语里所有可选的说法都存在各种问题。我们曾看到过很多这种情况，人们收到很多建议，但没有一个是明显“正确”的选择。（例如，在某些环境中法语和西班牙语单词“自由”是有效的,但印度人却完全不认可。）每个提交的用来替代“自由软件”的词语都存在一些语义问题——这也包括“开源软件”。

“开放源代码软件”的官方定义（由开放源代码促进会公布，这里引用太长了[^open-5]）是间接引述自我们的“自由软件”的标准。与自由软件不同；在一些方面稍微有点宽松。尽管如此，他们的定义大多数情况还是非常接近我们的定义的。

然而，“开源软件”这个概念表面的意思是“你可以看源代码”，因此多数人似乎都把这当作它的真正意义。这个标准比自由软件更脆弱，甚至比开源的官方定义都脆弱。这样就包括了很多既不自由也不开源的软件。

由于“开放源代码”的表面含义并非拥护者们所设想的，结果大多数人曲解了这个说法。以下是撰稿人 Neal Stephenson 所定义的“开源”：“Linux 是‘开源’软件的意思，简单地说，就是任何人都可以得到源代码的副本[^open-6]。”我并不认为他有意抵触或者争论官方的定义。我想他只是用了英语的习俗来提出开源的含义。堪萨斯洲曾经发表过类似的定义：“使用开源软件（OSS）。开源软件是源代码可自由、公开使用的软件，但特定的许可证规定了人们可以用代码做些什么[^open-7]”。

《纽约时报》的一篇文章引申了开源的意思，认为开源就是让用户做测试[^open-8]——让一小部分用户测试产品的早期版本并给出反馈——而这已经是专有软件数十年来一直在做的事情。

这个说法还被引申为设计和发布没有专利的产品[^open-9]。无专利的设备对社会而言确实值得称赞，但是“源代码”并不属于这些。

开源的支持者们试图通过指出他们的官方定义来应对这个问题，但收效甚微，甚至还不如直接用“自由软件”。“free software”这个说法天生就只有两种含义，其中一个是我们设想的含义，所以领会了“言论自由，而并非免费的啤酒”的人就不会曲解它。但是“开源”只有一个天然的含义，但是这个含义却和它的支持者们预想的不同。所以不存在一个一劳永逸的方法来解释和证明其官方定义。这就产生了更大的歧义。

另外一个关于“开源”的误解认为它的意思是“不使用GNU GPL”。这还会产对一个对“自由软件”的误解，认为自由软件就是“GPL 许可证保护的软件”。这样都不对了，因为 GNU GPL 被当作是一个开源许可证，而大多数开源许可证被当作是自由软件许可证。而且还有很多不是 GNU GPL 的自由软件许可证[^open-10]。

“开放源代码”甚至已经被引申和应用到了其他活动中，比如政府、教育和科学，那些没有源代码的，与软件的标准并不相关的领域。这些活动唯一的共同点是他们只是以某种方式邀请人们参加。而目前为止这个概念只是被引申成了“参与”或“透明”而已，甚至更浅。最坏的情况，它已经成为一个空洞的流行语[^open-11]。

### 不同的价值观会得出类似的结论……但并非总是如此

二十世纪六十年代，激进组织因为派别纷争而获得一些声誉：一些组织因为对策略上细节的分歧而导致分裂。尽管依然有着相似的基本目标和价值观，但是分裂出来的两个组织往往把对方当作敌人。右翼利用了这一点，来抨击整个左派。

有些人试图把我们和开源之间的分歧比作这些激进组织之间的分歧，以此来诋毁自由软件运动。但是他们完全错了。我们虽然和开源阵营在根本目标和价值观上无法达成共识，但是他们和我们的观点在许多情况下是一样的，都引领了实际行动——比如开发自由软件。

结果是，来自自由软件运动和开源阵营的人们经常在一些诸如软件开发的实际项目中协同工作。不同的哲学观点能够如此频繁地激励不同人参与到相同的项目中，这是非同寻常的。不过因为这些观点相差很大，所以也存在导致行为相差很大的情况。

开源的思想是允许用户修改和重新发布软件以使它更强大、更可靠。但是这些并不能得到保证。专有软件的开发者们并不一定就不称职。有时他们开发的程序也是强大而且可靠的，尽管它并没有尊重用户的自由。自由软件积极分子和开源爱好者对此的反应是非常不同的。

一个从未受到自由软件思想影响的纯开源爱好者，会说：“我非常惊讶你们不使用我们的开发模式，居然能让程序工作得这么好，但是你们确实做到了。我怎样才能得到一份副本呢？”。这种态度会鼓励那些夺走我们自由，或有损自由的项目。

自由软件积极拥护者会说：“你的程序很吸引人，但我更珍视我的自由。所以我抵制你的程序。我会以其他方式努力，支持一个开发自由替代品的项目。”如果我们珍视我们的自由，我们就能行动起来保卫它。

### 强大而可靠的软件可能是件坏事

我们想让软件变得强大而可靠的想法，来自软件被设计用于服务它的用户的假设。如果软件强大而可靠，这意味着它将更好地服务于用户。

然而只有在软件尊重了用户的自由时，才能说它服务于用户。如果软件被设计的目的是使用户枷锁缠身会怎样呢？那样的话，强大仅仅意味着枷锁套得更紧，而可靠则使枷锁更难去除。恶意的功能，比如针对用户的间谍行为、限制用户、后门和在专有软件里很常见的强制性升级，甚至有些开源的支持者也想实现这些。

在电影和唱片公司的压力下，个人使用的软件逐渐被有意地设计成能够限制用户的软件。这种恶意的特征被称为 DRM 或者数字限制管理（Digital Restrictions Management，参见[DefectiveByDesign.org](DefectiveByDesign.org)），而这正是与自由软件所要提倡的自由精神相对立的。并且不仅仅在精神上：因为 DRM 的目标是践踏你们的自由，DRM 的开发者们试图使你修改实现了 DRM 的软件变得困难、或者不可能，甚至非法。

然而，一些开源支持者提出了所谓“开源 DRM”软件。他们的想法是，通过公开并允许人们修改那些被设计成用来限制你访问加密媒体的程序的源代码，生产更加强大、可靠的软件来限制像你这样的用户。然后，再将这些程序放到那些不允许你修改的设备中发布。

这种软件或许是开放源代码的，而且使用了开源的开发模式，但它并不是自由软件，因为并没有尊重实际运行它的用户的自由。如果开源开发模式通过开发更强大和更可靠的软件来限制用户而获得了成功，这将使它变得更糟糕。

### 对自由的敬畏

起初，开源阵营从自由软件运动中分裂出来，是因为“自由软件”的伦理观念使一些人不安。这的确是事实：谈论关于自由、道义问题、可靠性和方便性，提醒人们去考虑那些可能被他们忽略的问题，比如他们的行为是否是道德的。这会引起不舒服，而且一些人甚至会回避它。但这并不意味着我们应该停止讨论这些事情。

然而，这正是开源的引领者决定要做的。他们希望停止对伦理规范和自由问题的讨论，而仅仅关注某个自由软件直接的实际利润，这样，他们或许就能更有效地将软件“卖”给某些用户，特别是商业用户。

用他们自己的话说，这种方法已经被证实是有效的。开源的修辞方式已经吸引了许多商业和个人用户来使用，甚至开发这些壮大我们社区的自由软件——但仅仅是在表面的、实用上的。开源哲学，和它纯粹的实用主义价值观，阻碍了人们对自由软件更深层观点的理解；它将许多人带进了我们的社区，但却没有教他们去捍卫社区。就目前的现状来看还是不错的，但是它不足以捍卫自由。要吸引自由软件用户，需要让他们成为个体自由的捍卫者。

迟早这些用户会因为一些实际利益而转向专有软件。无数的公司试图提供这种诱惑，有些甚至提供免费副本。为什么用户会减少？只有他们领悟了自由软件所赋予用户的自由，去珍惜自由的价值，而不只关心特定自由软件在技术上和实用性上的方便性价值，他们就会明白了。为了传播这种思想，我们必须谈论自由。对商业采取一定的沉默方式对于社区来说是有益的，但是，如果大家普遍地把对自由的向往看作是一种怪癖，那将是很危险的。

这种危险确实已经发生。大多数投入自由软件的人，特别是发行者，很少谈论“自由”——通常是因为他们追求“更容易被商业接受”。几乎所有的 GNU/Linux 操作系统发行版都在基本的自由系统上加入了专有软件包，而且他们让用户认为这是优点，而不是与“自由”思想背道而驰的。

加入专有版权的软件和部分非自由的 GNU/linux 发行版之所以找到了孕育的温床，是因为我们的许多社区没有在他们的软件上贯彻自由。这并非巧合。大多数 GNU/Linux 的用户是通过讨论“开源”而引入到这个系统的，而这些讨论却并没有将“自由”作为目标。那些不支持自由的行为和不探讨自由的言论并肩而行，相互促进。为了避免这种趋势，我们需要更多地，而不是更少地，来谈论“自由”。

### “FLOSS” 和 “FOSS”

为了在自由软件和开源之间保持中立，常用“FLOSS” 和 “FOSS”[^open-12]这种说法。如果你的目标是中立性，那么“FLOSS”更好，因为这真的很中立。如果你更想表达自由，那么用中立的说法并不好。站在自由的一边，让人们看到你对自由的支持。

### 对立的传播

“自由”和“开放”在传播上是一组对立的概念。“自由软件”和“开源”虽然是不同的思想，但大多数人认为这两个在概念上是相同的。当人们变得习惯于说和思考“开源”，这对他们获取自由软件运动的理念和思考是一个障碍。如果他们已经将“开放”和我们联系起来，在他们认识到我们代表*其他事情*之前，也许需要冲击他们的理性。任何推广“开放”的活动实际上都会更深的让自由软件运动隐藏在幕后。

因此，自由软件的活跃者经过深思熟虑以后决定拒绝参加那些标榜自己是“开放”的活动。即使活动本身并不错，但每次为“开放”多做的贡献，都会对另一方作出伤害。也有很多很好的活动是“自由”或“解放”的。而参与这些活动，会对这些项目有小小的额外好出。既然有这么多有益的项目可选，为什么不选能更有好处的呢？

### 结论

开源的拥护者把新用户引入我们的社区，我们这些自由软件支持者必须做更多地工作来让这些新用户关注自由的问题。我们必须大声且更大声的高呼：“是自由软件给予了你们自由！” 每当你说“自由软件”，而不是说“开源”的时候，你就是在为我们助阵。

#### 备注

Karim R. Lakhani 和 Robert G. Wolf 的论文“Why Hackers Do What They Do: Understanding Motivation and Effort in Free/Open Source Software Projects”（剑桥: MIT 出版社, 2005）[http://ocw.mit.edu/courses/sloan-
school-of-management/15-352-managing-innovation-emerging-trends-spring-2005/readings/lakhaniwolf.pdf](http://ocw.mit.edu/courses/sloan-school-of-management/15-352-managing-innovation-emerging-trends-spring-2005/readings/lakhaniwolf.pdf)，在探讨自由软件开发者的动机时，指出相当一部分人被“软件必须是自由的”的观点所鼓舞。这里忽略了他们调查的对象是 SourceFourge 的开发人员这一事实，而该站点并不支持这是个伦理问题的观点。

[^open-1]: 有关自由软件的完整定义，参见《什么是自由软件？》一文。

[^open-2]: 关于操作系统可参见《Linux 和 GNU 系统》一文

[^open-3]: 一个典型的领子，比如 Jay Lyman 的文章“Open Source Is Woven Into the Latest, Hottest Trends”（2013年9月12日）<http://www.linuxinsider.com/story/Open-Source-Is-Woven-Into-the-Latest-Hottest-Trends-78937.html>

[^open-4]: 参见“How Free Software and Open Source Relate as Categories of Programs”一文，位于<http://gnu.org/philosophy/free-open-overlap.html>

[^open-5]: 全部定义可参见<http://opensource.org/docs/osd> 

[^open-6]: Neal Stephenson, In the Beginning...Was the Command Line（纽约，HarperCollins出版，1999年），p 49。

[^open-7]: 堪萨斯州全州技术架构，“信息架构”，version 8.0, 20.3.8, 2011年10月11日。
<https://web.archive.org/web/20001011193422/http://da.state.ks.us/ITEC/TechArchPt6ver80.pdf>

[^open-8]: Mary Jane Irwin，“The Brave New World of Open-Source Game Design”（开源游戏设计的勇敢新世界），纽约时报，在线版，2009年2月7日。<http://www.nytimes.com/external/gigaom/2009/02/07/07gigaom-the-brave-new-world-of-open-source-game-design-37415.html>

[^open-9]: Karl Mathiesen 和 Tess Riley，“Texas Teenager Creates $20 Water Purifier to Tackle Toxic E-Waste Pollution”（德州青少年创建 $20 水净化器，以解决有毒电子废物污染环境），2015年8月27日。<http://theguardian.com/sustainable-business/2015/aug/27/texas-teenager-water-purifier-toxic-e-waste-pollution>

[^open-10]: 参见“Various Licenses and Comments about Them” <http://gnu.org/licenses/license-list.html>”

[^open-11]: Evgeny Morozov，“Open and Closed”（开放和封闭），2013年3月16日，<http://www.nytimes.com/2013/03/17/opinion/sunday/morozov-open-and-closed.html>

[^open-12]: 可参见本文或文章“FLOSS 和 FOSS” <http://www.gnu.org/philosophy/floss-and-foss.html>
