# 版权和不公

\newpage
## 阅读的权利

> Copyright © 1996, 2002, 2007, 2009, 2010, 2014 Richard Stallman。本文撰写于 1996 年并以标题 “The Right to Read: A Dystopian Short Story”（阅读的权利：一段反乌托邦的短故事）于 1997 年二月发表于 Communications of the ACM, vol. 40, n. 2。

*本文摘自《第谷之路》（The Road to Tycho），这是一系列关于“月球人革命”的前奏的文章，于 2096 年发表于月球城。*

对于 Dan Halbert 而言，他的“第谷之路”始于大学时代——当 Lissa Lenz 向他借用计算机的时候。她的计算机发生了故障，并且除非她能够借到另一台计算机，她将肯定不能完成中期项目。她不敢向其他任何人求助，除了 Dan。

这将 Dan 置于两难境地，他有责任帮助她——但如果将自己的计算机借给她，她将有机会阅读他的书籍。抛开如果您允许其他人阅读您的书籍，您将被处以很多年监禁这一事实，这种想法首先使他感到震惊。与其他任何人一样，他从小学开始就被这样教育：分享书本是龌龊并且非法的——只有盗版者才会去做这些坏事。

并且，他不被 SPA ——软件保护权力机构——抓住的机会并不大，在他的计算机软件课上，Dan 知道了每本书都带有一个版权监视器，它将会将此书于何时何地被何人阅读的信息上报给中央授权许可机构（该机构对这些信息的利用不仅仅是为了抓住阅读盗版者，也会将个人阅读兴趣偏好出卖给图书零售商）。当他的计算机下一次联网时，中央授权许可机构将会发现这一切。他作为计算机拥有者将会受到最严厉的处罚——由于他未能尽力阻止这种犯罪。

当然，也许 Lissa 本意上并不一定是要阅读他的书籍，她有可能只是想借用计算机来编写她的中期汇报。但是，Dan 知道她来自于中产阶级家庭，并且很难负担得起学费，遑论她的各种阅读费用。阅读他的书籍可能是使她能够顺利毕业的唯一出路。他理解这种情形；他自己也必须借钱以支持其所需的科研论文阅读费用（这些费用的 10% 将会被付给撰写了这些论文的科研人员；由于 Dan 致力于他的学术事业，他可以指望自己的科研论文被频繁引用，这样他就可以赚到足够的钱来支付这笔阅读费用）。

其后，Dan 将会了解到，以前曾经有一段时间，任何人都可以去图书馆阅读期刊文章甚至是图书而无需支付任何费用。那时也有独立的学者，他们可以阅读数千页的文献而无需得到政府图书馆的批准。但是，在 20 世纪 90 年代，商业性和非盈利性的期刊出版者都开始征收访问费用。直到 2047 年，提供对学术文献的免费公开访问的图书馆已经成为一种灰暗的记忆。

当然，也有一些方式可用于绕过软件保护权力机构（SPA）和中央授权许可机构的审查。它们本身是非法的。Dan 曾经有一位计算机软件专业的同学，Frank Martucci，此人得到了一种非法的调试工具，并且将其应用于在阅读时绕过版权监视器的代码。但是，他将此事告知了太多的朋友，其中之一将他告发至 SPA 以获取一份奖赏（债台高筑的学生很容易被利诱叛变）。2047 年，Frank 被捕入狱，并非由于盗版阅读，而是由于非法拥有一份调试工具。

其后，Dan 将会知道曾经有一段时间，任何人都被允许拥有调试工具，那时甚至有可以从光盘（CD）获得或者从网络上下载得到的自由调试工具。但是，随着普通用户将其用于绕过版权监视器，最终一位法官裁决非法目的成为了调试工具在实际中的主要用途。这意味着它们是非法的，调试工具的开发者都被捕入狱。

当然，程序员们仍然需要调试工具，但在 2047 年，调试工具厂商限量发布它们，并且仅对得到政府官方授权许可与担保的程序员分发。Dan 用于计算机软件课上的调试工具位于一道特殊的防火墙后面，使得它只能被用于课堂练习。

从前，通过安装某种修改过的操作系统内核来绕过版权监视器也是可能的。Dan 最终将会了解到这些自由内核，甚至整个自由操作系统。这些东西直到世纪之交前后都还存在。但是，它们不仅像调试工具那样是非法的——甚至您即使拥有它们也不能安装，因为您不知道您计算机的 root 口令。而美国联邦调查局（FBI）或者微软客服都不会告知您那个口令。
Dan 得出结论，他不能简单地将计算机借给 Lissa，但他又不能拒绝帮助她，因为他爱着她。每次和她说话的机会都会使他充满愉悦。而她选择向他求助，这意味着她也爱着他。

Dan 做出了一些更加不可想象的举动来解决这种两难境地——他将计算机借给了她，并且将他的口令告知了她。通过这种方式，如果 Lissa 阅读了他的书籍，中央授权许可机构将会认为实际上是他在阅读这些书。这仍然是一种犯罪，但是 SPA 不会自动发现这一点，除非 Lissa 将他举报。

当然，如果学校最终发现他将自己的口令给了 Lissa，这将使得他们二人的学生身份终结，不论她使用这个口令做了什么。学校的政策是这样的，任何对其监控学生如何使用计算机的行为的干涉是惩戒行为的底线，不论您是否做了任何有害的事——这种所谓的攻击行为使得学校管理人员难于对您进行监控。他们认为这意味着您正在做一些其他的被禁止的事情，并且他们不需要知道这些事情到底是什么。

学生们通常不会因此被开除——不是直接被开除。而是他们将会被禁止使用学校的计算机系统，这将使他们不可避免地不能通过他们的任何课程。

其后，Dan 将会知道，这种大学政策只是始于 20 世纪 80 年代，那时大学生们开始大规模使用计算机。在此之前，大学一直保持着另一种学生惩戒制度；它们将会惩罚那些有害的行为，而非那些仅仅是引起怀疑的行为。

Lissa 没有向 SPA 举报 Dan，而他关于帮助她的决定使得他们终成眷属。这也促使他们质问他们在儿时曾被教给的关于盗版的东西。这对夫妇开始阅读关于版权的历史的东西，关于苏联以及它对复制分享的限制，甚至是关于最初的美国宪法。他们移居月球，在那里他们遇到了其他同样选择逃离 SPA 魔掌的人们。当第谷于 2062 年爆发起义的时候，普遍的阅读权利立即成为这场起义的核心诉求。

### 作者注记

-   本文据说应该是由其他人在未来撰写的一篇历史文章，描述了 Dan Halbert 在一种专制社会下的青年生活，这种专制社会是由那些将“盗版”作为宣传口号的敌人创立的。因此本文使用那种社会下的用语。我尝试从今天的视角呈现它，使其看起来更具压迫性。有关“盗版”可参考《应避免使用（或慎用）的词语》一问。

-   以下注记自本文初次发表之后经过数次更新。

    阅读的权利是一场于今天打响的斗争，尽管可能需要经过 50 年的时间才能使我们现在的生活方式成为灰暗的记忆，上文所述的大部分特定法律和实践已经被提议，它们中的许多已经在美国和其他地区被通过并成为正式的法律。在美国，1998 年的数字千年版权法案（DMCA）为限制阅读与出借计算机化的图书（及其他形式的作品）建立了法律基础。欧盟在 2001 年通过的一项版权指导意见中实施了类似的限制。在法国，随着“信息社会的作者权利与相关权利法案”（DADVSI）于 2006 年通过，仅仅是拥有 DeCSS，一款用于解密数码多功能影音光盘（DVD）的自由软件，的一份副本即被视为犯罪。

    在 2001 年，由迪士尼赞助的参议员 Hollings 提出了一项称为“安全系统与标准认证法案”（SSSCA）的法律，其要求每台新计算机带有强制性的限制复制设备并且禁止用户绕过它。继 Clipper 芯片及类似的美国政府关于密钥保管的提案之后，这显示了一种长期趋势：计算机系统越来越倾向于赋予不在场者对该计算机系统的实际使用者进行有效控制的权力。SSSCA 随后更名为“消费者宽带和数字电视促进法案”（CBDTPA）这一不可拼读的名称，它被评注为“消费但不要尝试编程法案”（Consume But Don't Try Programming Act）。

    随后不久，共和党人控制了美国参议院。他们与好莱坞的联系不如民主党人那样密切，因此他们没有强行推动这些提案。现在民主党人重新获得控制权，我们所面临的威胁进一步升高。

    在 2001 年，美国开始试图利用它所倡议的美洲“自由贸易”区（FTAA）条约来向整个西半球强制施加相同的规则。FTAA 是一种所谓的“自由贸易”条约，它们实际上是被设计用于赋予商业企业更多凌驾于民主政府之上的权力；强制推行诸如 DMCA 的法律正是这种精神的典型体现。而 FTAA 事实上由时任巴西总统卢拉否决，此人拒绝接受 DMCA 及其他类似法规的条件。

    此后，美国通过一系列“自由贸易”协定将类似的条件强行施加给诸如澳大利亚和墨西哥等国，并且通过另一纸条约，中美洲自由贸易协定（CAFTA），将其强行施加给哥斯达黎加等国。时任厄瓜多尔总统科雷亚拒绝与美国签署一项“自由贸易”协定，但我听说厄瓜多尔已经于 2003 年采纳了类似于 DMCA 的法案。

    这个故事中的某一种理念直到 2002 年还未在现实中被提议，这种理念是由 FBI 和微软掌控您的个人计算机的 root 口令并且不会让您得到它们。

    这一阴谋的倡导者将其命名为诸如“信任计算”或者“Palladium”。我们称之为“背叛计算”[^righttoread-1]，由于其效果是使您的计算机听命于商业公司，并且到了不再听命于您甚至是违抗您的地步。这在 2007 年作为 Windows Vista 的一部分被实施[^righttoread-2]；我们可以预见苹果也会做出类似的事情。在这种阴谋中，由计算机制造商掌控其秘密代码，但 FBI 对它同样是唾手可得。

    确切地说，微软所掌控的并不是传统意义上的口令；由于无人能够在终端上输入它。与之相反，它是一种数字签名和加密密钥，它对应着存储在您的计算机上的另一个密钥。这将允许微软以及任何潜在与微软合作的网站对于用户能够在其计算机上做的事情进行完全控制。

    Vista 同样赋予了微软额外的权力；例如，微软可以强制安装更新，它可以命令所有运行 Vista 的计算机拒绝运行某一特定的设备驱动程序。Vista 所施加的诸多限制的主要目的是强制实施用户所不能克服的数字限制管理（DRM）。DRM 的威胁正是我们发起 Defective by Design 运动的原因 [DefectiveByDesign.org](DefectiveByDesign.org)。

    当这段故事初次编写之时，SPA 威胁小型互联网服务供应商（ISP），要求它们允许 SPA 监控所有用户。大多数 ISP 在受到威胁的时候都妥协了，由于它们打不起官司。一家位于加利福尼亚州奥克兰的 ISP，Community ConneXion 拒绝了这一要求，并且确实被起诉了。SPA 随后撤诉，但它得到了 DMCA 的支持，这赋予了它们一直渴求的权力。SPA，实际上是软件发行商协会之意，由商业软件联盟（BSA）取代了其类似于警察的职责。在今天，BSA 不是一支官方警察力量，但它却在以非官方的方式行使这种权力。通过使用让我们想起前苏联的手段，它邀请人们举报其同事和朋友。于 2001 年在阿根廷发生的一起 BSA 恐怖行动几乎毫无遮掩地威胁人们：分享软件将被处以酷刑。

    上文描述的大学安全政策并非毫无实据。例如，芝加哥地区的某大学的一台计算机在登录时显示了以下信息：

    > 本系统仅供授权用户使用。对于任何未经授权或者超出其授权范围使用本系统的个人，其在本系统上进行的所有活动将被监控并且记录。在对任何人不当使用本系统进行监控或者系统维护期间，授权用户的行为也可能被监控。任何使用本系统的个人必须明确同意接受这种监控，并且此监控一旦发现可能指证非法行为或者侵犯大学规定的行为的证据，本系统可能将通过此监控发现的证据移交至大学权力机构和/或官方执法机构。

    这是一种类似于美国宪法第四修正案的有趣方式：首先施压以迫使几乎所有人放弃他们的权利。

### 坏消息

关于阅读的权利的斗争已经在进行中了，敌人已经有备而来严阵以待，而我们还没有。因此这场斗争正在向着对我们不利的方向进行。自本文初次发表之日起发生的一些代表性的坏消息包括：

-   今天的商业电子书剥夺了读者的传统自由。参见《电子书的威胁》一文以获得更多信息；

-   某一“生物课本”网站[^righttoread-3]允许您访问其出版物，仅当您签订合同以保证不会将其借给任何人阅读[^righttoread-4]。而出版商可以随意废除此合同；

-   电子出版物限制其用户的自由[^righttoread-5]；

-   计算机中的图书[^righttoread-6]：用于控制谁可以在一台计算机上阅读图书和文档的软件。

如果我们想要阻止这样的坏消息并且带来一些好消息，我们需要组织起来并且进行斗争。自由软件基金会（FSF）的 Defective by Design 运动已经为这场斗争拉开序幕；订阅该运动的邮件列表以提供支持。并且加入 FSF 以资助我们的工作。

### 参考文献

-   美国专利及商标局（USPTO），Intellectual Property and the National Information Infrastructure: The Report of the Working Group on Intellectual Property Rights, Washington, DC: GPO, 1995. （参见《您说过“知识产权”吗？这是一种迷惑性的幻景》一文以获知为何“知识产权”这一短语是含混不清的并且永远不应被使用）。

-   Samuelson, Pamela, “The Copyright Grab,” *Wired,* January 1996, 4.01, <http://wired.com/wired/archive/4.01/white.paper_pr.html>.

-   Boyle, James, “Sold Out,” *New York Times,* 31 March 1996, sec. 4, p. 15; 也可以在这里找到：<https://law.duke.edu/boylesite/sold_out.htm>.

-   社论, *Washington Post,* “Public Data or Private Data,” 3 November 1996, sec. C, p. 6, [http://web.archive.org/web/20130508120533/http://www.interesting-people.org/archives/interesting-people/199611/msg00012.html](http://web.archive.org/web/20130508120533/http://www.interesting-people.org/archives/interesting-people/199611/msg00012.html).

-   公有领域联盟（Union for the Public Domain）——一个致力于抵抗并且逆转版权和专利的权力过度扩张的组织。 


[^righttoread-1]: 参见《您能够信任您的计算机吗？》一文以获得更多关于“信任计算”的信息。 

[^righttoread-2]: 参见 <http://badvista.fsf.org/> 以了解我们反对 Windows Vista 的运动。 

[^righttoread-3]: Nature America Inc., “Announcing Principles of Biology, an Interactive Textbook by Nature Education,” <http://nature.com/nature_education/biology.html>. 

[^righttoread-4]: Nature America Inc., “Principles of Science Privacy Notice,” accessed August 2015, <http://nature.com/principles/viewTermsOfUse>. 

[^righttoread-5]: 参见 Don Clark 的文章 “Seybold Opens Chapter on Digital Books” (31 August 1999, [http://www.zdnet.com/article/seybold-opens-chapter-on-digital-books/](http://www.zdnet.com/article/seybold-opens-chapter-on-digital-books/))以获知有关以电子形式发布图书以及影响到阅读其副本的权利的版权问题的信息。 

[^righttoread-6]: “Microsoft Announces New Software for Reading on Screen,” 30 August 1999, <http://microsoft.com/en-us/news/press/1999/Aug99/SeyboldPR.aspx>. 
