\newpage
## 民主可以承受多少监控？

> Copyright © 2015 理查德·斯托曼（Richard Stallman）。本文最初以相同的标题发表于《连线》杂志（2013年10月14日）[http://www.wired.com/opinion/2013/10/a-necessary-evil-what-it-takes-for-
democracy-to-survive-surveillance](http://www.wired.com/opinion/2013/10/a-necessary-evil-what-it-takes-for-democracy-to-survive-surveillance)

多亏了爱德华•斯诺登的揭露，我们才知道当今社会中的普遍监控级别已经与人权不相容。在美国和世界其他地区持续发生的针对持不同政见者、信息来源和新闻工作者的骚扰和指控确认了这一点。我们需要适当降低普遍监控的级别，但是到底应当在多大程度上？我们所必须保证其不被超越的，可接受的*最大监控级别*到底是多少？这种监控级别应当这样定义：一旦超过了这样的级别，监控行为将会干涉民主的运行。此时揭露者（例如斯诺登）很可能因此而被逮捕。

面对政府的保密政策，我们作为人民只能依靠揭露者告知国家正在做什么[^surveilance-1]。然而，当今的监控对潜在的揭露者进行了威迫，也就是说监控程度过高。为了重获我们对于国家民主的控制，我们必须设法降低监控级别使得揭露者能够确信他们是安全的。

如同我们已经倡导了 30 多年的，使用自由软件是掌控我们自己的数字生活的第一步。这也包括了避免被监控。我们不可能信任任何私有软件；由于美国国家安全局（NSA）通过利用[^surveilance-2]甚至还有制造[^surveilance-3]私有软件中的安全漏洞来入侵我们自己的计算机和路由器。自由软件赋予了我们控制自己计算机的权利，但仅凭这一点并不足以在我们涉足互联网的时候保护我们的隐私[^surveilance-4]。

美国国内“限制国内监控权力”[^surveilance-5]的两党立法已经被提出，但它依赖于限制政府对我们的虚拟档案的使用。这不足以保护揭露者，如果“逮捕揭露者”是获取足够信息以确认此人身份的基础。我们需要做得更多。

### 民主社会中的监控程度上限

如果揭露者不敢揭发罪行和谎言，我们将会失去对政府和制度仅存的有效控制。这可以解释为何那种使得国家可以知道是谁同记者进行交谈的监控行为是过分的——超出了民主所能承受的范围。

在 2011 年，一位匿名的美国政府官员不怀好意地告诉新闻工作者：美国政府在传唤记者时，并不会以“我们知道你同谁交谈”作为理由[^surveilance-6]。有时，记者的通话记录将会被传唤以获知这个问题的答案[^surveilance-7]。但是，斯诺登已经向我们展示了，它们实际上将会在任何时刻传唤美国境内的任何人的所有通话记录，通过 Verizon [^surveilance-8]或其他通讯公司[^surveilance-9]。

反对者和持不同政见者的活动需要对国家保密，由于国家将会主动对他们施展阴谋诡计。美国公民自由联盟（ACLU）已经指出美国政府对和平的持不同政见者和组织所进行的系统性渗透行为，理由是他们当中可能潜伏着恐怖分子[^surveilance-10]。

### 信息，一旦被采集，将会被滥用

当人们认识到普遍监控的级别过高的时候，他们的第一反应可能会是提议限制对采集到的数据的访问。这听起来很好，但这甚至丝毫不能解决问题，即使假定政府遵守这条规则。（美国国家安全局（NSA）曾经欺骗美国外国情报监控法庭（FISA），后者声称它不能有效地证实 NSA 有义务对其监控行为作出说明[^surveilance-11]。）犯罪的嫌疑将成为访问这些数据的理由，于是，一旦揭露者被指控从事间谍活动，试图找到这个间谍将会为访问所采集到的数据提供理由。

此外，国家监控系统的工作人员会出于个人原因滥用数据。一些 NSA 特工使用美国国家监控系统来跟踪他们的情人——不论是过去的、现在的还是正在追求的——并将这种做法称为 LOVEINT[^surveilance-12]。NSA 宣称它已经发现了几次这样的行为并对其进行了处罚；但是我们不知道还有多少次这样的行为没有抓到。然而，这些事件并不会让我们感到惊讶，由于警方已经长期利用他们可访问的驾照记录以跟踪那些迷倒了他们的对象。这种行为称之为“查询车牌获得约会”（running a plate for a date）[^surveilance-13]。

监控数据总会被用于其他目的，即使这是被禁止的。只要数据被采集，国家就有可能访问它们。国家可以用极坏的方式滥用这些数据，发生在欧洲[^surveilance-14]和美国[^surveilance-15]的一些例子证实了这一点。

国家所采集的个人信息同样可能由于服务器的安全措施被攻陷而被境外骇客获得，甚至是被那些效力于敌对国家的骇客获得[^surveilance-16]。

政府可以轻松地利用大规模监控能力直接颠覆民主制度[^surveilance-17]。

国家对监控数据的完全访问权力使得国家可能对任何人发动大规模的彻底搜查。为了保护新闻业和民主的安全，我们必须限制对信息的采集，而这些信息是国家可以轻松访问的。

### 对隐私的有效保护必须是技术层面的

电子前哨基金会（EFF）和一些其他组织提出了一系列法律准则以期阻止滥用大规模监控[^surveilance-18]。这些关键性准则包括了对揭露者明确的法律保护。其结果是这些准则将足以保护民主自由——如果它们能够永久地得到完全采纳，并且被没有例外地严格强制执行。

然而，这样的法律保护是不牢靠的：如同最近多年的历史事实所展示的，它们可以被废除（如同在美国外国情报监控法案 FISA 修正案中）、被架空或者被无视[^surveilance-19]。

同时，一些蛊惑民心的政客将会援引常见的理由作为支持完全监控的基础；任何恐怖袭击，即使只是造成了极少的人员伤亡，也可以被夸大作为证据以支持上述理由。

如果对数据访问的限制被搁置一旁，就如同这些限制从未存在过一般：多年来的有价值的档案将会立即可被国家和它的特工所滥用。如果这些档案被商业公司获得，也会被这些商业公司出于其私有目的而被滥用。然而，如果我们能够阻止对个人档案的采集，这些档案将不复存在，并且国家不能逆动地编译这些档案。新的反自由的政体将会不得不从头实施监控，并且它自成立之初只会采集新的数据。至于架空或者立即无视这条法律，这种想法几乎没有任何意义。

### 最重要的是，不要犯傻

如果您想要拥有隐私，您一定不要主动将其放弃：有义务保护您的隐私的最重要的人就是您自己！您必须避免向网站暴露自己的身份，您可以使用 Tor 同它们联络，或者使用那些能够阻止网站用于跟踪访问者的阴谋诡计的浏览器。您可以使用 GNU 隐私卫士（GnuPG）加密您的邮件内容。您可以使用现金支付任何费用。

保护您自己的数据；不要将您的数据储存在某家商业公司的“简便易用”的服务器上。然而，在下面这种情况下，将数据存储在商业服务之上是安全的：只要您将文件置于归档文件中，并且加密整个归档文件，包括文件名。务必使用自由软件在您自己的计算机上进行操作，然后再上传。

出于隐私考虑，您必须避免使用私有软件，这是由于私有软件赋予他人控制您的计算机使用的权力，它们很可能在监控您[^surveilance-20]。您还应该拒绝使用“服务作为软件替代品”（SaaSS）[^surveilance-21]，同样由于这赋予了他人控制您的计算机使用的权力，它要求您将全部相关数据提交到它们的服务器。

您也需要保护您的朋友或熟人的隐私。除了联系方式以外，不要泄露他们的任何个人信息[^surveilance-22]。并且不要向任何网站泄露您的邮件列表或者电话联系人。不要将您的朋友的任何信息告诉诸如 Facebook 这样的公司，因为您的朋友也许并不想在报纸上公布他们的名字。如果可能，根本不要被 Facebook 所利用。拒绝使用任何要求用户提供真实姓名的通讯系统，即使您愿意供出您的名字，由于这些通讯系统会向他人施压以迫使他们交出隐私。

自我保护是至关重要的，但即使是最严密的自我保护也不足以保护您的隐私免于被不属于您的系统所泄露。当我们与他人通讯或者在城市内出行的时候，我们的隐私取决于社会的实践。我们可以避开一些但不是全部的可以监控我们的通讯或行踪的系统。显然，更佳的解决方案是让所有这些系统停止监控，而非使嫌疑对象合法。

### 我们需要基于隐私原因设计每一个系统

如果我们不想要一个全面监控的社会，我们必须将监控视为一种社会污染，并且限制监控对每一个新系统的影响，如同我们要限制实体建设工程对环境的影响。

例如，“智能”电表宣称它能够向电力公司持续发送每位用户的电力消耗，包括与普通用户相比较的情况。这种统计是基于普遍监控而实现的，但实际上却又不需要任何监控行为。电力公司可以容易地计算出某一居住区的平均电力消耗，通过将总消耗除以购电者的数量，并且将这个平均值发送至电表。每个用户的电表可以将本人的电力使用情况同任何时期的平均电力使用相比较，这样就可以不用监控而实现所有好处！

我们需要将这样的隐私设计融入我们所有的数字系统。

### 针对数据采集的补救：让数据分散开来

使监控行为不危害隐私的一种方式是使数据保持分散状态从而难于访问。老式的安保摄像头对隐私很少构成威胁[^surveilance-23]，由于录像数据存储在安装这些设备的营业场所内，并且至多被保存几周。由于访问这些数据相对困难，这种数据采集行动从未被大规模部署；只有当某人报导一起犯罪行为时，这些影响数据才会被访问。每天对数以百万计的数据卡带进行人工采集再进行观看或复制几乎是不现实的。

如今，老式的安保摄像头已经变成了监控摄像机：由于它们被连接到互联网，采集的影像可以传输到一所数据中心并被永久保存。这已经是很危险的了，但事情正在变得更坏。面部识别技术的发展使得这样的事情成为可能：对可疑的新闻记者在街道上进行不间断跟踪以便察看他们同何人交谈。

通常，联网摄像机的自身数据安全措施极差，使得几乎任何人都能察看它所记录的内容[^surveilance-24]。为了重获隐私，我们应当禁止在针对公众的场合使用联网的摄像机，除非它由人来操作。每个人必须被允许偶尔发布照片或视频记录，但对于互联网上相关数据的系统性采集行为必须受到限制。

### 针对互联网商业监控的补救

大部分数据采集行为来自于人们自身的数字活动。数据通常首先由商业公司进行采集。但是，当讨论监控行为对隐私和民主的威胁的时候，监控行为直接由国家进行或者由商业公司代为进行并无本质区别，由商业公司所采集的数据，国家也可以系统性地获取。

NSA 通过棱镜计划（PRISM）进入了多家大型互联网公司的数据库[^surveilance-25]。AT&T 自 1987 年起保存了所有通话记录并且允许美国缉毒局（DEA）搜索其所有数据[^surveilance-26]。严格地说，美国政府并不直接拥有这些数据，但它实际上确实拥有了这些数据。

因此，为了保证新闻业和民主的安全，我们必须减少由任何组织采集的关于个人的数据，而不仅仅减少由国家采集的数据。我们必须这样重新设计各种数字系统以使其不再采集其用户的数据。如果它们确实需要关于我们的重要数字资料，当超出处理数据所需的基本时间以后，这些机构和个人就不应该被允许继续保留那些数据。

当前，互联网监控级别的动机之一是经济支持，即网站通过跟踪用户的活动和偏好而进行的广告行为。这使得广告，作为一种我们可以学会无视之的行为，从一种仅仅是恼人的行为变成了一种对我们造成伤害的监控系统，不论我们是否了解它的内情。互联网购物同样会跟踪用户，我们都已经意识到，所谓的“隐私条款”与其说是维护用户隐私的承诺，不如说是它们用于侵犯用户隐私的借口。

我们可以通过采用一种匿名支付系统——即隐藏付款人的身份——来解决以上两个问题（我们并不想协助收款人避税）。比特币不是匿名的[^surveilance-27]，尽管有人试图开发出允许使用比特币进行匿名支付的方式。然而，数字货币技术的开发始于 20 世纪 80 年代[^surveilance-28]；我们只需要对商业规则进行适当调整，并且使得国家不会阻止它们。

网站对个人数据的采集的更大的威胁在于骇客可以攻陷安全措施，获取并滥用个人数据。这可能还包括用户的信用卡信息。而匿名支付系统可以终结这种威胁：如果网站不知道您的任何信息，那么网站的安全漏洞就不会危害到您。

### 针对旅行监控的补救

我们必须将数字收费系统改为匿名支付系统（例如使用数字货币）。车辆牌照识别系统将会识别各种牌照，而这些数据可以被无限期保存[^surveilance-29]；应该由法律要求它们仅仅记录那些由法庭命令要求追查的牌照号码。另一种不太安全的措施是在本地记录所有车辆牌照，但仅保存几天时间，并且不允许从网络访问所有数据；对数据的访问应该限于搜索一系列由法庭命令要求追查的牌照号码之中。

美国“禁飞黑名单”必须被废除，由于这是一种未经审判的刑罚[^surveilance-30]。

要求对黑名单上某个乘客的行李进行额外的搜查是可以接受的，国内航班上的匿名乘客可以视为在此黑名单上。禁止非某国公民登上飞往该国的航班也是可以接受的，如果他们根本没被批准入境。这些措施对于任何法律目的都是足够的。

很多公共交通系统使用某种智能卡或者射频识别（RFID）设备进行支付。这些系统将会采集个人数据：只要您错误地使用现金以外的任何方式进行支付，它们将会将此卡片和您的姓名永久关联起来。接下来，它们将会记录与每块卡片相关联的所有出行信息。这些行为加起来已经构成了大规模监控，这样的数据采集必须被限制。

导航服务也会进行监控：用户的计算机将用户的所在地和目的地告知地图服务；而后服务器确定路线，返回用户的计算机并且显示出来。现在，服务器很可能会记录用户的位置信息，由于没有什么措施能够阻止它们这样做。这种监控行为本质上并不必要，并且可以通过重新设计来解决：用户计算机中的自由软件将会下载相关地区的地图数据（如果之前从未下载），计算出最佳路线并且显示出来，而无需告知任何人用户的所在地或目的地。

用于诸如自行车租借等目的的系统可以这样设计：租借者的身份仅在其借出物品的站点内可知。物品借出时，将会通知所有站点某件物品处于借出状态，这样，当用户将物品返还回任何站点（通常是另一处站点）的时候，该站点将会获知该物品被借出的时间和地点，同时将会告知所有其他站点该物品不再处于借出状态。站点还会计算用户的账单并将账单信息（等待随机长度的时间之后）沿着一系列环形拓扑结构的站点之间的线路发送至总部。这样，总部将不会获知账单信息来自哪个站点。当这一操作完成后，归还站点将会忘记所有与这笔已完成的业务有关的信息。如果某一物品长时间处于借出状态，借出该物品的站点将会告知总部。此时，它可以立即发送借用者的身份信息。

### 关于通讯档案的补救

互联网服务供应商（ISP）和电信公司保存着海量的用户联系人信息（浏览、通话记录等）。对于移动电话，还会记录用户的物理位置[^surveilance-31]，例如 AT&T 已保存了超过 30 年。不久以后它们甚至还会记录用户的身体活动[^surveilance-32]。并且 NSA 很可能正在大规模采集移动电话的物理位置数据[^surveilance-33]。

只要通讯系统创建这样的通讯档案，不受监视的通讯就不可能实现。因此创建或记录这些通讯档案应该被判定为非法。ISP 和电信公司必须不被允许长期保存这些信息，或者在没有法庭命令的情况下长期监控某一特定人群。

这种解决方案并不完全令人满意，由于这实际上并不能阻止政府在通讯信息生成的时候立即对其进行采集——这正是美国政府对部分或全部电信公司所做的[^surveilance-34]。我们可能必须依靠法律禁止这种行为。但是，这种假设比现实的状况好得多，现实中的相关法律（美国爱国者法案，我称之为 PAT RIOT Act，即“镇压暴动法案”）并不明确禁止这种行为。此外，如果政府重启这种监控，它不应得到重启监控的时间点之前发生的每位用户的通话记录数据。

为了保护您的电子邮件联系人的隐私，一种简单的方式是您和他人都使用某个不会与您所在国家政府进行合作的国家提供的邮件服务，并且在通讯过程中使用加密。然而，Ladar Levison（Lavabit 的拥有者，美国监控系统试图对其邮件服务实现完全控制）提出了一种更为高级的加密系统设想：您向我的邮件服务的某位用户发送邮件，我的邮件服务所知道的只是我收到了来自您所使用的邮件服务的某位用户的邮件，但难以确认是您向我发送了邮件。

### 但是，适度的监控是必需的

国家为了缉捕罪犯，它需要能够在法庭命令下调查特定的犯罪行为或者疑似犯罪预谋。在互联网时代，监听通话的权力自然延伸到监听互联网连接的权力。这种权力容易出于政治原因而被滥用，但这也是必需的。幸运的是，这并不会使得在案件发生之后找到揭露者变为可能，如果（如我所建议的）能够阻止数字系统在事件发生之前进行大规模档案信息采集。

拥有国家赋予权力的个人，例如警察，将被收回个人的隐私权并且必须被监视（事实上，警察拥有属于他们自己的伪证罪别名“testilying”[^surveilance-35]。由于他们经常做出这样的事情，特别是对抗议者和摄影师[^surveilance-36]。加州的某个城市要求警察随时随身携带摄像机之后，他们的武力使用下降了 60% [^surveilance-37]。ACLU 对此表示欢迎。

商业公司不是自然人，因此不应被赋予自然人的权利[^surveilance-38]。要求商业公司公开其行为的细节是正当合理的，这些行为可能会造成对社会的化学、生物、核、财政、计算机相关（例如数字限制管理 DRM[^surveilance-39]）或者政治（例如游说拉票行为）等方面的危害，这些危害必须被控制在公众福祉所要求的范围以内。这些行为所造成的危害（考虑诸如墨西哥湾漏油事件、福岛核电站事故、2008 年财政危机等）更甚于恐怖主义。

然而，新闻业必须被保护免遭监控，即使这种监控行为是作为某项业务的一部分而被执行的。

数字技术的发展极大地提高了我们的出行、活动和通讯所受的监控水平。这种监控水平远远超过了 20 世纪 90 年代我们所经历过的，也远远超过了 20 世纪 80 年代生活在铁幕笼罩之下的人们所经历的[^surveilance-40]。而提议国家对使用采集到的数据进行法律限制并不能改变这种状况。

商业公司正在设计更具侵略性的监控设施。一些充斥着监控行为的项目依附于诸如 Facebook 之类的公司，它们可能对人们的思考方式产生深远的影响[^surveilance-41]。这样的可能性是不可预测的；然而它对民主的威胁已经不是推测。这种威胁无处不在，随时可见。

除非我们坚信我们自由的国家之前的监控行为严重欠缺，并且我们理应受到更甚于苏联和民主德国（东德）那样的监控。否则我们必须逆转这种监控升级的趋势，这依赖于阻止对民众的大数据进行大规模采集。

[^surveilance-1]: Maira Sutton, “We’re TPP Activists: Reddit Asked Us Everything,” 21 November 2013, <https://www.eff.org/deeplinks/2013/11/reddit-tpp-ama>. 

[^surveilance-2]: Glyn Moody, “How Can Any Company Ever Trust Microsoft Again?” 17 June 2013, <http://www.computerworlduk.com/blogs/open-enterprise/how-can-any-company-ever-trust-microsoft-again-3569376/>. 

[^surveilance-3]: James Ball, Julian Borger and Glenn Greenwald, “Revealed: How US and UK Spy Agencies Defeat Internet Privacy and Security,” 6 September 2013, <http://theguardian.com/world/2013/sep/05/nsa-gchq-encryption-codes-security>. 

[^surveilance-4]: Bruce Schneier, “Want to Evade NSA Spying? Don’t Connect to the Internet,” 7 October 2013, <http://www.wired.com/2013/10/149481/>. 

[^surveilance-5]: Dan Roberts, “Patriot Act Author Prepares Bill to Put NSA Bulk Collection ’Out of Business,’” 10 October 2013, <http://theguardian.com/world/2013/oct/10/nsa-surveillance-patriot-act-author-bill>. 

[^surveilance-6]: Lucy Dalglish, “Lessons from Wye River,” The News Media & the Law (Summer 2011): p. 1, [http://www.rcfp.org/browse-media-law-resources/news-media-law/news-media-and-law-summer-2011/lessons-wye-river](http://www.rcfp.org/browse-media-law-resources/news-media-law/news-media-and-law-summer-2011/lessons-wye-river). 

[^surveilance-7]:  Washington Agencies, “Yemen leak: former FBI man admits passing information to Associated Press,” 24 September 2013, [http://www.theguardian.com/media/2013/sep/24/yemen-leak-sachtleben-guilty-associated-press](http://www.theguardian.com/media/2013/sep/24/yemen-leak-sachtleben-guilty-associated-press). 

[^surveilance-8]:  参见 “Verizon forced to hand over telephone data—full court ruling” (6 June 2013) 位于 <http://www.theguardian.com/world/interactive/2013/jun/06/verizon-telephone-data-court-order>，以获得关于美国外国情报监控法庭（FISA）之下美国政府采集 Verizon 旗下数以百万计的美国客户的通话记录的信息。 

[^surveilance-9]: Siobhan Gorman, Evan Perez, and Janet Hook, “NSA Data-Mining Digs into Networks Beyond Verizon,” 7 June 2013, <http://www.marketwatch.com/story/nsa-data-mining-digs-into-networks-beyond-verizon-2013-06-07>. 

[^surveilance-10]: ACLU, “Policing Free Speech: Police Surveillance And Obstruction of First Amendment-Protected Activity,” 29 June 2010, <https://www.aclu.org/files/assets/Spyfiles_2_0.pdf>. 

[^surveilance-11]:  David Kravets, Kim Zetter, Kevin Poulsen, “NSA Illegally Gorged on U.S. Phone Records for Three Years,” 10 September 2013, <http://www.wired.com/2013/09/nsa-violations/>. 

[^surveilance-12]:  Adam Gabbatt and agencies, “NSA Analysts ‘Wilfully Violated’ Surveillance Systems, Agency Admits,” 24 August 2013, <http://theguardian.com/world/2013/aug/24/nsa-analysts-abused-surveillance-systems>. 

[^surveilance-13]:  M. L. Elrick, “Cops Tap Database to Harass, Intimidate,” 31 July 2001, <http://sweetliberty.org/issues/privacy/lein1.htm\#\.VeQiuxcpDow>. 

[^surveilance-14]:  Rick Falkvinge, “Collected Personal Data Will Always Be Used against the Citizens,” 17 March 2012, <http://falkvinge.net/2012/03/17/collected-personal-data-will-always-be-used-against-the-citizens/>. 

 [^surveilance-15]: 考虑二战期间被收容的日裔美国人。 

 [^surveilance-16]: Mike Masnick, “Second OPM Hack Revealed: Even Worse Than the First,” 12 June 2015, <https://www.techdirt.com/articles/20150612/16334231330/second-opm-hack-revealed-even-worse-than-first.shtml>. 

 [^surveilance-17]: Joanna Berendt, “Macedonia Government Is Blamed for Wiretapping Scandal,” 21 June 2015, <http://www.nytimes.com/2015/06/22/world/europe/macedonia-government-is-blamed-for-wiretapping-scandal.html?_r=0>. 

 [^surveilance-18]: “International Principles on the Application of Human Rights to Communications Surveillance,” last modified May 2014, <https://en.necessaryandproportionate.org/text>. 

 [^surveilance-19]: Eric Lichtblau and James Risen, “Officials Say U.S. Wiretaps Exceeded Law,” 15 April 2009, <http://nytimes.com/2009/04/16/us/16nsa.html>. 

 [^surveilance-20]: 几十年来，自由软件运动一直致力于揭露私有软件公司诸如微软和苹果的专权的监控机制。监控行为已经在各行业之间蔓延，而不再限于软件产业，并且——离开键盘的限制——进入移动计算领域，在办公室、家庭、交通工具、教室内等。如需获知监控行为进入这些领域的不断增加的方式，参见<http://gnu.org/philosophy/proprietary/proprietary-surveillance.html>. 

 [^surveilance-21]: 参见《服务器真正是在为谁服务？》一文以获取更多信息。

 [^surveilance-22]: Nicole Perlroth, “In Cybersecurity, Sometimes the Weakest Link Is a Family Member,” 21 May 2014, [http://bits.blogs.nytimes.com/2014/05/21/in-cybersecurity-sometimes-the-weakest-link-is-a-family-member/](http://bits.blogs.nytimes.com/2014/05/21/in-cybersecurity-sometimes-the-weakest-link-is-a-family-member/). 

 [^surveilance-23]: 我在此假定安保摄像头用于诸如商店内部或大街上。任何由其他人架设的对准某人私人空间的摄像机侵犯了隐私，但这是另一个问题。 

 [^surveilance-24]: Ms. Smith, “CIA Wants to Spy On You through Your Appliances,” 18 March 2012, [http://networkworld.com/article/2221934/microsoft-subnet/cia-wants-to-spy-on-you-through-your-appliances.html](http://networkworld.com/article/2221934/microsoft-subnet/cia-wants-to-spy-on-you-through-your-appliances.html). 

 [^surveilance-25]: Jon Queally, “Latest Docs Show Financial Ties between NSA and Internet Companies,” 23 August 2013, <http://www.commondreams.org/news/2013/08/23/latest-docs-show-financial-ties-between-nsa-and-internet-companies>. 

 [^surveilance-26]: Scott Shane and Colin Moynihan, “Drug Agents Use Vast Phone Trove, Eclipsing N.S.A.’s,” 1 September 2013,
[http://www.nytimes.com/2013/09/02/us/drug-agents-use-vast-phone-trove-eclipsing-nsas.html?_r=0](http://www.nytimes.com/2013/09/02/us/drug-agents-use-vast-phone-trove-eclipsing-nsas.html?_r=0). 

 [^surveilance-27]: Dan Kaminsky, “Let’s Cut through the Bitcoin Hype: A Hacker-Entrepreneur’s Take,” 3 May 2013, [http://wired.com/2013/05/lets-cut-through-the-bitcoin-hype/](http://wired.com/2013/05/lets-cut-through-the-bitcoin-hype/). 

 [^surveilance-28]: Steven Levy, “E-Money (That’s What I Want),” Wired, 2.12 (December 1994), <http://archive.wired.com/wired/archive/2.12/emoney_pr.html>. 

 [^surveilance-29]: Richard Bilton, “Camera Grid to Log Number Plates,” last updated on 22 May 2009, <http://news.bbc.co.uk/2/hi/programmes/whos_watching_you/8064333.stm>. 

 [^surveilance-30]: Nusrat Choudhury, “Victory! Federal Court Recognizes Constitutional Rights of Americans on the No-Fly List,” 29 August 2013, [https://www.aclu.org/blog/victory-federal-court-recognizes-constitutional-rights-americans-no-fly-list](https://www.aclu.org/blog/victory-federal-court-recognizes-constitutional-rights-americans-no-fly-list). 

 [^surveilance-31]: Kai Biermann, “Betrayed by Our Own Data,” 26 March 2011, <http://www.zeit.de/digital/datenschutz/2011-03/data-protection-malte-spitz>. 

[^surveilance-32]: Sara M. Watson, “The Latest Smartphones Could Turn Us All into Activity Trackers,” 10 October 2013, [http://wired.com/2013/10/the-trojan-horse-of-the-latest-iphone-with-the-m7-coprocessor-we-all-become-qs-activity-trackers/](http://wired.com/2013/10/the-trojan-horse-of-the-latest-iphone-with-the-m7-coprocessor-we-all-
become-qs-activity-trackers/). 

 [^surveilance-33]: Patrick Toomey, “It Sure Sounds Like the NSA Is Tracking Our Locations,” 30 September 2013, [https://aclu.org/blog/it-sure-sounds-nsa-tracking-our-locations](https://aclu.org/blog/it-sure-sounds-nsa-tracking-our-locations). 

 [^surveilance-34]: Glenn Greenwald, “NSA Collecting Phone Records of Millions of Verizon Customers Daily,” 6 June 2013, <http://www.theguardian.com/world/2013/jun/06/nsa-phone-records-verizon-court-order>. 

 [^surveilance-35]: 一些例子“Testilying: Cops Are Liars Who Get Away with Perjury” (Nick Malinowski, 3 February 2013, [http://vice.com/read/testilying-cops-are-liars-who-get-away-with-perjury](http://vice.com/read/testilying-cops-are-liars-who-get-away-with-perjury)) 以及 “Detective Is Found Guilty of Planting Drugs” (Tim Stelloh, 1 November 2011, [http://nytimes.com/2011/11/02/nyregion/brooklyn-detective-convicted-of-planting-drugs-on-innocent-people.html?pagewanted=all&_r=0](http://nytimes.com/2011/11/02/nyregion/brooklyn-detective-convicted-of-planting-drugs-on-innocent-people.html?pagewanted=all&_r=0))

 [^surveilance-36]: 关于这一点参见“摄影不是犯罪”网站 <http://photographyisnotacrime.com/> 

 [^surveilance-37]: Kevin Drum,“Ubiquitous Surveillance, Police Edition,” 22 August 2013, [http://motherjones.com/kevin-drum/2013/08/ubiquitous-surveillance-police-edition](http://motherjones.com/kevin-drum/2013/08/ubiquitous-surveillance-police-edition). 

 [^surveilance-38]: Public Citizen, “Call Your Representative: Tell Her or Him to Co-Sponsor a Constitutional Amendment to Overturn Citizens United and Restore Democracy to the People,” August 2015, <http://action.citizen.org/p/dia/action3/common/public/?action_KEY=12266>. 

 [^surveilance-39]: 参见《应避免使用（或慎用）的词语》一文中有关 DRM 的叙述。

 [^surveilance-40]: James Allworth, “Your Smartphone Works for the Surveillance State,” 7 June 2013, <https://hbr.org/2013/06/your-iphone-works-for-the-secret-police>. 

 [^surveilance-41]: Evan Selinger and Brett Frischmann, “Will the Internet of Things Result in Predictable People?” 10 August 2015, <http://theguardian.com/technology/2015/aug/10/internet-of-things-predictable-people>. 
