\newpage
## GNU工程

> Copyright © 1998, 2001, 2002, 2005–2008, 2010 Richard Stallman。本文最初以标题“GNU 操作系统和自由软件运动”发表于由 Chris DiBona 等人编写的《开源软件文集：开源革命之声》（Sebastopol: O’Reilly Media, 1999）[^thegnu-0]。尽管我不是 “开放源码”的支持者，我还是贡献了这篇文章， 这样自由软件运动的思想不会在那本书中完全失声。

[^thegnu-0]: 《开源软件文集：开源革命之声》一书中译本已由中国电力出版社于1999年12月出版，洪峰译。——译者注

### 第一个软件分享社区

当我在1971年开始在 MIT（麻省理工学院）的人工智能实验室工作的时候，我成为了那里一个已存在数年之久的软件分享社区的一员。在我们这个特别的社区里，分享软件不受任何限制；这和计算机的历史一样悠久，正如分享菜谱的行为乃是和做饭的历史一样久远的。但我们分享得比大多数人更多。

人工智能实验室使用一个叫 ITS（不兼容分时系统）的分时操作系统，由实验室的黑客[^thegnu-1]员工们设计，并以 Digital PDP-10 ——当年的大型机之一——的汇编语言写成。作为这个社区和人工智能实验室系统黑客员工的一员，我的工作便是改进这个系统。

那时我们并不称我们的软件为“自由软件”，因为那个词尚不存在；但它们实际上就是。只要其他大学和公司的人想要移植和使用我们的程序，我们都十分欢迎。要是你看谁在用一个没见过而有趣的程序，你总可以提出要看看源代码，以便阅读，改动，或者吸收其部件以创造新的程序。

### 社区的解体 

80年代初，Digital 关停了 PDP-10 系列，与此同时，形势发生了剧变。PDP-10 在60年代优雅而强大的架构无法自然地扩展到80年代开始可用的更大的地址空间上。这意味着几乎所有组成 ITS 的程序都要作废。

人工智能实验室的黑客社区不久前就解体了。在1981年，附属的 Symbolics 公司几乎雇走了人工智能实验室的所有黑客，而严重减员使得社区已无法自持（由 Steve Levy 撰写的《黑客》一书记述了这些事件，并给出了一幅社区全盛时期的清晰图景[^thegnu-n]）。人工智能实验室在1982年买了一台新的 PDP-10，而其管理员打算使用 Digital 的非自由分时系统取代 ITS。

[^thegnu-n]: 《黑客：计算机革命的英雄》一书已由机械工业出版社于2011年出版，赵俐、刁海鹏、田俊静译。——译者注

那时的新计算机，如 VAX 或 68020，都自带着操作系统，但没有一个是自由软件：仅仅为了得到一份可以运行的副本，你就得签保密协议。

这意味着使用计算机的第一步就是要你下保证不会去帮助你的邻居。协作的社区被禁止了。私有软件所有者订立的规则是：如果你和邻居分享，你就是海盗（在英语中也用该词表示“盗版者”——译者注）。想要改动，就来求我们吧。

说私有软件的社会制度——不许分享和改造软件的制度——是反社会的、是不道德的、是完全错误的，可能令不少读者吃惊。但是对于一个建立在分裂群众并保持用户无助的基础之上的制度，我们还能说些什么呢？对上述观点吃惊的读者可能已经将私有软件的社会制度视为理所当然，或用带有私有软件行业暗示的词语来判断。软件出版商花了大量的力气和时间去使人们相信对这个问题只有一种看法。

当软件出版商谈论“行使”他们的“权利”或“停止盗版” [^thegnu-2] 时，他们实际“说”的是次要的。这些声明真正传达的是他们将未阐明的假设视为理所当然；公众被要求不加审视地接受这些。还是让我们来仔细审视一番吧。

其中一个假设就是，软件公司对拥有软件有着毋庸置疑的自然权利并因此有权置身所有用户之上。（如果这真是一个自然权利，那么无论它对公众有多大害处，我们也不能反对。）有趣的是，美国宪法和法律惯例排斥这种观点：版权不是自然权利，而是一个政府强加的、限制用户自然地复制权的人为垄断。

另一个未阐明的假设是，对软件唯一重要的是它能让你做什么工作——我们计算机用户不应关心我们应当拥有什么样的社会。

第三个假设是，如果我们不授予软件公司凌驾于程序的用户之上的权利，我们将没有软件可用（或者决不会有一个程序来做这个或那个特定的工作）。这个假设，在自由软件运动展示了我们能够制造丰富的有用的软件而不在上面拴任何锁链之前，也许看似是有理的。

如果我们拒绝接受这些假设，并基于普通常识下的道德把用户放在首位来判断这些问题，我们会得到非常不同的结论。计算机用户应当有自由去修改程序以适应他们的需求，并自由地共享软件，因为帮助别人是社会的根基。

篇幅所限，结论背后的展开叙述不在此详述，读者请参阅文章《为何软件不应有主》于 <http://gnu.org/philosophy/why-free.html>，以及《如今自由软件更加重要》。

### 严酷的道德抉择 

没了社区，继续像从前那样是不可能了。与此相反，我面临着一个严酷的道德抉择。

最简单的选择是加入私有软件世界，签署保密协议并下保证不去帮助黑客同仁。很可能我也会开发在保密协议下分发的软件，因而压迫他人并迫使他们也去背叛他们的伙伴。这样我可以挣钱并在写代码时乐在其中。但我知道当我在事业的尽头，回望筑墙分化人们的岁月时，我将发现我竟耗费了生命以使这个世界变得更糟。

当有人拒绝把我们的打印机控制程序（该程序缺少部分特性使得打印机极其难用）的源代码交给我和 MIT 人工智能实验室时，我已经尝过了当保密协议接受端的滋味。所以我无法对自己说保密协议是无辜的。当他拒绝和我们分享代码时我很生气，己所不欲，毋施于人。

另一个选择是离开计算机领域，直截了当但令人不快。这样我的技艺不会被滥用，但它们会荒废。我将不会因分化限制计算机用户而被指责，但这种事仍然会发生。

所以我求索一条路线让程序员可以做一些好事。我扪心自问，有没有可能有什么项目或程序可以由我来写，以再重新成立一个社区？

答案很清晰：我们首先需要的是一个操作系统。它是开始使用一台计算机的至关重要的软件。有了操作系统你可以做很多事；没有操作系统你就完全无法使用计算机。有了自由的操作系统，我们就可以再次拥有互助的黑客社区——并邀请任何人加入。而且任何人都能使用计算机而毋须图谋去剥夺他们的朋友。

作为一个操作系统开发者，我拥有适当的技艺。故我觉上天降此大任于我，纵不觉注定成功。我决定将系统做成和 Unix 兼容以使其可移植，而且这样 Unix 用户可以很容易切换到它。追随黑客传统，我选了 GNU 这个名字，即“GNU’s Not Unix”（意为“GNU 不是 Unix”）的递归缩写。

一个操作系统并不意味着仅仅是一个内核，这样几乎没有足够的水平来运行其他程序。在20世纪70年代，能称得上操作系统的软件都包含了命令处理器、汇编器、编译器、解释器、调试器、文本编辑器、邮件程序，以及其它许多程序。ITS、Multics、VMS 和 Unix 都有这些。GNU 操作系统也得有。

后来我听到希勒尔的这些话[^thegnu-3]：

> 我不为我谁为我？
> 我只为我我为何？
> 此时不作更待何时？

启动 GNU 工程的决定正是基于类似的情怀。

### Free 是“freedom”的“free”

“free software”一语常常引发误解——它无关价格、它关乎自由。以下是自由软件的定义：

一个软件对你，一个特定用户而言是自由软件，当：


-   不论目的为何，有使用该软件的自由。
-   有修改软件以符合自身需求的自由。（为使得该自由有效行使，你必须能够访问源代码，
    因为在没有源代码的情况下修改程序非常困难。）
-   有重新分发该软件副本的自由，既可免费亦可收费。
-   有发行该软件的修改版的自由，这样社区将从你的改进中受益。

因为 “free” 指的是自由，而不是价格，所以在销售副本和自由软件之间没有矛盾。事实上，销售副本的自由是很重要的：以 CD-ROM 形式卖出的自由软件集对社区很重要，并且出售它们是为自由软件开发筹集资金的重要方法。因此，无法给予人们这些自由的程序就不是自由软件。

因为 “free” 一词的二义性，人们用了很长时间找寻替代词，但更好的词汇尚未找到。英语比其它语言有更多的单词和词汇间的微妙差别，但它缺少一个简单而明确的单词用来表示“自由”，就像在“freedom”一词中——最接近此含义的单词是 “unfettered”。诸如 “liberated"，“freedom” 和 “open” 等替代都有错误的含义或一些其它缺点。

### GNU软件和GNU系统 

开发一个系统是个非常大的工程。为了达成目标，我决定尽可能适配并使用现有的自由软件。例如，一开始我就决定用 TeX 来做主要的文本排版器；若干年后，我决定使用 X 窗口系统而不是为 GNU 再写一个窗口系统。

由于上述决定，和其他类似的决定，GNU 系统不同于所有 GNU 软件的集合。GNU 系统包含非 GNU 的软件，这些程序是由其他人或项目为了他们自己的目的而开发的。我们之所以能用它们是因为它们是自由软件。

### 工程启动

我在1984年1月辞去了 MIT 的工作而开始编写 GNU 软件。离开 MIT 是必要的，这样 MIT 就无法干涉我将 GNU 作为自由软件发行。如果我还在职， MIT 可能会要求拥有这些作品，并强加他们自己的发行条款，甚至将它们变成一个私有软件包。我不希望做大量工作却只是看到它背离其初衷：创建一个新的软件分享社区。

尽管如此，Winston 教授，后来的 MIT 人工智能实验室的领导，友善地邀请我继续使用实验室的设施。

### 第一步

GNU 工程开始前不久，我听说了自由大学编译器工具包，又称 VUCK（荷兰语的“自由”一词以*V*开头）。该编译器设计成支持多种编程语言，包括 C 和 Pascal，并支持多种目标机器，我曾写信给其作者询问 GNU 是否可以使用它。

他带着嘲弄回答了，说大学是自由的而编译器不是。因此我决定首先为 GNU 工程而写的程序就是一个支持多种语言，多平台的编译器。

我希望能避免只靠自己编写整个编译器，因此我要来了 Lawrence Livermore 实验室开发的多平台编译器 Pastal 的源码。它支持一种适合系统编程的 Pascal 语言的扩充版本，并由该语言写成。我给它加上了一个 C 语言前端，并开始将其移植到 Motorola 68000计算机。但当我发现该编译器需要数兆字节的栈空间，而可用的 68000 Unix 系统仅允许 64k 时，我只得放弃。

随后我了解到 Pastel 编译器的工作方式是分析整个输入文件得到一个语法树，将整个语法树转化为一条“指令”链，再产生整个输出文件，整个过程不释放任何内存空间。到此为止，我总结我只得从头开始写一个新的编译器。那个新编译器现在叫 GCC：其中没有一点 Pastel 编译器的内容，不过我仍努力把我之前写的 C 前端适配上去并用上。但那是几年后的事了：首先，我做出了 GNU Emacs。

### GNU Emacs 

我从1984年9月开始写 GNU Emacs，从1985年初它就开始可用了。这使得我开始可以使用 Unix 系统编辑文件：因为没有兴趣学用 vi 或 ed，在那之前我在其他类型的机器上编辑文件。

这时候，人们开始想用 GNU Emacs，因此出现了该如何发行它的问题。当然，我把它放在了我在 MIT 时用的计算机的匿名 ftp 服务器上（那台计算机 `prep.ai.mit.edu`，因而成了主要的 GNU ftp 发行站点，当它一年后退役时，我将其域名转移到我们的新 ftp 服务器上）。但在那时，不少感兴趣的人们并不在互联网上因而无法通过 ftp 得到副本。所以问题是，我该跟他们说什么？

我可以说，“找个上网的朋友帮你下载一个”。或者我可以像对原来 PDP-10 Emacs 那样做：跟他们说，“寄一盘磁带和 SASE （贴足邮资写明发信人）来，我会把 Emacs 写到磁带上寄回去。”但我没有工作，而我正在寻找通过自由软件挣钱的方法。所以我宣布我会寄一盘磁带给任何想要的人，要价 150 美元。我以这种方式启动了发行自由软件的事业，那是今天发行整个 GNU/Linux 系统的公司们的先驱。

### 是一个对任何用户都自由的程序吗? 

如果一个程序离开作者的手时是自由软件，这并不一定意味着它对拥有其副本的每一个人都是自由软件。例如，公有领域的软件 [^thegnu-4]（没有版权的软件）是自由软件；但任何人都可以制作由它修改而来的私有版本。类似的，不少自由程序是被版权保护但按照一个简单的、允许私有修改版的宽容性协议发行。

这个问题的典型例子是 X 窗口系统。这是一个由 MIT 开发并以一个宽容性协议发行的自由软件，它很快被各个计算机公司接受。它们把 X 以仅有二进制的形式加到它们的私有 Unix 系统中，并被同样的保密协议控制着。这些 X 的副本和 Unix 一样，已经不再是自由软件。

X 窗口系统的开发者们并不认为这是一个问题——他们期望并有意使其发生。他们的目标不是自由，而仅仅是“成功”，那种定义为“有许多用户”的成功。他们不在意这些用户是否拥有自由，只是希望他们人数众多。

这导致一个矛盾的情形，两种不同的自由度计算方法对同一个问题“这个程序自由吗？”给出不同的回答。如果你基于 MIT 许可证的发行条款给出的自由作判断，你就会说 X 是自由软件。但是如果你以一般 X 用户的自由来衡量，你就只能说它是私有软件。大多数 X 用户当时正在使用的是随 Unix 系统而来的私有版本，而不是自由版本。

### 左版（Copyleft）和 GNU GPL 

GNU 的目标是给与用户自由，而不仅仅是流行。所以我们需要使用可以阻止 GNU 软件被转变成私有软件的发行条款。我们使用的方法叫“左版” [^thegnu-5]

左版使用版权法，但使它的作用与之通常的作用相反：它成为一种保持程序自由的手段，而不是限制程序的手段。

左版的核心思想是给与任何人运行程序、复制程序、改写程序，和发行改写后的程序的许可——但没有添加他们自己的限制的许可。这样一来，定义“自由软件”的关键自由藉由每个拥有副本的人得以保证，这些自由成了不可剥夺的权利。

对于一个有效的左版，修改版也得是自由的。这确保了建立在我们的工作基础上的作品发布后将有用于社区。当以程序员为业者志愿改进 GNU 软件时，左版能防止他们的雇主说：“你不能分享那些改进，因为我们要用它们来做一个我们的私有版本。”

如果我们要确保程序的每个用户的自由，就需要做出修改保证必须的自由。那些私有化 X 窗口系统的公司通常作了一些修改以将其移植到它们的系统和硬件。这些改动与 X 的大规模扩展相比而言是较小的，但是它们并非微不足道。如果进行修改是拒绝用户自由的一个借口，任何人来利用这一借口都是非常容易的。

一个有关的问题涉及将自由的程序和非自由的代码结合到一起。这样的结合体将不可避免变得不自由；任何一个在非自由部分上缺失的自由也将在整体上缺失。允许这样的结合将会打开足以沉掉一艘船的缺口：任何添加或结合到左版程序上的东西必须使得更大的结合版也是自由和左版的。

我们明确为大多数 GNU 软件使用了左版的 GNU 通用公共许可证，或简称 GNU GPL。我们在特定场合下有其它种类的左版可以使用。GNU 手册也是左版的，但使用一个非常简化的左版类型，因为GNU GPL 的复杂性对手册是不需要的[^thegnu-6]。

### 自由软件基金会 

随着使用 Emacs 的兴趣的增长，开始有其他人加入 GNU 工程，我们感到再次筹集资金的时候到了。所以我们在 1985 年建立了自由软件基金会（FSF），一个发展自由软件的免税慈善机构。FSF 也接手了发行 Emacs 磁带的工作；后来通过将其他自由软件（既有 GNU 的也有非 GNU 的）加到磁带上，和卖软件的自由手册扩展了该业务。

FSF 的大部分收入曾经来自销售自由软件的副本和其他相关服务（源代码的 CD-ROM、二进制文件的 CD-ROM、精心印刷的手册，都有着再发行和修改的自由），以及豪华的发行版（我们为客户选择的平台定制的完整的软件集）。今天 FSF 仍然销售手册和其他部件 [^thegnu-7]，但大部分的资金来自成员的会费。你可以通过 <http://fsf.org/join> 来加入 FSF。

自由软件基金会的雇员已经编写并维护了大量的 GNU 软件包。两个值得注意的是 C 库和 shell。GNU C 库是运行于 GNU/Linux 系统上的任一程序用于和 Linux 通信的组件，由自由软件基金会的成员之一，Roland McGrath 所开发。用于大部分 GNU/Linux 系统的 shell 是 BASH，“Bourne Again Shell”[^thegnu-8]，由 FSF 雇员 Brian Fox 编写。

我们资助了这些程序的开发是因为 GNU 工程并不仅仅与工具和开发环境有关。我们的目标是一个完整的操作系统，而该目标需要这些程序。

### 支持自由软件 

自由软件的哲学抵制一种特定的分布极广的商业实践，但它不反对商业。当商业尊重用户的自由时，我们祝愿它们成功。

销售 Emacs 的副本展现了一种自由软件的生意。当 FSF 接手了这项生意之后，我需要另一种方法谋生。我在销售与我所开发的自由软件相关的服务中找到了它。它包括教人们诸如对 GNU Emacs 编程，定制 GCC，和主要是移植 GCC 到新平台的软件开发的课题。

今天,每个此类的自由软件生意被许多公司实践着。有的通过 CD-ROM 发行自由软件集；其他的则销售服务，从回答用户问题，到改正程序错误，以至增加大的新功能等不同层次上。我们甚至开始看到基于发起新的自由软件产品的自由软件公司。

值得特别注意的是，不少公司尽管将它们自己与 “open source” 一词联系在一起，实际上它们的生意是基于与自由软件一起工作的非自由软件。它们不是自由软件公司，它们是私有软件公司，其产品诱惑用户远离自由。它们称此为“增值包”，反映了它们希望我们接受的价值观念：便利在自由之上。如果我们更珍惜自由，我们应该称它们为“去自由的”包。

### 技术目标 

GNU的首要目标是作为自由软件。即使 GNU 对 Unix 没有技术优势，它也有允许用户合作的社会优势；它还有道德优势：尊重用户的自由。

但是将已知好的实践检验过的标准应用到工作上是很自然的——例如，动态地分配数据结构以避免武断地固定大小限制，并在任何有意义之处处理所有可能的 8 位代码。

另外，我们放弃了面向小内存的 Unix 设计，决定不支持 16 位机器（显然 32 位机器在 GNU 系统完成时将成为主流），并且不为了减少内存使用而作任何努力，除非超过了一兆字节。在处理非常大但不是至关紧要的文件的程序中，我们鼓励程序员们将整个文件读入内存，然后扫描其内容而不必顾虑输入输出的问题。

这些决定使得不少 GNU 程序在可靠性和速度上超越了在 Unix 上的对应的程序。

### 捐来的计算机 

当 GNU 工程声名鹊起，人们开始给工程捐赠运行 Unix 的计算机。这非常有用，因为开发 GNU 组件最轻松的方法就是在一个 Unix 系统上做，然后一个一个地替换掉 Unix 系统上的组件。但这引发了一个道德问题：我们拥有 Unix 的副本从根本上说是不是正当的。

Unix 以前是（并且现在还是）私有软件，而 GNU 工程的哲学说我们不该用私有软件。然而，应用与推论出“自卫的暴力是正当的”相同的理由，我的结论是：在开发用来帮助其他人停止使用私有软件包的自由软件代替品的关键时刻，使用私有软件包是合理的。

但是，尽管这是一个可以合理化的罪恶，它仍然是罪恶。今天我们已经不再持有任何 Unix 的副本，因为我们已经用自由的操作系统取代了它们。如果我们不能将一台计算机的操作系统换成自由的，我们就把整台计算机都换掉。

### GNU 任务清单

随着 GNU 工程的进行，以及越来越多的系统组件被找到或开发，最终使得整理一份未完成工作的清单变得很有用。我们用它来招募开发者来编写缺失的部分。它被称为 GNU 任务清单。除了尚未完工的 Unix 组件外，我们列出了额外的各种各样的其它有用的软件和文档项目，我们认为，这些是一个真正完整的系统所应当拥有的。

如今[^thegnu-9]，留在 GNU 任务清单中的 Unix 组件除了一些无关紧要的之外已经几乎没有了——它们都已经被完成了。但清单中充满了可以被称为“应用程序”的项目。将任何不止能吸引一小部分用户的程序加到操作系统中都是有益的。

就连游戏都在任务清单里——而且从一开始就有。Unix 包含游戏，所以 GNU 自然也该包含。但兼容性对游戏来说不是问题，所以我们没有跟着 Unix 已有的游戏列表走。作为代替，我们列出了用户可能会喜欢的一系列不同种类的游戏。

### GNU 库 GPL 

GNU C 库使用一种特别的左版，称作 GNU 库 GPL（LGPL）[^thegnu-10]，允许将私有软件链接到该库上。为什么需要这样的特例？

这不是个原则问题：没有哪个原则说私有软件产品有资格包含我们的代码（为什么要为一个严辞拒绝与我们分享的工程作贡献呢？）为 C 库，或任何库使用 LGPL，是个策略问题。

C 库做的是通用的工作：每个私有系统或编译器都附带 C 库。因此，让我们的 C 库只能为自由软件所用不会为自由软件带来任何优势——这只会吓阻人们使用我们的库。

有一个系统是这个的例外：在 GNU 系统（包括 GNU/Linux）中，GNU C 库是唯一的 C 库。所以 GNU C 库的发行许可决定了是否可以为 GNU 系统编译私有程序。没有道德理由允许私有应用在 GNU 系统中运行，但从战略上来看禁止它们会更多地吓阻人们使用 GNU 系统，而不是鼓励开发自由应用。所以使用库 GPL 对 C 库是个好策略。

对于其他的库，策略性的决定需要具体问题具体分析。当一个库做的是一种能帮助编写特定种类程序的特殊工作时，那么将其用 GPL 发行，限制其只能被用于自由软件，是一种帮助其它自由软件开发者的方法。这给了他们面对私有软件的一个优势。

考虑 GNU Readline，一个被开发用来为 BASH 提供命令行编辑功能的库。Readline 是用普通的 GNU GPL 而不是库 GPL 发行的。这可能确实减少了 Readline 的使用量，但这对我们没有损失。与此同时，至少有一个可用的应用特地为了能够使用 Readline 而变成了自由软件，那是社区真正的收获。

私有软件有金钱提供的优势；自由软件开发者则要相互取得优势。我希望有朝一日我们能拥有大量受 GPL 保护的、没有可用的私有替代的库，提供作为新自由软件的砖石的有用模块，并为进一步的自由软件开发添加巨大的优势。

### 搔到痒处？

Eric Raymond[^thegnu-11] 说“每一个优秀的软件作品都从搔到开发者个人的痒处（意为“解决开发者个人的问题”——译者注）开始 [^thegnu-12]。”也许有时是这样。但不少 GNU 软件的关键部分是为了一个完整的自由操作系统而开发的。它们来自愿景和计划，而不是冲动。

例如，我们开发了 GNU C 库因为类 Unix 系统需要一个 C 库，开发了 BASH 因为类 Unix 系统需要一个 shell，还有 GNU tar 因为类 Unix 系统需要一个 tar 程序。我们自己的程序也同样如此—— GNU C 编译器，GNU Emacs，GDB 和 GNU Make。

有些 GNU 程序是为应对我们的自由的特定威胁而开发的。为此，我们开发了 gzip 来取代因 LZW 专利而从社区流失的 Compress 程序。我们发现有人开发 LessTif，最近更开始了 GNOME 和 Harmony，来解决因某些私有软件库（见下文）所带来的问题。我们正在开发 GNU 隐私卫士（即 GnuPG 简称 GPG。基于 OpenPGP 协议实现的自由的用于加密、数字签名及产生非对称密钥对的软件。——译者注）来取代流行的非自由加密软件，因为用户不应该在隐私和自由之间作出选择。

当然，写这些程序的人们变得对这项工作感兴趣，许多人为了自己的兴趣和需要给它们添加了很多功能。但那并不是这些程序存在的原因。

### 出乎意料的发展 

在 GNU 工程刚刚开始的时候，我觉得我们将开发整个 GNU 系统，然后整个发行。而这并没有发生。

因为 GNU 系统的每一个组件都是在 Unix 系统中实现的，每个组件早在一个完整的 GNU 出现以前就都可以在 Unix 系统中运行。这些程序有的变得流行，而用户们开始扩充并移植它们——到各种互不兼容的 Unix 版本上，有时也会移植到其他系统。

这个过程使得这些程序更加强大，且为 GNU 工程引来了资金和贡献者。但或许也使得一个最小可用系统延迟了数年，因为 GNU 的开发者们把时间投入到维护这些移植版和为已有组件增加特性，而不是去编写一个个缺失的组件上。

### GNU Hurd 

到了1990年，GNU 系统几乎已完成了：唯一主要的缺失部分是内核。我们已经决定将我们的内核实现为一组运行在 Mach 上的服务进程。Mach 是一个由卡内基梅隆大学，而后在犹他大学开发的微内核；GNU Hurd 是运行于 Mach 之上一组服务（正如一群牛羚——GNU）（Hurd 与 herd 谐音，而 herd 有“群”的意思——译者注），负责 Unix 内核的各种任务。开发的启动，因为我们要等 Mach 像它承诺的那样作为自由软件发行，而有所延误。

选择这种设计的一个原因是为了避免此工作中看起来似乎是最困难的一部分：在没有一个源码层调试器的条件下调试内核程序。这部分工作在 Mach 中已被完成，因此我们期待能将 Hurd 服务作为用户程序来调试，用 GDB。但这花了很长时间才做到，而互相发消息的多线程服务群实际上非常难以调试。这使得让 Hurd 能够稳定工作的进程延长了很多年。

### Alix 

GNU 的内核原本并未打算叫 Hurd。它原本的名字是 Alix——以我当时的恋人命名。她，作为一个 Unix 系统管理员，指出她的名字是多么符合 Unix 系统版本的一般命名模式；作为玩笑，她跟朋友说：“有人一定得用我的名字给一个内核起名。”我什么都没说，但打算用一个叫 Alix 的内核让她吃一惊。

事情并没有保持不变。Michael（现在叫 Thomas）Bushnell，内核的主要开发者，钟意 Hurd 这个名字，并重新定义了 Alix 来表示内核的某个特定部分——用于捕获系统调用并向 Hurd 服务器发消息以处理的那个部分。

后来，Alix 和我分手了，她还改了名字；与此独立地，Hurd 的设计改变了，以至于 C 库直接向服务器发消息，而这使得那个 Alix 组件从设计中消失了。

但在这些事情发生以前，她的一个朋友在 Hurd 的源码中偶然见到了 Alix 这个名字，并告诉了她。所以她确实有机会发现有一个内核以她命名。

### Linux 和 GNU/Linux 

GNU Hurd 尚不适合用于生产，我们也不知道它还能不能适合。这个基于能力的设计有着直接来源于设计灵活性的问题，而且不知道有没有解决方案。


幸运的是，有另一个内核可用。在1991年，Linus Torvalds 开发了一个 Unix 兼容的内核并称之为 Linux。它一开始是私有的，但在 1992 年，他使其成为自由软件；整合 Linux 和尚不完整的 GNU 得到了一个完全自由的操作系统（当然，整合工作自身也很重要）。正是因为 Linux，我们今天终于能运行 GNU 系统的一个版本。

我们称这个版本的系统为 GNU/Linux，以表达他是由 GNU 系统和作为内核的 Linux 整合而成的。不要实用主义地称整个系统为“Linux”，因为那将我们的工作归于他人。请同等程度地提及我们 [^thegnu-13]。

### 未来的挑战 

我们已经证实了我们开发多种类型的自由软件的能力。但这并不意味着我们是不可战胜、不可阻挡的。一些挑战使得自由软件的未来变得不确定；与它们会战将需要坚实的努力和耐力，有时要奋战数年。这将会需要那种当人们珍惜他们的自由，并且不让任何人将其夺走时所显示的决心。

下边四个段落将讨论这些挑战。

#### 机密硬件 

硬件厂商愈发倾向于对硬件规格保密。这使得编写让 Linux 和 XFree86 能支持新硬件的自由驱动程序变得很难。现在我们有了完整的自由操作系统，但是如果不能支持明天的计算机，我们将会在明天失去它们。

有两种方法来应付这个问题。程序员可以采取逆向工程的手段来了解如何支持这些硬件。其他的人则可以选用被自由软件支持的硬件；随着我们的人数增加，规格保密将成为一个自取灭亡的策略。

逆向工程是件大工作；我们会有程序员具备足够的决心去担负这件工作吗？是的——如果我们已经建立了认为自由软件是个原则问题，而私有驱动程序不可容忍的坚定信念。我们中的大多数人会额外花钱，或甚至额外花时间，从而我们可以使用自由驱动程序吗？是的，如果拥抱自由的决心被广泛传播。

\[2008 脚注：这个问题同样延伸到 BIOS. 有一个自由的 BIOS，LibreBoot[^thegnu-14]（coreboot 的一个发行版）；这个问题对计算机变得重要起来，因为 LibreBoot 可以不用非自由的“Blob”就能支持它们。\]

#### 不自由的库 

运行于自由操作系统上的非自由库表现得就像针对自由软件开发者的陷阱一般。库的诱人特性是诱饵；如果你用了这个库，你就掉进了陷阱，因为你的程序无法有用地成为自由操作系统的一部分（严格来说，我们可以包含你的程序，但没有了该库它就无法*运行*）。更糟糕的是，如果一个使用私有库的程序流行起来，它可引诱其他没有怀疑的程序员们落入陷阱。

这样的程序的第一个实例是80年代的 Motif 工具箱，尽管那时还没有自由操作系统，但是很显然 Motif 以后会对自由操作系统引发什么问题。GNU 工程通过两种方式回应这个问题：通过请求个别的自由软件工程在支持 Motif 的同时也支持自由的 X 部件工具箱，并请求一些人编写替代 Motif 的自由软件。该工作花费许多年时间；由匈牙利程序员们开发的 LessTif，在1997年才变得足够强而得以支持大多数 Motif 应用程序。

在1996到1998年间，另一个不自由的 GUI 工具箱库，叫 Qt，被用在 KDE 桌面这一包含大量自由软件的集合中。

自由的 GNU/Linux 系统不能使用 KDE，因为我们不能使用那个库。但是一些不严格坚持自由软件的 GNU/Linux 系统商业发行者将 KDE 加入到它们的系统中——而产生了有更强能力，和更少自由的系统。KDE 小组积极地鼓励更多的程序员们使用 Qt，成百万的新“Linux 用户”从来都不知道有这样一个问题的存在。情形相当糟糕。

自由软件社区以两种方法应对这个问题： GNOME 和 Harmony。

GNOME，GNU Network Object Model Environment（译为“GNU 网络对象模型环境”，现在已经不再用这个说法——译者注），是 GNU 的桌面项目。从1997年开始，由 Miguel de Icaza 在红帽软件的支持下开发，GNOME 开始提供类似的桌面工具，但排它地只使用自由软件。它也有技术上的优势，如支持多种语言，而不仅仅是 C++。但是它的主要目的是自由：不需要使用任何非自由软件。

Harmony 是一个兼容的替代库，设计为使得无需 Qt 运行 KDE 软件成为可能。

在1998年11月，Qt 的开发者声名改动许可证，当其实施后，应该会使得 Qt 成为自由软件。虽然没办法确信，但是我想这应该部分归功于社区对 Qt 是非自由软件时所造成的问题的坚定回应（新的许可证既不方便也不公正，所以仍旧值得去避免使用 Qt）。

\[后记：2000年9月, Qt 按 GNU GPL 发行，实际解决了这个问题。\]

我们将如何应对下一个诱人的非自由库呢？整个社区会明白要远离陷阱吗？或者我们中的许多人将为了方便而放弃自由，从而产生一个大问题？我们的未来将取决于我们自身的哲学。

#### 软件专利

我们面对的最恶劣的威胁来自软件专利，它可以对自由软件加上算法和功能的限制多达二十年。LZW 压缩算法的专利申请于1983年，而我们仍然无法发行能够生成适当压缩过的 GIF 的自由软件。\[直到2009年这些专利才过期。\]1998年，由于专利诉讼威胁，一个用于生成 MP3 压缩音频的自由程序被迫从发行版中移除。

仍有办法对付专利：我们可以寻找证据以证明一个专利是无效的，也可以寻找替代方法来完成工作。但是这每一种方法只是偶尔才起作用；当它们都失败时，一个专利可能会迫使所有的自由软件都缺少某些用户想要的功能。当这种事发生时我们可以做些什么呢？

我们中因自由而重视自由软件的人们无论如何都将与自由软件共进退。我们将设法不用专利保护的功能而完成工作。但是那些认为自由软件技术出众而重视它的人们，有可能在专利抑制自由软件时认为这是自由软件的失败。因而，虽然讨论软件开发的“市集”模式的实用效力和一些自由软件的可靠性和能力是有用的，但我们决不能止步于此。我们必须探讨自由和原则。

#### 自由文档 

我们自由操作系统的最大不足不是在软件中——而是缺乏可以包含在我们系统中的优秀自由手册。文档资料是任何软件包的要害部分；当一个重要的自由软件包没有与优秀的自由手册一起出现，那就是一个重大缺陷。今天我们有许多这样的缺陷。

自由文档，像自由软件一样，是自由问题，不是价格问题。自由手册的标准几乎与自由软件完全相同：它是为了给予所有用户某种自由。必须允许重新发布（包括商业销售），不论是在线还是书面形式，因而手册能够伴随每个程序的每个副本。

改动的许可同样至关重要。作为一个普遍规律，我不相信人们有必要拥有修改所有种类文章和书籍的许可。例如，我不认为你或我应该被迫给予修改像本文这样描述我们行为和我们观点的文章的许可权。

但是有一个特殊的原因说明为什么修改自由软件文档资料的自由是要紧的。当人们行使他们修改软件的权利，并且增加或改变其功能时，如果他们是尽职的，则他们也会同时修改文档和资料——因而他们能随着修改过的程序一起提供正确和可用的文档资料。一个不允许程序员们尽职并完成该工作的手册不符合我们社区的要求。

关于修改应该如何完成的一些限制并不会造成问题。例如，保持原作者的版权声明，发行条款，或作者列表的要求是正当的。要求修改后的版本包括它们是修改版本的声明也是没有问题的，即使有整个章节不能删除或修改，只要这些章节处理的是非技术主题。这些类型的限制不是问题，因为它们不阻止尽职程序员修改手册以适应修改过的程序。换种说法，它们不妨碍自由软件社区完全利用该手册。

然而，必须能够修改手册中的所有*技术性*内容，并将结果以所有常规介质，通过所有常规渠道分发；否则，这些限制将对社区造成阻碍，手册将变得不自由，而我们需要另一手册。

自由软件开发者们会有觉悟和决心去生产全系列的自由手册吗？再说一次，我们的未来取决于哲学。

### 我们必须谈论自由

估计当今有数千万的用户使用诸如 Debian GNU/Linux 和红帽“Linux”这样的 GNU/Linux 系统。自由软件已经发展到了这样实用的优势，使得用户纯粹为了实用原因而聚集到它身边。

这种现象的好结果是明显的：更多人有兴趣开发自由软件，更多用户参与到自由软件产业，以及更能鼓励公司开发商业自由软件而不是私有软件产品。

但是对软件的兴趣增长快于对其指导哲学的了解，这带来了一定麻烦。我们面对上述挑战和威胁的能力依赖于坚决主张自由的意志。为了确定我们的社区拥有这个意志，我们需要在新用户来到社区时向他们传播这样的思想。

但是我们正在这点上失败：吸引新用户加入社区的努力大大超越了教育他们成为我们社区的好公民的努力。我们需要做这两件事，而且我们也需要保持这两个努力的平衡。

### “开放源代码”

当1998年一部分社区决定停止使用术语“自由软件”并改为说“开源软件”时，教导新用户有关自由的观念变得更加困难。

一些喜欢该术语的人想要避免“自由”与“免费”的混淆——这个目标是正当的。其他人却打算将激励了自由软件运动和 GNU 工程的原则精神抛到一边，反而迎合行政和商业用户，而这些用户中的许多人持有一种将利润置于自由，社区和原则之上的意识形态。因而，“开源”的花言巧语集中在制作高质量，强有力软件的潜能上，但是避开自由，社区和原则的思想。

“Linux”杂志是一个清晰的例子——其中充满了利用 GNU/Linux 运行私有软件的广告。当下一个 Motif 或 Qt 出现时，这些杂志将警告程序员们远离它还是为它登载广告呢？

商业支持能以许多方式为社区作贡献；其它种类的支持也都一样，它是有益的。但是为了赢得他们的支持而减少对自由和原则宣讲可能损失惨重；它使得前述“软件推广和公民意识教育”之间的失衡变得愈加糟糕。

“自由软件”和“开放源码”或多或少地描述了同一个软件的类型，但对软件本身和价值观的描述是不同的。GNU 工程继续使用“自由软件”这个术语，来表达自由是重要的思想，而不仅仅是技术。

### 尝试！

犹达大师的名言“没有‘尝试’ ”听似幽雅，但对我不起作用。我已经完成了我的大部分工作，与此同时担心我能不能做，且不确定如果我做了，我的努力够不够完成目标。不过无论如何我尝试了，因为在敌人和我的城池之间除了我没有任何人。令我吃惊的是，我有时会成功。

有时我失败了；我的一些城池陷落了。随后我发现另一个受到威胁的城池，并为另一场战斗做好准备。天长日久，我学会了寻找威胁并将我置于城池和威胁之间，并召集其他黑客和我联合。

今天，我不是在单打独斗。当我看见一个团的黑客挖战壕坚守战线时的感觉是一种安慰和乐趣，我意识到，目前，这个城池也许能幸存。但是危险与年俱增，并且现在 Microsoft 已经明确地将目标对准我们的社区。我们不能把自由的将来视为天命。别把它当作天命！如果你想要保持你的自由，你必须备战以保卫它。

[^thegnu-1]: 一部分大众传媒混淆地将“黑客”一词用来表示“安全破坏者”。我们作为黑客拒绝认可这个含义，并继续用这个词表示“那些喜爱编程、享受有趣的才智，或两者兼备的人。”见拙作 “On Hacking”，于 <http://stallman.org/articles/on-hacking.html>。 

[^thegnu-2]: 参见《应避免使用（或慎用）的词语》一文查看“盗版”一词的更多错误用法。

[^thegnu-3]: 作为无神论者，我不追随任何宗教领袖，但我有时发现我钦佩它们说过的一些话。 

[^thegnu-4]: 参见《自由与非自由软件的分类》查找更多的公有领域软件。 

[^thegnu-5]: 在1984或1985年，Don Hopkins（一位非常有想象力的朋友）寄给我一封信。在信封上他写下了不少有趣的话，包括这句：“Copyleft——逆转一切权利。”我用 “copyleft” 一词来命名我正在开发的发行理念。在本文中采用云南大学的贾星克、李极光二位教授的“左版”的译法——译者注。

[^thegnu-6]: 我们现在对文档使用 GNU 自由文档许可证。

[^thegnu-7]: 于我们的在线商店中可见，位于 <http://shop.fsf.org>。

[^thegnu-8]: “Bourne Again Shell” 是对 “Bourne Shell”——Unix 上普遍使用的 shell 玩的文字游戏。（Bourne 与表示出生的 born 谐音——译者注）

[^thegnu-9]: 写于1998年。2009年我们不再维护长任务列表。社区的自由软件开发得很快，我们没法全部追踪到。取而代之，我们有一个高优先级项目的列表——一个更短的列表，列举了我们十分想要鼓励人们去写的项目。

[^thegnu-10]: 这个许可证现在叫 GNU Lesser General Public License（GNU宽通用公共许可证），以免给出所有库都该使用它的印象。更多信息见 “Why You Shouldn’t Use the Lesser GPL for Your Next Library” 于 <http://www.gnu.org/philosophy/why-not-lgpl.html>。

[^thegnu-11]: Eric Raymond 是开源的主要拥护者；参见《为什么说开源漏掉了自由软件的要点》。 

[^thegnu-12]: 埃里克`雷蒙德（Eric. S. Raymond），《大讲堂与集市》；此书已由机械工业出版社于2014年出版，卫剑钒译。

[^thegnu-13]: 更多信息见 “GNU/Linux FAQ”，于 <http://gnu.org/gnu/gnu-linux-faq.html>, 和《Linux 和 GNU 操作系统》。

[^thegnu-14]: 参见 <http://libreboot.org> 。
