/*
   This file is part of the BasicMathEval Library - version 1.0
   Copyright (C)  2015, 2016    Ivano Primi ( ivprimi@libero.it )    

   The BasicMathEval Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The BasicMathEval library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _PARSER_H_
#define _PARSER_H_

#include <vector>
#include <string>
#include "mathToken.h"

namespace bmEval 
{
  class parser
  {
  public:
    parser (bool allowForImplicitMultiplication = false, 
	    bool allowForComplexInput = true) : 
    m_isImplicitMultiplicationAllowed (allowForImplicitMultiplication),
    m_isComplexInputAllowed (allowForComplexInput)
    { }

    // Default copy constructor, assignment operator and destructor are fine

    void allowForImplicitMultiplication (bool yesno) {
      m_isImplicitMultiplicationAllowed = yesno; 
    }

    void allowForComplexInput (bool yesno) {
      m_isComplexInputAllowed = yesno;
    }

    std::vector<mathToken> tokenize (const std::string& str) const;

  private:
    void postprocess (std::vector<mathToken>& tokenSequence) const;
    void checkArrangement (std::vector<mathToken>& tokenSequence) const;
    void checkArrangement (const mathToken& firstToken, const mathToken& secondToken) const;

    bool m_isImplicitMultiplicationAllowed;
    bool m_isComplexInputAllowed;
  };
} // end of namespace bmEval

#endif // _PARSER_H_
