/**
 * BMovieReviewer Copyright (C) 2009, 2010 Michael J. Beer
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package data;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;

import tools.AppLogger;
import tools.MultiPartFormOutputStream;

public class HTTPPost {

	public static String SEPARATOR = "";
	protected String url;

	protected String user = null;
	protected String passwort = null;

	public HTTPPost(String url) {
		this(url, null, null);
	}

	public HTTPPost(String url, String user, String passwort)
			throws IllegalArgumentException {
		if (url == null) {
			throw new IllegalArgumentException();
		}
		this.url = url;
		this.passwort = passwort;
		this.user = user;
	}

	/**
	 * Fuehrt einen POST aus der String, der gepostet wird, wird zuvor
	 * urlkodiert
	 * 
	 * @param contentType
	 * @param data
	 * @return
	 */
	public String executePost(String reciever, String data) {
		HttpURLConnection con = null;
		String response = "";
		String post = data;
		URL url;
		Globals globs = Globals.getInstance();

		try {
			url = new URL(this.url + "/" + reciever);
		} catch (MalformedURLException e) {
			throw new IllegalArgumentException("Ungueltige URL:  "
					+ e.toString());
		}

		// Falls logindaten gegeben, mituebertragen
		if (passwort != null && this.user != null) {
			try {
				post += "&"
						+ globs.getProperty("server.passwordstring")
						+ "="
						+ SEPARATOR
						+ URLEncoder.encode(this.passwort, globs
								.getProperty("encoding")) + SEPARATOR;
				post += "&"
						+ globs.getProperty("server.userstring")
						+ "="
						+ SEPARATOR
						+ URLEncoder.encode(this.user, globs
								.getProperty("encoding")) + SEPARATOR;
			} catch (Exception e) {
				AppLogger.throwing(this.toString(),
						"executePost(String, String)", e);
			}
		}

		try {
			con = (HttpURLConnection) url.openConnection();
			con.setRequestMethod("POST");
			con.setRequestProperty("Host", globs.getProperty("server.name"));
			con
					.setRequestProperty("Accept",
							"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
			con.setRequestProperty("Accept-Language",
					"de-de,de;q=0.8,en-us;q=0.5,en;q=0.3");
			con.setRequestProperty("Accept-Encoding", "gzip,deflate");
			con.setRequestProperty("Accept-Charset",
					"ISO-8859-1,utf-8;q=0.7,*;q=0.7");
			con.setRequestProperty("Keep-Alive", "300");
			con.setRequestProperty("Connection", "keep-alive");
			con.setRequestProperty("Referer", 
			        Globals.getInstance().getProperty("server.protocoll") + "://" + 
			        Globals.getInstance().getProperty("server.name") + "/" +
					Globals.getInstance().getProperty("server.dir") + "/backend.php");
			con.setRequestProperty("Content-Type",
					"application/x-www-form-urlencoded");
			con.setDoInput(true);
			con.setDoOutput(true);
			con.connect();

		} catch (Exception e) {
			System.err.println("Kann http - Verbindung nicht aufbauen   "
					+ e.toString());
			return "Uebertragung fehlgeschlagen";
		}
		try {
			DataOutputStream wr = new DataOutputStream(con.getOutputStream());
			wr.writeBytes(post);
			wr.close();
			con.disconnect();
		} catch (Exception e) {
			AppLogger.severe("Konnte Daten nicht senden " + e.toString());
			con.disconnect();
			return response;
		}

		// Antwort des Servers lesen
		try {
			BufferedReader rd = new BufferedReader(new InputStreamReader(con
					.getInputStream()));
			String line;
			while ((line = rd.readLine()) != null) {
				response += line;
			}
		} catch (Exception e) {
			AppLogger.severe("Serverantwort nicht lesbar " + e.toString());
			con.disconnect();
		}
		return response;
	}

	/**
	 * Fuehrt einen POST aus, wobei eine Datei uebertragen wird
	 * 
	 * @param receiver
	 *            Empfaenger-php-Skript
	 * @param data
	 *            Dateiinhalt
	 * @param name
	 *            Dateiname
	 * @param contentType
	 *            Typ des Dateiinhalts
	 * @return
	 */
	public String executePost(String receiver, byte[] data, String name,
			String contentType) {

		URL url = null;
		String boundary = MultiPartFormOutputStream.createBoundary();
		URLConnection urlConn = null;
		MultiPartFormOutputStream mps = null;
		String response = "";

		try {
			url = new URL(this.url + "/" + receiver);
		} catch (MalformedURLException e) {
			throw new IllegalArgumentException("Ungueltige URL:  "
					+ e.toString());
		}

		try {
			urlConn = MultiPartFormOutputStream.createConnection(url);
		} catch (IOException e) {
			return "Fehler bei Datei-Post: Konnte Verbindung nicht erstellen";
		}
		urlConn.setRequestProperty("Accept", "*/*");
		urlConn.setRequestProperty("Content-Type", MultiPartFormOutputStream
				.getContentType(boundary));
		urlConn.setRequestProperty("Connection", "Keep-Alive");

		try {
			mps = new MultiPartFormOutputStream(urlConn.getOutputStream(),
					boundary);
			if (this.passwort != null && this.user != null) {
				mps.writeField(Globals.getInstance().getProperty(
						"server.passwordstring"), passwort);
			}
			mps.writeFile("uploadedfile", contentType, name, data);
			mps.close();

			BufferedReader in = new BufferedReader(new InputStreamReader(
					urlConn.getInputStream()));
			String line = null;
			while ((line = in.readLine()) != null) {
				response += line;
			}
			in.close();
		} catch (IOException e) {
			System.err.println("Fehler bei Datei-Post: " + name);
			e.printStackTrace(System.out);
			return "Fehler bei Datei-Post: " + e.toString();
		}

		return response;
	}

	/**
	 * Generiert einen HTTP-Filepost mittels einer Funktion, die in einen
	 * PrintStream schreibt
	 * 
	 * @param receiver
	 * @param name
	 * @param method
	 *            die Methode, die den OutputStream beschreibt, besitzt als
	 *            einziges Argument den PrintStream
	 * @param obj
	 *            das Objekt, an welchem die Methode haengt
	 * @param contentType
	 * @return
	 */
	protected String postFromMethod(String receiver, String name,
			Method method, Object obj, String contentType) {
		if (receiver == null || name == null || method == null || obj == null
				|| contentType == null) {
			throw new IllegalArgumentException();
		}
		Class<?>[] params = method.getParameterTypes();

		// Die Methode darf als einzigen Parameter einen Printstream besitzen
		if (params.length > 1 || !params[0].isAssignableFrom(PrintStream.class)) {
			System.err.println("Parameterzahl: " + params.length);
			for (int i = 0; i < params.length; i++) {
				System.err.println("Parameter " + i + " : "
						+ params[i].toString());
			}
			throw new IllegalArgumentException();
		}

		byte[] data = null;
		String antwort = "";
		ByteArrayOutputStream bas = new ByteArrayOutputStream();

		try {
			method.invoke(obj, new PrintStream(bas, true)); // bogen.printXML(new
			// PrintStream(bas,
			// true));
			data = bas.toByteArray();
		} catch (Exception e) {
			antwort += e.toString();
		}

		try {
			bas.close();
		} catch (IOException e) {
			System.err.println("Konnte ByteArrayOutputStream nicht schlieszen "
					+ e.toString());
		}
		antwort += executePost(receiver, data, name, contentType);
		return antwort;
	}

	/**
	 * Fuehrt einen HTTP-Filepost aus
	 * 
	 * @param file
	 *            die Datei die zu posten ist
	 * @param contentType
	 *            Mimetyp der Datei
	 * @param receiver
	 *            Empfaengerskript
	 * @return Nachricht des Servers
	 * @throws IllegalArgumentException
	 * @throws IOException
	 */
	protected String postFile(File file, String contentType, String receiver)
			throws IllegalArgumentException, IOException {
		if (file == null || !file.exists() || !file.isFile()) {
			String meldung = "Datei " + file.getAbsolutePath()
					+ "  kann nicht geladen werden";
			meldung += (file.exists()) ? "" : " existiert nicht";
			meldung += (file.isFile()) ? "" : " ist keine Datei";

			throw new IllegalArgumentException(meldung);
		}

		long length = file.length();
		if (length > Integer.MAX_VALUE) {
			throw new IOException("Datei zu grosz");
		}
		byte[] data = new byte[(int) length];
		FileInputStream fis = new FileInputStream(file);
		fis.read(data);
		fis.close();
		return executePost(receiver, data, file.getName(), contentType);
	}

	
	
	public String postCover(Bogen bogen) {
		String answer = "\n\n\nPost Cover:\n";	
		Globals globs = Globals.getInstance();
		if(bogen.getCoverImage() == null) {
		    throw new IllegalArgumentException();
		}

		String name = bogen.getCover().getText();
        
        Method print;
        try {
            print = Bogen.class.getMethod("writeImage", OutputStream.class);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(
                    "Fatal: Klasse Bogen besitzt nicht erwartetes Interface: "
                            + e);
        }
        answer += postFromMethod(globs.getProperty("server.postjpeg"), name,
                        print, bogen, globs.getProperty("jpeg.mime"));

		return answer;
	}

	
	public String postXML(Bogen bogen) {
		String answer = "\n\nPost XML :\n";
		Globals globs = Globals.getInstance();		
		String name = bogen.getText(Bogen.I_TITEL).toLowerCase().replaceAll("\\W", "_");
		
		Method print;
		try {
			print = Bogen.class.getMethod("printXML", PrintStream.class);
		} catch (NoSuchMethodException e) {
			throw new RuntimeException(
					"Fatal: Klasse Bogen besitzt nicht erwartetes Interface: "
							+ e);
		}
		answer += postFromMethod(globs.getProperty("server.postxml"), name + ".xml",
						print, bogen, globs.getProperty("mimexml"));
		
		return answer;
	}
	
	
	public String postTex(Bogen bogen) {
		String answer = "\n\nPost Tex :\n";
		Globals globs = Globals.getInstance();
		Method print;
		String name = bogen.getText(Bogen.I_TITEL).toLowerCase().replaceAll("\\W", "_");
		
		try {
			print = Bogen.class.getMethod("printTex", PrintStream.class);
		} catch (NoSuchMethodException e) {
			throw new RuntimeException(
					"Klasse Bogen besitzt nicht erwartetes Interface" + e);
		}
		answer += postFromMethod(globs.getProperty("server.posttex"), name + ".tex",
						print, bogen, globs.getProperty("mimetex"));
		return answer;
	}


	public String postQuotes(Bogen bogen) {
		String answer = "\n\nPost Zitate :\n";
		Globals globs = Globals.getInstance();
		String post = "";
		String name = bogen.getText(Bogen.I_TITEL).toLowerCase().replaceAll("\\W", "_");
		
		try {
			int num = 0;
			post = "movie_name_2="
					+ URLEncoder.encode(bogen.getText(Bogen.I_TITEL), 
					        globs.getProperty("encoding")) + SEPARATOR;
			post += "&eval_file_2="
					+ URLEncoder.encode(name, globs.getProperty("encoding"))
					+ SEPARATOR;
			post += "&new_quote=" + URLEncoder.encode("\"Post Quotes\"", globs.getProperty("encoding"))
			+ SEPARATOR;
			post += "&quotes=";
			for (QualifiedString str : bogen.getZitate()) {
				AppLogger.info("Zitat : " + str.getTyp() + " : "
						+ str.getText());
				if (str.getTyp() > 0) { // registrieren, wenn nicht als
										// uninteressant markiert
					
					if(num > 0) {
						post += URLEncoder.encode("\n", globs.getProperty("encoding"));
					}
					post += URLEncoder.encode(str.getText(), globs.getProperty("encoding"));
					num++;									
				}
			}
			if(num > 0) {
				answer += executePost(globs.getProperty("server.postquotations"),post);
			} else {
				answer += "Keine Zitate zu registrieren";
			}
		} catch (UnsupportedEncodingException e) {
			AppLogger.throwing(this.toString(), "postQuotes(Bogen)", e);
		}
		return answer;
	}

	
	public String registerMovie(Bogen bogen) {
		String answer = "\n\nPost BMovie :\n";
		Globals globs = Globals.getInstance();
		String post = "";
		String name = bogen.getText(Bogen.I_TITEL).toLowerCase().replaceAll("\\W", "_");
		Iterator<QualifiedString> it = bogen.getLinks().iterator();
		QualifiedString l = null;
		
		try {
			post = "movie_name="
					+ URLEncoder.encode(bogen.getText(Bogen.I_TITEL), 
					        globs.getProperty("encoding")) + SEPARATOR;
			post += "&genre="
					+ SEPARATOR
					+ URLEncoder.encode(bogen.getText(Bogen.I_GENRE), 
					        globs.getProperty("encoding")) + SEPARATOR;
			while (it.hasNext()) {
				l = it.next();
				switch (l.getTyp()) {
				case 1: // IMDB deutsh bzw. Englisch
				case 2:
					post += "&imdb="
							+ SEPARATOR
							+ URLEncoder.encode(l.getText(), 
							        globs.getProperty("encoding")) + SEPARATOR;
					break;
				case 3: // wiki_de
					post += "&wiki_ger="
							+ SEPARATOR
							+ URLEncoder.encode(l.getText(), 
							        globs.getProperty("encoding")) + SEPARATOR;
					break;
				case 4: // wiki_de
					post += "&wiki_eng="
							+ SEPARATOR
							+ URLEncoder.encode(l.getText(), 
							        globs.getProperty("encoding")) + SEPARATOR;
					break;
				case 5: // wiki_de
					post += "&videoraiders="
							+ SEPARATOR
							+ URLEncoder.encode(l.getText(), 
							        globs.getProperty("encoding")) + SEPARATOR;
					break;
				default:
					// nichts
				}
			}
			
			post += "&eval_file="
					+ URLEncoder.encode(name + ".pdf", globs.getProperty("encoding"));

			if (bogen.getCover().toString().equals("")) {
				return answer
						+ "\n\n\nKein Cover angegeben - Senden an Server abgebrochen";
			}

			post += "&image="
					+ SEPARATOR
					+ URLEncoder.encode((new File(bogen.getCover().getText()))
							.getName(), globs.getProperty("encoding"))
					+ SEPARATOR;
			post += "&rss="
					+ SEPARATOR
					+ URLEncoder.encode(bogen.getText(Bogen.I_RSS), 
					        globs.getProperty("encoding")) + SEPARATOR;

			post += "&new_movie=Post+movie";
		} catch (UnsupportedEncodingException e) {
			return "Konnte nicht encodieren";
		}
		answer += executePost(globs.getProperty("server.postbmovie"), post);
		return answer;
	}
}
