/*
 * BMovieReviewer Copyright (C) 2009 Michael J. Beer
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package data.formats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;

import tools.AppLogger;
import tools.Utils;
import data.Bogen;
import data.Globals;

/**
 * Dient dem Ablegen/ Laden des Bogens von Platte
 * @author mibeer
 *
 */
public class HDBogen {
    /**
     * Speichert Bogen auf Platte
     */
    public static String save(Bogen bogen) throws IOException{
        String meldung = "";
        Globals globs = Globals.getInstance();
        
        if(bogen.getCoverImage() != null) {
            int quality = 85;
            try{
                quality = Integer.parseInt(globs.getProperty("jpeg.quality"));
            }catch(NumberFormatException e) {
                AppLogger.throwing("Bogen", "save()", e);
                meldung = "Eigensschaft jpeg.quality nichtnumerisch!";
            }
            Utils.writeImage(bogen.getCoverImage(), new File(bogen.getFilePath() + bogen.getCover().getText()), 
                    quality, globs.getProperty("jpeg.mime")); 
            meldung += bogen.getFilePath() + bogen.getCover().getText() + " gespeichert";
            AppLogger.info(bogen.getFilePath() + bogen.getCover().getText() + ".jpg gespeichert");
        }
        
        File xml = new File(bogen.getFilePath() + bogen.getFileName() + ".xml");
        PrintStream  out = new PrintStream(new FileOutputStream(xml));
        bogen.printXML(out);
        out.close();
        meldung += bogen.getFilePath() + bogen.getFileName() + ".xml gespeichert"; 
        AppLogger.info(bogen.getFilePath() + bogen.getFileName() + ".xml gespeichert");     
        return meldung;
    }
    
    public static String load(File file, Bogen bogen) throws CoverException, IOException {
        String meldung = "";
        Globals globs = Globals.getInstance();
        if(file == null || bogen == null) {
            throw new IllegalArgumentException();
        }
        InputStreamReader in = null;
        try{
            in = new InputStreamReader(new FileInputStream(file));
        }catch(IOException e) {
            throw new IOException("Konnte " + file.toString() + " nicht laden!");
        }
        XMLBogen.readXML(in, bogen);
        meldung += file.toString() + " geladen.";
        if(!bogen.getCover().getText().equals(Bogen.EMPTY_STRING)) {
            int scaledWidth = 300;
            try{
                scaledWidth = Integer.parseInt(globs.getProperty("coverwidth"));
            }catch(NumberFormatException e) {
                AppLogger.throwing("Bogen", "save()", e);
                meldung = "Eigenschaft jpegquality nichtnumerisch!";
            }
            String path = Utils.getDirPath(file.getAbsolutePath());
            URL url = new File(path + bogen.getCover().toString()).toURI().toURL();
            try{
                bogen.setCoverImage(Utils.loadImage(url, scaledWidth)); 
            }catch(Exception e) {
                  AppLogger.throwing("HDBogen", "load", e);
                  meldung += " Konnte Bilddatei nicht laden!";  
                  //bogen.getCover().setText("");
                  throw new CoverException("Konnte Bilddatei " + url.toString() + " nicht laden!");
            }
        }
        return meldung;
    }
    
    
    /**
     * Zeigt an, dass Titelbilddatei nich geladen werden konnte
     * @author mibeer
     *
     */    
    public static class CoverException extends IOException {

        public CoverException(String msg) {
            super(msg);
        }
        /**
         * 
         */
        private static final long serialVersionUID = 1L;
        
    }
}
