package gui;

import java.awt.Component;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Utils {
    public static File getFile(Component parent, String path, FileNameExtensionFilter filter) {
        if(path == null || parent == null) {
            throw new IllegalArgumentException();
        }
        JFileChooser chooser = new JFileChooser(path);
        if(filter != null) {
            chooser.setFileFilter(filter);
        }
        int returnVal = chooser.showOpenDialog(parent);
        if (returnVal != JFileChooser.APPROVE_OPTION) {
            return null;
        }
        return chooser.getSelectedFile();
    }
}
