/*
 * BMovieReviewer Copyright (C) 2009 Michael J. Beer
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package main;

import gui.Gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

import tools.AppLogger;
import tools.CmdArgsParser;
import tools.Utils;
import data.Bogen;
import data.Globals;
import data.formats.PDFBogen;
import data.formats.XMLBogen;

public class BMovieApp implements Runnable {

        Bogen bogen;

    public BMovieApp(Bogen bogen) {
        Utils.setBaseDir();
        // Falls gesetzt, Appletflag loeschen
        Globals.setAppType(Globals.STAND_ALONE | Globals.MIT_SENDEN | Globals.MIT_PDF);
        // Globals.setAppType(Globals.APPLET &
        // (Globals.STAND_ALONE | Globals.MIT_PDF));

        Globals globs = Globals.getInstance();
        // Wenn Dictionarybase unbekannt, Rechtschreibpruefung deakt.
        String mode = globs.getProperty("spellcheck.mode");
        String base = globs.getProperty("spellcheck.base");
        if (base.equals("unknown") && !mode.equals("disabled")) {
            // Falls unbekannt, aber Rechtschreibpruefung aktiviert, auf
            // Unterverzeichnis "dat" verweisen
            AppLogger.config("\n\n\nSetze spellcheck.base neu\n\n\n");
            globs.setProperty("spellcheck.base", "file:///" + globs.getProperty("basedirectory") +  
                        File.separator + globs.getProperty("datadirectory") + File.separator);
        }

        // set logo file 
        // try to get Logo
        if(globs.getProperty("logourl").equals("unknown")) {
            String logoFile = "file://" + globs.getProperty("basedirectory") + File.separator +
                    globs.getProperty("datadirectory") + File.separator + "logo.png";
            AppLogger.config("setze Logopfad auf dat/logo.png")
;            globs.setProperty("logourl", logoFile);
        }
        
        AppLogger.config(Globals.getInstance().toString());
        this.bogen = bogen;
        Gui g = new Gui(Globals.APP_NAME, this.bogen);
        g.setVisible(true);

    }

    @Override
    public void run() {
    }

    public static void main(String[] argv) {

        Bogen bogen = null;

        CmdArgsParser args = new CmdArgsParser(argv);
        if (args.isMalformed()) {
            System.out.println(Globals.COPYLEFT);
            System.out.println("\n\nZur Nutzung siehe Datei Readme\n");
            return;
        }

        // Logger konfigurieren
        Logger log = AppLogger.getLogger();
        Handler handler = new StreamHandler(System.out, new SimpleFormatter());
        handler.setLevel(Level.ALL);
        log.addHandler(handler);
        log.setLevel(Level.ALL);

        // Falls Config ausgegeben werden soll, das tun und ohne weitere Ausgabe
        // beenden
        if (args.isSet(CmdArgsParser.STAT_GENERATE_CONFIG)) {
            data.formats.XMLConfig.printConfig(System.out);
            return;
        }

        // DTD ausgeben?
        if (args.isSet(CmdArgsParser.STAT_PRINT_DTD)) {
            data.formats.XMLBogen.printDTD(System.out);
            return;
        }

        // Konfigdatei setzen & laden
        Globals.getInstance().setProperty("configfile", args.getArgs()[1]);
        Utils.loadConfig();
        if (!Utils.isTexProvided()) {
            Globals.getInstance().setProperty("texcommand", "disabled");
        }

        // Codierung setzen
        try {
            handler.setEncoding(Globals.getInstance().getProperty("encoding"));
        } catch (UnsupportedEncodingException e) {
            System.err.println("System unterstuetzt Codierung " + Globals.getInstance().getProperty("encoding") + " nicht");
        }

        // Copyleft ausgeben
        System.out.println(Globals.COPYLEFT);

        // Bogen erzeugen
        if (args.isSet(CmdArgsParser.STAT_IMPORT) || args.isSet(CmdArgsParser.STAT_CONVERT)) {
            // Bogen wird aus bestehender Datei erzeugt...
            if (args.isSet(CmdArgsParser.STAT_PDF)) {
                // aus pdf erzeugen
                File in = new File(args.getArgs()[0]);
                if (!in.exists() || !in.isFile()) {
                    AppLogger.severe("Datei " + in.toString() + "existiert nicht");
                }
                bogen = PDFBogen.readPDF(in);
                bogen.setFilePath(in.getAbsolutePath());
                bogen.setFileName(in.getName());
            }
            if (args.isSet(CmdArgsParser.STAT_XML)) {
                // XML einlesen
                try {
                    File in = new File(args.getArgs()[0]);
                    if (!in.exists() || !in.isFile()) {
                        AppLogger.severe("Datei " + in.toString() + "existiert nicht");
                    }
                    FileInputStream fin = new FileInputStream(in);
                    bogen = XMLBogen.readXML(new InputStreamReader(fin), new Bogen());
                    bogen.setFilePath(in.getAbsolutePath());
                    bogen.setFileName(in.getName());
                    fin.close();
                } catch (IOException e) {
                    AppLogger.throwing("Main", "main", e);
                    return;
                }
            }
        } else {
            bogen = new Bogen();
        }

        // Gui starten ?
        if (args.isSet(CmdArgsParser.STAT_GUI)) {
            new BMovieApp(bogen);
            return;
        }

        if (args.isSet(CmdArgsParser.STAT_CONVERT)) {
            try {
                String file = args.getArgs()[0];
                FileOutputStream fout = new FileOutputStream(file);
                bogen.printTex(new PrintStream(fout));
                bogen.setFilePath(file);
                bogen.setFileName((new File(file)).getName());
                fout.close();
                return;
            } catch (IOException e) {
                AppLogger.throwing("Main", "main", e);
                return;
            }
        }

        if (args.isSet(CmdArgsParser.STAT_EXPORT)) {
            // XML einlesen
            try {
                File in = new File(args.getArgs()[0]);
                if (!in.exists() || !in.isFile()) {
                    AppLogger.severe("Datei " + in.toString() + "existiert nicht");
                }
                FileInputStream fin = new FileInputStream(in);
                bogen = XMLBogen.readXML(new InputStreamReader(fin), new Bogen());
                fin.close();
            } catch (IOException e) {
                AppLogger.throwing("Main", "main", e);
                return;
            }
            if (args.isSet(CmdArgsParser.STAT_TEX)) {
                try {
                    File in = new File(bogen.getFilePath() + bogen.getFileName());
                    FileOutputStream fin = new FileOutputStream(in);
                    bogen.printTex(new PrintStream(fin));
                    fin.close();
                } catch (IOException e) {
                    AppLogger.throwing("Main", "main", e);
                    return;
                }
            }
            if (args.isSet(CmdArgsParser.STAT_PDF)) {
                try {
                    File in = new File(bogen.getFilePath() + bogen.getFileName());
                    FileOutputStream fin = new FileOutputStream(in);
                    PDFBogen.writePDF(bogen, bogen.getFilePath() + bogen.getFileName() + ".tex");
                    // XMLBogen.printXML(new PrintStream(fin), bogen);
                    fin.close();
                } catch (IOException e) {
                    AppLogger.throwing("Main", "main", e);
                    return;
                }
            }
        }
    }

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
}
