package tools;

import data.Globals;

public class CmdArgsParser {

	public CmdArgsParser(String[] args) {
		if (args == null) {
			throw new IllegalArgumentException();
		}

		init();

		int pos = 0, inc = 0;
		String current = null;
		while (pos < args.length) {
			current = args[pos];
			if (current.length() > 0) {
				if (current.charAt(0) == '-') {
					// ist eine Option
					if (current.length() > 1) {
						if (current.charAt(1) == '-') {
							// Langform
							inc = parseLongForm(args, pos);
							if (inc == 0) {
								// nicht wohlgeformt => Abbruch
								malFormed = true;
								return;
							}
							pos += inc;
						} else {
							// Kurzform
							inc = parseShortForm(args, pos);
							if (inc == 0) {
								// nicht wohlgeformt => Abbruch
								malFormed = true;
								return;
							}
							pos += inc;
						}
					} else {
						// nicht wohlgeformt => Abbruch
						malFormed = true;
						return;
					}
				} else {
					// keine Option spezifiziert => Muss zu ladende XML Datei
					// sein
					file[0] = current;
				}
			} else {
				pos++;
			}
		}

	}

	protected void init() {
		file = new String[2];
		file[1] = Globals.getInstance().getProperty("configfile");
	}

	/**
	 * Parst ein Langargument Zurueckgegeben wird die Zahl der "verbrauchten"
	 * Argumente Dabei indiziert 0 einen Fehler
	 * 
	 * @param args
	 *            Argumentarray
	 * @param pos
	 *            Postion des zu parsenden Arguments
	 * @return
	 */
	protected int parseLongForm(String[] args, int pos) {
		int inc = 0;
		int i = 0;
		// remove leading -
		String current = args[pos].substring(1, args[pos].length());
		for (i = 0; i < POSSIBLE_LONG.length; i++) {
			if (current.equals(POSSIBLE_LONG[i])) {
				status |= STATI[i];
				if (OPT_ARGS[i] > -1) {
					if (args.length > pos + 1) {
						// es wird ein Argument erwartet und es folgt noch ein
						// Argument
						file[OPT_ARGS[i]] = args[pos + 1];
					} else {
						return 0;
					}
				}
				inc = INCREMENT[i];
			}
		}
		if (i > POSSIBLE_LONG.length) {
			inc = 0;
		}
		return inc;

	}

	/**
	 * Parst ein Kurzargument Zurueckgegeben wird die Zahl der "verbrauchten"
	 * Argumente Dabei indiziert 0 einen Fehler
	 * 
	 * @param args
	 *            Argumentarray
	 * @param pos
	 *            Postion des zu parsenden Arguments
	 * @return
	 */
	protected int parseShortForm(String[] args, int pos) {
		int inc = 0;
		int i = 0;
		// remove leading -
		String current = args[pos].substring(1, args[pos].length());
		for (i = 0; i < POSSIBLE_SHORT.length; i++) {
			if (current.equals(POSSIBLE_SHORT[i])) {
				status |= STATI[i];
				if (OPT_ARGS[i] > -1) {
					if (args.length > pos + 1) {
						// es wird ein Argument erwartet und es folgt noch ein
						// Argument
						file[OPT_ARGS[i]] = args[pos + 1];
					} else {
						return 0;
					}
				}
				inc = INCREMENT[i];
			}
		}
		if (i > POSSIBLE_SHORT.length) {
			inc = 0;
		}
		return inc;
	}

	public String[] getArgs() {
		return file;
	}

	public int getStatus() {
		return status;
	}

	public boolean isMalformed() {
		return malFormed;
	}

	public boolean isSet(int opt) {
		if ((getStatus() & opt) == opt) {
			return true;
		}
		return false;
	}

	/**
	 * Moegliche angegebene Dateien 0 zu behandelnde Datei 1 config
	 */
	protected String[] file;

	/**
	 * wohlgeformte Parameterzeile ?
	 */
	protected boolean malFormed = false;

	// //////////////////////////////////////////////////////////
	// Alle moeglichen Parameter
	public final static String[] POSSIBLE_LONG = { "generate-config-file",
			"config-file", "print-bmovie-dtd", "import-pdf", "export-pdf",
			"export-tex", "convert-pdf", "file" };

	public final static String[] POSSIBLE_SHORT = { "gcf", "cfg", "dtd", "ip",
			"ep", "et", "cp", "f" };

	protected final int[] INCREMENT = { 1, 2, 1, 2, 2, 2, 2, 2 };

	protected final int[] STATI = { STAT_GENERATE_CONFIG, STAT_GUI,
			STAT_PRINT_DTD, STAT_IMPORT | STAT_PDF | STAT_GUI,
			STAT_EXPORT | STAT_PDF, STAT_EXPORT | STAT_TEX,
			STAT_CONVERT | STAT_PDF, STAT_GUI | STAT_IMPORT | STAT_XML };

	protected final int[] OPT_ARGS = { -1, 1, -1, 0, 0, 0, 0, 0};

	protected int status = STAT_GUI;

	// Moegliche Zustaende
	/**
	 * Gui starten?
	 */
	public static int STAT_GUI = 1;
	/**
	 * Importieren?
	 */
	public static int STAT_IMPORT = 2;
	/**
	 * Exportieren?
	 */
	public static int STAT_EXPORT = 4;
	/**
	 * Konvertieren?
	 */
	public static int STAT_CONVERT = 8;
	/**
	 * Tex?
	 */
	public static int STAT_TEX = 16;
	/**
	 * XML?
	 */
	public static int STAT_XML = 32;
	/**
	 * PDF
	 */
	public static int STAT_PDF = 64;

	/**
	 * Generate config file
	 */
	public static int STAT_GENERATE_CONFIG = 128;
	/**
	 * Print dtd
	 */
	public static int STAT_PRINT_DTD = 256;
}
