;;; This file is automatically loaded by Bobot++. This is required for
;;; the bot to function.

;;; This file is covered by the GPL version 2 or (at your option) any
;;; later version 

;;; the-bot-module must be available to guile-user so that scripts
;;; loaded with Interp::Load have access to the bot: procedures
(module-use! (resolve-module '(guile-user) #f)
	     the-bot-module)

(define-public %bot:loadpath (list
			      (string-append (getenv "HOME")
					     "/.bobotpp/scripts/")
			      bot:sys-scripts-dir))
(define-public %bot:load-extensions %load-extensions)

;;; bot-log: Write as many messages as you want to the log.  If the
;;; arg is a thunk it will be executed and it's output will be
;;; written to the log
(define-public (bot:log . messages)
  (for-each
   (lambda (x)
     (if (thunk? x)
       (display (x) (bot-logport))
       (display x (bot-logport))))
   messages )
  (bot:flushport))

(define-public (bot:load file)
  (let path-loop ((load-path %bot:loadpath))
    (cond ((not (null? load-path))
	   (if (not
		(let ext-loop ((extensions %bot:load-extensions))
		  (if (not (null? extensions))
		      (if (catch 'system-error
				 (lambda ()
				   (load
				    (string-append (car load-path)
						   file
						   (car extensions))))
				 (lambda args
				   #f ))
			  #t
			  (ext-loop (cdr extensions))))))
	       (path-loop (cdr load-path))))
	  (else
	   (begin (bot:log "ERROR: File " file " Not Found!\n") #f)))))

(define-public (bot:load-module module-spec)
  (let ((module->string
	 (lambda (module)
	  (apply
	   (lambda (s . rest)
	     (string-append
	      s
	      (apply string-append
		     (map (lambda (str) (string-append "/" str)) rest))))
		 (map symbol->string module))))
	(new-module
	 (make-module))
	(old-module (current-module)))
    (module-use! new-module the-bot-module)
    (set-current-module new-module)
    (bot:load (module->string module-spec))
    (set-current-module old-module)
    new-module))

(define-public (bot:use-module module-spec)
  (module-use! (current-module)
	       (bot:load-module module-spec)))
    

;;; REGEX UTILS

;;; match-not-channel adds a prefix regex to your regex so it doesn't
;;; match the sender or channel in a PUBLIC message
(define-public (bot:match-not-channel regex)
  (string-append "^[[:graph:]]* [&#+!][^ ,\a]+ [[:graph:][:space:]]*" regex))

;;; match-to-me matches text that was addressed to the bot with a
;;; ':',',', or nothing after the bot name
(define-public (bot:match-to-me regex)
  (string-append (bot:match-not-channel (bot:getnickname))
		 "[[:space:][:graph:]]*" regex))

;;;; string-utils
(define-public str-app string-append) ; shorter

;;; Message sending utils

;;; returns the CTCP quoted message
(define-public (ctcp-quote message)
  message) ; FIXME: fill me in

;;; DEPRECATED FUNCTION NAMES
;;; These are provided for backwards compatibility
;;; and will be removed in the 2.3 dev tree

(define-public bot-load bot:load)
(define-public bot-action bot:action)
(define-public bot-adduser bot:adduser)
(define-public bot-addserver bot:addserver)
(define-public bot-addshit bot:addshit)
(define-public bot-ban bot:ban)
(define-public bot-cycle bot:cycle)
(define-public bot-deban bot:deban)
(define-public bot-delserver bot:delserver)
(define-public bot-deluser bot:deluser)
(define-public bot-delshit bot:delshit)
(define-public bot-deop bot:deop)
(define-public bot-die bot:die)
(define-public bot-do bot:do)
(define-public bot-invite bot:invite)
(define-public bot-join bot:join)
(define-public bot-keep bot:keep)
(define-public bot-kick bot:kick)
(define-public bot-kickban bot:kickban)
(define-public bot-lock bot:lock)
(define-public bot-logport bot:logport)
(define-public bot-mode bot:mode)
(define-public bot-msg bot:msg)
(define-public bot-nextserver bot:nextserver)
(define-public bot-nick bot:nick)
(define-public bot-op bot:op)
(define-public bot-part bot:part)
(define-public bot-reconnect bot:reconnect)
(define-public bot-say bot:say)
(define-public bot-server bot:server)
(define-public bot-setversion bot:setversion)
(define-public bot-tban bot:tban)
(define-public bot-tkban bot:tkban)
(define-public bot-topic bot:topic)
(define-public bot-unlock bot:unlock)
(define-public bot-getnickname bot:getnickname)
(define-public bot-getserver bot:getserver)
(define-public bot-getserverlist bot:getserverlist)
(define-public bot-flush bot:flush)
(define-public bot-flushport bot:flushport)
(define-public bot-random bot:random)
(define-public bot-addcommand bot:addcommand)
(define-public bot-delcommand bot:delcommand)
(define-public bot-addhook bot:addhook)
(define-public bot-addtimer bot:addtimer)
(define-public bot-deltimer bot:deltimer)