// ServerQueueItem.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef SERVERQUEUEITEM_H
#define SERVERQUEUEITEM_H

class ServerQueueItem {
public:
  int priority, penalty, type;

  enum {
    CHANNELMODE, USERMODE, INVITE, JOIN, KICK,
    NICK, NOTICE, PART, PASS, PING, PONG, PRIVMSG,
    QUIT, TOPIC, USER, USERHOST, WHO, WHOIS, OTHER
  };

  ServerQueueItem(int, int, int);
  virtual ~ServerQueueItem() { }

  virtual bool merge(ServerQueueItem *) { return false; }
  virtual String getLine() = 0;

  friend class ServerQueue;

private:
  ServerQueueItem(const ServerQueueItem &);
};


class ServerQueueOtherItem : public ServerQueueItem {
public:
  String line;

  ServerQueueOtherItem(String, int, int, int);
  String getLine();
};

class ServerQueueChannelModeItem : public ServerQueueItem {
public:
  String channel;
  String mode;
  String parameters;
  int paramcount;

  ServerQueueChannelModeItem(String, String, String);
  bool merge(ServerQueueItem *);
  String getLine();
};

class ServerQueueKickItem : public ServerQueueItem {
public:
  String channel;
  String who;
  String reason;
  int count;

  ServerQueueKickItem(String, String, String);
  bool merge(ServerQueueItem *);
  String getLine();
};

class ServerQueueNoticeItem : public ServerQueueItem {
public:
  String dest;
  String message;
  int count;

  ServerQueueNoticeItem(String, String);
  bool merge(ServerQueueItem *);
  String getLine();
};

#endif
