// DCCPerson.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef DCCPERSON_H
#define DCCPERSON_H

#include "String.H"
#include "Person.H"
#include "DCCConnection.H"
#include "UserCommands.H"

class DCCPerson : public Person {
  DCCConnection *dcc;
public:
  DCCPerson(DCCConnection *);
  DCCPerson(DCCPerson &);

  Person * copy();

  //  String getNick() const;
  //  String getAddress() const;

  void keepAlive();
  bool handleInput ();

  void sendNotice(String);

  friend class Bot;
  friend class DCCManager;
  friend void
  UserCommands::DCCList (ServerConnection *, Person *,
			 String, String);
};

#endif
