// Interp.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USESCRIPTS

#include "Macros.H"
#include "Commands.H"
#include "Interp.H"
#include "BotInterp.H"

#include <libguile.h>

// static class member initial definitions
Bot * Interp::bot = 0;
SCM Interp::bot_module = 0;
#ifdef MULTITHREAD
pthread_mutex_t Interp::mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

typedef SCM (*SCMFunc)();

SCM
scm_apply_wrapper(void *data)
{
#ifdef MULTITHREAD
  //  pthread_mutex_lock (&Interp::mutex);
#endif

  wrapper_data * wd = static_cast<wrapper_data *> (data);
  scm_apply(wd->func, wd->args, SCM_EOL);

#ifdef MULTITHREAD
  //  pthread_mutex_unlock (&Interp::mutex);
#endif

  return SCM_BOOL_T;
}

#define bot_new_procedure(a, b, c, d, e) scm_c_define_gsubr (a, c, d, e, b); scm_c_export (a, 0)
#define scm_c_define_gsubr(a, b, c, d, e) scm_c_define_gsubr (a, b, c, d, e); scm_c_export (a, 0)
#define scm_c_define(a, b) scm_c_define (a, b); scm_c_export (a, 0)

void
interp_init_helper (void* unused)
{
  scm_c_use_module ("guile-user");
  // Hooks
  scm_c_define ("bot:exit-hook", scm_make_hook (scm_long2num (0)));

  // Symbols
  // bot:user-*
  scm_c_define ("bot:user-none", scm_long2num (User::NONE));
  scm_c_define ("bot:user-user", scm_long2num (User::USER));
  scm_c_define ("bot:user-trusted", scm_long2num (User::TRUSTED_USER));
  scm_c_define ("bot:user-friend", scm_long2num (User::FRIEND));
  scm_c_define ("bot:user-master", scm_long2num (User::MASTER));
  // sys-dir
  scm_c_define ("bot:sys-scripts-dir", 
		scm_makfrom0str (String(PREFIX) + 
				 "/share/bobotpp/scripts/"));
  // Hooks
  scm_c_define ("hooks/action", scm_long2num(Hook::ACTION));
  scm_c_define ("hooks/nickname", scm_long2num(Hook::NICKNAME));
  scm_c_define ("hooks/signoff", scm_long2num(Hook::SIGNOFF));
  scm_c_define ("hooks/ctcp", scm_long2num(Hook::CTCP));
  scm_c_define ("hooks/ctcp-reply", scm_long2num(Hook::CTCP_REPLY));
  scm_c_define ("hooks/disconnect", scm_long2num(Hook::DISCONNECT));
  scm_c_define ("hooks/flood", scm_long2num(Hook::FLOOD));
  scm_c_define ("hooks/invite", scm_long2num(Hook::INVITE));
  scm_c_define ("hooks/join", scm_long2num(Hook::JOIN));
  scm_c_define ("hooks/kick", scm_long2num(Hook::KICK));
  scm_c_define ("hooks/leave", scm_long2num(Hook::LEAVE));
  scm_c_define ("hooks/part", scm_long2num(Hook::LEAVE));
  scm_c_define ("hooks/mode", scm_long2num(Hook::MODE));
  scm_c_define ("hooks/message", scm_long2num(Hook::MESSAGE));
  scm_c_define ("hooks/notice", scm_long2num(Hook::NOTICE));
  scm_c_define ("hooks/public", scm_long2num(Hook::PUBLIC));
  scm_c_define ("hooks/public-notice", scm_long2num(Hook::PUBLIC_NOTICE));
  scm_c_define ("hooks/raw", scm_long2num(Hook::RAW));
  scm_c_define ("hooks/timer", scm_long2num(Hook::TIMER));
  scm_c_define ("hooks/topic", scm_long2num(Hook::TOPIC));
  // send hooks
  scm_c_define ("hooks/send/public", scm_long2num (Hook::SEND_PUBLIC));
  scm_c_define ("hooks/send/message", scm_long2num (Hook::SEND_MESSAGE));
  scm_c_define ("hooks/send/action", scm_long2num (Hook::SEND_ACTION));
  scm_c_define ("hooks/send/ctcp", scm_long2num (Hook::SEND_CTCP));
  // dcc hooks
  scm_c_define ("hooks/dcc/chat-begin", 
		scm_long2num (Hook::DCC_CHAT_BEGIN));
  scm_c_define ("hooks/dcc/chat-message", 
		scm_long2num (Hook::DCC_CHAT_MESSAGE));

  // procedures
  bot_new_procedure ("bot:action", (SCMFunc)ScriptCommands::Action, 2, 0, 0);
  scm_c_define_gsubr ("bot:adduser", 5, 2, 0,
		      (SCMFunc)ScriptCommands::AddUser);
  bot_new_procedure ("bot:addserver", (SCMFunc)ScriptCommands::Action, 
		     3, 4, 0);
  scm_c_define_gsubr ("bot:addshit", 3, 2, 0, 
		      (SCMFunc)ScriptCommands::AddShit);
  bot_new_procedure ("bot:ban", (SCMFunc)ScriptCommands::Action, 2, 0, 0);
  bot_new_procedure ("bot:change-command-level", (SCMFunc)ScriptCommands::ChangeCommandLevel,
		     2, 0, 0);
  bot_new_procedure ("bot:cycle", (SCMFunc)ScriptCommands::Action, 1, 0, 0);
  bot_new_procedure ("bot:deban", (SCMFunc)ScriptCommands::Deban, 2, 0, 0);
  bot_new_procedure ("bot:delserver", (SCMFunc)ScriptCommands::DelServer, 
		     1, 0, 0);
  bot_new_procedure ("bot:deluser", (SCMFunc)ScriptCommands::DelUser, 2, 0, 0);
  bot_new_procedure ("bot:delshit", (SCMFunc)ScriptCommands::DelShit, 2, 0, 0);
  bot_new_procedure ("bot:deop", (SCMFunc)ScriptCommands::Deop, 2, 0, 0);
  bot_new_procedure ("bot:die", (SCMFunc)ScriptCommands::Die, 1, 0, 0);
  bot_new_procedure ("bot:do", (SCMFunc)ScriptCommands::Do, 1, 0, 0);
  bot_new_procedure ("bot:invite", (SCMFunc)ScriptCommands::Invite, 2, 0, 0);
  bot_new_procedure ("bot:join", (SCMFunc)ScriptCommands::Join, 1, 1, 0);
  bot_new_procedure ("bot:keep", (SCMFunc)ScriptCommands::Keep, 2, 0, 0);
  bot_new_procedure ("bot:kick", (SCMFunc)ScriptCommands::Kick, 2, 1, 0);
  bot_new_procedure ("bot:kickban", (SCMFunc)ScriptCommands::KickBan, 2, 1, 0);
  bot_new_procedure ("bot:lock", (SCMFunc)ScriptCommands::Lock, 1, 0, 0);
  bot_new_procedure ("bot:logport", (SCMFunc)ScriptCommands::LogPort, 0, 0, 0);
  bot_new_procedure ("bot:mode", (SCMFunc)ScriptCommands::Mode, 2, 0, 0);
  bot_new_procedure ("bot:msg", (SCMFunc)ScriptCommands::Msg, 2, 0, 0);
  bot_new_procedure ("bot:nextserver", (SCMFunc)ScriptCommands::NextServer, 
		     0, 0, 0);
  bot_new_procedure ("bot:nick", (SCMFunc)ScriptCommands::Nick, 1, 0, 0);
  bot_new_procedure ("bot:op", (SCMFunc)ScriptCommands::Op, 2, 0, 0);
  bot_new_procedure ("bot:part", (SCMFunc)ScriptCommands::Part, 1, 0, 0);
  bot_new_procedure ("bot:reconnect", (SCMFunc)ScriptCommands::Reconnect, 
		     0, 0, 0);
  bot_new_procedure ("bot:say", (SCMFunc)ScriptCommands::Say, 2, 0, 0);
  bot_new_procedure ("bot:server", (SCMFunc)ScriptCommands::Server, 1, 0, 0);
  scm_c_define_gsubr ("bot:setfloodrate", 1, 0, 0,
		      (SCMFunc)ScriptCommands::SetFloodRate);
  bot_new_procedure ("bot:setversion", (SCMFunc)ScriptCommands::SetVersion, 
		     1, 0, 0);
  bot_new_procedure ("bot:tban", (SCMFunc)ScriptCommands::TBan, 3, 0, 0);
  bot_new_procedure ("bot:tkban", (SCMFunc)ScriptCommands::TKBan, 3, 1, 0);
  bot_new_procedure ("bot:topic", (SCMFunc)ScriptCommands::Topic, 2, 0, 0);
  bot_new_procedure ("bot:unlock", (SCMFunc)ScriptCommands::Unlock, 1, 0, 0);

  bot_new_procedure ("bot:getnickname", (SCMFunc)ScriptCommands::getNickname, 
		     0, 0, 0);
  bot_new_procedure ("bot:getserver", (SCMFunc)ScriptCommands::getServer, 
		     0, 0, 0);
  bot_new_procedure ("bot:getserverlist", 
		     (SCMFunc)ScriptCommands::getServerList, 0, 0, 0);
  bot_new_procedure ("bot:flush", (SCMFunc)ScriptCommands::flushQueue, 
		     0, 0, 0);
  bot_new_procedure ("bot:flushport", (SCMFunc)ScriptCommands::flushPort, 
		     0, 0, 0);
  bot_new_procedure ("bot:random", (SCMFunc)ScriptCommands::random, 
		     1, 0, 0);
  bot_new_procedure ("bot:addcommand", (SCMFunc)ScriptCommands::addCommand, 
		     5, 0, 0);
  bot_new_procedure ("bot:delcommand", (SCMFunc)ScriptCommands::delCommand, 
		     1, 0, 0);
  bot_new_procedure ("bot:addhook", (SCMFunc)ScriptCommands::AddHook, 
		     3, 3, 0);
  bot_new_procedure ("bot:addtimer", (SCMFunc)ScriptCommands::AddTimer, 
		     2, 0, 0);
  bot_new_procedure ("bot:deltimer", (SCMFunc)ScriptCommands::DelTimer, 
		     1, 0, 0);

  scm_c_define_gsubr ("bot:dcc-chat-send", 2, 0, 0,
		      (SCMFunc)ScriptCommands::sendDCCChatMessage);

  // "Low Level" Message functuions
  scm_c_define_gsubr ("bot:send-CTCP", 3, 0, 0,
		      (SCMFunc)ScriptCommands::sendCTCP);
}

#undef bot_new_procedure
#undef scm_c_define_gsubr
#undef scm_c_define


SCM
interp_post_startup_helper (void *bot_module)
{
  SCM module = static_cast<SCM> (bot_module);
  scm_c_define ("the-bot-module", module);
  scm_c_export ("the-bot-module", 0);
  // load bobot-utils
  scm_primitive_load 
    (scm_makfrom0str (String(PREFIX) + 
		      "/share/bobotpp/scripts/bobot-utils.scm"));
  return 0;
}

void
Interp::Startup()
{
  bot_module = scm_c_define_module ("the-bot-module", 
				    interp_init_helper, 0);
  scm_c_call_with_current_module (bot_module,
				  interp_post_startup_helper,
				  bot_module);
}

void
Interp::Shutdown()
{ 
  scm_c_run_hook (gh_lookup ("bot:exit-hook"), SCM_EOL);
}

void
Interp::Execute(Bot *b, String command)
{
#ifdef MULTITHREAD
  // We get the lock
  pthread_mutex_lock(&mutex);
#endif
  
  bot = b;
  gh_eval_str_with_catch (command, ErrorHandler);
  
#ifdef MULTITHREAD
  // We release the lock
  pthread_mutex_unlock(&mutex);
#endif
}

void load_script_helper (void* file)
{
  String filename = *static_cast<String*> (file);
  scm_c_use_module ("guile-user");
  gh_eval_file_with_catch(filename, Interp::ErrorHandler);
}

void
Interp::LoadScript(Bot *b, String filename)
{
#ifdef MULTITHREAD
  // We get the lock
  pthread_mutex_lock(&mutex);
#endif
  bot = b;
  //scm_c_define_module ("", load_script_helper, &filename);
  gh_eval_file_with_catch(filename, ErrorHandler);
#ifdef MULTITHREAD
  // We release the lock
  pthread_mutex_unlock(&mutex);
#endif
}

SCM
Interp::ErrorHandler(void *data, SCM tag, SCM throw_args)
{
  bot->botInterp->ScriptLog(throw_args);
  return SCM_BOOL_F;
}

#endif
