// UserListItem.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (c) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

// An UserListItem object is the object that is stored in the UserList.

#ifndef USERLISTITEM_H
#define USERLISTITEM_H

#include <ctime>

#include "Mask.H"

class User;
class UserList;
class Commands;
class UserCommands;

class UserListItem {
  // Mask on the user
  Mask mask;
  // Mask on the channel
  Mask channelMask;
  // Level (from 0 to 4)
  int level;
  // Protection (from 0 to 2)
  int prot;
  // Auto-op
  bool aop;
  // Date until which the UserListItem is valid
  time_t expirationDate;
  // Password
  String passwd;
  // How many channels are we identified on ?
  int identified;
  // Is this item automatically added ?
  bool autoEntry;

public:
  UserListItem(String m, String mc, int l, int p, bool a,
               std::time_t e = -1, String pass= "", bool ae = false)
    : mask(m), channelMask(mc), level(l), prot(p), aop(a),
      expirationDate(e), passwd(pass), identified(0), autoEntry(ae) { }

  // Returns true if it matches <m> on channel(s) <mc>
  bool matches(String m, String mc)
    { if (mc.length()==0) return mask.matches(m);
      else return mask.matches(m) && channelMask.matches(mc); }

  // Returns true if it matches <m>
  bool matches(String m)
    { return mask.matches(m); }

  // Is the item still valid ? (-1 means infinity)
  bool isStillValid()
    { return expirationDate == -1 || std::time(NULL) <= expirationDate; }

  friend class Parser;
  friend class Channel;
  friend class User;
  friend class UserList;
  friend class Commands;
  friend class UserCommands;
};

#endif
