// BotThreading.C  -*- C++ -*-
// Copyright (c) 2008 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#include "BotThreading.H"

#ifdef MULTITHREAD

#include <pthread.h>
#include <iostream>

BotMutex::BotMutex (bool recursive)
{
  pthread_t self = pthread_self ();
#if 0
  std::cerr << "Mutex Init..."
	    << " Mutex: " << &mutex
	    << " Thread: " << &self
	    << std::endl;
#endif
  pthread_mutexattr_init (&attrs);

  if (recursive)
    pthread_mutexattr_settype (&attrs, PTHREAD_MUTEX_RECURSIVE);

  pthread_mutex_init (&mutex, &attrs);

}

BotMutex::~BotMutex ()
{
  pthread_t self = pthread_self ();
#if 0
  std::cerr << "Mutex Destroy..."
	    << " Mutex: " << &mutex
	    << " Thread: " << &self
	    << std::endl;
#endif
  pthread_mutex_destroy (&mutex);
  pthread_mutexattr_destroy (&attrs);
}

void BotMutex::lock ()
{
//   pthread_t self = pthread_self ();
//   std::cerr << "< Mutex Lock..."
// 	    << " Mutex: " << &mutex
// 	    << " Thread: " << &self
// 	    << std::endl;
  pthread_mutex_lock (&mutex);
}

void BotMutex::unlock ()
{
//   pthread_t self = pthread_self ();
//   std::cerr << "> Mutex Unlock..."
// 	    << " Mutex: " << &mutex
// 	    << " Thread: " << &self
// 	    << std::endl;
  pthread_mutex_unlock (&mutex);
}

#else // non threaded noops

BotMutex::BotMutex ()
{ }

BotMutex::~BotMutex ()
{ }

void BotMutex::lock ()
{ }

void BotMutex::unlock ()
{ }

#endif // MULTITHREAD

BotLock::BotLock (BotMutex & m)
  : mutex(m)
{
//   pthread_t self = pthread_self ();
//   std::cerr << "Lock Init..."
// 	    << " Lock: " << this
// 	    << " Mutex: " << &mutex
// 	    << " Thread: " << &self
// 	    << std::endl;
  mutex.lock ();
}

BotLock::~BotLock ()
{
//   pthread_t self = pthread_self ();
//   std::cerr << "Lock Destroy..."
// 	    << " Lock: " << this
// 	    << " Mutex: " << &mutex
// 	    << " Thread: " << &self
// 	    << std::endl;
  mutex.unlock ();
}
