// ChannelUserList.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2002,2005,2008,2009 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.

#ifndef CHANNEL_USER_LIST_H
#define CHANNEL_USER_LIST_H

#include <algorithm>
#include <list>
#include <string>

#include "BotThreading.H"

class User;
class UserList;
class UserListItem;

class ChannelUserList
{
  std::list<User> users;
  mutable BotMutex users_mutex;
  std::string channel_name;

  std::equal_to<User> user_equal_p;
  std::less<User> user_less_p;

  std::list<User>::iterator get_user_i_ (const std::string &);
  void add_ (std::string, std::string, int, UserListItem*, bool) throw ();

public:
  struct user_not_found 
  { 
    std::string name;
    user_not_found (const std::string &n)
      : name (n)
    { }
  };

  enum
    {
      MODE_ADD = 0,
      MODE_REMOVE = 1
    };

  ChannelUserList (const std::string &) throw ();
  ~ChannelUserList () throw ();

  void add (std::string, std::string, int, UserList*, bool = false) throw ();
  void del (const std::string &) throw ();
  User get (const std::string &) const;
  void change_nickname (const std::string &, std::string);
  void change_user_mode (const std::string &, int, bool) throw ();
  void change_user_key (const std::string &, const std::string &) throw ();
  bool in_channel_p (const std::string &) const throw ();
  unsigned int user_count () const throw ();
  unsigned int operator_count () const throw ();

  template<typename T>
  void foreach (T & fun)
  {
    BotLock foreach_lock (users_mutex);
    std::for_each (users.begin (), users.end (), fun);
  }
};

#endif
