// DCCPerson.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifndef DCCPERSON_H
#define DCCPERSON_H

#include "Person.H"
#include "String.H"
#include "UserCommands.H"

class DCCConnection;

class DCCPerson : public Person {
  DCCConnection *dcc;
public:
  DCCPerson(DCCConnection *);
  DCCPerson(DCCPerson &);

  Person * copy();

  //  String getNick() const;
  //  String getAddress() const;

  void keepAlive();
  bool handleInput ();

  void sendNotice(String);

  friend class Bot;
  friend class DCCManager;
  friend void
  UserCommands::DCCList (ServerConnection *, Person *,
			 String, String);
};

#endif
