// Mask.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <string.h>

#include "Mask.H"

Mask::Mask(String s)
  : mask(s)
{ }

String
Mask::getMask() const
{
  return mask;
}

bool
Mask::matches(String s) const
{
  return match(mask.c_str (), s.c_str ());
}

bool
Mask::matches(const Mask & m) const
{
  return match(mask.c_str (), m.mask.c_str ());
}

bool
Mask::match(const char * m, const char * n) const
{
  if (!*m) {
    if (!*n)
      return true;
    else
      return false;
  } else
    if (!*n)
      return false;

  if (m[0] == '*') {
    while (*m && (m[0] == '*' || m[0] == '?'))
      m++;
    
    if (*m == '\0')
      return true;
    
    const char *c = n;
    while ((c = strchr(c, *m)) != 0) {
      if (match(m, c))
        return 1;
      c++;
    }
  }

  if ((std::tolower (m[0]) == std::tolower (n[0])) ||
      (m[0] == '?') ||
      ((m[0] == '\\') && ((m[1] == '?' && n[0] == '?') ||
                          (m[1] == '*' && n[0] == '*'))))
    return match(++m, ++n);

  return false;
}
