(* Copyright (C) 2014, Daniel Wyckoff, except for the portions so labeleled
which I got from Daniel Schepler*)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)



(*This file is copied and pasted from Daniel Schepler's "Zorn's Lemma" except for 
  a simple lemma labeled "Wyckoff" *)

Require Import Description.

(*Schepler*)
Lemma exclusive_dec: forall P Q:Prop, ~(P /\ Q) ->
  (P \/ Q) -> {P} + {Q}.
Proof.
intros.
assert ({x:bool | if x then P else Q}).
apply constructive_definite_description.
case H0.
exists true.
red; split.
assumption.
destruct x'.
reflexivity.
tauto.
exists false.
red; split.
assumption.
destruct x'.
tauto.
reflexivity.

destruct H1.
destruct x.
left.
assumption.
right.
assumption.
Qed.

(*Schepler*)
Lemma decidable_dec: forall P:Prop, P \/ ~P -> {P} + {~P}.
Proof.
intros.
apply exclusive_dec.
tauto.
assumption.
Qed.

Require Import Classical.

(*Schepler*)
Lemma classic_dec: forall P:Prop, {P} + {~P}.
Proof.
intro P.
apply decidable_dec.
apply classic.
Qed.

(* Wyckoff *)
Lemma or_to_sumbool : forall P Q:Prop, P \/ Q -> {P} + {Q}.
intros P Q h1.
case (classic_dec (P /\ Q)) as [h0l | h0r].
destruct h0l; left; assumption.
apply exclusive_dec; assumption.
Qed.


(*Wyckoff*)
Lemma eq_dec : forall {T:Type} (x y:T), {x = y} + {x <> y}.
intros T x y.
destruct (classic_dec (x = y)). left; auto. right; auto.
Qed.