(* Copyright (C) 2015 Daniel Wyckoff *)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)
  
Require Import BoolAlgBasics.
Require Import Homomorphisms.
Require Import Subalgebras.
Require Import SetUtilities.
Require Import TypeUtilities.
Require Import LogicUtilities.
Require Import Description.
Require Import FunctionalExtensionality.
Require Import FiniteMaps.
Require Import FiniteOperations.
Require Import ProofIrrelevance.
Require Import DecidableDec.

Section Extensions.
Variable T:Type.

Inductive extends_homo  
          {Ap Bp Cp:Bool_Alg_p T} 
          (f:btp Bp->btp Cp) (g:btp Ap->btp Cp) : Prop :=
  extends_homo_intro : 
    subalg_of_p Ap Bp ->
    homomorphism_p f -> homomorphism_p g ->
    extends_sig f g -> extends_homo f g.

Lemma refl_extends_homo : 
  forall {Ap Bp:Bool_Alg_p T} (f:btp Ap->btp Bp),
    homomorphism_p f ->
    extends_homo f f.
intros Ap Bp f h1.
constructor; auto.
apply refl_subalg_of_p.
apply refl_extends_sig.
Qed.

Inductive extends_homo_p1
          {Ap Bp:Bool_Alg_p T} {C:Bool_Alg}
          (f:btp Bp->bt C) (g:btp Ap->bt C) : Prop :=
  extends_homo_p1_intro :
    subalg_of_p Ap Bp ->
    homomorphism_p1 _ f -> homomorphism_p1 _ g ->
    extends_sig f g -> extends_homo_p1 f g.

Lemma refl_extends_homo_p1 : 
  forall {Ap:Bool_Alg_p T} {B:Bool_Alg} (f:btp Ap->bt B),
    homomorphism_p1 _ f ->
    extends_homo_p1 f f.
intros Ap Bp f h1.
constructor; auto.
apply refl_subalg_of_p.
apply refl_extends_sig.
Qed.

Lemma extends_homo_p1_iff : 
  forall {Ap Bp Cp:Bool_Alg_p T} 
         (f:btp Bp->btp Cp) (g:btp Ap->btp Cp),
    extends_homo f g <-> extends_homo_p1 (ba_conv_fun2 f) (ba_conv_fun2 g).
intros Ap Bp Cp f g.
split.
intro h1. destruct h1 as [h1 h2 h3 h4]. 
rewrite homomorphism_p_iff in h2, h3.
constructor; auto.
rewrite homomorphism_p1_iff.  assumption.
rewrite homomorphism_p1_iff. assumption.
intro h1. destruct h1 as [h1 h2 h3 h4].
rewrite homomorphism_p1_iff in h2, h3.
constructor; auto. rewrite homomorphism_p_iff. assumption.
rewrite homomorphism_p_iff. assumption.
Qed.



Definition extends_homo2 
          {Ap Ap' Bp Cp:Bool_Alg_p T} 
          (f:btp Bp->btp Cp) (g:btp Ap->btp Cp) (g':btp Ap'->btp Cp): Prop :=
  extends_homo f g /\ extends_homo f g'.

Definition extends_homo2_p1 
          {Ap Ap' Bp:Bool_Alg_p T} {C:Bool_Alg}
          (f:btp Bp->bt C) (g:btp Ap->bt C) (g':btp Ap'->bt C): Prop :=
  extends_homo_p1 f g /\ extends_homo_p1 f g'.


Definition extends_homo2_p1_iff :  
  forall {Ap Ap' Bp Cp:Bool_Alg_p T} 
         (f:btp Bp->btp Cp) (g:btp Ap->btp Cp) 
         (g':btp Ap'->btp Cp),
    extends_homo2 f g g' <-> extends_homo2_p1 (ba_conv_fun2 f)
                                              (ba_conv_fun2 g)
                                              (ba_conv_fun2 g').
intros Ap Ap' Bp Cp f g g'.
split.
intro h1. destruct h1 as [h1 h2]. 
rewrite extends_homo_p1_iff in h1.  rewrite extends_homo_p1_iff in h2. 
constructor; auto.
intro h1. destruct h1 as [h1 h2].
rewrite <- extends_homo_p1_iff in h1. rewrite <- extends_homo_p1_iff in h2.
constructor; auto.
Qed.              


Definition fam_fun_ba_one_range (Bp:Bool_Alg_p T) := 
  Ensemble {Ap:(Bool_Alg_p T) & (btp Ap)->(btp Bp)}.


Definition fam_fun_ba_one_range_p1 (B:Bool_Alg) := 
  Ensemble {Ap:(Bool_Alg_p T) & (btp Ap)->(bt B)}.


Definition ba_conv_fam_fun_ba_one_range 
           {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp) : 
  fam_fun_ba_one_range_p1 (ba_conv Bp) :=
  Im F (fun p=>existT (fun S=>btp S->bt (ba_conv Bp))  (projT1 p) (ba_conv_fun2 (projT2 p))).

Lemma in_ba_conv_fam_fun_ba_one_range_iff : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp)
         (pr:{A:Bool_Alg_p T & (btp A)->(btp Bp)}),
    In F pr <-> In (ba_conv_fam_fun_ba_one_range F) (existT (fun S=>btp S->bt (ba_conv Bp))  (projT1 pr) (ba_conv_fun2 (projT2 pr))).
intros Bp F pr. split.
intro h1.
apply Im_intro with pr; auto.
intro h2.
inversion h2 as [pr' h3 pr'' h4]. subst. clear h2.
destruct pr as [A f], pr' as [A' f'].
simpl in h4, h3.
inversion h4. subst. clear H1.
apply inj_pair2 in h4.
rewrite <- h4 in h3 at 1.
assumption.
Qed.


Definition fam_homo {Bp:Bool_Alg_p T}
           (F:fam_fun_ba_one_range Bp) : Prop :=
  forall f, In F f -> homomorphism_p (projT2 f).

Definition fam_homo_p1 {B:Bool_Alg}
           (F:fam_fun_ba_one_range_p1 B) : Prop :=
  forall f, In F f -> homomorphism_p1 _ (projT2 f).

Lemma fam_homo_p1_iff : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    fam_homo F <-> fam_homo_p1 (ba_conv_fam_fun_ba_one_range F).
intros Bp F. split.
intro h1. red in h1. red.
intros pr h2.
destruct h2 as [pr h2]. subst. simpl.
specialize (h1 pr h2).
rewrite homomorphism_p1_iff. rewrite homomorphism_p_iff in h1.
assumption.
intro h1. red in h1. red.
intros pr h2.
rewrite  in_ba_conv_fam_fun_ba_one_range_iff in h2.
specialize (h1 _ h2). simpl in h1.
rewrite homomorphism_p_iff. rewrite homomorphism_p1_iff in h1.
assumption.
Qed.



Definition common_extension_fam_homo 
           {Ap Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp) 
           (f:btp Ap->btp Bp) : Prop :=
  fam_homo F /\
  forall g, In F g -> extends_homo f (projT2 g).

Definition common_extension_fam_homo_p1 
           {Ap:Bool_Alg_p T} {B:Bool_Alg} 
           (F:fam_fun_ba_one_range_p1 B) (f:btp Ap->bt B) 
: Prop :=
  fam_homo_p1 F /\
  forall g, In F g -> extends_homo_p1 f (projT2 g).

Lemma common_extension_fam_homo_p1_iff : 
  forall {Ap Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp) 
         (f:btp Ap->btp Bp),
    common_extension_fam_homo F f <->
    common_extension_fam_homo_p1 (ba_conv_fam_fun_ba_one_range F) (ba_conv_fun2 f).
intros Ap Bp F f. split.
intro h1. red in h1. red.
destruct h1 as [h1 h2]. rewrite fam_homo_p1_iff in h1. split; auto.
intros g h3.
destruct g as [A' k].
inversion h3 as [pr h4 ? h5]. subst.
inversion h5. subst. clear H1.
rewrite h5 in h3. simpl.
destruct pr as [A' k']. simpl in h3, h4, h5.
apply inj_pair2 in h5. subst.
specialize (h2 _ h4).
rewrite <- extends_homo_p1_iff. simpl in h2.
assumption.
intro h1. red in h1. red.
destruct h1 as [h1 h2]. rewrite <- fam_homo_p1_iff in h1. split; auto.
intros g h3. destruct g as [A' k].
rewrite in_ba_conv_fam_fun_ba_one_range_iff in h3.
specialize (h2 _ h3).
simpl in h2, h3.
rewrite extends_homo_p1_iff.
assumption.
Qed.


Lemma common_extension_fam_homo_p1_homo_p1 : 
  forall (Bp:Bool_Alg_p T) (A:Bool_Alg) 
         (f:btp Bp->bt A) (fam:fam_fun_ba_one_range_p1 A),
    Inhabited fam ->
    common_extension_fam_homo_p1 fam f ->
    homomorphism_p1 _ f.
intros Bp A f fam h1 h2.
destruct h1 as [pr h1b].
red in h2. destruct h2 as [h2 h3].
specialize (h3 pr h1b).
destruct h3.
assumption.
Qed.


Definition directed_fam_homo 
           {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp) : Prop :=
  fam_homo F /\ forall f g, 
                  In F f -> In F g ->
                  exists k, In F k /\
                            extends_homo2 (projT2 k) (projT2 f)
                                          (projT2 g).

Definition directed_fam_homo_p1 
           {B:Bool_Alg} (F:fam_fun_ba_one_range_p1 B) : Prop :=
  fam_homo_p1 F /\ forall f g, 
                  In F f -> In F g ->
                  exists k, In F k /\
                            extends_homo2_p1 (projT2 k) (projT2 f)
                                          (projT2 g).

Lemma directed_fam_homo_p1_iff : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    directed_fam_homo F <->
    directed_fam_homo_p1 (ba_conv_fam_fun_ba_one_range F).
intros Bp F. split.
intro h1. red. red in h1. destruct h1 as [h1 h2].
rewrite fam_homo_p1_iff in h1. split; auto.
intros f g h3 h4. destruct f as [A' f], g as [A'' f'].
rewrite <- (in_ba_conv_fam_fun_ba_one_range_iff F (existT _ A' (ba_conv_fun1 f))) in h3.
rewrite <- (in_ba_conv_fam_fun_ba_one_range_iff F (existT _ A'' (ba_conv_fun1 f'))) in h4.
specialize (h2 _ _ h3 h4). simpl in h2.
destruct h2 as [k h2].
exists k. simpl. destruct h2 as [h2a h2b].
split; auto.
rewrite in_ba_conv_fam_fun_ba_one_range_iff in h2a. 
destruct k as [C k]. simpl in h2a. assumption.
rewrite extends_homo2_p1_iff in h2b.
assumption.
intro h2. red in h2. red.
destruct h2 as [h2 h3]. split.
rewrite fam_homo_p1_iff. assumption.
intros f g h4 h5.
rewrite in_ba_conv_fam_fun_ba_one_range_iff in h4, h5.
specialize (h3 _ _ h4 h5). simpl in h3.
destruct h3 as [k h3]. exists k. 
destruct h3 as [h3a h3b]. split.
rewrite in_ba_conv_fam_fun_ba_one_range_iff.
destruct k as [A k]. simpl. assumption.
rewrite extends_homo2_p1_iff. assumption.
Qed.



Definition inj_fam_homo
           {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp) : Prop :=
  fam_homo F /\
  forall f, In F f -> FunctionProperties.injective (projT2 f).

Definition inj_fam_homo_p1  
           {B:Bool_Alg} (F:fam_fun_ba_one_range_p1 B) : Prop :=
  fam_homo_p1 F /\
  forall f, In F f -> FunctionProperties.injective (projT2 f).

Lemma inj_fam_homo_p1_iff : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    inj_fam_homo F <-> inj_fam_homo_p1 (ba_conv_fam_fun_ba_one_range F).
intros Bp F. split.
intro h1. red. red in h1. destruct h1 as [h1 h2].
split. rewrite fam_homo_p1_iff in h1. assumption.
intros f h3.  destruct f as [A' f].
rewrite <- (in_ba_conv_fam_fun_ba_one_range_iff 
              F (existT _ _ (ba_conv_fun2  f))) in h3.
specialize (h2 _ h3). simpl in h2. simpl.
assumption.
intro h1. red in h1. red.
destruct h1 as [h1 h2]. split. rewrite fam_homo_p1_iff. assumption.
intros f h3. 
rewrite in_ba_conv_fam_fun_ba_one_range_iff in h3.
specialize (h2 _ h3). simpl in h2.
assumption.
Qed.


Definition fam_fun_ba_domains {Bp:Bool_Alg_p T} 
           (F:fam_fun_ba_one_range Bp) :=
  Im F (@projT1 _ _).

Definition fam_fun_ba_domains_p1 {B:Bool_Alg} 
           (F:fam_fun_ba_one_range_p1 B) :=
  Im F (@projT1 _ _).

Lemma fam_fun_ba_domains_p1_eq : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    fam_fun_ba_domains F = 
    fam_fun_ba_domains_p1 (ba_conv_fam_fun_ba_one_range F).
intros Bp F.
unfold fam_fun_ba_domains, fam_fun_ba_domains_p1, ba_conv_fam_fun_ba_one_range.
rewrite im_im. simpl.
reflexivity.
Qed.


Lemma directed_fam_homo_directed_domains : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    directed_fam_homo F ->
    directed (fam_fun_ba_domains F).
intros Bp F h1. red in h1.
destruct h1 as [h1 h2].
red.
intros Ap Ap' h3 h4.
destruct h3 as [fa h3]. destruct h4 as [fb h4]. subst.
specialize (h2 _ _ h3 h4).
destruct h2 as [k [h2a [h2b h2c]]].
destruct k as [Cp fc].
exists Cp.
split.
unfold fam_fun_ba_domains.
apply Im_intro with (existT (fun Ap : Bool_Alg_p T => btp Ap -> btp Bp) Cp fc). assumption. simpl.
reflexivity.
destruct h2b as [h5]. simpl in h5.
destruct h2c as [h6]. simpl in h6.
split; auto.
Qed.

Lemma directed_fam_homo_directed_domains_p1 : 
  forall {B:Bool_Alg} (F:fam_fun_ba_one_range_p1 B),
    directed_fam_homo_p1 F ->
    directed (fam_fun_ba_domains_p1 F).
intros B F h1. red in h1.
destruct h1 as [h1 h2].
red.
intros Ap Ap' h3 h4.
destruct h3 as [fa h3]. destruct h4 as [fb h4]. subst.
specialize (h2 _ _ h3 h4).
destruct h2 as [k [h2a [h2b h2c]]].
destruct k as [Cp fc].
exists Cp.
split.
unfold fam_fun_ba_domains_p1.
apply Im_intro with (existT (fun Ap : Bool_Alg_p T => btp Ap -> bt B) Cp fc). assumption. simpl.
reflexivity.
destruct h2b as [h5]. simpl in h5.
destruct h2c as [h6]. simpl in h6.
split; auto.
Qed.


Lemma directed_common_extension_p1 : 
  forall {B:Bool_Alg} (F:fam_fun_ba_one_range_p1 B),
    directed_fam_homo_p1 F ->
    Inhabited F ->
    exists (pfd: directed (fam_fun_ba_domains_p1 F))
           (pfi:Inhabited (fam_fun_ba_domains_p1 F)),
      let Ap:=directed_ba_p pfd pfi in 
      exists (f:btp Ap->bt B),
      common_extension_fam_homo_p1 F f /\
      (inj_fam_homo_p1 F -> FunctionProperties.injective f).
intros B F h1 h2.
pose proof (directed_fam_homo_directed_domains_p1 F h1) as h3.
exists h3.
assert (h4:Inhabited (fam_fun_ba_domains_p1 F)).
  destruct h2 as [f h4].
  apply Inhabited_intro with (projT1 f).
  unfold fam_fun_ba_domains_p1. apply Im_intro with f; auto.
exists h4.
intro Ap.
red in h1.
destruct h1 as [h1a h1b].
red in h1a.
assert (h5:forall x:btp Ap, exists! y:bt B,
             forall g,
               In F g ->
               forall (pf:In (ba_p_ens (projT1 g)) (proj1_sig x)),
                      (projT2 g) (exist _ _ pf) = y).
  intro x.
  destruct x as [x h5]. simpl in h5.
  destruct h5 as [A x h5 h6]. destruct h5 as [A h5]. subst.
  destruct h5 as [f h5]. subst. simpl.
  exists ((projT2 f) (exist _ _ h6)).
  red. split.
  intros g h7 h8.
  specialize (h1b _ _ h5 h7).
  destruct h1b as [k [h1c h1d]].
  red in h1d. destruct h1d as [h1d h1e].
  destruct h1d as [h9 h10 h11 h12], h1e as [h13 h14 h15 h16].
  red in h12. destruct h12 as [h12a h12b], h16 as [h16a h16b].
  specialize (h12b  (exist (In (ba_p_ens (projT1 f))) x h6)).
  specialize (h16b (exist (In (ba_p_ens (projT1 g))) x h8)).
  rewrite h12b, h16b.
  f_equal. apply proj1_sig_injective. simpl. reflexivity.
  intros x' h7.
  specialize (h7 _ h5 h6).
  assumption.
exists (fun x => (proj1_sig (constructive_definite_description _ (h5 x)))).
split.
red. split.
intros g h6. 
apply h1a; auto.
intros g h6.
constructor.
apply directed_ba_p_subalg.
unfold fam_fun_ba_domains_p1.
apply Im_intro with g; auto.
apply homo_two_ops_plus_p1.
intros x y.
destruct constructive_definite_description as [z h7].
simpl.
destruct constructive_definite_description as [a h8]. simpl.
destruct constructive_definite_description as [b h9]. simpl.
destruct x as [x h10], y as [y h11].
simpl in h7, h8, h9.
unfold Ap in h10, h11. simpl in h10, h11.
destruct h10 as [Xp x h10 h12], h11 as [Yp y h13 h14]. 
destruct h10 as [Xp h10], h13 as [Yp h13]. subst.
destruct h10 as [f h10], h13 as [f' h13]. subst.
specialize (h8 _ h10 h12). specialize (h9 _ h13 h14).
subst. simpl in h7.
specialize (h1b _ _ h10 h13).
destruct h1b as [f'' [h1b h1c]].
destruct h1c as [h15 h16]. 
destruct h15 as [h15a h15b h15c h15d], h16 as [h16a h16b h16c h16d].
red in h15d, h16d.
destruct h15d as [h15d h15e], h16d as [h16d h16e].
specialize (h15e (exist _ _ h12)). specialize (h16e (exist _ _ h14)).
rewrite h15e, h16e.
specialize (h7 _ h1b). simpl in h7.
pose proof (directed_plus_compat _ h3 
                                  (exist
              (fun x0 : T =>
               In (FamilyUnion (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T))))
                 x0) x
              (family_union_intro T
                 (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)))
                 (ba_p_ens (projT1 f)) x
                 (Im_intro (Bool_Alg_p T) (Ensemble T) 
                    (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)) 
                    (projT1 f)
                    (Im_intro {Ap0 : Bool_Alg_p T & btp Ap0 -> bt B}
                       (Bool_Alg_p T) F
                       (projT1
                          (P:=fun Ap0 : Bool_Alg_p T => btp Ap0 -> bt B)) f
                       h10 (projT1 f) eq_refl) (ba_p_ens (projT1 f)) eq_refl)
                 h12))
           (exist
              (fun x0 : T =>
               In (FamilyUnion (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T))))
                 x0) y
              (family_union_intro T
                 (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)))
                 (ba_p_ens (projT1 f')) y
                 (Im_intro (Bool_Alg_p T) (Ensemble T) 
                    (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)) 
                    (projT1 f')
                    (Im_intro {Ap0 : Bool_Alg_p T & btp Ap0 -> bt B}
                       (Bool_Alg_p T) F
                       (projT1
                          (P:=fun Ap0 : Bool_Alg_p T => btp Ap0 -> bt B))
                       f' h13 (projT1 f') eq_refl) 
                    (ba_p_ens (projT1 f')) eq_refl) h14))) as h15.
simpl in h15.
specialize (h15 _ _ h12 h14). 
assert (h16: In (fam_fun_ba_domains_p1 F) (projT1 f)).
  unfold fam_fun_ba_domains_p1. apply Im_intro with f; auto.
assert (h17:In (fam_fun_ba_domains_p1 F) (projT1 f')).
  apply Im_intro with f'; auto.
specialize (h15 h16 h17). 
destruct h15 as [Cp [h18 [h19 [h20 [h21 [h22 [h23 [h24 [h25 h27]]]]]]]]].
assert (h29: (proj1_sig
             (exist (In (ba_p_ens (projT1 f''))) x (h15d x h12)
              %+ exist (In (ba_p_ens (projT1 f''))) y (h16d y h14))) = 
             (proj1_sig
        (exist (In (ba_p_ens Cp)) x (h18 x h12)
         %+ exist (In (ba_p_ens Cp)) y (h19 y h14)))).
  assert (h30:In (fam_fun_ba_domains_p1 F) (projT1 f'')).
    apply Im_intro with f''; auto.
  pose proof (h3 _ _   h30 h25) as h31.
  destruct h31 as [Dp [h31 [h32 h33]]].
  red in h32, h33. destruct h32 as [h32a [h32b h32c]], h33 as [h33a [h33b h33c]].
  pose proof (ba_p_subst_plus _ _ h32c _ _ (h15d x h12) (h16d y h14)) as h34.
  assert (h35:In
                (ba_p_ens (Subalg_p Dp (ba_p_ens (projT1 f'')) h32a h32b))
                x).
    rewrite <- h32c. apply (h15d x h12).
  assert (h36 : In
                    (ba_p_ens (Subalg_p Dp (ba_p_ens (projT1 f'')) h32a h32b))
                    y).
    rewrite <- h32c. apply (h16d y h14). 
  specialize (h34 h35 h36).
  pose proof (ba_p_subst_plus _ _ h33c _ _ (h18 x h12) (h19 y h14)) as h37.
  assert (h38: In (ba_p_ens (Subalg_p Dp (ba_p_ens Cp) h33a h33b)) x).
    rewrite <- h33c. apply (h18 x h12).
  assert (h39 : In (ba_p_ens (Subalg_p Dp (ba_p_ens Cp) h33a h33b)) y).
    rewrite <- h33c. apply (h19 y h14).
  specialize (h37 h38 h39).
  rewrite h34, h37.
  simpl.
  f_equal. f_equal. apply proj1_sig_injective. simpl. reflexivity.
  apply proj1_sig_injective. simpl. reflexivity.
assert (h0: In (ba_p_ens (projT1 f''))
                (proj1_sig
                   (directed_plus T h3
                      (exist
                         (fun x0 : T =>
                          In
                            (FamilyUnion
                               (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T))))
                            x0) x
                         (family_union_intro T
                            (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)))
                            (ba_p_ens (projT1 f)) x
                            (Im_intro (Bool_Alg_p T) 
                               (Ensemble T) (fam_fun_ba_domains_p1 F)
                               (ba_p_ens (T:=T)) (projT1 f)
                               (Im_intro
                                  {Ap0 : Bool_Alg_p T & btp Ap0 -> bt B}
                                  (Bool_Alg_p T) F
                                  (projT1
                                     (P:=fun Ap0 : Bool_Alg_p T =>
                                         btp Ap0 -> bt B)) f h10 
                                  (projT1 f) eq_refl) 
                               (ba_p_ens (projT1 f)) eq_refl) h12))
                      (exist
                         (fun x0 : T =>
                          In
                            (FamilyUnion
                               (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T))))
                            x0) y
                         (family_union_intro T
                            (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)))
                            (ba_p_ens (projT1 f')) y
                            (Im_intro (Bool_Alg_p T) 
                               (Ensemble T) (fam_fun_ba_domains_p1 F)
                               (ba_p_ens (T:=T)) (projT1 f')
                               (Im_intro
                                  {Ap0 : Bool_Alg_p T & btp Ap0 -> bt B}
                                  (Bool_Alg_p T) F
                                  (projT1
                                     (P:=fun Ap0 : Bool_Alg_p T =>
                                         btp Ap0 -> bt B)) f' h13
                                  (projT1 f') eq_refl) 
                               (ba_p_ens (projT1 f')) eq_refl) h14))))). 
rewrite h27 at 1.
pose (exist _ _ (h15d _ h12) %+ exist _ _ (h16d _ h14)) as z'.
pose proof (in_ba_p_ens_plus  _ (projT1 f'') _ _ (h15d x h12) (h16d y h14)) as h28.
  rewrite h29 in h28.
  assumption. 
specialize (h7 h0).
rewrite <- h7.
rewrite <- homo_plus_p1.
f_equal.
apply proj1_sig_injective. simpl.
rewrite h27.
rewrite h29 at 1.
reflexivity.
assumption.
intro x.   
destruct constructive_definite_description as [a h7].
destruct constructive_definite_description as [b h8]. simpl.
destruct x as [x h9]. simpl in h7, h8. 
unfold Ap in h9.
destruct h9 as [X x h9 h10].
destruct h9 as [Xp h9]. subst.
destruct h9 as [f h9]. subst.
specialize (h8 _ h9 h10). rewrite <- h8 at 1.
pose proof (directed_comp_compat _ h3  (exist
                         (fun x0 : T =>
                          In
                            (FamilyUnion
                               (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T))))
                            x0) x
                         (family_union_intro T
                            (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)))
                            (ba_p_ens (projT1 f)) x
                            (Im_intro (Bool_Alg_p T) 
                               (Ensemble T) (fam_fun_ba_domains_p1 F)
                               (ba_p_ens (T:=T)) (projT1 f)
                               (Im_intro
                                  {Ap0 : Bool_Alg_p T & btp Ap0 -> bt B}
                                  (Bool_Alg_p T) F
                                  (projT1
                                     (P:=fun Ap0 : Bool_Alg_p T =>
                                         btp Ap0 -> bt B)) f h9 
                                  (projT1 f) eq_refl) 
                               (ba_p_ens (projT1 f)) eq_refl) h10))) as h11.
simpl in h11.
specialize (h11 _ h10).
assert (h12:In (fam_fun_ba_domains_p1 F) (projT1 f)).
  unfold fam_fun_ba_domains_p1. apply Im_intro with f; auto.
specialize (h11 h12).
destruct h11 as [Cp [h18 [h19 [h20 h21]]]].
specialize (h7 _ h9).
assert (h22:In (ba_p_ens (projT1 f))
                (proj1_sig
                   (directed_comp T h3
                      (exist
                         (fun x0 : T =>
                          In
                            (FamilyUnion
                               (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T))))
                            x0) x
                         (family_union_intro T
                            (Im (fam_fun_ba_domains_p1 F) (ba_p_ens (T:=T)))
                            (ba_p_ens (projT1 f)) x
                            (Im_intro (Bool_Alg_p T) 
                               (Ensemble T) (fam_fun_ba_domains_p1 F)
                               (ba_p_ens (T:=T)) (projT1 f)
                               (Im_intro
                                  {Ap0 : Bool_Alg_p T & btp Ap0 -> bt B}
                                  (Bool_Alg_p T) F
                                  (projT1
                                     (P:=fun Ap0 : Bool_Alg_p T =>
                                         btp Ap0 -> bt B)) f h9 
                                  (projT1 f) eq_refl) 
                               (ba_p_ens (projT1 f)) eq_refl) h10))))).
  rewrite h21.
  apply in_ba_p_ens_comp.
specialize (h7 h22).
rewrite <- h7 at 1.
rewrite <- homo_comp_p1.
f_equal.
apply proj1_sig_injective.
simpl. rewrite h21.
reflexivity.
apply h1a; auto. apply h1a; auto.
red.
assert (h7: Included (A_p T (Bc_p T (projT1 g))) (A_p T (Bc_p T Ap))).
  red. intros x h7.
  simpl.
  apply family_union_intro with (ba_p_ens (projT1 g)).
  apply Im_intro with (projT1 g).
  unfold fam_fun_ba_domains. apply Im_intro with g; auto.
  reflexivity. assumption.
exists h7.
intro x.
destruct constructive_definite_description as [a h8].
simpl.
specialize (h8 _ h6). simpl in h8.
specialize (h8 (proj2_sig _)). rewrite <- h8.
f_equal.
apply proj1_sig_injective. simpl.
reflexivity.
intro h6. red.
intros x y.
destruct constructive_definite_description as [a h7].
destruct constructive_definite_description as [b h8].
simpl.
intro h9. subst.
destruct x as [x h9], y as [y h10].
simpl in h9, h10.
destruct h9 as [X x h9 h11], h10 as [Y y h10 h12].
destruct h9 as [X h9], h10 as [Y h10]. subst.
destruct h9 as [f h9], h10 as [g h10]. subst.
specialize (h7 _ h9). specialize (h8 _ h10).
simpl in h7, h8.
specialize (h7 h11). specialize (h8 h12). 
apply proj1_sig_injective. simpl. subst.
red in h6.
destruct h6 as [h6a h6b].
specialize (h1b _ _ h9 h10).
destruct h1b as [k [h1b h1c]].
red in h1c. destruct h1c as [h1c h1d].
destruct h1c as [h1ca h1cb h1cc h1cd]. destruct h1d as [h1da h1db h1dc h1dd].
red in h1cd, h1dd.
destruct h1cd as [h13 h14], h1dd as [h15 h16].
specialize (h14 (exist (In (ba_p_ens (projT1 f))) x h11)).
specialize (h16 (exist (In (ba_p_ens (projT1 g))) y h12)).
rewrite h14, h16 in h7.
simpl in h7.
specialize (h6b _ h1b). red in h6b.
apply h6b in h7.
pose proof (f_equal (@proj1_sig _ _) h7) as h17.
simpl in h17.
assumption.
Qed.



Lemma directed_common_extension : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    directed_fam_homo F ->
    Inhabited F ->
    exists (pfd: directed (fam_fun_ba_domains (ba_conv_fam_fun_ba_one_range F)))
           (pfi:Inhabited (fam_fun_ba_domains (ba_conv_fam_fun_ba_one_range F))),
      let Ap := directed_ba_p pfd pfi in
      exists (f:btp Ap->btp Bp),
        common_extension_fam_homo F f /\
        (inj_fam_homo F -> FunctionProperties.injective f).
intros Bp F h1 h2.
rewrite directed_fam_homo_p1_iff in h1.
assert (h3:Inhabited (ba_conv_fam_fun_ba_one_range F)).
  destruct h2 as [x h2].
  eapply Inhabited_intro. rewrite in_ba_conv_fam_fun_ba_one_range_iff in h2.
  apply h2.
pose proof (directed_common_extension_p1 _ h1 h3) as h4. 
simpl in h4.
destruct h4 as [h4 [h5 [f [h6 h7]]]].
exists h4, h5.
simpl.
exists f. 
rewrite common_extension_fam_homo_p1_iff.
split. assumption.
intro h8.
rewrite inj_fam_homo_p1_iff in h8.
apply h7; auto.
Qed.



Definition chain_fam_homo
           {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp) : Prop :=
  fam_homo F /\ forall f g,
                  In F f -> In F g ->
                  extends_homo (projT2 f) (projT2 g) \/ 
                  extends_homo (projT2 g) (projT2 f).

Definition chain_fam_homo_p1
           {B:Bool_Alg} (F:fam_fun_ba_one_range_p1 B) : Prop :=
  fam_homo_p1 F /\ forall f g,
                  In F f -> In F g ->
                  extends_homo_p1 (projT2 f) (projT2 g) \/ 
                  extends_homo_p1 (projT2 g) (projT2 f).

Lemma chain_fam_homo_p1_iff : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    chain_fam_homo F <->
    chain_fam_homo_p1 (ba_conv_fam_fun_ba_one_range F).
intros Bp F. split.
intro h1. red in h1. red. destruct h1 as [h1 h2].
rewrite fam_homo_p1_iff in h1. split; auto.
intros f g h3 h4. destruct f as [A' f], g as [B' g]. simpl.
rewrite <- (in_ba_conv_fam_fun_ba_one_range_iff 
              F (existT _ _ (ba_conv_fun2 f))) in h3.
rewrite <- (in_ba_conv_fam_fun_ba_one_range_iff 
              F (existT _ _ (ba_conv_fun2 g))) in h4.
specialize (h2 _ _ h3 h4). simpl in h2.
do 2 rewrite extends_homo_p1_iff in h2. assumption.
intro h1. red in h1. red. destruct h1 as [h1 h2].
split.
rewrite fam_homo_p1_iff. assumption.
intros f g h3 h4.
rewrite in_ba_conv_fam_fun_ba_one_range_iff in h3, h4.
specialize (h2 _ _ h3 h4). simpl in h2.
do 2 rewrite extends_homo_p1_iff.
assumption.
Qed.

Lemma chain_fam_homo_impl_directed_fam_homo_p1 : 
  forall {B:Bool_Alg} (F:fam_fun_ba_one_range_p1 B),
    chain_fam_homo_p1 F -> directed_fam_homo_p1 F.
intros B F h1.
red. red in h1.
destruct h1 as [h1a h1b].
split; auto.
intros f g h2 h3.
specialize (h1b _ _ h2 h3).
destruct h1b as [h4 | h5].
exists f. split; auto.
red. split; auto.
apply refl_extends_homo_p1.
destruct h4; auto.
exists g. 
split; auto.
red. split; auto.
apply refl_extends_homo_p1.
destruct h5; auto.
Qed.


Lemma chain_fam_homo_impl_directed_fam_homo : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    chain_fam_homo F -> directed_fam_homo F.
intros Bp F h1.
rewrite chain_fam_homo_p1_iff in h1. 
rewrite directed_fam_homo_p1_iff.
apply chain_fam_homo_impl_directed_fam_homo_p1; auto.
Qed.



Lemma chain_common_extension : 
  forall {Bp:Bool_Alg_p T} (F:fam_fun_ba_one_range Bp),
    chain_fam_homo F ->
    Inhabited F ->
    exists (pfd: directed (fam_fun_ba_domains (ba_conv_fam_fun_ba_one_range F)))
           (pfi:Inhabited (fam_fun_ba_domains (ba_conv_fam_fun_ba_one_range F))),
      let Ap := directed_ba_p pfd pfi in
      exists (f:btp Ap->btp Bp),
        common_extension_fam_homo F f /\
        (inj_fam_homo F -> FunctionProperties.injective f).
intros Bp F h1 h2.
pose proof (chain_fam_homo_impl_directed_fam_homo F h1) as h3.
apply directed_common_extension; auto.
Qed.


Lemma chain_common_extension_p1 : 
  forall {B:Bool_Alg} (F:fam_fun_ba_one_range_p1 B),
    chain_fam_homo_p1 F ->
    Inhabited F ->
    exists  (pfd: directed (fam_fun_ba_domains_p1 F))
            (pfi:Inhabited (fam_fun_ba_domains_p1 F)),
      let Ap:=directed_ba_p pfd pfi in
      exists (f:btp Ap->bt B),
        common_extension_fam_homo_p1 F f /\
        (inj_fam_homo_p1 F -> FunctionProperties.injective f).
intros Bp F h1 h2.
pose proof (chain_fam_homo_impl_directed_fam_homo_p1 F h1) as h3.
apply directed_common_extension_p1; auto.
Qed.



Lemma gen_ens_determines_homo :
  forall {A B:Bool_Alg} (f g:bt B -> bt A),
    homomorphism f -> homomorphism g ->
    forall E:Ensemble (bt B),
      ba_ens B = Gen_Ens E ->
    agree_on f g E ->
    f = g.   
intros A B f g h1 h2 E h3 h4.
destruct (classic (E = (Empty_set _))) as [h5 | h6].
subst.
rewrite gen_ens_empty in h3.
unfold ba_ens in h3.
apply functional_extensionality.
intros x.
pose proof (Full_intro _ x) as h5.
unfold  bt in h5. unfold bt in h3.
rewrite h3 in h5.
destruct h5.
rewrite (homo_zero f); auto. rewrite (homo_zero g); auto.
rewrite (homo_one f); auto. rewrite (homo_one g); auto.
apply not_empty_Inhabited in h6.
pose [x:bt B | f x = g x] as C.
assert (h5:Included E C).
  red.
  intros x h7.
  red in h4. specialize (h4 _ h7).
  constructor. assumption.
assert (h7:alg_closed C).
  apply two_ops_times_closed.
  destruct h6 as [x h6]. apply Inhabited_intro with x. apply h5; auto.
  red.
  intros x.
  destruct x as [x h7].
  destruct h7 as [h7].
  unfold Bcomp_sub. simpl.
  constructor.
  rewrite (homo_comp f); auto. rewrite (homo_comp g); auto.
  f_equal. assumption.
  red. intros x y.
  destruct x as [x h7], y as [y h8].
  destruct h7 as [h7], h8 as [h8].
  unfold Btimes_sub. simpl.
  constructor.
  rewrite (homo_times f); auto. rewrite (homo_times g); auto.
  rewrite h7, h8.
  reflexivity.
apply gen_ens_closed_eq in h7.
apply gen_ens_preserves_inclusion in h5.
rewrite h7 in h5. rewrite <- h3 in h5.
assert (h8:C = ba_ens B).
  apply Extensionality_Ensembles.
  red. split. red. intros. constructor.
  assumption.
unfold C in h8.
apply functional_extensionality.
intro x.
pose proof (Full_intro _ x) as h9.
unfold ba_ens in h8. unfold bt in h9. unfold bt in h8.
rewrite <- h8 in h9.
destruct h9.
assumption.
Qed.


Lemma gen_ens_determines_homo_p1 :
  forall {Bp:Bool_Alg_p T} {A:Bool_Alg} (f g:btp Bp -> bt A),
    homomorphism_p1 _ f -> homomorphism_p1 _ g ->
    forall (E:Ensemble T) (pf:Included E (ba_p_ens Bp)),
      ba_p_ens Bp = Gen_Ens_p E pf ->
      agree_on f g (im_proj2_sig E pf) ->
      f = g.   
intros Bp A f g h1 h2 E h3 h4 h5.
rewrite homomorphism_p1_iff in h1.
rewrite homomorphism_p1_iff in h2.
rewrite ba_p_ens_eq, gen_ens_p_eq in h4.
apply im_proj1_sig_injective in h4.
pose proof (gen_ens_determines_homo (ba_conv_fun1 f) (ba_conv_fun1 g) h1 h2 _ h4 h5) as h6.
assumption.
Qed.


End Extensions.

Section HomoExtensionCriterion.


Lemma finite_homo_extension_criterion_if : 
  forall {A B:Bool_Alg} {E:Ensemble (bt B)},
    Finite E ->
    ba_ens B = Gen_Ens E ->
    forall (g:sig_set E->bt A),
 (forall F:Ensemble (bt B), 
         Finite F -> Included F E ->
         forall a:Fin_map F signe mns,
           el_prod _ a = 0 -> 
           el_prod_compose _ (sig_fun_app g 0) a = 0) ->
      exists! h:(bt B)->(bt A), homomorphism h /\ extends_sig1 h g.
intros A B E h3 h1 g h2.
pose proof (normal_form_gen_ba _ _ h3 h1) as h4.
destruct h4 as [h4l h4r].
pose proof (normal_form_gen_im _ _ h3 g) as h5. simpl in h5.
destruct h5 as [h5l h5r].
pose proof (gen_e_eq_c_unq _ _ h3) as h6. simpl in h6.
rewrite <- h1 in h6.
assert (h7:forall b:(bt B),
             exists! S : Ensemble (Fin_map E signe mns),
               exists (pf:Included S (non_zero_el_prod_maps B E)),
                 plus_subset_non_zero_el_prod_maps B E h3 _ pf = b).
  intro b. 
  assert (h7:In (ba_ens B) b). constructor.
  rewrite h6 in h7. destruct h7 as [h7]. 
  destruct h7 as [S h7].  exists (non_zero_el_prod_maps_of_set B h3 S).
  red in h7. destruct h7 as [h7 h8].
  red. destruct h7 as [h7 h9]. split.
  exists (incl_non_zero_el_prod_maps_of_set _ h3 S).
  rewrite <- h9.
  pose proof (plus_subset_el_prod_maps_eq_same_non_zero B h3 
                                                        S) as h10.  unfold plus_subset_non_zero_el_prod_maps. 
  assert (h11: finite_image (Fin_map E signe mns) (Btype (Bc B)) S 
             (el_prod B) (finite_fin_map_ens S h3 signe_finite) = 
               finite_image (Fin_map E signe mns) (Btype (Bc B)) S 
                            (el_prod B)
                            (Finite_downward_closed (Fin_map E signe mns)
                                                    (non_zero_el_prod_maps B E) (non_zero_el_prod_maps_fin B E h3) S
                                                    h7)).
  apply proof_irrelevance.
  rewrite h11 in h10 at 1.
  rewrite h10 at 1.
  apply plus_set_functional. reflexivity.
  intros S' h10. destruct h10 as [h10 h11].
  rewrite <- h9 in h11.
  apply plus_subset_non_zero_el_prod_maps_inj in h11. subst.
  apply Extensionality_Ensembles.
  red. split.
  red. intros f h11. destruct h11. assumption.
  red. intros f h11. specialize (h10 _ h11).
  destruct h10 as [h10]. constructor; auto.
pose (fun b:bt B => (proj1_sig (constructive_definite_description _ (h7 b)))) as fa. 
assert (h8:forall b:(bt B), Finite (fa b)).
  intro b. unfold fa. destruct constructive_definite_description as [S h9]. simpl.
  destruct h9 as [h9 h10].
  unfold plus_subset_non_zero_el_prod_maps in h10.
  apply (Finite_downward_closed (Fin_map E signe mns)
                (non_zero_el_prod_maps B E)
                (non_zero_el_prod_maps_fin B E h3) S h9). 
pose (fun b:(bt B) => plus_subset_non_zero_el_prod_compose_maps _ _ h3 (sig_fun_app g 0) (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) (fa b)) (incl_non_zero_el_prod_compose_maps_of_set _ _ _ _ )) as f'. 
assert (h9:forall b:(bt B), In (Gen_Ens (Im (full_sig E) g)) (f' b)).
  intro b. 
  unfold f'. 
  assert (h10:Im E (sig_fun_app g 0) = Im (full_sig E) g).
    apply Extensionality_Ensembles.
    red. split.
    red. intros x h10. destruct h10 as [x h10]. subst.
    unfold sig_fun_app. destruct (DecidableDec.classic_dec (In E x)) as [h11 | h12].
    apply Im_intro with (exist _ _ h11). constructor.
    reflexivity. contradiction.
    red. intros x h10. destruct h10 as [x h10]. subst.
    clear h10. destruct x as [x h10]. apply Im_intro with x; auto.
    unfold sig_fun_app. destruct (DecidableDec.classic_dec (In E x)) as [h11 | h12].
    f_equal. apply proj1_sig_injective. reflexivity.
    contradiction.  
  rewrite <- h10.  
  apply in_gen_ens_im_g_plus_subset_el_prod_compose_maps.

assert (hhom:homomorphism f').
  pose (fun (b:bt B) => exist _ _ (h9 b)) as f.  
  assert (h10:homomorphism (B:=Gen (Im (full_sig E) g)) f).
    apply homo_two_ops_plus.
    intros r s.
    unfold f.
    apply proj1_sig_injective. simpl.
    unfold Bplus_sub. simpl.
    unfold f'.
    unfold fa.
    destruct constructive_definite_description as [XY h10].
    destruct constructive_definite_description as [X h11].
    destruct constructive_definite_description as [Y h12].
    simpl.
    destruct h10 as [h10a h10b], h11 as [h11a h11b], h12 as [h12a h12b].
    subst.
    rewrite plus_subset_non_zero_el_prod_maps_union in h10b.
    apply plus_subset_non_zero_el_prod_maps_inj in h10b. subst.
    rewrite <- plus_subset_non_zero_el_prod_compose_maps_union.
    unfold plus_subset_non_zero_el_prod_compose_maps.
    pose proof (plus_subset_el_prod_compose_maps_eq_same_non_zero _ h3 (sig_fun_app g 0) (Union X Y)) as h11.
    assert (h12:(finite_image (Fin_map E signe mns) (Btype (Bc A))
                              (non_zero_el_prod_compose_maps_of_set A h3 
                                                                    (sig_fun_app g 0) (Union X Y))
                              (el_prod_compose A (sig_fun_app g 0))
                              (finite_non_zero_el_prod_compose_maps_of_set A h3
                                                                           (sig_fun_app g 0) (Union X Y))) = 
                (finite_image (Fin_map E signe mns) (Btype (Bc A))
                              (non_zero_el_prod_compose_maps_of_set A h3 
                                                                    (sig_fun_app g 0) (Union X Y))
                              (el_prod_compose A (sig_fun_app g 0))
                              (finite_fin_map_ens
                                 (non_zero_el_prod_compose_maps_of_set A h3 
                                                                       (sig_fun_app g 0) (Union X Y)) h3 signe_finite))).
    apply proof_irrelevance.
    rewrite <- h12 at 1.
    rewrite <- h11 at 1.
    pose proof (im_union X Y (el_prod_compose A (sig_fun_app g 0))) as h13.
    assert (h14:Finite  (Union (Im X (el_prod_compose A (sig_fun_app g 0)))
                               (Im Y (el_prod_compose A (sig_fun_app g 0))))).
    rewrite <- h13. apply finite_image. 
    apply  finite_fin_map_ens. assumption. apply signe_finite. 
    pose proof (subsetT_eq_compat _ _ _ _  (finite_image (Fin_map E signe mns) (Btype (Bc A)) 
                                                         (Union X Y) (el_prod_compose A (sig_fun_app g 0))
                                                         (finite_fin_map_ens (Union X Y) h3 signe_finite)) h14 h13) as h15.
    dependent rewrite -> h15.
    pose proof (finite_image _ _ _ (el_prod_compose A (sig_fun_app g 0)) (finite_fin_map_ens X h3 signe_finite)) as h16.
    pose proof (finite_image _ _ _ (el_prod_compose A (sig_fun_app g 0)) (finite_fin_map_ens Y h3 signe_finite)) as h17. 
    rewrite (plus_set_union' _ _  h16 h17 h14) at 1.
    pose proof (im_union (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                         (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y)
                         (el_prod_compose A (sig_fun_app g 0))) as h18.
    assert (h19:Finite  (Union
                           (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                               (el_prod_compose A (sig_fun_app g 0)))
                           (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y)
                               (el_prod_compose A (sig_fun_app g 0))))).
    rewrite <- h18. apply finite_image. apply finite_fin_map_ens; auto. apply signe_finite.
    pose proof (subsetT_eq_compat _ _ _ _ (finite_image (Fin_map E signe mns) (Btype (Bc A))
                                                        (Union
                                                           (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                                                           (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y))
                                                        (el_prod_compose A (sig_fun_app g 0))
                                                        (finite_fin_map_ens
                                                           (Union
                                                              (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                                                              (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y))
                                                           h3 signe_finite)) h19 h18) as h20.
    dependent rewrite -> h20. 
    assert (h21:Finite  (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                            (el_prod_compose A (sig_fun_app g 0)))).
    apply finite_image.  apply finite_non_zero_el_prod_compose_maps_of_set.
    assert (h22:Finite (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y)
                           (el_prod_compose A (sig_fun_app g 0)))).
    apply finite_image.  apply finite_non_zero_el_prod_compose_maps_of_set.
    rewrite (plus_set_union' _ _ h21 h22).
    f_equal.
    pose proof (plus_subset_el_prod_compose_maps_eq_same_non_zero _ h3 (sig_fun_app g 0) X) as h23.
    assert (h24:plus_set
                  (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                      (el_prod_compose A (sig_fun_app g 0)))
                  (finite_image (Fin_map E signe mns) (Btype (Bc A))
                                (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                                (el_prod_compose A (sig_fun_app g 0))
                                (finite_non_zero_el_prod_compose_maps_of_set A h3
                                                                             (sig_fun_app g 0) X)) =  plus_set
                                                                                                        (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) X)
                                                                                                            (el_prod_compose A (sig_fun_app g 0))) h21).
    apply plus_set_functional; auto.
    rewrite h24 in h23.
    rewrite <- h23.
    apply plus_set_functional. reflexivity.
    pose proof (plus_subset_el_prod_compose_maps_eq_same_non_zero _ h3 (sig_fun_app g 0) Y) as h23.
    assert (h24:plus_set
                  (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y)
                      (el_prod_compose A (sig_fun_app g 0)))
                  (finite_image (Fin_map E signe mns) (Btype (Bc A))
                                (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y)
                                (el_prod_compose A (sig_fun_app g 0))
                                (finite_non_zero_el_prod_compose_maps_of_set A h3
                                                                             (sig_fun_app g 0) Y)) =  plus_set
                                                                                                        (Im (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0) Y)
                                                                                                            (el_prod_compose A (sig_fun_app g 0))) h22).
    apply plus_set_functional; auto.
    rewrite h24 in h23.
    rewrite <- h23.
    apply plus_set_functional. reflexivity.
    unfold f. intro r. apply proj1_sig_injective. simpl.
    unfold Bcomp_sub. simpl.
    unfold f', fa.
    destruct constructive_definite_description as [X' h10].
    destruct constructive_definite_description as [X h11].
    simpl.
    destruct h10 as [h10a h10b], h11 as [h11a h11b]. subst.
    pose proof (plus_subset_non_zero_el_prod_maps_comp B E h3 _ h11a) as h12.
    rewrite h12 in h10b. clear h12.
    apply plus_subset_non_zero_el_prod_maps_inj in h10b. subst.
    rewrite <- plus_subset_non_zero_el_prod_compose_maps_comp.
    apply plus_set_functional.
    f_equal. 
    apply Extensionality_Ensembles.
    red. split.
    red. intros k h12. destruct h12 as [k h12 h13].
    destruct h12 as [h12 h14]. destruct h12 as [h12].
    destruct h13 as [h13].
    constructor. constructor. assumption. 
    intro h15. destruct h15 as [k h15 h16]. contradiction.
    red.
    intros k h12. destruct h12 as [h12 h13]. destruct h12 as [h12].
    pose proof (contrapos _ _ (h2 _ h3 (inclusion_reflexive _) k)) as h17.
    pose proof (h17 h12) as h17'.
    constructor. constructor. constructor. assumption.
    contradict h13. constructor. assumption. 
    constructor. assumption. constructor. assumption.   
unfold f in h10.
destruct h10 as [h10a h10b h10c]. 
constructor. 
intros x y. pose proof (h10a x y) as h11.
pose proof (f_equal (@proj1_sig _ _) h11) as h12. simpl in h12.
rewrite h12. unfold Btimes_sub. simpl. reflexivity.
intros x y. pose proof (h10b x y) as h11.
pose proof (f_equal (@proj1_sig _ _) h11) as h12. simpl in h12.
rewrite h12. unfold Bplus_sub. simpl. reflexivity.
intro x. pose proof (h10c x) as h11.
pose proof (f_equal (@proj1_sig _ _) h11) as h12. simpl in h12.
rewrite h12. unfold Bcomp_sub. simpl. reflexivity.
assert (hex:extends_sig1 f' g).


red.
intro x. destruct x as [x h9']. simpl.
unfold f'. 
pose proof (elt_eq_plus_subset_non_zero_el_prod_maps_at_one _ _ h3 _ h9') as h10'. simpl in h10'.
destruct h10' as [h10' h11']. 
pose proof (elt_eq_plus_subset_non_zero_el_prod_compose_maps_at_one _ _  h3 (sig_fun_app g 0) _ h9') as h12'.
destruct h12' as [h12 h13]. 
unfold fa. destruct constructive_definite_description as [S h15].
simpl. 
destruct h15 as [h15 h16].
rewrite h11' in h16.
apply plus_subset_non_zero_el_prod_maps_inj in h16. rewrite h16.
clear h15. clear h16.  
assert (heq:sig_fun_app g 0 x = g (exist _ _ h9')).
  unfold sig_fun_app. destruct DecidableDec.classic_dec as [h14 | h15]. f_equal. apply proj1_sig_injective. reflexivity. contradiction.
rewrite <- heq at 1.
rewrite h13.
assert (h14: [a : Fin_map E signe mns
     | In (non_zero_el_prod_compose_maps A (sig_fun_app g 0) E) a /\
       a |-> x = pls]  = 
              (non_zero_el_prod_compose_maps_of_set A h3 (sig_fun_app g 0)
        [a : Fin_map E signe mns
        | In (non_zero_el_prod_maps B E) a /\ a |-> x = pls])).
  apply Extensionality_Ensembles.
  red. split.
  red. intros k h14. destruct h14 as [h14]. destruct h14 as [h14 h15].
  destruct h14 as [h14]. constructor. constructor. split; auto.
  pose proof (h2 _ h3 (inclusion_reflexive _) k) as h16.
  apply contrapos in h16. constructor. assumption.
  assumption.
  constructor. assumption.
  red.
  intros k h14.
  destruct h14 as [k h14 h15]. destruct h14 as [h14]. destruct h14 as [h14a h14b].
  destruct h15 as [h15].
  constructor. split. constructor. assumption. assumption.
pose proof (subsetT_eq_compat _ (fun S => Included S  (non_zero_el_prod_compose_maps A (sig_fun_app g 0) E)) _ _ h12
                               (incl_non_zero_el_prod_compose_maps_of_set A h3 
        (sig_fun_app g 0)
        [a : Fin_map E signe mns
        | In (non_zero_el_prod_maps B E) a /\ a |-> x = pls]) h14) as h15.
dependent rewrite -> h15.  
reflexivity.

exists f'. red. split. split; auto.
 
intros k h10. destruct h10 as [h10 h11].
assert (hag:agree_on f' k E).
red in hex. red in h11. red.
intros x h12.
specialize (hex (exist _ _ h12)). specialize (h11 (exist _ _ h12)).
simpl in hex, h11. congruence.
pose proof (gen_ens_determines_homo f' k hhom h10 _ h1 hag) as h12.
assumption.
Qed.


Lemma finite_homo_extension_criterion_if_p : 
  forall {T:Type} {Ap Bp:Bool_Alg_p T} {E:Ensemble (btp Bp)},
    Finite E ->
    ba_p_ens Bp = Gen_Ens_p _ (incl_im_proj1_sig_ba_p_ens E) ->
    forall (g:sig_set E->btp Ap),
 (forall F:Ensemble (btp Bp), 
         Finite F -> Included F E ->
         forall a:Fin_map F signe mns,
           el_prod_p _ _ a = %0 -> 
           el_prod_compose_p _ _ (sig_fun_app g %0) a = %0) ->
      exists! h:(btp Bp)->(btp Ap), homomorphism_p h /\ extends_sig1 h g.
intros T Ap Bp E h1 h2 g h3. 
rewrite gen_ens_p_eq in h2.  rewrite ba_p_ens_eq in h2 at 1.
apply im_proj1_sig_injective in h2.
rewrite <- im_proj2_sig_undoes_im_proj1_sig' in h2 at 1.
assert (h5: (forall F : Ensemble (bt (ba_conv Bp)),
        Finite F ->
        Included F E ->
        forall a : Fin_map F signe mns,
        el_prod (ba_conv Bp) a = 0 ->
        el_prod_compose (ba_conv Ap) (sig_fun_app (ba_conv_sig_fun1 g) %0) a =
        %0)).
  intros F h5 h6 a h7. 
  assert (h7':  el_prod (ba_conv Bp) (ba_conv_fin_map_dom a) = 0).
    assumption.
    rewrite <- el_prod_p_eq in h7'.
    specialize (h3 F h5 h6 a h7').
    rewrite el_prod_compose_p_eq in h3.
    assumption.
pose proof (finite_homo_extension_criterion_if (A:=ba_conv Ap) (B:=ba_conv Bp) h1 h2 (ba_conv_sig_fun1 g) h5) as h4.
destruct h4 as [k h4]. red in h4. destruct h4 as [h4a h4b].
exists k. red. split.
rewrite homomorphism_p_iff.
assumption.
intro f.
specialize (h4b f).
rewrite homomorphism_p_iff.
assumption.
Qed.


Lemma finite_homo_extension_criterion_if_p1 : 
  forall {T':Type} {Bp:Bool_Alg_p T'} {A:Bool_Alg} {E:Ensemble (btp Bp)},
    Finite E ->
    ba_p_ens Bp = Gen_Ens_p _ (incl_im_proj1_sig_ba_p_ens E) ->
    forall (g:sig_set E->bt A),
 (forall F:Ensemble (btp Bp), 
         Finite F -> Included F E ->
         forall a:Fin_map F signe mns,
           el_prod_p _ _ a = %0 -> 
           el_prod_compose_p1 _ (sig_fun_app g 0) a = 0) ->
      exists! h:(btp Bp)->(bt A), homomorphism_p1 _ h /\ extends_sig1 h g.
intros T' Bp A E h1 h2 g h3.
rewrite gen_ens_p_eq in h2. rewrite <- im_proj2_sig_undoes_im_proj1_sig' in h2.
rewrite ba_p_ens_eq in h2.
apply im_proj1_sig_injective in h2.
assert (h5:forall F : Ensemble (bt (ba_conv Bp)),
             Finite F ->
             Included F E ->
             forall a : Fin_map F signe mns,
               el_prod (ba_conv Bp) a = 0 ->
               el_prod_compose A (sig_fun_app g 0) a (B:=ba_conv Bp) = 0).
  intros F h6 h7 a h8.
  rewrite <- (el_prod_p_eq _ Bp a) in h8 at 1.
  specialize (h3 _ h6 h7 a h8).
  rewrite el_prod_compose_p1_eq in h3.
  assumption.
pose proof (finite_homo_extension_criterion_if (B:=ba_conv Bp) h1 h2 g h5) as h4.
destruct h4 as [k h4]. red in h4. destruct h4 as [h4 h6].
exists k.
red. split.
rewrite homomorphism_p1_iff.
assumption.
intros x' h7.
rewrite homomorphism_p1_iff in h7.
specialize (h6 _ h7). subst.
reflexivity.
Qed.


Require Import ListUtilities.


Theorem homo_extension_criterion : 
  forall {A B:Bool_Alg} {E:Ensemble (bt B)},
    ba_ens B = Gen_Ens E ->
    forall (g:sig_set E->bt A),
      (exists h:(bt B)->(bt A), homomorphism h /\ extends_sig1 h g) <->
      (forall F:Ensemble (bt B), 
         Finite F -> Included F E ->
         forall a:Fin_map F signe mns,
           el_prod _ a = 0 -> 
           el_prod_compose _ (sig_fun_app g 0) a = 0).
intros A B E h1 g.
split. 
Focus 2.
(* <- *)
intro h2. 
assert (h0:forall F:(finc E), Included (proj1_sig F) (ba_p_ens (ba_to_ba_p B))).
  intro F. destruct F as [F h3]. destruct h3 as [h3a h3b].
  simpl. rewrite ba_p_ens_ba_to_ba_p_eq.
  red. intros; constructor. 
pose (fun F:(finc E) => Gen_p (proj1_sig F) (h0 F)) as B_F.
assert (h0':forall F:(finc E), Included (proj1_sig F) (ba_p_ens (B_F F))). unfold B_F.
  unfold B_F. intro F. rewrite ba_p_ens_gen_p_eq.
  apply gen_ens_includes_p.
pose (fun F:(finc E) => im_proj2_sig _ (h0' F)) as finc_bp.
assert (h8:forall F:(finc E), proj1_sig F = im_proj1_sig (finc_bp F)).
  intro F. unfold finc_bp. rewrite im_proj1_sig_undoes_im_proj2_sig at 1.
  reflexivity.
assert (h9:forall (F:(finc E)) (x:sig_set (finc_bp F)), Ensembles.In E (proj1_sig (proj1_sig x))).
  intros F x. destruct x as [x h10]. simpl.
  destruct x as [x h11]. simpl.
  destruct F as [F h12]. destruct h12 as [h12 h13].
  apply h13.
  inversion h10 as [y h14 ? h15]. subst.
  simpl in y. clear h14. apply exist_injective in h15. subst.
  apply proj2_sig.
pose (fun F:(finc E) => 
        (fun x:sig_set (finc_bp F)=> 
           g (exist _ _ (h9 _ x)))) as g_F.
                  
assert (h4:forall F:(finc E), Finite (finc_bp F)).
  intro F. unfold finc_bp. apply finite_image. rewrite <- finite_full_sig_iff.
  apply (match proj2_sig F with | conj P _ => P end). 
assert (h3:forall F:(finc E),
             ba_p_ens (B_F F) = 
             Gen_Ens_p (im_proj1_sig (finc_bp F)) (incl_im_proj1_sig_ba_p_ens (finc_bp F))).

  intro F.  unfold B_F.
  rewrite ba_p_ens_gen_p_eq at 1.      
  pose proof (gen_p_subalg_of_p_compat _ (h0 F)) as h3.

  assert (h5:Included (im_proj1_sig (finc_bp F)) (ba_p_ens (ba_to_ba_p B))).
    intros; constructor.
  pose proof (gen_ens_p_subalg_of_p 
                h3 _ 
                (incl_im_proj1_sig_ba_p_ens (finc_bp F)) h5) as h6.
  unfold bt, ba_p_ens, B_F. unfold bt, ba_p_ens, B_F in h6.  
  rewrite h6 at 1.
  assert (h7:proj1_sig F = im_proj1_sig (finc_bp F)).
    unfold finc_bp. rewrite im_proj1_sig_undoes_im_proj2_sig at 1.
    reflexivity. 
  apply gen_ens_p_functional; auto.

assert (h10:forall (F:(finc E)) (D : Ensemble (btp (B_F F))),
       Finite D ->
       Included D (finc_bp F) ->
       forall a : Fin_map D signe mns,
       el_prod_p (bt B) (B_F F) a = %0 ->
       el_prod_compose_p1 (bt B) (sig_fun_app (g_F F) 0) a = 0).
  intros F D h11 h12 a h13.
  unfold btp, B_F in D. simpl in D.
  unfold Bc_p', Btype_p in D. simpl in D.
  pose (im_proj1_sig D) as D'.

  assert (h14:Finite D').
    unfold D'. apply finite_image. assumption.
  assert (h15:Included D' E).
    red in h12. red. intros x h15. destruct h15 as [x h15]. subst.
    destruct x as [x h16]. simpl.
    specialize (h12 _ h15).
    inversion h12 as [c h17 ? h18]. subst.
    apply exist_injective in h18. subst.
    destruct F as [F h18]. simpl in h12, h15, h16, c, h17.
    destruct h18 as [h18a h18b].
    apply h18b. apply proj2_sig.

  assert (h16:forall x:sig_set D', Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F)) (proj1_sig x)).
    intro x. destruct x as [x h16]. simpl. destruct h16 as [x h16].
    subst. destruct x as [x h17]. simpl.
    assumption.
  pose (fun x:sig_set D' => exist _ _ (h16 x)) as fp.
  pose (fun x:sig_set D' => a |-> (fp x)) as fa.
  pose (sig_fun_to_fin_map fa h14 mns) as ga. 
  assert (h17:Included (Im (full_sig D') fa) signe).
    red. intros. destruct x. left. right.
  pose (fin_map_new_ran ga signe_finite h17) as fa'. 

  assert (h18:el_prod B fa' = 0).    
    unfold el_prod. unfold el_prod_p in h13.
    pose proof (finite_set_list_no_dup  (Im D' (fun i : Btype (Bc B) => eps i (fa' |-> i)))
     (finite_image (Btype (Bc B)) (bt B) D'
        (fun i : Btype (Bc B) => eps i (fa' |-> i)) 
        (fin_map_fin_dom fa'))) as h18. 
    destruct h18 as [l h18]. destruct h18 as [h18 h18'].
    pose proof (times_set_compat' _ _ (finite_image (Btype (Bc B)) (bt B) D'
        (fun i : Btype (Bc B) => eps i (fa' |-> i)) 
        (fin_map_fin_dom fa')) h18) as h19.
    rewrite h19 at 1.
    pose proof (finite_set_list_no_dup (Im D (fun i : btp (B_F F) => eps_p i (a |-> i)))
          (finite_image (btp (B_F F)) (btp (B_F F)) D
             (fun i : btp (B_F F) => eps_p i (a |-> i)) 
             (fin_map_fin_dom a))) as h20.
    destruct h20 as [l' h20]. destruct h20 as [h20 h20'].
    pose proof (times_set_compat_p' _ _   (finite_image (btp (B_F F)) (btp (B_F F)) D
             (fun i : btp (B_F F) => eps_p i (a |-> i)) 
             (fin_map_fin_dom a)) h20) as h21.
    rewrite h21 in h13 at 1.
    rewrite times_list_p_eq in h13. simpl in h13.
    assert (hz:proj1_sig  (exist (Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F)))
          (proj1_sig
             (transfer
                (Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
                   (SubBtype B (Full_set (bt B)))
                   (SubBtype B (Full_set (bt B))) eq_refl
                   (sig_set
                      (fun a0 : Btype (Bc B) =>
                       Ensembles.In (Full_set (bt B)) a0))
                   (sig_set
                      (fun a0 : Btype (Bc B) =>
                       Ensembles.In (Full_set (bt B)) a0))
                   (Morphisms.eq_proper_proxy Type
                      (sig_set
                         (fun a0 : Btype (Bc B) =>
                          Ensembles.In (Full_set (bt B)) a0))) eq_refl)
                (exist (Ensembles.In (Full_set (bt B))) 0
                   (Z_c B (Full_set (bt B)) (alg_closed_ba_ens B)))))
          (Z_c_p (bt B) (ba_to_ba_p B) (Gen_Ens_p (proj1_sig F) (h0 F))
             (incl_gen_ens_p (proj1_sig F) (h0 F))
             (closed_gen_ens_p (proj1_sig F) (h0 F)))) = 0).
    assert (h22: (Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
                 (SubBtype B (Full_set (bt B)))
                 (SubBtype B (Full_set (bt B))) eq_refl
                 (sig_set
                    (fun a0 : Btype (Bc B) =>
                     Ensembles.In (Full_set (bt B)) a0))
                 (sig_set
                    (fun a0 : Btype (Bc B) =>
                     Ensembles.In (Full_set (bt B)) a0))
                 (Morphisms.eq_proper_proxy Type
                    (sig_set
                       (fun a0 : Btype (Bc B) =>
                        Ensembles.In (Full_set (bt B)) a0))) eq_refl) = eq_refl _). apply proof_irrelevance.
    simpl. rewrite h22 at 1. rewrite transfer_eq_refl. simpl.
    reflexivity.
    pose proof (f_equal (@proj1_sig _ _) h13) as h22.
    simpl in h22, hz.
    rewrite hz in h22 at 1. clear h13.
    rewrite <- h22.
    unfold ba_conv_list.
    assert (h23:list_to_set l = im_proj1_sig (list_to_set l')).
      rewrite <- h18 at 1. rewrite <- h20 at 1.
      apply Extensionality_Ensembles.
      red. split.
      red. intros x h23.
      destruct h23 as [x h23]. subst.
      destruct h23 as [x h23]. subst. 
      pose proof (h3 F) as h3'. 
      destruct x as [x h24].
      assert (h25:Gen_Ens_p (im_proj1_sig (finc_bp F))
          (incl_im_proj1_sig_ba_p_ens (finc_bp F)) =
                  (Gen_Ens_p (proj1_sig F) (h0 F))).
        pose proof (gen_p_subalg_of_p_compat _ (h0 F)) as hg.
        assert (h5:Included (im_proj1_sig (finc_bp F)) (ba_p_ens (ba_to_ba_p B))).
    intros; constructor.
  pose proof (gen_ens_p_subalg_of_p 
                hg _ 
                (incl_im_proj1_sig_ba_p_ens (finc_bp F)) h5) as h6.
  unfold bt, ba_p_ens, B_F. unfold bt, ba_p_ens, B_F in h6.  
  rewrite h6 at 1. 
  assert (h7:proj1_sig F = im_proj1_sig (finc_bp F)).
    unfold finc_bp. rewrite im_proj1_sig_undoes_im_proj2_sig at 1.
    reflexivity.    
  apply gen_ens_p_functional; auto. simpl.
  rewrite h25 in h3'. 
  pose proof h24 as h24'. rewrite <- h3' in h24' at 1.
  pose ((fun i : btp (B_F F) => eps_p i (a |-> i)) (exist _ _ h24')) as x'.
  pose proof (proj2_sig x') as h26. simpl in h26.
  apply Im_intro with (exist _ _ h26).
  apply Im_intro with
          (exist
             (fun x0 : bt B =>
              Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F)) x0) x h24). assumption. 
  apply proj1_sig_injective. simpl. unfold x'.
  f_equal. f_equal.
  apply proj1_sig_injective. simpl. reflexivity.
  f_equal. apply proj1_sig_injective. simpl. reflexivity.
  simpl. unfold x'.
  rewrite eps_p_eq. unfold ba_conv_elt, ba_conv_type.
  rewrite transfer_eq_refl. unfold fa'.
  rewrite <- (fin_map_new_ran_compat ga signe_finite h17) at 1.
  unfold ga.   
  assert (h27:Ensembles.In D' x).
    unfold D'. apply Im_intro with  (exist
             (fun x0 : bt B =>
              Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F)) x0) x h24).
    assumption. simpl. reflexivity.
  rewrite (sig_fun_to_fin_map_compat fa h14 mns _ h27) at 1. 
  unfold fa. unfold fp. simpl.
  assert (h28:a |-> exist (Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F))) x
            (h16 (exist (Ensembles.In D') x h27)) =
              a |-> exist (Ensembles.In (ba_p_ens (B_F F))) x h24').
    f_equal. apply proj1_sig_injective. simpl. reflexivity.
  rewrite h28 at 1.
  unfold eps.
  destruct (a |-> exist (Ensembles.In (ba_p_ens (B_F F))) x h24').
  simpl. reflexivity. simpl.
  assert (h29: (Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
           (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B)))
           eq_refl
           (sig_set
              (fun a0 : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a0))
           (sig_set
              (fun a0 : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a0))
           (Morphisms.eq_proper_proxy Type
              (sig_set
                 (fun a0 : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a0)))
           eq_refl) = eq_refl).
    apply proof_irrelevance.
  rewrite h29 at 1. rewrite transfer_dep_eq_refl. simpl.
  unfold Bcomp_sub. simpl. reflexivity.
  
  red. intros x h23.
  destruct h23 as [x h23]. subst.
  unfold D'.
  unfold im_proj1_sig. rewrite im_im.
  destruct x as [x h24]. simpl.
  inversion h23 as [x' h25 ? h26]. subst. clear h23.
  apply Im_intro with x'. assumption.
  rewrite eps_p_eq in h26.
  pose proof (f_equal (@proj1_sig _ _) h26) as h26'. clear h26.
  simpl in h26'. subst.
  unfold ba_conv_elt, ba_conv_type. rewrite transfer_eq_refl.
  unfold fa'. 
  pose proof (fin_map_new_ran_compat ga signe_finite h17 (proj1_sig x')) as h27. 
  unfold D' in h27. unfold D'.
  rewrite <- h27 at 1.
  unfold ga.
  assert (h28:Ensembles.In D' (proj1_sig x')).
    unfold D'. apply Im_intro with x'. assumption. reflexivity.
  pose proof (sig_fun_to_fin_map_compat fa h14 mns _ h28) as h29.
  unfold D' in h29. unfold D'. rewrite h29 at 1.
  unfold fa, fp. simpl. 
  destruct x' as [x' h30]. simpl.
  simpl in h29, h28, h27.
  assert (h31: a
         |-> exist
               (fun x : bt B =>
                Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F)) x) x' h30 =
    a
      |-> exist (Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F))) x'
            (h16 (exist (Ensembles.In (im_proj1_sig D)) x' h28))).
    f_equal. apply proj1_sig_injective. simpl. reflexivity.
  rewrite h31 at 1.
  unfold eps.
  destruct ( a
       |-> exist (Ensembles.In (Gen_Ens_p (proj1_sig F) (h0 F))) x'
             (h16 (exist (Ensembles.In (im_proj1_sig D)) x' h28))).
  simpl. reflexivity.
  simpl.
  assert (h32:Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
           (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B)))
           eq_refl
           (sig_set
              (fun a0 : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a0))
           (sig_set
              (fun a0 : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a0))
           (Morphisms.eq_proper_proxy Type
              (sig_set
                 (fun a0 : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a0)))
           eq_refl = eq_refl).
    apply proof_irrelevance.
  rewrite h32 at 1. rewrite transfer_dep_eq_refl. simpl.
  unfold Bcomp_sub. simpl. 
  reflexivity.
  pose proof (gen_p_subalg_of_p_compat _ (h0 F)) as h24.
  unfold B_F.
  rewrite (proj1_sig_times_list_transfer_dep_ba_conv_type_eq h24 _ _ h18' h20' h23) at 1.
  reflexivity.
pose proof (h2 D' h14 h15 fa' h18) as h20. 
rewrite <- h20.
rewrite el_prod_compose_p1_eq.  
unfold el_prod_compose.
apply times_set_functional.
unfold D', im_proj1_sig. rewrite im_im.
unfold ba_conv_set, ba_conv_type.  
apply im_ext_in.
intros x hin.
f_equal. 
unfold ba_conv_fun1. 
unfold sig_fun_app.
destruct (classic_dec (Ensembles.In (finc_bp F) x)) as [h21 | h22].
unfold g_F.
destruct (classic_dec  (@Ensembles.In (bt B) E
          (@proj1_sig (bt B)
             (fun x0 : bt B =>
              @Ensembles.In (bt B)
                (@Gen_Ens_p (bt B) (ba_to_ba_p B)
                   (@proj1_sig (Ensemble (bt B))
                      (fun F0 : Ensemble (bt B) =>
                       @Finite (bt B) F0 /\ @Included (bt B) F0 E) F) 
                   (h0 F)) x0) x))) as [h23 | h24].
f_equal.
apply proj1_sig_injective. simpl. reflexivity. 
contradict h24.
destruct x as [x h22]. simpl.
pose proof (h9 F (exist _ _ h21)) as h23.
simpl in h23.
assumption. 
contradict h22. apply h12. assumption.
unfold fa'. unfold ba_conv_fin_map_dom.
rewrite <- (fin_map_new_ran_compat ga signe_finite h17).
unfold ga.
assert (h21:Ensembles.In D' (proj1_sig x)). apply Im_intro with x.
  assumption. reflexivity.
rewrite (sig_fun_to_fin_map_compat fa h14 mns _ h21).
unfold fa. unfold fp. simpl.
f_equal.
apply proj1_sig_injective.
simpl. reflexivity.

(*Finally can apply finite_homo_extension_criterion_if_p1 parametrically!!*)
pose (fun F:(finc E) => 
         proj1_sig (constructive_definite_description _ 
                                                      (finite_homo_extension_criterion_if_p1 (A:=A) (h4 F) (h3 F) (g_F F) (h10 F)))) as psi.
pose (Im (Full_set (finc E)) (fun F => existT (fun C:(Bool_Alg_p (bt B)) => (btp C->bt A)) (B_F F) (psi F))) as fam. 
assert (h11:directed_fam_homo_p1 _ fam).
  red. split.
  red. intros f h11. destruct h11 as [F h11]. subst.
  simpl.
  unfold psi.
  destruct constructive_definite_description as [f h12]. simpl.
  destruct h12 as [h12 h13]. assumption.
  intros F G h11 h12.
  destruct h11 as [F h11], h12 as [G h12]. subst. 
  destruct F as [F h13], G as [G h14].
  destruct h13 as [h13a h13b], h14 as [h14a h14b].
  simpl.
  pose (Union F G) as H'.
  assert (h15:Finite H'). apply Union_preserves_Finite; auto.
  assert (h16:Included H' E). unfold H'. auto with sets.
  pose (exist  (fun S=>Finite S /\ Included S E) _ (conj h13a h13b)) as F'.
  pose (exist  (fun S=>Finite S /\ Included S E) _ (conj h15 h16)) as H''.
  assert (h17:Included (ba_p_ens (B_F F')) (ba_p_ens (B_F H''))).
    unfold B_F.
    do 2 rewrite ba_p_ens_gen_p_eq.
    apply gen_ens_preserves_inclusion_p.
    unfold F', H''. simpl. unfold H'. auto with sets.
  exists (existT (fun C:(Bool_Alg_p (bt B)) => (btp C->bt A)) (B_F H'') (psi H'')).
  split.
  unfold fam.
  apply Im_intro with H''. constructor. reflexivity. 
  simpl.
  red. split. split.
  red.  exists h17.
  unfold B_F. simpl.

  assert (h18: alg_closed_p
              (ba_p_ens
                 (Gen_p F
                    (h0
                       (exist
                          (fun F0 : Ensemble (bt B) =>
                           Finite F0 /\ Included F0 E) F 
                          (conj h13a h13b))))) h17).

    pose proof (ba_p_ens_gen_p_eq F  (h0
              (exist (fun F0 : Ensemble (bt B) => Finite F0 /\ Included F0 E)
                 F (conj h13a h13b)))) as h18.
    assert (h19:Included  (Gen_Ens_p F
          (h0
             (exist (fun F0 : Ensemble (bt B) => Finite F0 /\ Included F0 E)
                F (conj h13a h13b))))
                          (ba_p_ens (B_F H''))).
      rewrite <- h18. assumption. 
    pose proof (subsetT_eq_compat _ (fun S => Included S (ba_p_ens (B_F H''))) _ _ h17 h19 h18) as h20.
    unfold B_F, F' in h20. simpl in h20.
    dependent rewrite -> h20. 
    pose proof (gen_ens_includes_p _ (h0 F')) as h22.
    unfold F' in h22. simpl in h22.
    assert (h23:Included F (ba_p_ens (B_F H''))).
      auto with sets.
    pose proof (closed_gen_ens_p _ h23) as h24.
  assert (h25:subalg_of_p (B_F H'') (ba_to_ba_p B)).
    unfold B_F.
    apply gen_p_subalg_of_p_compat. 
  pose proof (gen_ens_p_subalg_of_p h25 _ h23 (h0 F')) as h26. 
  pose proof (subsetT_eq_compat _ (fun S => Included S (ba_p_ens (B_F H''))) _ _ (incl_gen_ens_p F h23) h19 h26) as h27.
  dependent rewrite -> h27 in h24.
  assumption.  
exists h18.  
assert (h19:Included F (ba_p_ens (Gen_p H' (h0 H'')))).
  rewrite ba_p_ens_gen_p_eq.
  assert (h20:Included F H').
    unfold H'. auto with sets.
  pose proof (gen_ens_includes_p _ (h0 H'')) as h21.
  unfold H'' in h21. simpl in h21. auto with sets.
assert (h20: Subalg_p (Gen_p H' (h0 H''))
     (ba_p_ens
        (Gen_p F
           (h0
              (exist (fun F0 : Ensemble (bt B) => Finite F0 /\ Included F0 E)
                 F (conj h13a h13b))))) h17 h18 = 
             Gen_p F h19).
  apply subalg_functional_p.
  rewrite ba_p_ens_gen_p_eq at 1.
  symmetry.
  apply gen_ens_p_subalg_of_p.
  apply gen_p_subalg_of_p_compat.
rewrite h20 at 1.
symmetry.
apply gen_p_subalg_of_p.
apply gen_p_subalg_of_p_compat.
unfold psi.
destruct constructive_definite_description as [f h18].
simpl.
destruct h18 as [h18 h19].
assumption.
unfold psi.
destruct constructive_definite_description as [f h18].
simpl.
destruct h18; auto.


unfold psi.
destruct constructive_definite_description as [f h18].
destruct constructive_definite_description as [k h19].
simpl.
destruct h18 as [h18a h18b]. destruct h19 as [h19a h19b].
red in h18b. red in h19b.
pose (restriction_sig f _ h17) as f'.
assert (hinc:Included F H'). unfold H'. auto with sets. 
assert (h20:f' = k).
  pose proof (subalg_of_p_gen_p_gen_p _ _  _ hinc (h0 F') (h0 H'')) as h22.
  assert (h23:Included (ba_p_ens (Gen_p F (h0 F'))) (ba_p_ens (Gen_p H' (h0 H'')))).
    do 2 rewrite ba_p_ens_gen_p_eq. assumption.
pose proof (homomorphism_p1_restriction_sig _ _ f h18a _ h23 h22) as h24.
  assert (h25:Included F (ba_p_ens (Gen_p F (h0 F')))).
    rewrite ba_p_ens_gen_p_eq.  apply gen_ens_includes_p.

  assert (h26: ba_p_ens (Gen_p F (h0 F')) = Gen_Ens_p F h25).
    rewrite ba_p_ens_gen_p_eq.
    assert (h26:subalg_of_p (Gen_p F (h0 F')) (ba_to_ba_p B)). 
      apply gen_p_subalg_of_p_compat.
    rewrite (gen_ens_p_subalg_of_p h26 F h25 (h0 F')).
    reflexivity.
  assert (h27: agree_on (restriction_sig f (ba_p_ens (Gen_p F (h0 F'))) h23) k
         (im_proj2_sig F h25)).
    red. intros x  h27. 
    assert (h29:Ensembles.In (finc_bp (exist _ _ (conj h13a h13b))) x).
      destruct h27 as [x h27]. subst. 
      unfold finc_bp. simpl.
      apply Im_intro with x. assumption.
      apply proj1_sig_injective. simpl. reflexivity.
    specialize (h19b (exist _ _ h29)).
    simpl in h19b.
    rewrite <- h19b.
    destruct h27 as [x h27]. subst.
    destruct x as [x h30].
    simpl.
    assert (h31:Ensembles.In (ba_p_ens (Gen_p H' (h0 H''))) x).
      apply h23. apply h25. assumption.
    assert (h32:Ensembles.In (finc_bp H'') (exist _ _ h31)).
      unfold finc_bp. apply Im_intro with (exist _ _ (hinc _ h30)).
      constructor.
      apply proj1_sig_injective. simpl. reflexivity.
    unfold restriction_sig. simpl.
    specialize (h18b (exist _ _ h32)).
    simpl in h18b. 
    assert (h33: f (exist (Ensembles.In (Gen_Ens_p H' (h0 H''))) x (h23 x (h25 x h30))) = 
                  f (exist (Ensembles.In (ba_p_ens (Gen_p H' (h0 H'')))) x h31)).
      f_equal. apply proj1_sig_injective. simpl. reflexivity.
    rewrite h33.
    rewrite <- h18b.
    unfold g_F.
    f_equal.
    apply proj1_sig_injective. simpl. reflexivity.
  unfold f'.
  pose proof (gen_ens_determines_homo_p1 _ _ _ h24 h19a F h25 h26 h27) as h28. 
  rewrite <- h28.
  f_equal. apply proof_irrelevance.  
  red. 
assert (h21:Included
            (Gen_Ens_p F
               (h0
                  (exist
                     (fun F0 : Ensemble (bt B) => Finite F0 /\ Included F0 E)
                     F (conj h13a h13b)))) (Gen_Ens_p H' (h0 H''))).
  apply gen_ens_preserves_inclusion_p.
  unfold H'. auto with sets.
exists h21.
intro x.
rewrite <- h20.
unfold f', restriction_sig.
f_equal. apply proj1_sig_injective. simpl. reflexivity.
pose (exist  (fun S=>Finite S /\ Included S E) _ (conj h14a h14b)) as G'.

assert (h17':Included (ba_p_ens (B_F G')) (ba_p_ens (B_F H''))).
    unfold B_F.
    do 2 rewrite ba_p_ens_gen_p_eq.
    apply gen_ens_preserves_inclusion_p.
    unfold G', H''. simpl. unfold H'. auto with sets.
 unfold psi.
destruct constructive_definite_description as [f h18].
destruct constructive_definite_description as [k h19].
simpl.
destruct h18 as [h18a h18b]. destruct h19 as [h19a h19b].
red in h18b. red in h19b. 
pose (restriction_sig f _ h17') as f'.
assert (hinc:Included G H'). unfold H'. auto with sets.
assert (h20:f' = k).
  pose proof (subalg_of_p_gen_p_gen_p _ _  _ hinc (h0 G') (h0 H'')) as h22.
  assert (h23:Included (ba_p_ens (Gen_p G (h0 G'))) (ba_p_ens (Gen_p H' (h0 H'')))).
    do 2 rewrite ba_p_ens_gen_p_eq. assumption.
pose proof (homomorphism_p1_restriction_sig _ _ f h18a _ h23 h22) as h24.
  assert (h25:Included G (ba_p_ens (Gen_p G (h0 G')))).
    rewrite ba_p_ens_gen_p_eq.  apply gen_ens_includes_p.

  assert (h26: ba_p_ens (Gen_p G (h0 G')) = Gen_Ens_p G h25).
    rewrite ba_p_ens_gen_p_eq.
    assert (h26:subalg_of_p (Gen_p G (h0 G')) (ba_to_ba_p B)). 
      apply gen_p_subalg_of_p_compat.
    rewrite (gen_ens_p_subalg_of_p h26 G h25 (h0 G')).
    reflexivity.
  assert (h27: agree_on (restriction_sig f (ba_p_ens (Gen_p G (h0 G'))) h23) k
         (im_proj2_sig G h25)).
    red. intros x  h27. 
    assert (h29:Ensembles.In (finc_bp (exist _ _ (conj h14a h14b))) x).
      destruct h27 as [x h27]. subst. 
      unfold finc_bp. simpl.
      apply Im_intro with x. assumption.
      apply proj1_sig_injective. simpl. reflexivity.
    specialize (h19b (exist _ _ h29)).
    simpl in h19b.
    rewrite <- h19b.
    destruct h27 as [x h27]. subst.
    destruct x as [x h30].
    simpl.
    assert (h31:Ensembles.In (ba_p_ens (Gen_p H' (h0 H''))) x).
      apply h23. apply h25. assumption.
    assert (h32:Ensembles.In (finc_bp H'') (exist _ _ h31)).
      unfold finc_bp. apply Im_intro with (exist _ _ (hinc _ h30)).
      constructor.
      apply proj1_sig_injective. simpl. reflexivity.
    unfold restriction_sig. simpl.
    specialize (h18b (exist _ _ h32)).
    simpl in h18b. 
    assert (h33: f (exist (Ensembles.In (Gen_Ens_p H' (h0 H''))) x (h23 x (h25 x h30))) = 
                  f (exist (Ensembles.In (ba_p_ens (Gen_p H' (h0 H'')))) x h31)).
      f_equal. apply proj1_sig_injective. simpl. reflexivity.
    rewrite h33.
    rewrite <- h18b.
    unfold g_F.
    f_equal.
    apply proj1_sig_injective. simpl. reflexivity.
  unfold f'.
  pose proof (gen_ens_determines_homo_p1 _ _ _ h24 h19a G h25 h26 h27) as h28. 
  rewrite <- h28. 
  f_equal. apply proof_irrelevance. 
rewrite <- h20.
constructor.
unfold B_F. simpl.
apply subalg_of_p_gen_p_gen_p.
unfold H'. auto with sets. assumption. 
apply homomorphism_p1_restriction_sig. assumption.
apply subalg_of_p_gen_p_gen_p.
unfold G', H''. simpl. unfold H'. auto with sets.
unfold f'.
red.
assert (h21:Included
            (A_p (bt B)
               (Bc_p (bt B)
                  (B_F
                     (exist
                        (fun F0 : Ensemble (bt B) =>
                         Finite F0 /\ Included F0 E) G 
                        (conj h14a h14b)))))
            (A_p (bt B) (Bc_p (bt B) (B_F H'')))).
  simpl.
  apply gen_ens_preserves_inclusion_p. unfold H'. auto with sets.
exists h21.
intro x.
unfold restriction_sig.
f_equal. apply proj1_sig_injective. simpl. reflexivity.
assert (h12:Inhabited (Full_set (finc E))).
  assert (h13:Finite (Empty_set (bt B))). auto with sets.
  assert (h14:Included (Empty_set (bt B)) E). auto with sets.
  unfold finc. 
  apply Inhabited_intro with (exist (fun F=>Finite F /\ Included F E) _ (conj h13 h14)).
  constructor.
assert (h13:Inhabited fam).  
  unfold fam.
  destruct h12 as [K h12].
  apply Inhabited_intro with ((fun F : (finc E) =>
         existT (fun C : Bool_Alg_p (bt B) => btp C -> bt A) (B_F F) (psi F)) K).
  apply Im_intro with K. assumption.
  reflexivity. 
pose proof (directed_common_extension_p1 _ _ h11 h13) as h14.
destruct h14 as [h14 [h15 [f [h17 h18]]]].  
assert (h19:directed_ba_p h14 h15 = (ba_to_ba_p B)).
  assert (h21: fam_ba_p_bt_p_compat (fam_fun_ba_domains_p1 (bt B) fam)
          (ba_to_ba_p B)).
    red. intros Ap h19. destruct h19 as [Ap h19]. subst.
    destruct Ap as [Ap rho]. simpl.
    inversion h19 as [Ap' h20 ? h21]. clear h19.
    subst.
    inversion h21. subst.
    apply gen_p_subalg_of_p_compat.
  pose proof (subalg_of_p_directed_ba_p_ba_to_ba_p _ h14 h15 h21) as h20.
   assert (h22:ba_p_ens (directed_ba_p h14 h15) = ba_p_ens (ba_to_ba_p B)).
     apply Extensionality_Ensembles.
     red. split.
     red. intros; constructor.
     rewrite h1 at 1. 
     apply gen_minimal''. 
     apply alg_closed_ba_p_ens.
     assumption.
     unfold ba_p_ens, directed_ba_p. simpl.
     red.
     intros x h22. 
     assert (h23:Included (Singleton x) (ba_p_ens (ba_to_ba_p B))).
     red. intros x' h23. destruct h23. rewrite ba_p_ens_ba_to_ba_p_eq.
     constructor.

     assert (h23':Included (Singleton x) E). 
     red. intros x' h23'. destruct h23'; auto.
     assert (h24:Finite (Singleton x)).
     apply Singleton_is_finite.
     apply family_union_intro with (Gen_Ens_p (Singleton x) h23).
     apply Im_intro with (Gen_p (Singleton x) h23).
     unfold fam, fam_fun_ba_domains_p1.
     rewrite im_im. simpl.
     unfold finc.
     apply Im_intro with (existT (fun S => Finite S /\ Included S E) _ (conj h24 h23')).
     constructor.
     unfold B_F. simpl.
     f_equal. apply proof_irrelevance.
     rewrite ba_p_ens_gen_p_eq. reflexivity.
     apply gen_ens_includes_p. constructor.
  apply bc_inj_p. 
  destruct h20 as [h20a [h20b h20c]].
  rewrite h20c at 1.  
  unfold Subalg_p. simpl.
  assert (h23:Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
        (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B))) eq_refl
        (sig_set (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
        (sig_set (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
        (Morphisms.eq_proper_proxy Type
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)))
        eq_refl = eq_refl). apply proof_irrelevance.
  rewrite h23 at 1. simpl. 
  assert (h24:A_p (bt B)
                (Bc_p' (bt B) (ba_to_ba_p B)
                   (ba_p_ens (directed_ba_p h14 h15)) h20a h20b) =
              A_p (bt B)
                (bc_sig_set_conv
                   (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)
                   (Bc' B (Full_set (bt B)) (alg_closed_ba_ens B)) eq_refl)).
    apply Extensionality_Ensembles.
    red. split.
    red. intros x h24.
    unfold bc_sig_set_conv. simpl. apply Full_intro.
    red. intros x h24. unfold Bc_p'. simpl.
    rewrite h22.
    rewrite ba_p_ens_ba_to_ba_p_eq. constructor.
  apply (bconst_ext_p (Bc_p' (bt B) (ba_to_ba_p B) (ba_p_ens (directed_ba_p h14 h15)) h20a h20b)
   (bc_sig_set_conv (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)
     (Bc' B (Full_set (bt B)) (alg_closed_ba_ens B)) eq_refl) h24).
  unfold bc_sig_set_conv. simpl.
   rewrite transfer_dep_eq_refl. 
   unfold SubBtype, ba_p_ens, directed_ba_p.
   simpl.
   unfold SubBtype_p.
   apply Extensionality_Ensembles.
   red. split.
   red. intros x h25.
   rewrite <- (transfer_r_undoes_transfer  (sig_set_eq
           (FamilyUnion
              (Im (fam_fun_ba_domains_p1 (bt B) fam) (ba_p_ens (T:=bt B))))
           (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a) h24) x).
   rewrite <- transfer_in_r at 1.
   rewrite (transfer_sig_set_eq _ _ h24 (sig_set_eq
           (FamilyUnion
              (Im (fam_fun_ba_domains_p1 (bt B) fam) (ba_p_ens (T:=bt B))))
            (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a) h24) x) at 1.
   constructor.
   red. intros; constructor.
 

 rewrite <- transfer_fun2_r_transfer_dep_r_compat'. 
 rewrite transfer_fun2_r_eq'.

 apply functional_extensionality. intro x. apply functional_extensionality. intro y.
 rewrite (transfer_r_sig_set_eq _ _ h24) at 1.
 simpl.
 apply proj1_sig_injective.
 simpl.
 do 2 rewrite (transfer_sig_set_eq _ _  h24) at 1.
 
  unfold Bplus_sub, Bplus_sub_p. simpl.
  destruct x as [x h26], y as [y h27].
  assert (h25:Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
           (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B)))
           eq_refl
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (Morphisms.eq_proper_proxy Type
              (sig_set
                 (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)))
           eq_refl = eq_refl). apply proof_irrelevance.
  rewrite h25 at 1.
  rewrite transfer_dep_eq_refl. simpl.
  unfold Bplus_sub. simpl.
  reflexivity.


 rewrite <- transfer_fun2_r_transfer_dep_r_compat'. 
 rewrite transfer_fun2_r_eq'.

 apply functional_extensionality. intro x. apply functional_extensionality. intro y.
 rewrite (transfer_r_sig_set_eq _ _ h24) at 1.
 simpl.
 apply proj1_sig_injective.
 simpl.
 do 2 rewrite (transfer_sig_set_eq _ _  h24) at 1.
 
  unfold Btimes_sub, Btimes_sub_p. simpl.
  destruct x as [x h26], y as [y h27].
  assert (h25:Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
           (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B)))
           eq_refl
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (Morphisms.eq_proper_proxy Type
              (sig_set
                 (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)))
           eq_refl = eq_refl). apply proof_irrelevance.
  rewrite h25 at 1.
  rewrite transfer_dep_eq_refl. simpl.
  unfold Btimes_sub. simpl.
  reflexivity.

  rewrite transfer_dep_r_id_transfer_r_compat.
  rewrite (transfer_r_sig_set_eq _ _ h24).
  apply proj1_sig_injective.
  simpl.
  assert (h25:Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
           (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B)))
           eq_refl
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (Morphisms.eq_proper_proxy Type
              (sig_set
                 (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)))
           eq_refl = eq_refl). apply proof_irrelevance.
  rewrite h25 at 1.
  rewrite transfer_eq_refl.
  simpl. reflexivity.

  rewrite transfer_dep_r_id_transfer_r_compat.
  rewrite (transfer_r_sig_set_eq _ _ h24).
  apply proj1_sig_injective.
  simpl.
  assert (h25:Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
           (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B)))
           eq_refl
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (Morphisms.eq_proper_proxy Type
              (sig_set
                 (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)))
           eq_refl = eq_refl). apply proof_irrelevance.
  rewrite h25 at 1.
  rewrite transfer_eq_refl.
  simpl. reflexivity.
 
 rewrite <- transfer_fun_r_transfer_dep_r_compat'. 
 rewrite transfer_fun_r_eq'.
 apply functional_extensionality. intro x. 
 rewrite (transfer_r_sig_set_eq _ _ h24) at 1.
 simpl.
 apply proj1_sig_injective.
 simpl.
 rewrite (transfer_sig_set_eq _ _  h24) at 1.
 
  unfold Bcomp_sub, Bcomp_sub_p. simpl.
  destruct x as [x h26].
  assert (h25:Morphisms.trans_co_eq_inv_impl_morphism eq_Transitive
           (SubBtype B (Full_set (bt B))) (SubBtype B (Full_set (bt B)))
           eq_refl
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (sig_set
              (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a))
           (Morphisms.eq_proper_proxy Type
              (sig_set
                 (fun a : Btype (Bc B) => Ensembles.In (Full_set (bt B)) a)))
           eq_refl = eq_refl). apply proof_irrelevance.
  rewrite h25 at 1.
  rewrite transfer_dep_eq_refl. simpl.
  unfold Bcomp_sub. simpl.
  reflexivity.
assert (h20:btp (directed_ba_p h14 h15) = btp (ba_to_ba_p B)).
  f_equal; auto.
pose (fun x:bt B => ((transfer_fun h20 f) (exist _ _ (Full_intro _ x)))) as f'. 
pose proof (common_extension_fam_homo_p1_homo_p1 _ _ _ f fam h13 h17) as h21.
exists f'.
split.  unfold f'.
rewrite (ba_p_subst_homomorphism_p1 _ _ _ _ h19 h20) in h21. 
rewrite homomorphism_p1_iff in h21.
unfold ba_conv_fun1 in h21.
unfold Btype, ba_conv, ba_to_ba_p in h21. simpl in h21.
simpl in h21.
rewrite <- homomorphism_ba_to_ba_p_iff.
rewrite homomorphism_p1_iff.
assumption.
red.
intro x.
destruct h17 as [h17a h17b].
destruct x as [x h22]. simpl.
unfold f'.
rewrite transfer_fun_eq.
assert (h23:Included (Singleton x) E).
  red; intros x' h24. destruct h24; auto.
assert (h24:Included (Singleton x) (ba_p_ens (ba_to_ba_p B))).
  intros; constructor.
assert (h25:Ensembles.In (ba_p_ens  (Gen_p (Singleton x) h24)) x).
  rewrite ba_p_ens_gen_p_eq.
  apply gen_ens_includes_p. constructor.
assert (h26:Included E (ba_p_ens (ba_to_ba_p B))). 
  red; intros; constructor.
pose proof (subalg_of_p_gen_p_gen_p (ba_to_ba_p B) (Singleton x) E h23 h24 h26) as h27.      
pose proof h27 as h27'.
destruct h27' as [h27a  [h27b h27c]].       
assert (h28:Finite (Singleton x)). apply Singleton_is_finite.
assert (h30:Finite (im_proj2_sig (Singleton x) h24)).
  apply finite_image; auto. rewrite <- finite_full_sig_iff.
  assumption.
assert (h31:Included (Singleton x) (ba_p_ens (Gen_p (Singleton x) h24))).
  red. intros x' h32. destruct h32.
  rewrite ba_p_ens_gen_p_eq. apply gen_ens_includes_p.
  constructor.
pose (exist  (fun C=>Finite C /\ Included C E) _ (conj h28 h23)) as sp. 
pose (existT (fun Bp=>(btp Bp)->bt A) (Gen_p (Singleton x) (h0
           (exist (fun C : Ensemble (bt B) => Finite C /\ Included C E)
              (Singleton x) (conj h28 h23))))
             (psi sp)) as gp.

specialize (h17b gp).
assert (h32:Ensembles.In fam gp).
  unfold fam. 
  apply Im_intro with (exist (fun C=>Finite C /\ Included C E) _ (conj h28 h23)). constructor.
  reflexivity.
specialize (h17b h32). 
pose proof h17b as h17. 
destruct h17 as [h33 h34 h35 h36].
red in h36.
unfold gp in h36. simpl in h36.
unfold psi in h36.
destruct h36 as [h36 h37].
assert (h38:Ensembles.In  (Gen_Ens_p (Singleton x)
                    (h0
                       (exist
                          (fun C : Ensemble (bt B) =>
                           Finite C /\ Included C E) 
                          (Singleton x) (conj h28 h23)))) x).
  apply gen_ens_includes_p. constructor.
specialize (h37 (exist _ _ h38)).
simpl in h37.
destruct constructive_definite_description as [k h39].
simpl in h37.
pose proof h39 as h39'.
destruct h39' as [h39a h39b].
red in h39b.
assert (h40: Ensembles.In (ba_p_ens (B_F sp)) x).
  unfold B_F.
  rewrite ba_p_ens_gen_p_eq.
  unfold sp. simpl.
  apply gen_ens_includes_p. constructor.
assert (h41:Ensembles.In (finc_bp sp) (exist _ _ h40)).
  unfold finc_bp, sp.
  simpl.
  apply Im_intro with (exist _ _ (In_singleton  _ x)). constructor.
  apply proj1_sig_injective. simpl.
  reflexivity.
specialize (h39b (exist _ _ h41)).
unfold g_F, sp in h39b. simpl in h39b.
assert (h42: g
           (exist (Ensembles.In E) x
              (h9
                 (exist (fun C : Ensemble (bt B) => Finite C /\ Included C E)
                    (Singleton x) (conj h28 h23))
                 (exist
                    (Ensembles.In
                       (finc_bp
                          (exist
                             (fun C : Ensemble (bt B) =>
                              Finite C /\ Included C E) 
                             (Singleton x) (conj h28 h23))))
                    (exist
                       (Ensembles.In
                          (ba_p_ens
                             (B_F
                                (exist
                                   (fun C : Ensemble (bt B) =>
                                    Finite C /\ Included C E) 
                                   (Singleton x) (conj h28 h23))))) x h40)
                    h41))) =   g (exist (fun x0 : bt B => Ensembles.In E x0) x h22)).
  f_equal. apply proj1_sig_injective. reflexivity.
rewrite <- h42 at 1.
rewrite  h39b at 1.
assert (h43:k
          (exist
             (Ensembles.In
                (Gen_Ens_p (Singleton x)
                   (h0
                      (exist
                         (fun C : Ensemble (bt B) => Finite C /\ Included C E)
                         (Singleton x) (conj h28 h23))))) x h38) = 
             k
     (exist
        (Ensembles.In
           (ba_p_ens
              (B_F
                 (exist (fun C : Ensemble (bt B) => Finite C /\ Included C E)
                    (Singleton x) (conj h28 h23))))) x h40)).
   f_equal. apply proj1_sig_injective. reflexivity.
rewrite <- h43.
rewrite h37 at 1.
f_equal. 
pose h20 as h20'.
pose proof (f_equal (@ba_p_ens (bt B))  h19) as h44.
unfold btp, directed_ba_p, ba_to_ba_p, Btype_p, bc_sig_set_conv, directed_bcp in h44.
simpl in h44.
unfold ba_sig_set_conv in h44. simpl in h44.
unfold ba_p_ens, bc_sig_set_conv in h44.
simpl in h44.
unfold btp, directed_ba_p, ba_to_ba_p, Btype_p in h20'. 
unfold Bc_p, ba_sig_set_conv in h20'.
unfold bc_sig_set_conv in h20'. simpl in h20'.
rewrite (transfer_r_sig_set_eq _ _ h44 h20).
apply proj1_sig_injective.
simpl.
reflexivity.

(* ->  *)
intro h2.
destruct h2 as [f [h2 h3]].
red in h3.
intros F h4 h5 a h6. 
assert (h7:f (el_prod B a) = 0).
rewrite h6.
apply homo_zero. assumption.
unfold el_prod in h7.
unfold el_prod_compose.
rewrite <- h7 at 1.
rewrite homo_times_set; auto.
apply times_set_functional.
rewrite im_im.
apply im_ext_in.
intros x h8.
specialize (h3 (exist _ _(h5 _ h8))).
simpl in h3.  
unfold eps.
assert (h9: f (if a |-> x then x else - x) =
            (if a |-> x then (f x) else - (f x))).
  destruct (a|->x); auto.
  rewrite homo_comp; auto.
rewrite h9 at 1.
rewrite <- h3 at 1.
destruct (a |-> x). 
unfold sig_fun_app.
destruct (classic_dec (Ensembles.In E x)) as [h10 | h11].
f_equal. apply proj1_sig_injective. simpl. reflexivity.
contradict h11.
apply h5; auto.
rewrite <- h3.
unfold sig_fun_app.
destruct (classic_dec (Ensembles.In E x)) as [h10 | h11].
f_equal. f_equal. apply proj1_sig_injective. simpl. reflexivity.
contradict h11.
apply h5; auto.
Qed.


End HomoExtensionCriterion.