(* Copyright (C) 2014, Daniel Wyckoff, except for the portions so labeleled
which I got from Daniel Schepler*)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)


(* Some of these lemmas are copied and pasted from Daniel Schepler's
  "Zorns Lemma" package.  Such lemmas are notated "Schepler", otherwise
  "Wyckoff". *)

Require Import Specif.
Require Import ProofIrrelevance.
Require Import ClassicalChoice.

Axiom prop_ext : forall (P Q : Prop), 
  (P <-> Q) -> P = Q.


(*Wyckoff*)
Lemma neq_sym : forall {T:Type} (a b:T), a <> b -> b <> a.
intros ? ? ? h1. intro. subst. contradict h1. apply eq_refl.
Qed.

(*Wyckoff*)
Lemma neq_sym_iff : forall {T:Type} (a b:T), a <> b <-> b <>a.
intros; split; apply neq_sym.
Qed.

(*Wyckoff*)
Lemma eq_sym_iff : forall {T:Type} (a b:T), a = b <-> b = a.
intros; split; auto.
Qed.


(*Wyckoff*)
Lemma eq2 : forall {T:Type} {x y y':T}, 
                  (x = y) -> (x = y') -> (y = y').
intros; subst; auto.
Defined.

(*Wyckoff*)
Lemma eq2' : forall {T:Type} {x x' y:T}, 
                  (x = y) -> (x' = y) -> (x = x').
intros; subst; auto.
Defined.


(*Wyckoff*)
Lemma eq_trans : forall {T:Type} {x y z:T}, 
                  (x = y) -> (y = z) -> (x = z).
intros; subst; auto.
Defined.


(*Wyckoff*)
Lemma eq_trans' : forall {T:Type} {x y z:T}, 
                    (y = x) -> (z = y) -> (z = x).
intros; subst; auto.
Defined.



Section utilities.
Variable P : Prop.
Variable T : Type.
Variable Q : T -> Prop.

(*Wyckoff*)
Lemma prop_dis_forall : 
  (forall (x:T), P \/ (Q x)) -> 
  (P \/ (forall (y:T), (Q y))).
intro h1.
assert (h2: P \/ ~P).
  tauto.
case h2.
tauto.
intro h3.
right.
intro y.
assert (h4: P \/ Q y).
  apply h1.
tauto.
Qed.

End utilities.

Section exist_fact.
(*Wyckoff*)
Lemma existTexist : forall (A:Type) (P:A->Prop) (x y:A) (p:(P x)) (q:(P y)),
  existT P x p = existT P y q -> exist P x p = exist P y q.
intros A P x y p q h1.
assert (h2: sig_of_sigT (existT P x p) = sig_of_sigT (existT P y q)).
rewrite h1. reflexivity.
apply h2.
Qed.

(*Schepler*)
Lemma proj1_sig_injective: forall {A:Type} (P:A->Prop)
  (a1 a2:{x:A | P x}), proj1_sig a1 = proj1_sig a2 -> a1 = a2.
Proof.
intros.
destruct a1.
destruct a2.
simpl in H.
apply existTexist.
apply subsetT_eq_compat; trivial.
Qed.

(*Wyckoff*)
Lemma exist_injective : forall {U:Type} (P:U->Prop) (x y:U) (p:P x) (q:P y),
  exist _ x p = exist _ y q -> x = y.
intros U P x y p q h1.
pose proof (f_equal (@proj1_sig _ _) h1) as h2.
simpl in h2.
assumption.
Qed.


(*Wyckoff*)
Lemma unfold_sig : forall {T:Type} (P:T->Prop) (x:{t:T | P t}), 
  x = exist _ (proj1_sig x) (proj2_sig x).
intros T P x.
destruct x.
simpl. reflexivity.
Qed.

(*Wyckoff*)
Lemma simpl_sig : forall {T:Type} (P:T->Prop) (a:{x:T | P x})
                         (pf:P (proj1_sig a)),
  exist _ _ pf = a.
intros T P a h1.
destruct a as [a h2].
simpl.
apply proj1_sig_injective.
simpl.
reflexivity.
Qed.


(* Schepler *)
Lemma choice_on_dependent_type: forall {A:Type} {B:A->Type}
  (R:forall a:A, B a -> Prop),
  (forall a:A, exists b:B a, R a b) ->
  exists f:(forall a:A, B a), forall a:A, R a (f a).
Proof.
intros.
destruct (choice (fun (a:A) (b:{a:A & B a}) =>
  match b with existT a' b0 => a=a' /\ R a' b0 end))
as [choice_fun].
intro a.
destruct (H a) as [b].
exists (existT (fun a:A => B a) a b).
split; trivial.
assert (f0:forall a:A, {b:B a | R a b}).
intro.
pose proof (H0 a).
destruct (choice_fun a) as [a' b].
destruct H1.
destruct H1.
exists b; trivial.
exists (fun a:A => proj1_sig (f0 a)).
intro.
destruct (f0 a) as [b].
exact r.
Qed.

End exist_fact.


(*Wyckoff*)
Lemma conditional_correspondence : 
  forall (P Q:Prop) (h1:{P}+{~P}) (h2:{Q}+{~Q}),
    (if h1 then true else false) =
    (if h2 then true else false) -> (P<->Q).
intros P Q h1 h2 h3.
assert (h4:forall (P' Q':Prop) (h1:{P'}+{~P'}) (h2:{Q'}+{~Q'}),
             (if h1 then true else false) =
             (if h2 then true else false) -> (P'->Q')).
  intros P' Q' h1' h2' h3'.
  destruct h1' as [h1a | h1b]; destruct h2' as [h2a | h2b].
  auto. discriminate. discriminate.
  tauto.
red. split.
apply (h4 _ _ h1 h2 h3).
symmetry in h3.
apply (h4 _ _ h2 h1 h3). 
Qed.

(*Wyckoff*)
Definition iff1 {P Q:Prop} (pf:P <-> Q) (pfp:P) : Q.
rewrite pf in pfp. refine pfp.
Defined.

(*Wyckoff*)
Definition iff2 {P Q:Prop} (pf:P <-> Q) (pfq:Q) : P.
rewrite <- pf in pfq. refine pfq.
Defined.

(*Wyckoff*)
Lemma contrapos : forall (P Q:Prop), (P -> Q) -> (~Q -> ~P).
intros; tauto.
Qed.

(*Wyckoff*)
Definition simpl_prop (P:Prop) : Prop.
simpl P. refine P.
Defined.

(*Wyckoff*)
Definition simpl_pf {P:Prop} (pf:P) : (simpl_prop P).
simpl pf. refine pf.
Defined.