(* Copyright (C) 2014, Daniel Wyckoff*)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)


Require Import ProofIrrelevance.
Require Export BoolAlgBasics.
Require Import Topology.
Require Import SetUtilities.
Require Import LogicUtilities.
Require Import InfiniteOperations.


Lemma empty_closed_reg : forall (X:TopologicalSpace), 
  regular _ (Empty_set (point_set X)).
intro X.
red.
rewrite closure_empty.
rewrite interior_empty.
reflexivity.
Qed.

Lemma full_closed_reg : forall (X:TopologicalSpace),
  regular _ (Full_set (point_set X)).
intro X.
red.
rewrite closure_full.
rewrite interior_full.
reflexivity.
Qed.


Section RegularOpenAlgebra.
Variable T:Type.
Variable X:TopologicalSpace.

(*"Lemma 1. If P <= Q, then Q - ' <= P - ' ."*)

Lemma comp_closure_inclusion_quasi_sym : forall (P Q:(Ensemble (point_set X))),
  Included P Q -> Included (Q - ') (P - ').
intros P Q h1.
apply complement_inclusion.
apply closure_increasing.
assumption.
Qed.

(*"Lemma 2. If P is open, then P <= P - ' - ' ."*)
Lemma open_included_reg : forall (P:(Ensemble (point_set X))), open P ->
  Included P (P - ' - ').
intros P h0.
pose proof (closure_inflationary P) as h1.
pose proof (complement_inclusion _ _ h1) as h2.
pose proof (Complement_Complement _ P) as h3.
rewrite <- h3 in h0.
change (open (P ' ')) with (closed (P ')) in h0.
pose proof (closure_minimal _ _ h0 h2) as h4.
pose proof (complement_inclusion _ _ h4) as h5.
rewrite Complement_Complement in h5.
assumption.
Qed.

(*" Lemma 3. If P is open, then P - ' = P - ' - ' - '"*)
Lemma open_regularization_comp_clo : forall (P:Ensemble (point_set X)), 
  open P -> (P - ') = P - ' - ' - '.
intros P h1.
apply Extensionality_Ensembles.
red.
split.
(* >= *)
Focus 2.
apply comp_closure_inclusion_quasi_sym.
apply open_included_reg.
assumption.
(* <= *)
assert (h2:open (P - ')).
  pose proof (closure_closed P) as h2.
  red in h2.
  assumption.
apply open_included_reg.
assumption.
Qed.


Corollary open_regular_comp_clo : forall (P:Ensemble (point_set X)), 
  open P -> regular _ (P - ').
intros P h1.
red.
rewrite interior_eq. 
apply open_regularization_comp_clo.
assumption.
Qed.

Lemma regularization_increasing : forall (P Q:Ensemble (point_set X)), 
  Included P Q -> Included (P - ' - ') (Q - ' - ').
intros P Q h1.
pose proof (comp_closure_inclusion_quasi_sym _ _ h1) as h2.
apply comp_closure_inclusion_quasi_sym; assumption.
Qed.

(*"Lemma 4. If P and Q are open, then (P /\ Q)-'-' = P-'-' /\ Q-'-'"*)

Lemma reg_preserves_int : forall (P Q:Ensemble (point_set X)), 
  open P -> open Q -> (Intersection P Q) - ' - ' = 
  Intersection (P - ' - ') (Q - ' - ').
intros P Q h1 h2.
apply Extensionality_Ensembles.
red. split.
(* <= *) 
  assert (h3:Included (Intersection P Q) P). auto with sets.
  assert (h4:Included (Intersection P Q) Q). auto with sets.
  pose proof (regularization_increasing _ _ h3).
  pose proof (regularization_increasing _ _ h4).
  constructor; auto with sets.
(* >= *)
assert (h0:forall (P0 Q0:Ensemble (point_set X)), 
  open P0 -> 
  Included (Intersection P0 (Q0 - ' - ')) (Intersection P0 Q0 - ' - ')).
  intros P0 Q0 hp0. (*hq0.*)
  assert (h3:Included (Intersection P0 (Q0 -)) (Intersection P0 Q0 -)).
    red.
    intros x h3.
    apply meets_every_open_neighborhood_impl_closure.
    intros U h4 h5.
    destruct h3 as [x h6 h7].
    pose proof (closure_impl_meets_every_open_neighborhood _ _ _ h7) as h8.
    pose proof (open_intersection2 _ _ _ h4 hp0) as h9.
    assert (h10:In (Intersection U P0) x). auto with sets.
    pose proof (h8 _ h9 h10) as h11. clear h8. 
    inversion h11 as [a h12].
    apply Inhabited_intro with a. 
    destruct h12 as [? ? h12].
    destruct h12.
    repeat split; assumption. 
  pose proof (complement_inclusion _ _ h3) as h4.
  rewrite comp_int in h4.
  pose proof (closure_increasing _ _ h4) as h5.
  pose proof (complement_inclusion _ _ h5) as h6.
  pose proof (Complement_Complement _ P0) as h7. 
  rewrite  <- h7 in hp0.
  pose proof (closure_union (P0 ') (Q0 - ')) as h8.
  rewrite h8 in h6.
  rewrite comp_union in h6.
  assert (h9: P0 ' - ' = P0).
    change (open (P ' ')) with (closed (P ')) in h1.
    pose proof (closure_fixes_closed _ hp0) as h9.
    pose proof (f_equal (closure (X:=X)) h9).
    congruence.
  rewrite h9 in h6. 
  assumption.
pose proof (h0 P Q h1) as h3.
assert (h4:open (P - ' - ')).
  change (open (P - ' - ')) with (closed (P - ' -)).
  apply closure_closed.
pose proof (h0 (P - ' - ') Q h4) as h5.
pose proof (h0 Q P h2) as h6.
rewrite Intersection_commutative in h6.
pose proof (regularization_increasing _ _ h6) as h7.
assert (h8:Intersection Q P = Intersection P Q). 
  apply Intersection_commutative.
rewrite h8 in h7.
rewrite open_regularization_comp_clo with (Intersection P Q - ').
auto with sets.
apply closure_closed.
Qed.

Corollary intersection_regular : forall (P Q:Ensemble (point_set X)), 
  regular _ P -> regular _ Q -> regular _ (Intersection P Q).
intros P Q h1 h2.
rewrite regular_iff.
rewrite reg_preserves_int; try (apply regular_open; assumption).
rewrite regular_iff in h1.
rewrite regular_iff in h2.
rewrite <- h1. rewrite <- h2.
reflexivity.
Qed.


Definition Btype_ro := {S:(Ensemble (point_set X)) | regular _ S}.
Definition BS_ro := Full_set Btype_ro.

Definition Bplus_ro (P Q:Btype_ro) : Btype_ro.
destruct P as [P h1].
destruct Q as [Q h2].
refine (exist _ ((Union P Q) - ' - ') _).
apply open_regular_comp_clo.
apply closure_closed.
Defined.

Definition Btimes_ro (P Q:Btype_ro) : Btype_ro.
destruct P as [P h1].
destruct Q as [Q h2].
refine (exist _ (Intersection P Q) _).
apply intersection_regular; assumption.
Defined.

Definition Bone_ro : Btype_ro := 
  (exist _ (Full_set (point_set X)) (full_closed_reg X)).

Definition Bzero_ro : Btype_ro := 
  (exist _ (Empty_set (point_set X)) (empty_closed_reg X)).

Definition Bcomp_ro (S:Btype_ro) : Btype_ro.
destruct S as [S h1].
refine (exist _ (S - ') _).
apply open_regular_comp_clo.
apply regular_open.
assumption.
Defined.

Definition Bc_ro := Build_Bconst 
  Btype_ro BS_ro Bplus_ro Btimes_ro Bone_ro Bzero_ro Bcomp_ro.

Infix "ro+" := (Bplus_ro) (at level 50, left associativity).
Infix "ro*" := (Btimes_ro) (at level 40, left associativity).

Definition ro0 := Bzero_ro.
Definition ro1 := Bone_ro.
Notation "'ro-' x" := (Bcomp_ro x) (at level 30).


(*"The proof of (7) is quite easy."*)

Lemma complement_closure_union : forall (P Q:Ensemble (point_set X)), 
  Union P Q - ' = Intersection (P - ') (Q - ').
intros P Q.
pose proof (closure_union P Q) as h1.
rewrite h1.
apply comp_union.
Qed.

Lemma regular_comp_clo_inj : forall (P Q:Ensemble (point_set X)), 
  regular _ P -> regular _ Q -> P - ' = Q - ' -> P = Q.
intros P Q h1 h2 h3.
pose proof (f_equal (@closure X) h3) as h4.
pose proof (f_equal (@Ensembles.Complement (point_set X)) h4) as h5.
red in h1. rewrite interior_eq in h1.
red in h2. rewrite interior_eq in h2.
congruence.
Qed.

Lemma assoc_sum_ro : forall P Q R : Btype_ro, P ro+ (Q ro+ R) = P ro+ Q ro+ R.
intros P Q R.
pose proof (proj2_sig (P ro+ (Q ro+ R))) as h1.
pose proof (proj2_sig (P ro+ Q ro+ R)) as h2.
unfold Btimes_ro, Bplus_ro.
destruct P as [P h3]. destruct Q as [Q h4]. destruct R as [R h5].
simpl in h1. simpl in h2.
apply existTexist.
apply subsetT_eq_compat.
apply regular_comp_clo_inj; try assumption.

assert (h6:open (Union P (Union Q R - ' - '))).
  apply open_union2; [apply regular_open; assumption | 
    apply closure_closed].
pose proof (open_regularization_comp_clo _ h6) as h7.
rewrite complement_closure_union in h7 at 1.
assert (h8: open (Union Q R)).
  apply open_union2; apply regular_open; assumption.
pose proof (open_regularization_comp_clo _ h8) as h9.
rewrite <- h9 in h7.
rewrite complement_closure_union in h7 at 1.
rewrite <- h7.

assert (h10:open (Union (Union P Q - ' - ') R)).
  apply open_union2; [apply closure_closed |
    apply regular_open; assumption].
pose proof (open_regularization_comp_clo _ h10) as h11.
rewrite complement_closure_union in h11 at 1.
assert (h12: open (Union P Q)).
  apply open_union2; apply regular_open; assumption.
pose proof (open_regularization_comp_clo _ h12) as h13.
rewrite <- h13 in h11.
rewrite complement_closure_union in h11 at 1.
rewrite <- h11.
apply assoc_prod_psa.
Qed.

Lemma assoc_prod_ro : forall P Q R : Btype_ro, P ro* (Q ro* R) = P ro* Q ro* R.
intros P Q R.
destruct P. destruct Q. destruct R.
unfold Btimes_ro, Bplus_ro.
apply existTexist.
apply subsetT_eq_compat.
apply assoc_prod_psa.
Qed.

Lemma comm_sum_ro : forall P Q: Btype_ro, P ro+ Q = Q ro+ P.
intros P Q.
destruct P. destruct Q. 
unfold Btimes_ro, Bplus_ro.
apply existTexist.
apply subsetT_eq_compat.
do 4 f_equal.
auto with sets.
Qed.

Lemma comm_prod_ro : forall P Q : Btype_ro, P ro* Q = Q ro* P.
intros P Q.
destruct P. destruct Q. 
unfold Btimes_ro, Bplus_ro.
apply existTexist.
apply subsetT_eq_compat.
apply Intersection_commutative.
Qed.

Lemma abs_sum_ro : forall P Q:Btype_ro, P ro+ P ro* Q = P.
intros P Q.
destruct P as [P h1]. destruct Q as [Q h2]. 
unfold Btimes_ro, Bplus_ro.
apply existTexist.
apply subsetT_eq_compat.

rewrite dist_prod_psa.
assert (h5:Union P P = P). 
  apply Extensionality_Ensembles; split; red; auto with sets.
  intros ? h6. destruct h6; assumption.
rewrite h5.
assert (h6:Included P (Union P Q)). auto with sets.
rewrite inclusion_iff_intersection_eq in h6.
rewrite h6.
red in h1. rewrite interior_eq in h1.
symmetry. assumption.
Qed.

Lemma abs_prod_ro : forall P Q:Btype_ro, P ro* (P ro+ Q) = P.
intros P Q.
destruct P as [P h1]. destruct Q as [Q h2]. 
unfold Btimes_ro, Bplus_ro.
apply existTexist.
apply subsetT_eq_compat.
pose proof (regular_open _ _ h1) as h3.
pose proof (regular_open _ _ h2) as h4.
pose proof (open_union2 _ _ _ h3 h4) as h5.
red in h1.
rewrite interior_eq in h1.
rewrite h1 at 1.
rewrite <- reg_preserves_int; try assumption.
assert (h6: Included P (Union P Q)). auto with sets.
rewrite inclusion_iff_intersection_eq in h6.
rewrite h6.
rewrite h1 at 2.
reflexivity.
Qed.

Lemma dist_sum_ro : forall (Q R P:Btype_ro), P ro* (Q ro+ R) = 
  (P ro* Q) ro+ (P ro* R).
unfold Btimes_ro, Bplus_ro.
intros Q R P.
destruct Q as [Q h1]. destruct R as [R h2]. destruct P as [P h3].
apply existTexist.
apply subsetT_eq_compat.
red in h3. 
pose proof (interior_eq _ (P -)) as h4.
rewrite <- h3 in h4.
rewrite h4 at 1.
rewrite <- reg_preserves_int.
rewrite dist_sum_psa with _ Q R P.
reflexivity.
apply regular_open. assumption.
apply regular_open in h1.
apply regular_open in h2.
apply open_union2; assumption.
Qed.

Lemma dist_prod_ro : forall (Q R P:Btype_ro), 
  P ro+ Q ro* R = (P ro+ Q) ro* (P ro+ R).
unfold Btimes_ro, Bplus_ro.
intros Q R P.
destruct Q as [Q h1]. destruct R as [R h2]. destruct P as [P h3].
apply existTexist.
apply subsetT_eq_compat.
rewrite dist_prod_psa.
apply reg_preserves_int; apply open_union2; 
  apply regular_open; assumption.
Qed.

Lemma comp_prod_ro : forall (P:Btype_ro), P ro* (ro- P) = ro0.
intro P.
destruct P as [P h1]. unfold ro0. unfold Bzero_ro.
unfold Btimes_ro.
simpl.
apply existTexist.
apply subsetT_eq_compat.
pose proof (excl_middle_empty (P -)) as h2.
pose proof (closure_inflationary P) as h3.
pose proof (intersection_preserves_inclusion _ _ (P - ') h3) as h4.
rewrite Intersection_commutative in h4.
rewrite Intersection_commutative in h2.
rewrite h2 in h4.
apply Extensionality_Ensembles; red; split; auto with sets.
Qed.

(*"Lemma 5. The boundary of an open set is a nowhere dense closed set."*)
Lemma boundary_open_set : forall (P:Ensemble (point_set X)), open P ->
  let B := boundary P in closed B /\ now_dense B.
Proof.
intros P h1 B.
pose proof (open_boundary_difference _ _ h1) as h2.
rewrite setminus_int_complement in h2.
assert (h3:closed B).
unfold B. rewrite h2.
apply closed_intersection2;  
[apply closure_closed | red; rewrite Complement_Complement; assumption].
split.
(*closed*)
assumption.
(*now_dense*)
rewrite now_dense_iff2.
pose proof (closure_fixes_closed _ h3) as h4.
rewrite h4.
intros U h5 h6.
apply NNPP.
intro h7.
apply not_empty_Inhabited in h7.
destruct h7 as [x h7].
assert (h8:In (P -) x). unfold B in h6. 
  rewrite h2 in h6. red in h6. specialize (h6 x h7).
  inversion h6. assumption.
pose proof 
  (closure_impl_meets_every_open_neighborhood _ P x h8 _ h5 h7) as h9.
assert (h10:Intersection P U = Empty_set _).
  assert (h11:Included U (P ')). unfold B in h6. rewrite h2 in h6.
    red. intros y h11. red in h6. specialize (h6 _ h11).
    auto with sets. destruct h6; assumption.
  pose proof (included_empty_complement_int U (P ')) as h12.
  rewrite h12 in h11.
  rewrite Complement_Complement in h11.
  rewrite Intersection_commutative in h11.
  assumption.
apply Inhabited_not_empty in h9.
contradiction.
Qed. 

Lemma comp_sum_ro : forall P:Btype_ro, P ro+ (ro- P) = ro1.
intros P.
unfold Btimes_ro, Bplus_ro, ro1. unfold Bone_ro.
destruct P as [P h1].
simpl. 
apply existTexist.
apply subsetT_eq_compat.
apply regular_open in h1.
pose proof (boundary_open_set _ h1) as h2.
destruct h2 as [h2l h2r].
rewrite now_dense_iff4 in h2r.
pose proof (closure_fixes_closed _ h2l) as h3.
rewrite h3 in h2r.
pose proof (open_boundary_difference _ _ h1) as h4.
rewrite setminus_int_complement in h4.
rewrite h4 in h2r.
rewrite comp_int in h2r.
rewrite Complement_Complement in h2r.
red in h2r.
rewrite Union_commutative in h2r.
rewrite h2r.
rewrite complement_full. rewrite closure_empty.
apply complement_empty.
Qed.

Definition RO := Build_Bool_Alg Bc_ro (eq_refl BS_ro) assoc_sum_ro assoc_prod_ro
  comm_sum_ro comm_prod_ro abs_sum_ro abs_prod_ro dist_sum_ro dist_prod_ro
  comp_sum_ro comp_prod_ro.

Variable It:Type.
Lemma sup_regular : forall P:It->(Ensemble (point_set X)), 
  regular _ ((IndexedUnion P) - ' - ').
intro.
rewrite regular_iff.
rewrite <- open_regularization_comp_clo; [reflexivity | apply closure_closed].
Qed.

Lemma inf_regular : forall P:It->(Ensemble (point_set X)), 
  regular _ (IndexedIntersection P - ' - ').
intro.
rewrite regular_iff.
rewrite <- open_regularization_comp_clo; [reflexivity | apply closure_closed].
Qed.

(*End RegularOpenAlgebra.*)

Let Bt := (Btype (Bc RO)).

(*". . . the Boolean order relation for regular
open sets is the same as ordinary set-theoretic inclusion."*)

Lemma le_iff_inclusion_ro : forall (P Q:Bt), 
  le P Q <-> Included (proj1_sig P) (proj1_sig Q).
intros P Q.
unfold le.
rewrite eq_ord.
simpl.
unfold Btimes_ro.
destruct P as [P]. destruct Q as [Q].
simpl.
split.
(* -> *)
intro h1. apply exist_injective in h1. 
apply inclusion_iff_intersection_eq; assumption.
(* <- *)
intro h1.
apply existTexist.
apply subsetT_eq_compat.
apply inclusion_iff_intersection_eq. assumption.
Qed.

Definition proj1_sig_ind_ro {It:Type} (P:It->Bt) := fun (i:It) => proj1_sig (P i).

(*"Lemma 6. The supremum of a family {P_i} of regular open sets is (\/P_i) - ' - '"*)
Lemma sup_ro : forall (P:It->Bt), 
  Sup P (exist _ (IndexedUnion (proj1_sig_ind_ro P) - ' - ') 
    (sup_regular (proj1_sig_ind_ro P))).
intros P.
do 3 red.
split.
(* Upper bound *)
red.
intros Pi h1.
apply le_iff_inclusion_ro.
simpl.
assert (h2:Included (proj1_sig Pi) (IndexedUnion (proj1_sig_ind_ro P))).
  red.
  intros x h3.
  destruct h1 as [i ? ? h4].
  apply indexed_union_intro with i.
  unfold proj1_sig_ind_ro.
  rewrite h4 in h3.
  assumption.
assert (h3:open (IndexedUnion (proj1_sig_ind_ro P))).
  apply open_indexed_union.
  intro i. apply regular_open.
  unfold proj1_sig_ind_ro.
  apply proj2_sig.
pose proof (open_included_reg _ h3) as h4.
auto with sets.
(* Least Upper Bound *)
intros Q h1.
destruct Q as [Q h2].
assert (h3: Included (IndexedUnion (proj1_sig_ind_ro P)) Q).
  red.
  intros x h4.
  destruct h4 as [i x h5].
  red in h1.
  assert (h6:In (Im (Full_set It) P) (P i)).
    apply Im_intro with i.
    apply Full_intro. reflexivity.
  specialize (h1 _ h6).
  rewrite le_iff_inclusion_ro in h1.
  simpl in h1.
  auto with sets.
rewrite le_iff_inclusion_ro.
simpl.
red in h2.
clear h1.
rewrite interior_eq in h2.
rewrite h2.
do 2 (apply comp_closure_inclusion_quasi_sym).
assumption.
Qed.

Lemma inf_ro : forall (P:It->Bt), 
  Inf P (exist _ (IndexedIntersection (proj1_sig_ind_ro P) - ' - ') 
    (inf_regular (proj1_sig_ind_ro P))).
Proof.
intros P.
do 3 red.
split.
(* Lower bound *)
red.
intros Pi h1.
apply le_iff_inclusion_ro.
simpl.
assert (h2:Included (IndexedIntersection (proj1_sig_ind_ro P)) (proj1_sig Pi)).
  red.
  intros x h3.
  destruct h1 as [i ? ? h4].
  rewrite h4.
  unfold proj1_sig_ind_ro in h3.
  inversion h3 as [? h5].
  apply h5.
destruct Pi as [Pi h3].
simpl.
simpl in h2.
red in h3. clear h1. rewrite interior_eq in h3.
rewrite h3.
do 2 (apply comp_closure_inclusion_quasi_sym).
assumption.
(* Greatest Lower Bound *)
intros Q h1.
destruct Q as [Q h2].
assert (h3:Included Q (IndexedIntersection (proj1_sig_ind_ro P))).
  red.
  intros x h4.
  unfold proj1_sig_ind_ro.
  red in h1.
  constructor.
  intro i.
  assert (h5:In (Im (Full_set It) P )(P i)).
    apply Im_intro with i.
    apply Full_intro. reflexivity.
  specialize (h1 _ h5).
  rewrite le_iff_inclusion_ro in h1.
  simpl in h1.
  auto with sets.
rewrite le_iff_inclusion_ro.
simpl.
red in h2.
clear h1.
rewrite interior_eq in h2.
rewrite h2.
do 2 (apply comp_closure_inclusion_quasi_sym).
assumption.
Qed.

End RegularOpenAlgebra.
