(* Copyright (C) 2015 Daniel Wyckoff *)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)

Require Import FiniteBags.
Require Import SetUtilities.
Require Import Arith.
Require Import TypeUtilities.
Require Import FiniteMaps.
Require Import ProofIrrelevance.
Require Import ListUtilities.
Require Import NPeano.
Require Import DecidableDec.
Require Import Description.
Require Import LogicUtilities.
Require Import Infinite_sets.
Require Import FunctionalExtensionality.
 
Lemma card_pairwise_disjoint : 
   forall {T:Type} (F:Family T) (pff:Finite F),
    (forall S:Ensemble T, Ensembles.In F S -> Finite S) ->
    pairwise_disjoint F ->
    card_fun1 (FamilyUnion F) =
    plus_bag_nat (im_set_bag F pff card_fun1).
intros T F h1.
pose proof (finite_set_list_no_dup _ h1) as h2. 
destruct h2 as [l h2].
destruct h2 as [h2l h2r].
generalize dependent F. revert h2r.
induction l as [|A l h1]; simpl.
intros h1 F h2 h3 h4 h5. subst.
pose proof (im_set_bag_empty (@card_fun1 T)) as him.
assert (hpfeq:h2 = (Empty_is_finite (Ensemble T))). apply proof_irrelevance. subst.
rewrite im_set_bag_empty. rewrite plus_bag_nat_empty.
rewrite empty_family_union. apply card_fun1_empty.
intros h2 F h4 h5 hin h6. 
pose proof (no_dup_cons_nin _ _ h2) as h3.
pose proof (f_equal (fun S=>Subtract S A) h5) as h7. simpl in h7.
rewrite list_to_set_in_iff in h3.
rewrite sub_add_compat_nin in h7; auto.
pose proof (no_dup_cons _ _ h2) as h8.
pose proof (subtract_preserves_finite F A h4) as h9.
pose proof (incl_subtract F A) as h11. 
assert (h10:forall S:Ensemble T, Ensembles.In (Subtract F A) S ->
                                 Finite S).
  intros S h10. 
  specialize (hin _ (h11 _ h10)). assumption.
pose proof (pairwise_disjoint_incl _ _ _ h6 h11) as h12.
specialize (h1 h8 _ h9 h7 h10 h12). 
subst. 
rewrite family_union_add.
pose proof (sub_add_compat_nin _ _ h3) as heq.
rewrite <- heq at 1; auto. 
pose proof (hin _ (Add_intro2 _ (list_to_set l) A)) as h13.
assert (h14:forall S:Ensemble T, Ensembles.In (list_to_set l) S -> Finite S). 
  intros S h15. apply hin; auto. left; auto.
assert (h15:Finite (list_to_set l)).
  eapply Finite_downward_closed. apply h4. auto with sets.
pose proof (Finite_Finite_Union _  h14 h15) as h16.
pose proof (sub_add_compat_nin _ _ h3) as h17.
rewrite h17.
assert (h18:h4 = Add_preserves_Finite _ _ _ h15). apply proof_irrelevance.
subst.
rewrite plus_bag_nat_im_set_bag_add.
pose proof (pairwise_disjoint_add_family_union _ _ h3 h6) as h18.
red in h18. rewrite comm_prod_psa in h18.
pose proof (card_disj_union' _ _ h13 h16 h18) as h19.
pose proof (card_fun_card_fun1_compat _ (Union_preserves_Finite _ _ _ h13 h16)) as h21. 
rewrite <- h21.
rewrite <- h19.
simpl in h17. simpl in h1. rewrite h17 in h1 at 1.
pose proof (subsetT_eq_compat _ _ _ _ h9 h15 h17) as h22.
dependent rewrite -> h22 in h1.
rewrite <- h1.
rewrite (card_fun_card_fun1_compat _ h13).
rewrite (card_fun_card_fun1_compat _ h16).
ring.
assumption.
Qed.


Lemma card_cart_prod : 
  forall {T U:Type} (A:Ensemble T) (B:Ensemble U),
    Finite A -> Finite B ->
    card_fun1 (cart_prod A B) = (card_fun1 A) * (card_fun1 B).
intros T U A B h1 h2.
destruct (eq_dec A (Empty_set _)) as [hae | hnae].
subst. rewrite cart_prod_empty. do 2 rewrite card_fun1_empty.
ring.
destruct (eq_dec B (Empty_set _)) as [hbe | hnbe].
subst. rewrite cart_prod_empty'. do 2 rewrite card_fun1_empty.
ring.
pose proof (not_empty_Inhabited _ _ hnbe) as h11.
destruct h11 as [b h11].
pose proof (not_empty_Inhabited _ _ hnae) as h12.
destruct h12 as [a h12].
pose proof (cart_prod_fin _ _ h1 h2) as h3.
rewrite cart_prod_eq. rewrite cart_prod_eq in h3.
pose proof (Finite_Finite_Union_rev _  h3) as h4.
assert (h6:forall S : Ensemble (T * U),
        Ensembles.In
          [S0 : Ensemble (T * U)
          | exists y : U, Ensembles.In B y /\ S0 = cart_prod A (Singleton y)]
          S -> Finite S).
  intros S h7. destruct h7 as [h7]. destruct h7 as [y h7].
  destruct h7 as [h7l h7r]. subst. 
  apply cart_prod_sing_fin; auto.
assert (hpw: pairwise_disjoint
         [S : Ensemble (T * U)
         | exists y : U, Ensembles.In B y /\ S = cart_prod A (Singleton y)] ).
  red. intros X Y h7 h8 h9.
  destruct h8 as [h8]. destruct h8 as [y h8]. destruct h8 as [h8l h8r].
  destruct h9 as [h9]. destruct h9 as [y' h9]. destruct h9 as [h9l h9r].
 subst.
 red.
 apply Extensionality_Ensembles; red; split; auto with sets.
 red. intros pr h10. destruct h10 as [pr h10l h10r].
 destruct h10l as [h10l]. destruct h10l as [h10a h10b].
 destruct h10r as [h10r]. destruct h10r as [h10c h10d].
 destruct h10b; destruct h10d; subst.
 contradict h7. reflexivity.
pose proof (card_pairwise_disjoint _ h4 h6 hpw) as h5.
rewrite h5.
assert (h7:card_fun1 [S : Ensemble (T * U)
        | exists y : U, Ensembles.In B y /\ S = cart_prod A (Singleton y)] = card_fun1 B).
  pose [pr:(Ensemble (T*U))*U | Ensembles.In B (snd pr) /\ fst pr = cart_prod A (Singleton (snd pr))] as P.
  assert (h8:dom_rel P = [S : Ensemble (T * U)
     | exists y : U, Ensembles.In B y /\ S = cart_prod A (Singleton y)]).
    apply Extensionality_Ensembles.
    red. split. 
    red. intros S h9.
    destruct h9 as [h9]. destruct h9 as [y h9].
    destruct h9 as [h9]. simpl in h9.
    constructor. exists y. assumption.
    red. intros S h9.
    destruct h9 as [h9]. constructor. destruct h9 as [y h9].
    exists y. constructor. simpl. assumption.
  assert (h9:ran_rel P = B).
    apply Extensionality_Ensembles.
    red. split.
    red. intros y h9. destruct h9 as [h9]. 
    destruct h9 as [x h9]. destruct h9 as [h9]. simpl in h9.
    destruct h9; assumption.
    red. intros y h9. constructor.
    exists (cart_prod A (Singleton y)). constructor. simpl.
    split; auto.
  assert (h10:self_fp P).
    red. rewrite h8. rewrite h9.
    constructor.
    intros S h10.
    destruct h10 as [h10]. destruct h10 as [y h10].
    destruct h10 as [h10l h10r].
    exists y. red. split. split; auto. constructor. simpl.
    split; auto.
    intros y' h11'. destruct h11' as [h11l h11r].
    destruct h11r as [h11']. destruct h11' as [h11a h11b].
    simpl in h11b. 
    rewrite h10r in h11b.
    assert (h13:Ensembles.In (cart_prod A (Singleton y)) (a, y)).
      constructor; simpl. split; auto; try constructor.
    rewrite h11b in h13. inversion h13 as [h14]. clear h13.
    simpl in h14. destruct h14 as [? h14]. destruct h14; auto.
    intros pr h10. destruct h10 as [h10]. 
    destruct h10 as [h10l h10r]. 
    split. constructor. exists (snd pr). split; auto. assumption.

  red in h10. rewrite h8 in h10. rewrite h9 in h10.
  pose (fin_map_intro _ _ b h4 h2 P h10) as F.
  assert (h12':bij F).
    red. split.
    red. intros X Y h12' h13 h14.
    do 2 rewrite fin_map_app_compat in h14.
    pose proof (fps_to_f_s_compat h10 b _ h12') as h15.
    pose proof (fps_to_f_s_compat h10 b _ h13) as h16. 
    assert (h17:P = fin_map_to_fps F).
      pose proof (fin_map_to_fps_compat_s _ _ b h4 h2 P h10) as h17.
      rewrite h17. f_equal.
    assert (h18:fps_to_f P h10 b X = fps_to_f (fin_map_to_fps F) (fp_fin_map_to_fps F) b X). 
      pose proof (subsetT_eq_compat _ _ _ _ h10 (fp_fin_map_to_fps F) h17) as h19.
      dependent rewrite -> h19. reflexivity.
    rewrite h14 in h18.
    rewrite h18 in h15.
    inversion h15 as [h19]. clear h15.
    simpl in h19. destruct h19 as [h19l h19r].
    inversion h16 as [h20]. clear h16. simpl in h20.
    destruct h20 as [h20l h20r].
    assert (h21:(fps_to_f (fin_map_to_fps F) (fp_fin_map_to_fps F) b Y) =  (fps_to_f P h10 b Y)).
      pose proof (subsetT_eq_compat _ _ _ _ h10 (fp_fin_map_to_fps F) h17) as h19.
      dependent rewrite -> h19. reflexivity.
   rewrite h21 in h19r.
   rewrite <- h19r in h20r. rewrite h20r. reflexivity.
   red. intros y h12'.
   exists (cart_prod A (Singleton y)). constructor. constructor.
   exists y. split; auto.
   assert (h14:Ensembles.In (fin_map_to_fps F) (cart_prod A (Singleton y), y)).
     unfold F. rewrite <- fin_map_to_fps_compat_s.
     constructor. simpl. split; auto.
   pose proof (fin_map_to_fps_fin_map_app_compat F ((cart_prod A (Singleton y)), y) h14) as h13. simpl in h13. simpl. assumption.
eapply bij_dom_ran_card_eq'. apply h12'.
rewrite <- h7.
assert (h8:forall S:Ensemble (T*U), Ensembles.In  [S : Ensemble (T * U)
        | exists y : U, Ensembles.In B y /\ S = cart_prod A (Singleton y)] S -> card_fun1 S = card_fun1 A).
  intros S h9. destruct h9 as [h9]. destruct h9 as [y h9].
  destruct h9 as [h9l h9r].
  subst.
apply card_cart_prod_sing'; auto.
pose proof (plus_bag_nat_im_set_bag_eq_f _ h4 card_fun1 (card_fun1 A) h8) as h9.
rewrite h9.
ring.
Qed.

(*See subsequent lemma for easing the finitude to just one set.*)
Lemma bij_ex_impl_eq_card : 
  forall {T U:Type} (A:Ensemble T) (B:Ensemble U) 
         (pfa:Finite A) (pfb:Finite B) (P:T->U->Prop),
    (forall x:T, Ensembles.In A x -> 
                 exists! y:U, Ensembles.In B y /\ P x y) ->
    (forall y:U, Ensembles.In B y -> 
                 exists! x:T, Ensembles.In A x /\ P x y) ->
    card_fun1 A = card_fun1 B.
intros T U A B h1 h2 P h3 h4.
destruct (eq_dec B (Empty_set _)) as [h5 | hinh].
subst.
assert (h7:A = Empty_set _). apply NNPP.
  intro h5. apply not_empty_Inhabited in h5.
  destruct h5 as [a h5].
  specialize (h3 _ h5). destruct h3 as [y h3]. red in h3.
  destruct h3 as [h3]. destruct h3 as [h3]. contradiction.
subst.
rewrite card_fun1_empty. rewrite card_fun1_empty. reflexivity.
apply not_empty_Inhabited in hinh.
destruct hinh as [d hinh].
pose [pr:T*U | exists (pfa:Ensembles.In A (fst pr)),
               exists (pfb:Ensembles.In B (snd pr)),
                 proj1_sig (constructive_definite_description _ (h3 _ pfa)) = snd pr /\ 
                 proj1_sig (constructive_definite_description _ (h4 _ pfb)) = fst pr] as S.
assert (h5:self_fp S).
  red. split.
  intros x h5. destruct h5 as [h5]. destruct h5 as [y h5].
  exists y. red. split. split; auto. 
  constructor. exists x. assumption.
  intros y' h6. destruct h6 as [h6l h6r].
  destruct h5 as [h5]. destruct h5 as [h5l h5r]. destruct h5r as [h5a h5b]. 
  simpl in h5l. simpl in h5b. simpl in h5a.
  destruct constructive_definite_description as [b h8].
  destruct constructive_definite_description as [a h9].
  simpl in h5b. destruct h5b; subst.
  destruct h9 as [h9l h9r]. destruct h8 as [h10l h10r].
  destruct h6r as [h6r]. destruct h6r as [h11 h12]. destruct h12 as [h12 h13].
  destruct constructive_definite_description as [b' h8'].
  destruct constructive_definite_description as [a' h9'].
  simpl in h13. destruct h13; subst. simpl in h9'. simpl in h8'.
  destruct h9' as [h9a' h9b']. destruct h8' as [h8a' h8b'].
  pose proof (h3 _ h5l) as h10.
  destruct h10 as [y'' h10]. red in h10.
  destruct h10 as [h10a h10b]. destruct h10a as [h10a' h10b'].
  pose proof (h10b _ (conj h8a' h8b')). subst.
  pose proof (h10b _ (conj h10l h10r)). subst.
  reflexivity.
  intros pr h5. destruct h5 as [h5]. destruct h5 as [h5 h6].
  destruct h6 as [h6 h7].
  destruct constructive_definite_description as [b h8].
  destruct constructive_definite_description as [a h9].
  simpl in h7. destruct h7; subst.
  split. constructor. exists (snd pr). constructor. simpl.
  exists h5. exists h6. split.
  destruct constructive_definite_description as [y' h10]. simpl.
  destruct h10 as [h10l h10r].
  destruct h9 as [h9l h9r].
  pose proof (h3 _ h5) as h11. destruct h11 as [y h11].
  red in h11. destruct h11 as [h11l h11r].
  destruct h11l as [h11a h11b].
  pose proof (h11r _ (conj h10l h10r)). subst.
  pose proof (h11r _ h8). assumption.
  destruct constructive_definite_description as [a h10]. simpl.
  pose proof (h4 _ h6) as h11.
  destruct h11 as [a' h11]. red in h11. destruct h11 as [h11a h11b].
  pose proof (h11b _ h10). subst.
  pose proof (h11b _ h9). assumption.
  constructor. exists (fst pr).
  constructor.
  simpl. exists h5. exists h6.
  destruct constructive_definite_description as [b h10].
  destruct constructive_definite_description as [a h11].
  simpl. split.
  pose proof (h3 _ h5) as h12. destruct h12 as [b' h12r].
  red in h12r. destruct h12r as [h12a h12b].
  pose proof (h12b _ h10); subst.
  pose proof (h12b _ h8); subst. reflexivity.
  pose proof (h4 _ h6) as h12. destruct h12 as [a' h12r].
  red in h12r. destruct h12r as [h12a h12b].
  pose proof (h12b _ h11); subst.
  pose proof (h12b _ h9); subst. reflexivity.
red in h5.
assert (h6:dom_rel S = A).
  apply Extensionality_Ensembles.
  red. split. red. intros x h6.
  destruct h6 as [h6]. destruct h6 as [y h6].
  destruct h6 as [h6]. simpl in h6. destruct h6 as [h6]. assumption.
  red. intros x h6.
  constructor.
  exists  (proj1_sig
             (constructive_definite_description
                (fun y : U => Ensembles.In B y /\ P x y)
                (h3 _ h6))).
  constructor. simpl. exists h6.
  destruct constructive_definite_description as [y h7].
  simpl.
  destruct h7 as [h7l h7r].
  exists h7l. split; auto.
  destruct constructive_definite_description as [x' h8].
  simpl.
  destruct h8 as [h8l h8r].
  pose proof (h4 _ h7l) as h8.
  destruct h8 as [x'' h8]. red in h8.
  destruct h8 as [h8a h8b].
  pose proof (h8b _ (conj h8l h8r)); subst.
  pose proof (h8b _ (conj h6 h7r)); subst.
  reflexivity. 
rewrite h6 in h5.
assert (h7:ran_rel S = B).
  apply Extensionality_Ensembles.
  red. split.
  red.
  intros y h7. destruct h7 as [h7]. destruct h7 as [x h7].
  destruct h7 as [h7]. destruct h7 as [h7 h8]. destruct h8 as [h8 h9].
  simpl in h8. assumption.
  red. intros y h7. constructor.
  exists (proj1_sig
             (constructive_definite_description
                (fun x : T => Ensembles.In A x /\ P x y)
                (h4 _ h7))).
  constructor. simpl.
  destruct constructive_definite_description as [x h8]. simpl.
  destruct h8 as [h8l h8r].
  exists h8l. exists h7. split.
  destruct constructive_definite_description as [y' h9].
  simpl. 
  pose proof (h3 _ h8l) as h10.
  destruct h10 as [y'' h10]. red in h10.
  destruct h10 as [h10l h10r].
  pose proof (h10r _ (conj h7 h8r)). 
  pose proof (h10r _ h9). congruence.
  destruct constructive_definite_description as [x' h9].
  simpl.
  pose proof (h4 _ h7) as h10.
  destruct h10 as [x'' h10]. red in h10.
  destruct h10 as [h10l h10r].
  pose proof (h10r _ h9). 
  pose proof (h10r _ (conj h8l h8r)). congruence.
rewrite h7 in h5.
pose (fin_map_intro _ _ d h1 h2 _ h5) as F.
apply bij_dom_ran_card_eq' with F.
red. split.
red.
intros x x' h8 h9 h10.
pose proof (in_fin_map_to_fps F x  h8) as h11.
pose proof (in_fin_map_to_fps F x' h9) as h12.
unfold F in h11. unfold F in h12.
rewrite <- fin_map_to_fps_compat_s in h11.
rewrite <- fin_map_to_fps_compat_s in h12.
unfold F in h10. rewrite h10 in h11.
destruct h11 as [h11]. simpl in h11. destruct h11 as [h11a h11b].
destruct h11b as [h11b h11c]. 
destruct constructive_definite_description as [b h13].
destruct (constructive_definite_description _ 
          (h4 (fps_to_f S h5 d x') h11b)) as [a h14].
simpl in h11c. destruct h11c as [h11d h11e].
destruct h13 as [h13l h13r].
pose proof (h4 _ h13l) as h15.
destruct h15 as [x'' h15]. red in h15. destruct h15 as [h15l h15r].
pose proof (h15r _ (conj h8 h13r)).
rewrite <- h11d in h14.
pose proof (h15r _ h14).
inversion h12 as [h16]. clear h12. simpl in h16.
destruct h16 as [h16 h17]. destruct h17 as [h17 h18].
destruct constructive_definite_description as [b' h19].
destruct (constructive_definite_description _
          (h4 (fps_to_f S h5 d x') h17)) as [a' h20].
simpl in h18. destruct h18 as [h18l h18r].
rewrite <- h11d in h20.
pose proof (h15r _ h20). congruence.
red.
intros b h8.
exists (proj1_sig (constructive_definite_description _ (h4 _ h8))).
split.
destruct constructive_definite_description as [a h9].
simpl. destruct h9; auto.
destruct constructive_definite_description as [a h9].
simpl.
destruct h9 as [h9l h9r].
pose proof (fps_to_f_s_compat h5 d _ h9l) as h10.
destruct h10 as [h10]. simpl in h10.
destruct h10 as [h10 h11]. destruct h11 as [h11 h12].
destruct constructive_definite_description as [y h13].
destruct (constructive_definite_description _ 
           (h4 (fps_to_f S h5 d a) h11)) as [x h14].
simpl in h12. destruct h12 as [h12l h12r].
pose proof (h3 _ h10) as h15.
destruct h15 as [y' h15]. red in h15.
destruct h15 as [h15l h15r].
rewrite <- h12r in h15r.
destruct h14 as [h14l h14r]. 
pose proof (h15r _ (conj h11 h14r)).
rewrite <- h12r in h13.
pose proof (h15r _ h13).
rewrite <- h12r in h9r.
pose proof (h15r _ (conj h8 h9r)). congruence.
Qed.

(*like above function, but with only one required finitude.*)
Lemma bij_ex_impl_eq_card' : 
  forall {T U:Type} (A:Ensemble T) (B:Ensemble U) 
         (pfa:Finite A) (P:T->U->Prop),
    (forall x:T, Ensembles.In A x -> 
                 exists! y:U, Ensembles.In B y /\ P x y) ->
    (forall y:U, Ensembles.In B y -> 
                 exists! x:T, Ensembles.In A x /\ P x y) ->
    card_fun1 A = card_fun1 B.
intros T U A B h1 P h2 h3.
assert (h4:Finite B).
apply NNPP.
intro h4.
assert (h5:~FiniteT (sig_set B)).
  intro h5. apply FiniteT_sig_Finite in h5. contradiction.
pose (fun x:sig_set B => 
        (proj1_sig (constructive_definite_description _ (h3 _ (proj2_sig x))))) as f.
rewrite <- Finite_FiniteT_iff in h5.
assert (h6:Finite (Im (Full_set (sig_set B)) f)).
  eapply Finite_downward_closed.
  apply h1. red. intros x h6.
  destruct h6 as [x h6]. subst.
  unfold f. destruct constructive_definite_description as [a h7].
  simpl. destruct h7; assumption.
pose proof (Pigeonhole_bis _ _ _ _ h5 h6) as h7.
contradict h7.
red.
intros x y h7.
destruct x as [x h8]. destruct y as [y h9]. unfold f in h7.
destruct constructive_definite_description as [a h10].
destruct constructive_definite_description as [a' h11].
simpl in h7. subst. simpl in h10. simpl in h11.
pose proof (h3 _ h9) as h12.
destruct h12 as [a h12]. red in h12.
destruct h12 as [h12l h12r].
pose proof (h12r _ h11). subst.
destruct h10 as [h10l h10r].
specialize (h2 _ h10l).
destruct h2 as [b h2]. red in h2. destruct h2 as [h2l h2r].
destruct h12l as [h12a h12b].
pose proof (h2r _ (conj h8 h10r)). subst.
pose proof (h2r _ (conj h9 h12b)). subst.
apply proj1_sig_injective.
simpl. reflexivity.
apply (bij_ex_impl_eq_card _ _ h1 h4 _ h2 h3).
Qed.

Section Injectors.

Lemma finite_rel_classes_im_rel_sig_fun :
  forall {T U:Type} {A:Ensemble T} (f:sig_set A->U),
    Finite A -> Finite (rel_classes_im_rel_sig_fun f).
intros T U A f h1.
rewrite rel_classes_im_rel_eq_inv_im_singletons'.
rewrite im_im.
rewrite finite_full_sig_iff in h1.
unfold rel_classes_im_rel_sig_fun.
apply finite_image; auto.
Qed.


Lemma ex_same_im_subset_sig_inj : 
  forall {T U:Type} {A:Ensemble T},
    Finite A ->
    forall (f:sig_set A->U),
    exists (B:Ensemble T) (pf:Included B A),
      Ensembles.In (same_im_subsets_sig f) B /\
         FunctionProperties.injective (restriction_sig f B pf). 
intros T U A h1 f. 
pose proof (finite_rel_classes_im_rel_sig_fun f h1) as h2.
pose proof (finite_set_list_no_dup _ h2) as h3.
destruct h3 as [l h3]. destruct h3 as [h3a h3b].
revert A h1 f h2 h3a h3b.
induction l as [|B l h1]. 
intros A h1 f h2 h3 h4. 
simpl in h3. apply empty_rel_classes_im_rel_eq_inv_im_singletons in h3.
 subst.
exists (Empty_set _).  exists (inclusion_reflexive _).
split. constructor. exists (inclusion_reflexive _).
f_equal.
apply functional_extensionality.
intro x. contradict (proj2_sig x).
red. intro x. contradict (proj2_sig x).
intros A h2 f h3 h4 h5.
assert (h16:In B (B::l)). auto with datatypes.
rewrite list_to_set_in_iff in h16.
rewrite <- h4 in h16. 
pose proof (partition_rel_classes_im_rel_sig_fun f) as h17.
red in h17. destruct h17 as [h17 h18].
assert (h19:Included B A).
  rewrite <- h18.
  red. intros x h19. 
  destruct h16 as [S h16]. clear h18. subst.
  apply family_union_intro with (Im S (@proj1_sig _ _)).
  unfold rel_classes_im_rel_sig_fun.
  apply Im_intro with S; auto. assumption.
pose proof (setminus_inc A B) as h6.
assert (h7:Finite (Setminus A B)).
  apply Finite_downward_closed with A; auto.
specialize (h1 (Setminus A B) h7 (restriction_sig f _ h6)).
pose proof (finite_rel_classes_im_rel_sig_fun 
              (restriction_sig f (Setminus A B) h6) h7) as h8.
specialize (h1 h8).
pose proof (no_dup_cons_nin _ _ h5) as h9.
pose proof (no_dup_cons _ _ h5) as h10. 
assert (h11: rel_classes_im_rel_sig_fun (restriction_sig f (Setminus A B) h6) =
       list_to_set l). 
    pose proof (rel_classes_im_rel_sig_fun_setminus A B f h16) as h12.
  assert (h13:h6 = setminus_inc A B). apply proof_irrelevance. 
  clear h18. subst. rewrite h12.
  rewrite h4.
rewrite subtract_remove_compat.
simpl.
destruct (eq_dec B B) as [h13 | h14].
rewrite <- (remove_not_in' _ _ h9) at 1.
reflexivity. contradict h14. reflexivity.
specialize (h1 h11 h10).
destruct h1 as [C h1].
destruct h1 as [h12 [h13 h14]]. 
pose proof (inh_rel_classes_im_rel_sig_fun f _ h16) as h20.
destruct h20 as [b h20].
exists (Add C b).   
assert (h21:Included (Add C b) A).
  red. intros x h21. destruct h21 as [x h21l | x h21r].
  auto with sets. destruct h21r. auto with sets.
exists h21. 
split.
constructor. exists h21.
destruct h13 as [h13]. destruct h13 as [h13 h22].
rewrite im_full_sig_add.
unfold restriction_sig. simpl. unfold restriction_sig in h22.
simpl in h22.
assert (h24: (fun x : sig_set C =>
           f
             (exist (Ensembles.In A) (proj1_sig x)
                (h6 (proj1_sig x) (h13 (proj1_sig x) (proj2_sig x))))) = 
             (fun x : sig_set C =>
         f
           (exist (Ensembles.In A) (proj1_sig x)
              (h21 (proj1_sig x) (incl_add C b (proj1_sig x) (proj2_sig x)))))).
  apply functional_extensionality.
  intro x. f_equal. apply proj1_sig_injective. simpl. reflexivity.
rewrite h24 in h22.
rewrite <- h22.
unfold restriction_sig in h14. simpl in h14.
pose proof (full_sig_decompose_setminus_incl _ _ h19) as h25.
rewrite h25 at 1.
pose proof (im_elt_of_rel_classes_im_rel_sig_fun f B h19 h16 _ h20) as h26.
rewrite im_union. do 2 rewrite im_im.
rewrite h26 at 1.
unfold Add.
f_equal. f_equal.
apply functional_extensionality.
intro x. f_equal. apply proj1_sig_injective. simpl.
reflexivity.
f_equal. f_equal. apply proj1_sig_injective. simpl.
reflexivity.
unfold restriction_sig in h14. simpl in h14.
unfold restriction_sig. simpl.
red.
intros x y h22. red in h14.
destruct x as [x h23], y as [y h24]. simpl in h22.
apply proj1_sig_injective. simpl.
destruct h23 as [x h23a | x h23b], h24 as [y h24a | y h24b].
specialize (h14 (exist _ _ h23a) (exist _ _ h24a)). simpl in h14.
assert (h25:h6 x (h12 x h23a) = h21 x (Union_introl T C (Singleton b) x h23a)). apply proof_irrelevance.
assert (h26:h6 y (h12 y h24a) = h21 y (Union_introl T C (Singleton b) y h24a)). apply proof_irrelevance.
rewrite h25, h26 in h14.
specialize (h14 h22). apply exist_injective in h14. assumption.
destruct h24b.
assert (h24:Ensembles.In B x).
  symmetry in h22.
  pose proof (rel_classes_im_rel_sig_fun_consistent_membership f B h16 _ _ h22 h20) as h24.
  simpl in h24.
  assumption.
pose proof (h12 _ h23a) as h25.
destruct h25. contradiction.
destruct h23b.
assert (h24:Ensembles.In B y).
  pose proof (rel_classes_im_rel_sig_fun_consistent_membership f B h16 _ _ h22 h20) as h24.
  simpl in h24.
  assumption.
pose proof (h12 _ h24a) as h26.
destruct h26.
contradiction.
destruct h23b, h24b. reflexivity.
Qed.


Lemma finite_inhabited_sig_fun_injectors : 
  forall {T U:Type} {A:Ensemble T} 
         (f:sig_set A->U),
    Finite A ->
    Inhabited (sig_fun_injectors f).
intros T U A f h1.
unfold sig_fun_injectors.
pose proof (ex_same_im_subset_sig_inj h1 f) as h2.
destruct h2 as [B [h2 [h3 h4]]].
apply Inhabited_intro with (existT _ B (restriction_sig f B h2)).
constructor.
simpl.
split; auto. split.
red.
exists h2.
intro x.
unfold restriction_sig.
reflexivity.
destruct h3 as [h3].
destruct h3 as [h3 h5].
assert (h3 = h2). apply proof_irrelevance. subst.
assumption.
Qed.



End Injectors.
