/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            string.c
 *
 *  Thu Aug 26 22:29:25 2004
 *  Copyright  2004  Gergely POLONKAI
 *  polesz@techinfo.hu
 ****************************************************************************/

#include <gtk/gtk.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>

/*
 * WrapString()
 * Wraps a string into words. Words can be separated by the chars which seps
 * contains. If retlist is not NULL, a pointer is returned in it to the word
 * list. The return value is the number of words.
 */
signed int
WrapString(gchar *string, gchar *seps, gchar ***retlist)
{
	gchar *a, **ret;
	int *start = NULL, *end = NULL, current_sep = 0, previous_sep = 1, wnum = 0, i, j;
	signed int cword = -1;
	
	if (string == NULL)
		return -1;
	if (*string == 0)
		return 0;

	for (a = string; *a; a++)
	{
		if (strchr(seps, *a))
			current_sep = 1;
		else
			current_sep = 0;

		if (!current_sep && previous_sep)
			wnum++;

		previous_sep = current_sep;
	}

  if (retlist == NULL)
    return wnum;
	
	if (wnum == 0)
		return 0;
	
	if ((start = g_malloc(wnum * sizeof(int))) == NULL)
    return -1;
  
	if ((end = g_malloc(wnum * sizeof(int))) == NULL)
  {
    g_free(start);
    return -1;
  }
  
  if ((ret = g_malloc((wnum + 1) * sizeof(char *))) == NULL)
  {
    g_free(end);
    g_free(start);
    return -1;
  }
	
	current_sep = 0;
	previous_sep = 1;
	
	for (a = string; *a; a++)
	{
		if (strchr(seps, *a))
			current_sep = 1;
		else
			current_sep = 0;
		
		if (previous_sep && !current_sep) {
			start[++cword] = (a - string);
      end[cword] = strlen(string);
    }
		if (!previous_sep && current_sep)
			end[cword] = (a - string);
		
		previous_sep = current_sep;
	}
	
	for (i = 0; i < wnum; i++)
	{
    if ((ret[i] = g_malloc(end[i] - start[i] + 1)) == NULL)
    {
      for (j = 0; j < i; j++)
        g_free(ret[j]);
      g_free(ret);
      g_free(end);
      g_free(start);
      return -1;
    }
    memset(ret[i], 0, end[i] - start[i] + 1);
    strncpy(ret[i], string + start[i], end[i] - start[i]);
	}

  *retlist = ret;

  return wnum;
}

/*
 * str_eq()
 * Finds if two strings are the same. It can make case sensitive and
 * case-insensitive comparisons, depending on the value of cs.
 */
gboolean
str_eq(gchar *s1, gchar *s2, gboolean cs)
{
	gchar *a;

	if (!s1 && !s2)
		return TRUE;

	if (!s1 || !s2)
		return FALSE;

	if (strlen(s1) != strlen(s2))
		return FALSE;

	if (cs)
		return (strcmp(s1, s2) == 0) ? TRUE : FALSE;

	for (a = s1; *a; a++)
	{
		if (toupper(*a) != toupper(*(s2 + (a - s1))))
			return FALSE;
	}
	
	return TRUE;
}

/*
 * valist_to_string()
 * Creates a string from a va_list.
 */
signed int
valist_to_string(gchar **ret, gchar *fmt, va_list list)
{
	gchar *retval;
	int needed_len;
	
	if ((retval = g_malloc(strlen(fmt) + 1)) == NULL)
	{
		return -1;
	}
	memset(retval, 0, strlen(fmt) + 1);
	
	needed_len = vsnprintf(retval, strlen(fmt), fmt, list);
	
	if (needed_len < 0)
	{
		return -1;
	}
	
	if ((retval = g_realloc(retval, needed_len + 2)) == NULL)
	{
		return -1;
	}
	memset(retval, 0, needed_len + 2);
	
	if (vsnprintf(retval, needed_len + 1, fmt, list) < 0)
	{
		return -1;
	}
	
	if (ret)
	{
		*ret = retval;
	}
	
	return needed_len;
}

gboolean
is_numeric(gchar *str)
{
	gchar *a;
	
	if (!str)
		return FALSE;
	
	for (a = str; *a; a++)
	{
		if (!isdigit(*a))
			return FALSE;
	}
	
	return TRUE;
}
