/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            functions.h
 *
 *  Sat Aug 21 23:45:09 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ****************************************************************************/

#ifndef _BC_FUNCTIONS_H
# define _BC_FUNCTIONS_H

# include <gtk/gtk.h>

/* main.c */
void ExitCleanly(void);
gboolean ChangeMode(gchar);
signed int Connect(gchar *, short);
void DataReady(gpointer, gint, GdkInputCondition);

/* callbacks.c */
void destroy_event(GtkWidget *, gpointer);
gboolean delete_event(GtkWidget *, GdkEvent *, gpointer);
void activate_event(GtkWidget *, gpointer);
int commandline_keypress(GtkEntry *, GdkEventKey *, gpointer);
int vte_clicked(GtkEntry *, gpointer);
void grab_focus(GtkWidget *, gpointer);

/* widgets.c */
int CreateMainWindow(void);
void FeedMessageToTerminal(gboolean, gchar *, ...);
void FeedErrorToTerminal(gboolean, gchar *, ...);
void FeedInfoToTerminal(gboolean, gchar *, ...);

/* config.c */
gboolean ConfigInit(void);
gchar *CreateVersionString(gboolean);

/* string.c */
signed int WrapString(gchar *, gchar *, gchar ***);
gboolean str_eq(gchar *, gchar *, gboolean);
signed int valist_to_string(gchar **, gchar *, va_list);
gboolean is_numeric(gchar *);
gboolean trim(gchar *, gchar *, gchar *);

/* commands.c */
void ProcessLine(gchar *);

#endif
