/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            botcommander.h
 *
 *  Sun Aug 22 22:30:54 2004
 *  Copyright  2004  Gergely POLONKAI
 *  polesz@techinfo.hu
 ***************************************************************************/
/***************************************************************************
 * This file should be included before any other include files.
 ***************************************************************************/

#ifndef _BC_BOTCOMMANDER_H
# define _BC_BOTCOMMANDER_H

/* Include config.h if we have it */
# ifdef HAVE_CONFIG_H
#  include "config.h"
# endif /* HAVE_CONFIG_H */

/* If the PACKAGE macro is not defined, define it here. It is recommended to
 * append "hardcoded" at the end of the name, so you will see if something went
 * wrong (PACKAGE is defined in config.h)
 */
# ifndef PACKAGE
#  define PACKAGE "hardcoded BotCommander"
# endif /* PACKAGE */
/* If the VERSION macro is not defined, define it here. It is recommended to
 * append "hardcoded" at the end of the name, so you will see if something went
 * wrong (VERSION is defined in config.h)
 */
# ifndef VERSION
#  define VERSION "hardcoded 1.0pre2"
# endif /* VERSION */

/* This is where our configuration is stored in gconf. Must begin and end with a
 * slash (/). */
# if (CONFIG_BACKEND == CB_GCONF2)
#  define GCONF_CONFIG_ROOT "/apps/botcommander/"
# endif

/* Default values of configuration options */
# define DEFAULT_SCROLL_ON_OUTPUT TRUE
# define DEFAULT_TRANSPARENT_BACKGROUND FALSE
# define DEFAULT_BACKGROUND_SATURATION 1.0
# define DEFAULT_TEAROFF_MENUS FALSE
# define DEFAULT_DEBUG_MODE TRUE
# define DEFAULT_VTE_FONT "Monotype 12"
# define DEFAULT_CHANGE_TO_MESSAGE TRUE
# define DEFAULT_AUTOSAVE_ON_EXIT TRUE
# define DEFAULT_COMMANDLINE_HISTORY_LENGTH 100

/* It is recommended to leave these alone */
/* Allow interpretation of bold ANSI code (default TRUE) */
# define ALLOW_BOLD TRUE
/* Allow beeping when a BEL is arrived (default TRUE) */
# define AUDIBLE_BELL TRUE
/* Allow blinking when a BEL is arrived (default FALSE) */
# define VISIBLE_BELL FALSE

/*
 * The default place of the samba-like or xml config file if configure forgot to
 * define one. ~ is interpreted as $HOME, like in bourne-like shells.
 */
# ifndef DEFAULT_CONFIG
#  define DEFAULT_CONFIG "~/.botcommanderrc"
# endif

/*
 * Telnet codes. See telnet protocol definition (RFC 854) and telnet echo option
 * (RFC 875) for details.
 */
# define TLN_WILL "\373" /* Will */
# define TLN_WONT "\374" /* Won't */
# define TLN_IAC  "\377" /* Interpret As Command */
# define TLN_ECHO "\001" /* Echo */

/*
 * These sequences are used by eggdrop to tell us it doesn't want us to echo the
 * following input. This typically means that the next requested input is a
 * password (well, means this in eggdrop), so we should set the command line to
 * a password entry (thus, making typed characters to appear as asterisks).
 */
# define TLN_WILLECHO "\377\373\001"
# define TLN_WONTECHO "\377\374\001"

#endif /* _BC_BOTCOMMANDER_H */
