/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            variables.h
 *
 *  Sat Aug 21 23:27:50 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ***************************************************************************/
/***************************************************************************
 * Variable definitions
 ***************************************************************************/

#ifndef _BC_VARIABLES_H
# define _BC_VARIABLES_H

#if HAVE_CONFIG_H
# include "config.h"
#endif

# if (CONFIG_BACKEND == CB_GCONF2)
#  include <gconf/gconf-client.h>
# endif
# if (CONFIG_BACKEND == CB_SAMBA)
#  include <stdio.h>
# endif

# include <gtk/gtk.h>
# include <netinet/in.h>

# include "typedefs.h"

/* Global data which almost never changes */
extern static_data_t static_data;
/* Global configuration data (active in the current session) */
extern global_config_data_t config_data;
/* Data of the current connection. Will be moved into tab-specific data later. */
/* The internal botlist */
extern botrecord_t *bot_list;
/* Version of the program. Used many times. */
extern gchar *package_version;
/* Tab list */
extern tab_data_t *tab_list;
/* Command line history */
extern gchar **command_history;
/* Position in the command line history */
extern gint history_position;

# if (CONFIG_BACKEND == CB_GCONF2)
extern GConfClient *gconf_client;
# endif
# if (CONFIG_BACKEND == CB_SAMBA)
extern FILE *configfile;
# endif

#endif /* _BC_VARIABLES_H */
