#################################
# Blended Radiance brad_i18n.py #
#################################

##############################
# (c) Francesco Anselmo 2005 #
##############################

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import Blender

# Looking for saved keys in Blender.Registry dictionary:
registered_data = Blender.Registry.GetKey('brad')
if registered_data:
  lang  = registered_data['lang']

# ------i18n: begin
msg_Version = "0.1"
msg_ReleaseDate = "2005-01-03"
msg_Title = "brad " + msg_Version + " | " + msg_ReleaseDate

msg_Languages = ["English", "Italiano"]
msg_LanguagesIDs = ["en", "it"]

# ---------i18n: english: begin
if lang=="en":
   msg_Ok = "OK"
   msg_Yes = "Yes"
   msg_No = "No"
   msg_YesNo = ["No", "Yes"]
   msg_Cancel = "Cancel"
   msg_File = "File"
   msg_ExportFrame = "Export frame"
   msg_ExportSelectedCamera = "Export camera"
   msg_ExportAll = "Export frames"
   msg_Quit = "Quit"
   msg_Simulation = "SIMULATION"
   msg_Parameters = "Parameters"
   msg_Help = "Help"
   msg_About = "About"
   msg_AboutMsg = ["brad " + msg_Version,
                   "------------------------------",
                   "radiance exporter",
                   "and lighting simulation module",
                   "for blender",
                   "------------------------------",
                   "(c) 2005 Francesco Anselmo",
                   "<pisuke@bozzograo.net>"
                  ]
   msg_Status = "Status window"
   msg_Ready = "Ready"
   msg_Exporting = "Exporting ..."
   msg_CameraSaved = "Camera saved to file :: "
   msg_CameraNotSaved = "Cannot save camera to file :: "
   msg_SceneDirectoryCreated = "Scene directory created :: "
   msg_SceneDirectoryNotCreated = "Cannot create scene directory :: "
   msg_Frame = "Frame :: "
   msg_Help = "Help"
   msg_Options = "Options"
   msg_Preferences = "Preferences"
   msg_FrameDirectoryCreated = "Frame directory created :: "
   msg_FrameDirectoryNotCreated = "Cannot create frame directory :: "
   msg_Finished = "Finished. "
   msg_Exported = "The scene has been saved into :: "
   msg_CameraSceneSaved = "Camera saved for frame :: "
   msg_CameraSceneNotSaved = "Cannot save camera for frame :: "
   msg_SavingAreaLamp = "Saving area lamp :: "
   msg_SavingSphericalLamp = "Saving spherical lamp :: "
   msg_Mesh = "Mesh :: "
   msg_NumberMaterials = "Number of materials :: "
   msg_TooManyVertices = "Too many vertices :: "
   msg_SavingCone = "Cone :: "
   msg_SavingCube = "Cube :: "
   msg_SavingCylinder = "Cylinder :: "
   msg_SavingPlane = "Plane :: "
   msg_SavingSphere = "Sphere :: "
   msg_SavingTorus = "Torus :: "
   msg_Alert = "Attention!"
   msg_MissingFeature = "This feature is not yet available."
   msg_ModLib = "Materials library"
   msg_UpdateModPreview = "Update modifier preview"
   msg_Select = "Select"
   msg_Modify = "Modify"
   msg_New = "New"
   msg_Delete = "Delete"
   msg_Add = "Add"
   msg_Insert = "Insert"
   msg_Quality = "Quality"
   msg_Variability = "Variability"
   msg_Detail = "Detail"
   msg_Penumbras = "Penumbras"
   msg_Resolution = "Resolution"
   msg_Indirect = "Indirect bounces"
   msg_High = "High"
   msg_Medium = "Medium"
   msg_Low = "Low"
   msg_PictureName = "Picture name"
   msg_RawFile = "Raw picture name"
   msg_OctreeName = "Octree name"
   msg_OptionsFile = "Options file"
   msg_AmbientFile = "Ambient file"
   msg_ZFile = "Zbuffer File"
   msg_oconvOptions = "oconv options"
   msg_mkillumOptions = "mkillum options"
   msg_renderOptions = "rpict/rview options"
   msg_pfiltOptions = "pfilt options"
   msg_Exposure = "Exposure"
   msg_Eyesep = "Eye separation (stereo)"
   msg_Report = "Report"
   msg_ReportTime = "min.:"
   msg_ReportFile = "file:"
   msg_Export = "IMPORT/EXPORT"
   msg_Program = "PROGRAM"
   msg_Settings = "Settings"
   msg_Analysis = "ANALYSIS"
   msg_ExportAnimation = "Export animation"
   msg_ExportErase = "Erase export folder"
   msg_Libraries = "LIBRARIES"
   msg_LumLib = "Luminaires library"
   msg_ObjInstLib = "Object instances library"
   msg_ParObjLib = "Parametric objects library"
   msg_WeatherLib = "Weather library"
   msg_StartInteractive = "Start interactive rendering"
   msg_StartPicture = "Start picture rendering"
   msg_StartNumbers = "Start calculation"
   msg_StartDC = "Start daylight coefficients calculation"
   msg_StartHD = "Start holodeck rendering"
   msg_GetInfo = "Get information"
   msg_FalseColour = "Use false colours"
   msg_Glare = "Glare analysis"
   msg_PicConversion = "Picture conversion"
   msg_RadPar = "rad parameters"
   msg_RadZone = "Zone definition"
   msg_BasicRendering = "Simple mode"
   msg_AdvancedRendering = "Advanced mode"
   msg_ExportSelected = "Export selected items"
   msg_ExportLayers = "Export selected layers"
   msg_ExportPath = "Export path"
   msg_ExportFilename = "File name"
   msg_Layer = "Layer "
   msg_ExportSettings = "Export settings"
   msg_SelectAllLayers = "Select all layers"
   msg_UnselectAllLayers = "Unselect all layers"
   msg_GeometryDynamic = "Dynamic geometry"
   msg_GeometryDynamicHint = "The scene geometry and the sky conditions change for each frame"
   msg_GeometryStatic = "Static geometry"
   msg_GeometryStaticHint = "The scene geometry and the sky conditions don't change for each frame. Different camera positions are accounted."
   msg_ZoneInterior = [ "Exterior", "Interior" ]
   msg_ZoneMinX = "Xmin:"
   msg_ZoneMaxX = "Xmax:"
   msg_ZoneMinY = "Ymin:"
   msg_ZoneMaxY = "Ymax:"
   msg_ZoneMinZ = "Zmin:"
   msg_ZoneMaxZ = "Zmax:"
   msg_GetBBox = "Auto bbox"
   msg_GetBBoxHint = "Get bounding box according to the selected object's dimensions"
   msg_NoSelectedObject = "No selected object"
   msg_NoSelectedMesh = "No selected mesh"
   msg_SetBBox = "Bounding box has been set"
   msg_ExportCurrentFrameQuestion = "Export current frame?"
   msg_ExportRender = "Export and render"
   msg_Render = "Render"
   msg_Location = "Location"
   msg_Time = "Time"
   msg_Weather = "Sky and weather"
   msg_SavingSpotLamp = "Saving spotlight :: "
   msg_Latitude = "Latitude"
   msg_LatitudeHint = "Latitude [degrees north]"
   msg_Longitude = "Longitude"
   msg_LongitudeHint = "Longitude [degrees west]"
   msg_Meridian = "Meridian"
   msg_MeridianHint = "Reference meridiano [degrees west]"
   msg_North = "North"
   msg_Year = "Year"
   msg_YearStart = "Start year"
   msg_YearStep = "Year step"
   msg_YearEnd = "End year"
   msg_Month = "Month"
   msg_MonthStart = "Start month"
   msg_MonthStep = "Month step"
   msg_MonthEnd = "End month"
   msg_Day = "Day"
   msg_DayStart = "Start day"
   msg_DayStep = "Day step"
   msg_DayEnd = "End day"
   msg_Hour = "Hour"
   msg_HourStart = "Start hour"
   msg_HourStep = "Hour step"
   msg_HourEnd = "End hour"
   msg_Minute = "Minute"
   msg_MinuteStart = "Start minute"
   msg_MinuteStep = "Minute step"
   msg_MinuteEnd = "End minute"
   msg_Start = "Start"
   msg_Step = "Step"
   msg_End = "End"
   msg_InBetweenFrames = "Number of inbetween frames"
   msg_InBetweenFramesShort = "Inbet. frames"
   msg_TotalFrames = "Total frames"
   msg_SkyColour = "Sky colour"
   msg_R = "red"
   msg_G = "green"
   msg_B = "blue"
   msg_GroundColour = "Ground colour"
   msg_GroundAlbedo = "Ground reflectance"
   msg_SkyStaticDynamic = ["Static sky", "Dynamic sky"]
   msg_SkyStaticDynamicHint = ["The sky type is always the same, according to the specified sky",
                               "The sky type changes according to the weather data file specifications"]
   msg_WeatherDataFile = "Weather data file"
   msg_SkyType = "Sky type"
   msg_SkyTypeList = ["CIE Clear", "Intermediate", "CIE Overcast", "Uniform"]
   msg_SkyGenerator = ["gensky (CIE)", "gendaylit (Perez)"]
   msg_Coefficient = "Coefficient"
   msg_Normalise = "Normalise"
   msg_TestSky = "Sky preview"
   msg_TimeType = ["Solar time", "Local time"]
   msg_UseSkyMapping = "Use sky mapping"
   msg_SkyMap = "Sky map"
   msg_MappingType = "Mapping type"
   msg_MappingTypeCylindrical = "cylindrical"
   msg_MappingTypeAngular = "angular (fisheye)"
   msg_UseSun = "Sun"
   msg_GenskyTurbidity = "Linke turbidity"
   msg_GenskyTurbidityHint = "Linke turbidity"
   msg_GenskyManual = ["Automatic generation", "Manual input"]
   msg_GenskyInputData = "Input data"
   msg_GenskyRadianceIrradiance = ["Input radiance", "Input irradiance", "Input illuminance"]
   msg_SolarRadianceHint = "Solar radiance [W/(m2 sr)]"
   msg_SolarRadiance = ""
   msg_ZenithRadianceHint = "Zenith radiance [W/(m2 sr)]"
   msg_ZenithRadiance  = ""
   msg_DirectHorizIrradianceHint = "Direct horizontal irradiance [W/m2]"
   msg_DirectHorizIrradiance = "EES"
   msg_DirectNormalIrradianceHint = "Direct normal irradiance [W/m2]"
   msg_DirectNormalIrradiance = "EESN"
   msg_DiffuseHorizIrradianceHint = "Diffuse horizontal irradiance [W/m2]"
   msg_DiffuseHorizIrradiance = "EED"
   msg_DirectHorizIlluminanceHint = "Direct horizontal illuminance [lux]"
   msg_DirectHorizIlluminance = "EVS"
   msg_DiffuseHorizIlluminanceHint = "Diffuse horizontal illuminance [lux]"
   msg_DiffuseHorizIlluminance = "EVD"
   msg_EditorPath = "Text editor"
   msg_Mod = "M"
   msg_CurrentFrame = "Current frame"
   msg_ExportVtkPolydata = "Export selected as VtkPolydata"
   msg_ExportMethod = "Export method"
   msg_ExportMethodList = ["Instances", "xforms", "Mesh primitives"]
   msg_ExportGrid = "Export selected as grid"
   msg_SelectedVTKExported = "The selected object has been exported as a VTKPolyData object"
   msg_SelectedGridExported = "The selected object has been exported as Radiance grid"
   msg_rtraceOptions = "rtrace options"
   msg_ImportRad = "Import .rad file"
   msg_Importing = "Importing "
   msg_Done = "Done"
   msg_FileNotFound = "File not found"
   msg_importFilename = "File name"
   msg_ExportSelectedFixturesPositions = "Export selected fixtures positions as DXF"
   msg_LuminairePositionExported = "The selected fixtures positions have been exported"
   msg_postProcessOptions = "post-processing options"
   msg_generateSkyList = ["Don't generate sky", "Generate sky"]
   msg_InternalError = "Internal error"
   msg_CameraSettings = "Camera Settings"
   msg_TextureConverterPath = "Textures converter"
   msg_Browse = "Browse"
   msg_ErrorImportRad = "Error importing Radiance file"
   msg_Language = "Language"
   msg_SaveConfiguration = "Save configuration"
   msg_ConfigFileNotWritten = "Error writing configuration file"
   msg_ConfigFileWritten = "Configuration file correctly written, restart Blender to activate changes"
   msg_Debug = ["Do not print debug information","Print debug information"]
   msg_RadianceBinariesPath = "Radiance binaries path"
   msg_RadianceLibraryPath = "Radiance library path"


# ---------i18n: english: end

# ---------i18n: italiano: begin
if lang=="it":
   msg_Ok = "OK"
   msg_Yes = "Si"
   msg_No = "No"
   msg_YesNo = ["No", "Si"]
   msg_Cancel = "Annulla"
   msg_File = "File"
   msg_ExportFrame = "Esporta fotogramma"
   msg_ExportSelectedCamera = "Esporta telecamera"
   msg_ExportAll = "Esporta fotogrammi"
   msg_Quit = "Esci"
   msg_Simulation = "SIMULAZIONE"
   msg_Parameters = "Parametri"
   msg_Help = "Aiuto"
   msg_About = "Informazioni"
   msg_AboutMsg = ["brad " + msg_Version,
                   "------------------------------",
                   "modulo di esportazione verso radiance",
                   "e di simulazione illuminotecnica per blender",
                   "------------------------------",
                   "(c) 2005 Francesco Anselmo",
                   "<pisuke@bozzograo.net>"
                  ]
   msg_Status = "Finestra di stato"
   msg_Ready = "Pronto"
   msg_Exporting = "Esportazione ..."
   msg_CameraSaved = "Telecamera salvata nel file :: "
   msg_CameraNotSaved = "Impossibile salvare la telecamera nel file :: "
   msg_SceneDirectoryCreated = "Directory della scena creata :: "
   msg_SceneDirectoryNotCreated = "Impossibile creare la directory della scena :: "
   msg_Frame = "Fotogramma :: "
   msg_Help = "Aiuto"
   msg_Options = "Opzioni"
   msg_Preferences = "Preferenze"
   msg_FrameDirectoryCreated = "Directory del fotogramma creata :: "
   msg_FrameDirectoryNotCreated = "Impossibile creare la directory del fotogramma :: "
   msg_Finished = "Esportazione terminata. "
   msg_Exported = "Scena salvata in :: "
   msg_CameraSceneSaved = "Telecamera salvata per il fotogramma :: "
   msg_CameraSceneNotSaved = "Impossibile salvare la telecamera per il fotogramma :: "
   msg_SavingAreaLamp = "Sorgente luminosa poligonale :: "
   msg_SavingSphericalLamp = "Sorgente luminosa sferica :: "
   msg_Mesh = "Mesh :: "
   msg_NumberMaterials = "Numero di materiali :: "
   msg_TooManyVertices = "Troppi vertici :: "
   msg_SavingCone = "Cono :: "
   msg_SavingCube = "Cubo :: "
   msg_SavingCylinder = "Cilindro :: "
   msg_SavingPlane = "Piano :: "
   msg_SavingSphere = "Sfera :: "
   msg_SavingTorus = "Superficie toroidale :: "
   msg_Alert = "Attenzione!"
   msg_MissingFeature = "Questa funzione non e' ancora disponibile."
   msg_ModLib = "Libreria materiali"
   msg_UpdateModPreview = "Aggiorna l'anteprima"
   msg_Select = "Seleziona"
   msg_Modify = "Modifica"
   msg_New = "Nuovo"
   msg_Delete = "Cancella"
   msg_Add = "Aggiungi"
   msg_Insert = "Inserisci"
   msg_Quality = "Livello qualita'"
   msg_Variability = "Livello variabilita'"
   msg_Detail = "Livello dettaglio"
   msg_Penumbras = "Penombre"
   msg_Resolution = "Risoluzione"
   msg_Indirect = "Inter-riflessioni"
   msg_High = "Alto"
   msg_Medium = "Medio"
   msg_Low = "Basso"
   msg_PictureName = "Nome immagine"
   msg_RawFile = "Nome imm. grezza"
   msg_OctreeName = "Nome octree"
   msg_OptionsFile = "Nome file opzioni"
   msg_AmbientFile = "Nome file ambiente"
   msg_ZFile = "Nome file zbuffer"
   msg_oconvOptions = "Opzioni oconv"
   msg_mkillumOptions = "Opzioni mkillum"
   msg_renderOptions = "Opzioni rpict/rview"
   msg_pfiltOptions = "Opzioni pfilt"
   msg_Exposure = "Esposizione"
   msg_Eyesep = "Distanza interoculare"
   msg_Report = "Rendiconto"
   msg_ReportTime = "min.:"
   msg_ReportFile = "file:"
   msg_Export = "IMPORTA/ESPORTA"
   msg_Program = "PROGRAMMA"
   msg_Settings = "Impostazioni"
   msg_Analysis = "ANALISI"
   msg_ExportAnimation = "Esporta animazione"
   msg_ExportErase = "Cancella cartella di esportazione"
   msg_Libraries = "LIBRERIE"
   msg_LumLib = "Libreria apparecchi luminosi"
   msg_ObjInstLib = "Libreria istanze oggetti"
   msg_ParObjLib = "Libreria oggetti parametrici"
   msg_WeatherLib = "Libreria dati climatici"
   msg_StartInteractive = "Rendering interattivo"
   msg_StartPicture = "Rendering immagini"
   msg_StartNumbers = "Calcolo valori"
   msg_StartDC = "Calcolo daylight coefficients"
   msg_StartHD = "Rendering holodeck"
   msg_GetInfo = "Informazioni file"
   msg_FalseColour = "Falsi colori"
   msg_Glare = "Verifica abbagliamento"
   msg_PicConversion = "Conversione immagini"
   msg_RadPar = "Parametri rad"
   msg_RadZone = "Definizione zona"
   msg_BasicRendering = "Modalita' semplice"
   msg_AdvancedRendering = "Modalita' avanzata"
   msg_ExportSelected = "Esporta selezione"
   msg_ExportLayers = "Esporta lucidi selezionati"
   msg_ExportPath = "Percorso di esportazione"
   msg_ExportFilename = "Nome file"
   msg_Layer = "Lucido "
   msg_ExportSettings = "Impostazioni di esportazione"
   msg_SelectAllLayers = "Seleziona tutti i lucidi"
   msg_UnselectAllLayers = "Deseleziona tutti i lucidi"
   msg_GeometryDynamic = "Geometria dinamica"
   msg_GeometryDynamicHint = "La geometria della scena e le condizioni del cielo cambiano al variare dei fotogrammi"
   msg_GeometryStatic = "Geometria statica"
   msg_GeometryStaticHint = "La geometria della scena e le condizioni del cielo non cambiano al variare dei fotogrammi. Sono considerate soltanto le diverse posizioni della telecamera."
   msg_ZoneInterior = [ "Esterno", "Interno"]
   msg_ZoneMinX = "Xmin:"
   msg_ZoneMaxX = "Xmax:"
   msg_ZoneMinY = "Ymin:"
   msg_ZoneMaxY = "Ymax:"
   msg_ZoneMinZ = "Zmin:"
   msg_ZoneMaxZ = "Zmax:"
   msg_GetBBox = "Bbox automatica"
   msg_GetBBoxHint = "Imposta la bounding box secondo le dimensioni dell'oggetto selezionato"
   msg_NoSelectedObject = "Nessun oggetto selezionato"
   msg_NoSelectedMesh = "Nessun oggetto di tipo mesh selezionato"
   msg_SetBBox = "La bounding box  stata impostata"
   msg_ExportCurrentFrameQuestion = "Esportare il fotogramma corrente?"
   msg_ExportRender = "Esportazione e rendering"
   msg_Render = "Rendering"
   msg_Location = "Localita'"
   msg_Time = "Tempo"
   msg_Weather = "Cielo e condizioni atmosferiche"
   msg_SavingSpotLamp = "Sorgente luminosa di tipo spot :: "
   msg_Latitude = "Latitudine"
   msg_LatitudeHint = "Latitudine [gradi nord]"
   msg_Longitude = "Longitudine"
   msg_LongitudeHint = "Longitudine [gradi ovest]"
   msg_Meridian = "Meridiano"
   msg_MeridianHint = "Meridiano di riferimento [gradi ovest]"
   msg_North = "Nord"
   msg_Year = "Anno"
   msg_YearStart = "Anno iniziale"
   msg_YearStep = "Incremento anno"
   msg_YearEnd = "Anno finale"
   msg_Month = "Mese"
   msg_MonthStart = "Mese iniziale"
   msg_MonthStep = "Incremento mese"
   msg_MonthEnd = "Mese finale"
   msg_Day = "Giorno"
   msg_DayStart = "Giorno iniziale"
   msg_DayStep = "Incremento giorno"
   msg_DayEnd = "Giorno finale"
   msg_Hour = "Ora"
   msg_HourStart = "Ora iniziale"
   msg_HourStep = "Incremento ora"
   msg_HourEnd = "Ora finale"
   msg_Minute = "Minuto"
   msg_MinuteStart = "Minuto iniziale"
   msg_MinuteStep = "Incremento minuto"
   msg_MinuteEnd = "Minuto finale"
   msg_Start = "Inizio"
   msg_Step = "Incremento"
   msg_End = "Fine"
   msg_InBetweenFrames = "Numero di fotogrammi intermedi"
   msg_InBetweenFramesShort = "Fot. intermedi"
   msg_TotalFrames = "Totale fotogrammi"
   msg_SkyColour = "Colore cielo"
   msg_R = "rosso"
   msg_G = "verde"
   msg_B = "blu"
   msg_GroundColour = "Colore terreno"
   msg_GroundAlbedo = "Albedo"
   msg_SkyStaticDynamic = ["Cielo Statico", "Cielo Dinamico"]
   msg_SkyStaticDynamicHint = ["Il tipo di cielo non varia al variare del fotogramma",
                               "Il tipo di cielo varia in accordo con il file climatico specificato"]
   msg_WeatherDataFile = "File dati climatici"
   msg_SkyType = "Tipo di cielo"
   msg_SkyTypeList = ["Chiaro CIE", "Intermedio", "Coperto CIE", "Uniforme"]
   msg_SkyGenerator = ["gensky (CIE)", "gendaylit (Perez)"]
   msg_Coefficient = "Coefficiente"
   msg_Normalise = "Normalizza"
   msg_TestSky = "Mostra la volta celeste"
   msg_TimeType = ["Ora solare", "Ora locale"]
   msg_UseSkyMapping = "Immagine cielo"
   msg_SkyMap = "Immagine del cielo"
   msg_MappingType = "Tipo di mappatura"
   msg_MappingTypeCylindrical = "cilindrica"
   msg_MappingTypeAngular = "angolare (fisheye)"
   msg_UseSun = "Sole"
   msg_GenskyTurbidity = "Torbidita'"
   msg_GenskyTurbidityHint = "Torbidita' di Linke"
   msg_GenskyManual = ["Generazione automatica", "Input manuale"]
   msg_GenskyInputData = "Dati di input"
   msg_GenskyRadianceIrradiance = ["Radianza", "Irradianza", "Illuminamento"]
   msg_SolarRadianceHint = "Radianza solare [W/(m2 sr)]"
   msg_SolarRadiance = "SR"
   msg_ZenithRadianceHint = "Radianza zenitale [W/(m2 sr)]"
   msg_ZenithRadiance  = "ZR"
   msg_DirectHorizIrradianceHint = "Irradianza orizzontale diretta [W/m2]"
   msg_DirectHorizIrradiance = "EES"
   msg_DirectNormalIrradianceHint = "Irradianza orizzontale diretta normale [W/m2]"
   msg_DirectNormalIrradiance = "EESN"
   msg_DiffuseHorizIrradianceHint = "Irradianza orizzontale diffusa [W/m2]"
   msg_DiffuseHorizIrradiance = "EED"
   msg_DirectHorizIlluminanceHint = "Illuminamento orizzontale diretto [lux]"
   msg_DirectHorizIlluminance = "EVS"
   msg_DiffuseHorizIlluminanceHint = "Illuminamento orizzontale diffuso [lux]"
   msg_DiffuseHorizIlluminance = "EVD"
   msg_EditorPath = "Editor di testo"
   msg_Mod = "M"
   msg_CurrentFrame = "Fotogramma attuale"
   msg_ExportVtkPolydata = "Esporta selezione come VtkPolydata"
   msg_ExportMethod = "Metodo di esportazione"
   msg_ExportMethodList = ["Istanze", "trasformazioni xform", "Primitive Mesh"]
   msg_ExportGrid = "Esporta selezione come griglia"
   msg_SelectedVTKExported = "L'oggetto selezionato e' stato esportato (VTK PolyData)"
   msg_SelectedGridExported = "L'oggetto selezionato e' stato esportato (Radiance grid)"
   msg_rtraceOptions = "Optioni di rtrace"
   msg_ImportRad = "Importa file .rad"
   msg_Importing = "Importazione "
   msg_Done = "Operazione completata"
   msg_FileNotFound = "File non trovato"
   msg_importFilename = "Nome del file"
   msg_ExportSelectedFixturesPositions = "Esportazione DXF delle posizioni delle lampade selezionate"
   msg_LuminairePositionExported = "Le posizioni delle lampade selezionate sono state esportate"
   msg_postProcessOptions = "Opzioni di calcolo finale"
   msg_generateSkyList = ["Non generare cielo", "Genera cielo"]
   msg_InternalError = "Errore interno"
   msg_CameraSettings = "Impostazioni punto di vista"
   msg_TextureConverterPath = "Programma di conversione textures"
   msg_Browse = "Scegli"
   msg_ErrorImportRad = "Errore di importazione del file di Radiance"
   msg_Language = "Lingua"
   msg_SaveConfiguration = "Salva configurazione"
   msg_ConfigFileNotWritten = "Errore scrittura file di configurazione"
   msg_ConfigFileWritten = "File di configurazione scritto correttamente, riavviare Blender"
   msg_Debug = ["Non produrre informazioni utili per il debugging","Produci informazioni utili per il debugging"]
   msg_RadianceBinariesPath = "Percorso programmi di Radiance"
   msg_RadianceLibraryPath = "Percorso libreria di Radiance"

# ---------i18n: italiano: end

#setLang(blender_data)

# ------i18n: end

