################################
# Blended Radiance brad_lib.py #
################################

##############################
# (c) Francesco Anselmo 2005 #
##############################

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import os.path
import string

import Blender
from Blender.Draw import *

# load library list
def loadRadLib(path):
   if os.path.exists(path):
      if os.path.isdir(path):
         outputlist = os.listdir(path)
         outputlist.remove("CVS")
         return outputlist

# load weather data file list
def loadWeatherFiles(path):
   if os.path.exists(path):
      if os.path.isdir(path):
         outputlist = os.listdir(path)
         outputlist.remove("CVS")
         return outputlist

# load sky maps file list
def loadSkyMaps(path):
   if os.path.exists(path):
      if os.path.isdir(path):
         outputlist = os.listdir(path)
         outputlist.remove("CVS")
         return outputlist

# load location list
def loadLocations(path):
   if os.path.exists(path):
      if os.path.isfile(path):
         locfile = open(path, "r")
         loclines = locfile.readlines()
         locfile.close()
         return loclines

# create a targa preview of the selected modifier
def createModPreview(path, moddir):
 try:
   if os.path.exists(path):
      if os.path.isdir(path):
         prevpath = os.getcwd()
         modpath = os.path.join(path, moddir)
         os.chdir(modpath)
         radfilename = os.path.join(modpath, "tmp.rad")
         radfile = open(radfilename, "w")
         #create lamp
         radfile.write("void light bright\n")
         radfile.write("0\n")
         radfile.write("0\n")
         radfile.write("3 1000 1000 1000\n\n")
         radfile.write("bright sphere lamp\n")
         radfile.write("0\n")
         radfile.write("0\n")
         radfile.write("4 0.25 0.25 3.75 .05\n\n")
         #create sphere
         radfile.write(moddir + " sphere " + moddir + "_ball\n")
         radfile.write("0\n")
         radfile.write("0\n")
         radfile.write("4 3.5 3.5 0.5 0.5\n\n")
         #create white box
         radfile.write("void plastic g\n")
         radfile.write("0\n")
         radfile.write("0\n")
         radfile.write("5 .7 .7 .7 0 0\n\n")
         radfile.write("!genbox g box 4 4 4\n")
         radfile.close()
         #create octree
         octreefilename = "tmp.oct"
         oconvcommand = "oconv " + moddir + ".rad tmp.rad > " + octreefilename
         os.system(oconvcommand)
         #create raw radiance picture
         rawpicfilename = "tmpraw.pic"
         rpictcommand = "rpict -ab 1 -aa .15 -ad 512 -as 256 -vp 3.5 2 .5  -vd 0 1 0 -vu 0 0 1 -x 128 " + octreefilename + " > " + rawpicfilename
         os.system(rpictcommand)
         #pfilt radiance picture
         pfpicfilename = "tmppf.pic"
         pfiltcommand = "pfilt -x /2 -y /2 " + rawpicfilename + " > " + pfpicfilename
         os.system(pfiltcommand)
         #pcond (human vision) the radiance picture
         pcpicfilename = "tmppc.pic"
         pcondcommand = "pcond -h+ " + pfpicfilename + " > " + pcpicfilename
         os.system(pcondcommand)
         #flip vertically the radiance picture
         pflpicfilename = "tmppfl.pic"
         pflipcommand = "pflip -v " + pcpicfilename + " " + pflpicfilename
         os.system(pflipcommand)
         #convert radiance picture to tga image
         tgafilename = moddir + ".tga"
         tgacommand = "ra_t16 -3 " + pflpicfilename + " " + tgafilename
         os.system(tgacommand)
         #remove temporary files
         if os.path.exists(radfilename):
            os.remove(radfilename)
         if os.path.exists(octreefilename):
            os.remove(octreefilename)
         if os.path.exists(rawpicfilename):
            os.remove(rawpicfilename)
         if os.path.exists(pfpicfilename):
            os.remove(pfpicfilename)
         if os.path.exists(pcpicfilename):
            os.remove(pcpicfilename)
         if os.path.exists(pflpicfilename):
            os.remove(pflpicfilename)
         os.chdir(prevpath)
 except:
   tgafilename = moddir + ".tga"
   if os.path.exists(tgafilename):
     os.remove(tgafilename)

# add the selected modifier
def addMod(path, moddir):
   if os.path.exists(path):
      if os.path.isdir(path):
         #m = Blender.Material.New()
         #m.name=moddir
         importMod(path, moddir)
         Redraw()

# add the selected luminaire
def addLum(path, lumdir):
   if os.path.exists(path):
      if os.path.isdir(path):
         l = Blender.Lamp.New('Spot',lumdir)
         Redraw()

def importMod(path,name):
        # recognized Radiance primitives:
        # plastic, plastic2, metal, metal2, trans, trans2, glass, dielectric
        registered_data = Blender.Registry.GetKey('brad')
        if registered_data:
          brad_path  = registered_data['brad_path']
          convert_path  = registered_data['convert_path']
          debug  = registered_data['debug']

        if debug:
             print os.path.join(path, name, name+".rad")

        if os.path.exists(os.path.join(path, name, name+".rad")):
          # tokenize the file
          tokens = []

          radfile = open(os.path.join(path, name, name+".rad"), "r")
          radfilelines = radfile.readlines()
          endslash = 0
          for line in radfilelines:
                if line[len(line)-2] == "\\":
                    endslash = 1
                if line[0] != "#" and line[0] != "!" and endslash == 0:
                    for i in range(len(string.split(line))):
                        tokens.append(string.split(line)[i])
                elif endslash == 1:
                    if line[len(line)-2] != "\\":
                      endslash = 0
          radfile.close()
          # creating list of modifiers
          modifiers = []
          for i in range(len(tokens)):
              if modifiers.count(tokens[i])==0:
                try:
                    float(tokens[i])
                except:
                    modifiers.append(tokens[i])
          if debug:
             print modifiers

          #print tokens
          i = 0
          while i < len(tokens):
            if tokens[i+1] != "alias":
              snum = int(tokens[i+3])
              inum = int(tokens[i+3+1+snum])
              fnum = int(tokens[i+3+1+1+snum+inum])
              # import Radiance primitives
              if tokens[i+1] == "light":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
              if tokens[i+1] == "glow":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
              if tokens[i+1] == "plastic":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setSpec(float(tokens[i+3+1+1+1+snum+inum+3]))
              if tokens[i+1] == "plastic2":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setSpec(float(tokens[i+3+1+1+1+snum+inum+3]))
              if tokens[i+1] == "metal":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setSpec(float(tokens[i+3+1+1+1+snum+inum+3]))
              if tokens[i+1] == "metal2":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setSpec(float(tokens[i+3+1+1+1+snum+inum+3]))
              if tokens[i+1] == "trans":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setSpec(float(tokens[i+3+1+1+1+snum+inum+3]))
              if tokens[i+1] == "trans2":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setSpec(float(tokens[i+3+1+1+1+snum+inum+3]))
              if tokens[i+1] == "glass":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setAlpha(0.5)
              if tokens[i+1] == "dielectric":
                m = Blender.Material.New()
                m.name=str(tokens[i+2])
                m.setRGBCol(float(tokens[i+3+1+1+1+snum+inum]), float(tokens[i+3+1+1+1+snum+inum+1]), float(tokens[i+3+1+1+1+snum+inum+2]))
                m.setAlpha(0.5)
              # increase step
              i += (3 +1+1+1+ snum + inum + fnum)
            else:
              # increase step for alias primitive
              i += 4
          Redraw()
