""" brad: Radiance export settings
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, os.path, sys

import Blender
from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *

registered_data = Blender.Registry.GetKey('brad')
if registered_data:
  export_path  = registered_data['export_path']

class ExportSettingswin(BaseWindowClass):

	def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, escEvent, Deco):

		BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

		self.type="ExportSettingsWin"

		#self.Height = 110
		self.okE=okEvent
		self.escE=escEvent
		self.decoration=Deco
		self.title=Title

                # [0]=yes or no | [1]=staframe exported [2]=endframe exported
                self.geometryHasBeenExported=[0,0,0]

                self.ExportLayers = Create(1)
                self.ExportSelected = Create(1)

                self.ExportDynamicGeometry = Create(0)
                self.ExportStaticGeometry = Create(1)

                if sys.platform=='win32':
                  self.ExportMethod = Create(1)
                else:
                  self.ExportMethod = Create(2)

                self.ExportPath = Create(export_path)
                self.ExportFilename = Create(os.path.splitext(os.path.basename(Blender.Get('filename')))[0])

                #layers
                self.l=[Create(0)]
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))

                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))

                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))

                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))
                self.l.append(Create(1))

	#-------------------------------------------#
	#    DRAWING THE BUTTONS                    #
	#-------------------------------------------#

	def drawIt(self):

		if self.Visibility==1:
			if self.decoration == 0:
				self.drawBox()
			else:
				self.drawBoxS()


                        #export path
                        #rht = 43 #text row vertical position
                        #rhb = 67 #button row vertical position
                        #self.ExportPath = String(msg_ExportPath+": ",21,int(self.LocX) + 10, int(self.LocY)-rhb,int(self.Width)-30, 20,self.ExportPath.val,256,msg_ExportPath)

                        #export filename
                        rht = 73
                        rhb = 97
                        self.ExportFilename = String(msg_ExportFilename+": ",21,self.LocX + 10, self.LocY-rhb,self.Width-30, 20,self.ExportFilename.val,256,msg_ExportFilename)

                        #geometry static/dynamic
                        rht = 113
                        rhb = 137
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_GeometryStatic)
                        self.ExportStaticGeometry = Toggle("",28,self.LocX + 10, self.LocY-rhb,(self.Width-20)/2-6, 20,self.ExportStaticGeometry.val,msg_GeometryStaticHint)
                        self.drawText(self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rht, 0, 0, 0, msg_GeometryDynamic)
                        self.ExportDynamicGeometry = Toggle("",29,self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rhb,(self.Width-20)/2-6, 20,self.ExportDynamicGeometry.val,msg_GeometryDynamicHint)

                        #export method
                        rht = 153
                        rhb = 175
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_ExportMethod)
                        self.ExportMethod = Menu(msg_ExportMethod+" %t|"+msg_ExportMethodList[0]+" %x0|"+msg_ExportMethodList[1]+" %x1|"+msg_ExportMethodList[2]+" %x2|", 0, self.LocX + 10 , self.LocY-rhb, (self.Width-28), 18, self.ExportMethod.val, msg_ExportMethod)

                        #export what?
                        rht = 193
                        rhb = 217
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_ExportLayers)
                        self.ExportLayers = Toggle("",0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/2-6, 20,self.ExportLayers.val,msg_ExportLayers)
                        self.drawText(self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rht, 0, 0, 0, msg_ExportSelected)
                        self.ExportSelected=Toggle("",0,self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rhb,(self.Width-20)/2-6, 20,self.ExportSelected.val,msg_ExportSelected)

                        #layers buttons
                        rht = 243
                        rhb = 257
                        bw = 16
                        bh = 16
                        if self.ExportLayers.val:

                           self.l[1] = Toggle("",0,self.LocX+1*bw,self.LocY-rhb,bw,bh,self.l[1].val)
                           self.l[2] = Toggle("",0,self.LocX+2*bw,self.LocY-rhb,bw,bh,self.l[2].val)
                           self.l[3] = Toggle("",0,self.LocX+3*bw,self.LocY-rhb,bw,bh,self.l[3].val)
                           self.l[4] = Toggle("",0,self.LocX+4*bw,self.LocY-rhb,bw,bh,self.l[4].val)
                           self.l[5] = Toggle("",0,self.LocX+5*bw,self.LocY-rhb,bw,bh,self.l[5].val)

                           self.l[6] = Toggle("",0,self.LocX+6*bw+10,self.LocY-rhb,bw,bh,self.l[6].val)
                           self.l[7] = Toggle("",0,self.LocX+7*bw+10,self.LocY-rhb,bw,bh,self.l[7].val)
                           self.l[8] = Toggle("",0,self.LocX+8*bw+10,self.LocY-rhb,bw,bh,self.l[8].val)
                           self.l[9] = Toggle("",0,self.LocX+9*bw+10,self.LocY-rhb,bw,bh,self.l[9].val)
                           self.l[10] = Toggle("",0,self.LocX+10*bw+10,self.LocY-rhb,bw,bh,self.l[10].val)

                           #"select all layers" button
                           Button(msg_SelectAllLayers,26,self.LocX+10*bw+10+30,self.LocY-rhb,self.Width-(10*bw+10+50),bh)

                           self.l[11] = Toggle("",0,self.LocX+1*bw,self.LocY-rhb-bh-10,bw,bh,self.l[11].val)
                           self.l[12] = Toggle("",0,self.LocX+2*bw,self.LocY-rhb-bh-10,bw,bh,self.l[12].val)
                           self.l[13] = Toggle("",0,self.LocX+3*bw,self.LocY-rhb-bh-10,bw,bh,self.l[13].val)
                           self.l[14] = Toggle("",0,self.LocX+4*bw,self.LocY-rhb-bh-10,bw,bh,self.l[14].val)
                           self.l[15] = Toggle("",0,self.LocX+5*bw,self.LocY-rhb-bh-10,bw,bh,self.l[15].val)

                           self.l[16] = Toggle("",0,self.LocX+6*bw+10,self.LocY-rhb-bh-10,bw,bh,self.l[16].val)
                           self.l[17] = Toggle("",0,self.LocX+7*bw+10,self.LocY-rhb-bh-10,bw,bh,self.l[17].val)
                           self.l[18] = Toggle("",0,self.LocX+8*bw+10,self.LocY-rhb-bh-10,bw,bh,self.l[18].val)
                           self.l[19] = Toggle("",0,self.LocX+9*bw+10,self.LocY-rhb-bh-10,bw,bh,self.l[19].val)
                           self.l[20] = Toggle("",0,self.LocX+10*bw+10,self.LocY-rhb-bh-10,bw,bh,self.l[20].val)

                           #"unselect all layers" button
                           Button(msg_UnselectAllLayers,27,self.LocX+10*bw+10+30,self.LocY-rhb-bh-10,self.Width-(10*bw+10+50),bh)

                        #ok button
                        Button(msg_Ok,self.okE,self.LocX+10,self.LocY-self.Height+10,self.Width/3-6,20)

			self.drawTitle(self.title)
			if self.isSelected == 1:
				self.drawBoxHF()


	def enableExportSelected(self):
                #event 23
                if self.ExportSelected.val:
                   self.ExportLayers.val = 0
                else:
                   self.ExportLayers.val = 1
                Draw()

        def enableExportLayers(self):
                #event 24
                if self.ExportLayers.val:
                   self.ExportSelected.val = 0
                else:
                   self.ExportSelected.val = 1
                Draw()

        def selectAllLayers(self):
                #event 26
                for i in range (1,21):
                   self.l[i].val = 1

        def unselectAllLayers(self):
                #event 27
                for i in range (1,21):
                   self.l[i].val = 0

	def enableExportStaticGeometry(self):
                #event 28
                if self.ExportStaticGeometry.val:
                   self.ExportDynamicGeometry.val = 0
                else:
                   self.ExportDynamicGeometry.val = 1
                Draw()

        def enableExportDynamicGeometry(self):
                #event 29
                if self.ExportDynamicGeometry.val:
                   self.ExportStaticGeometry.val = 0
                else:
                   self.ExportStaticGeometry.val = 1
                Draw()
