""" brad: main menu window

"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from BaseWindowClass import BaseWindowClass
from Blender.Draw import *

class Menuwin(BaseWindowClass):

    menuItem  = []
    menuTitle = []
    menuList  = []
    menuEvent = []
    menuValue = []

    def __init__(self, LocX, LocY, Width, Height, numMenu, Title, Deco):

        BaseWindowClass.__init__(self,LocX,LocY,Width,Height)

        self.type="MenuWin"
        self.numMenu = numMenu
        self.title = Title
        self.decoration=Deco

        # Create the button #
        for i in range(numMenu):
            self.menuList.append(Create(0))

        # Create the title for each button #
        for i in range(numMenu):
            self.menuTitle.append("Title"+str(i))

        # Defaultmenu: item1, item2, item3, item4#
        for i in range(numMenu):
            self.menuItem.append(self.menuTitle[i]+" %t|Item0 %x0|Item1 %x1|Item2 %x2|Item3 %x3")

        for i in range(numMenu):
            self.menuEvent.append(i)

    def setMenuItem(self, item, numberofMenu):
        self.menuItem[numberofMenu] = item

    def drawIt(self):
        if self.Visibility == 1:
            if self.decoration == 0:
                self.drawBox()
            else:
                self.drawBoxS()

            for menu in range(self.numMenu):

                self.menuList[menu] = Menu(self.menuItem[int(menu)],
                    self.menuEvent[menu],
                    self.LocX + 10 + int(((self.Width-20)/self.numMenu)*menu),
                    self.LocY-50,
                    int((self.Width-20)/self.numMenu),
                    20,
                    0,
                    self.menuTitle[int(menu)])

            if self.isSelected == 1:
                self.drawBoxHF()
            self.drawTitle(self.title)
