""" brad: status message bar
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from BaseWindowClass import BaseWindowClass
from Blender.Draw import *

class Statuswin(BaseWindowClass):

	def __init__(self, LocX, LocY, Width, Height, Message, Title, Deco):

		BaseWindowClass.__init__(self,LocX,LocY,Width,Height)

		self.type="messagewin"
		self.msg = Message
		self.title = Title
		self.decoration = Deco

	msgColor = {'R':0, 'G':0, 'B':0} # default RGB = (0,0,0)

	def drawIt(self):
		if self.Visibility == 1:
			cw=6 #character width
			border = 10
			message_width = len(self.msg) * cw
			title_width = len(self.title) * cw

			if message_width > title_width:
					self.Width= message_width + border  # autoresize with message leght
			else:
					self.Width= title_width + border  # autoresize with title leght

			if self.decoration == 0:
				self.drawBox()
			else:
				self.drawBoxS()

			self.drawText(self.LocX+10,
				self.LocY-40,
				self.msgColor['R'],
				self.msgColor['G'],
				self.msgColor['B'],
				self.msg)


			if self.isSelected == 1:
				self.drawBoxHF()
			self.drawTitle(self.title)
