""" simulation time settings
"""

import os
import os.path
import string
import math
import time
import calendar

import Blender
from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *
from brad_lib import *
from brad_io import *

class SimTimewin(BaseWindowClass):

    def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, Deco):

        BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

        self.type="SimTimeWin"

        #self.Height = 110
        self.okE=okEvent
        self.decoration=Deco
        self.title=Title

        self.YearStart = Create(int(time.strftime("%Y", time.localtime(time.time()))))
        self.YearEnd = Create(int(time.strftime("%Y", time.localtime(time.time()))))
        self.YearStep = Create(1)

        self.MonthStart = Create(6)
        self.MonthEnd = Create(6)
        self.MonthStep = Create(1)

        self.DayStart = Create(1)
        self.DayEnd = Create(1)
        self.DayStep = Create(30)

        self.HourStart = Create(12)
        self.HourEnd = Create(12)
        self.HourStep = Create(1)

        self.MinuteStart = Create(0)
        self.MinuteEnd = Create(0)
        self.MinuteStep = Create(60)

        self.InBetweenFrames = Create(1)

        self.TotalFrames = 0

        self.y=0
        self.m=0
        self.d=0
        self.h=0
        self.minute=0

        self.updateDateTime(Blender.Get("curframe"))

        self.updateFrames()

    #-------------------------------------------#
    #    DRAWING THE BUTTONS                    #
    #-------------------------------------------#

    def drawIt(self):

      if self.Visibility==1:
        if self.decoration == 0:
                self.drawBox()
        else:
                self.drawBoxS()

        # time start
        rht = 45
        rhb = 70
        self.drawText(self.LocX + 10 + ((self.Width-20)/6-3), self.LocY-rht, 0, 0, 0, msg_Year)
        self.drawText(self.LocX + 10 + 2*((self.Width-20)/6-3), self.LocY-rht, 0, 0, 0, msg_Month)
        self.drawText(self.LocX + 10 + 3*((self.Width-20)/6-3), self.LocY-rht, 0, 0, 0, msg_Day)
        self.drawText(self.LocX + 25 + 4*((self.Width-20)/6-3), self.LocY-rht, 0, 0, 0, msg_Hour)
        self.drawText(self.LocX + 25 + 5*((self.Width-20)/6-3), self.LocY-rht, 0, 0, 0, msg_Minute)
        self.drawText(self.LocX + 10, self.LocY-rhb+3, 0, 0, 0, msg_Start)
        self.YearStart=Number("",37,self.LocX + 10 + ((self.Width-20)/6-3), self.LocY-rhb,(self.Width-20)/6-3, 20,self.YearStart.val,0,3000,msg_YearStart)
        self.MonthStart=Number("",37,self.LocX + 10 + 2*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.MonthStart.val,1,12,msg_MonthStart)
        self.DayStart=Number("",37,self.LocX + 10 + 3*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.DayStart.val,1,31,msg_DayStart)
        self.HourStart=Number("",37,self.LocX + 25 + 4*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.HourStart.val,0,23,msg_HourStart)
        self.MinuteStart=Number("",37,self.LocX + 25 + 5*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.MinuteStart.val,0,59,msg_MinuteStart)

        # time step
        rht = 95
        rhb = 95
        self.drawText(self.LocX + 10, self.LocY-rhb+3, 0, 0, 0, msg_Step)
        self.YearStep=Number("",37,self.LocX + 10 + ((self.Width-20)/6-3), self.LocY-rhb,(self.Width-20)/6-3, 20,self.YearStep.val,1,3000,msg_YearStep)
        self.MonthStep=Number("",37,self.LocX + 10 + 2*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.MonthStep.val,1,12,msg_MonthStep)
        self.DayStep=Number("",37,self.LocX + 10 + 3*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.DayStep.val,1,31,msg_DayStep)
        self.HourStep=Number("",37,self.LocX + 25 + 4*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.HourStep.val,1,24,msg_HourStep)
        self.MinuteStep=Number("",37,self.LocX + 25 + 5*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.MinuteStep.val,1,60,msg_MinuteStep)

        # time end
        rht = 120
        rhb = 120
        self.drawText(self.LocX + 10, self.LocY-rhb+3, 0, 0, 0, msg_End)
        self.YearEnd=Number("",37,self.LocX + 10 + ((self.Width-20)/6-3), self.LocY-rhb,(self.Width-20)/6-3, 20,self.YearEnd.val,0,3000,msg_YearEnd)
        self.MonthEnd=Number("",37,self.LocX + 10 + 2*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.MonthEnd.val,1,12,msg_MonthEnd)
        self.DayEnd=Number("",37,self.LocX + 10 + 3*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.DayEnd.val,1,31,msg_DayEnd)
        self.HourEnd=Number("",37,self.LocX + 25 + 4*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.HourEnd.val,0,23,msg_HourEnd)
        self.MinuteEnd=Number("",37,self.LocX + 25 + 5*((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/6-3), 20,self.MinuteEnd.val,0,59,msg_MinuteEnd)

        # inbetweenframes
        rhb = 145
        self.InBetweenFrames=Number(msg_InBetweenFramesShort+": ",37,self.LocX + 10 + ((self.Width-20)/6-3), self.LocY-rhb,((self.Width-20)/3-3), 20,self.InBetweenFrames.val,1,216000,msg_InBetweenFrames)
        self.drawText(self.LocX + 10 + 3*((self.Width-20)/6-3) + 15, self.LocY-rhb+5, 0, 0, 0, msg_TotalFrames+": ")
        self.drawText(self.LocX + 5*((self.Width-20)/6-3), self.LocY-rhb+5, 0, 0, 0, str(self.TotalFrames))

        #current frame
        rhb = 170
        self.updateDateTime(Blender.Get("curframe"))
        self.drawText(self.LocX + 10 + 3*((self.Width-20)/6-3) + 15, self.LocY-rhb+5, 0, 0, 0, msg_CurrentFrame+": ")
        self.drawText(self.LocX + 5*((self.Width-20)/6-3), self.LocY-rhb+5, 0, 0, 0,
                      str(self.getYear())+"-"+
                      str(self.getMonth())+"-"+
                      str(self.getDay())+"|"+
                      str(self.getHour())+":"+
                      zfill(str(self.getMinute()),2))

        #ok button
        Button(msg_Ok,self.okE,self.LocX+10,self.LocY-self.Height+10,self.Width/3-6,20)

        self.drawTitle(self.title)
        if self.isSelected == 1:
            self.drawBoxHF()

    def updateFrames(self):
      # event 37
      if self.YearStart.val>self.YearEnd.val:
         self.YearEnd.val=self.YearStart.val
      if self.MonthStart.val>self.MonthEnd.val and self.YearStart.val==self.YearEnd.val:
         self.MonthEnd.val=self.MonthStart.val
      if self.DayStart.val>self.DayEnd.val and self.MonthStart.val==self.MonthEnd.val and self.YearStart.val==self.YearEnd.val:
         self.DayEnd.val=self.DayStart.val
      if self.HourStart.val>self.HourEnd.val:
         self.HourEnd.val=self.HourStart.val
      if self.MinuteStart.val>self.MinuteEnd.val:
         self.MinuteEnd.val=self.MinuteStart.val

      self.TotalFrames = 0
      #years / anni
      for y in range(self.YearStart.val, self.YearEnd.val+1, self.YearStep.val):
       #months / mesi
       MonthEnd=self.MonthEnd.val
       MonthStart=self.MonthStart.val
       if y<self.YearEnd.val:
          MonthEnd=12
       if y>self.YearStart.val:
          MonthStart=1
       if calendar.isleap(y)==1:
        days = [0,
         31, #jan
         29, #feb
         31, #mar
         30, #apr
         31, #may
         30, #jun
         31, #jul
         31, #aug
         30, #sep
         31, #oct
         30, #nov
         31  #dec
        ]
       else:
        days = [0,
         31, #jan
         28, #feb
         31, #mar
         30, #apr
         31, #may
         30, #jun
         31, #jul
         31, #aug
         30, #sep
         31, #oct
         30, #nov
         31  #dec
        ]
       for m in range(MonthStart, MonthEnd+1, self.MonthStep.val):
        if self.DayEnd.val>days[m] and m==self.MonthEnd.val and y==self.YearEnd.val:
          #print y, m, days[m], self.DayEnd.val
          self.DayEnd.val=days[m]
        if self.DayStart.val>days[m] and m==self.MonthStart.val and y==self.YearStart.val:
          self.DayStart.val=days[m]
        DayEnd=self.DayEnd.val
        DayStart=self.DayStart.val
        if DayEnd>days[m]:
         #correction for last day of each month / correzione per l'ultimo del mese
         DayEnd=days[m]
        #days / giorni
        if m<MonthEnd:
           DayEnd=days[m]
        if m==12:
           DayEnd=days[m]
        if m>MonthStart:
           DayStart=1
        for d in range(DayStart, DayEnd+1, self.DayStep.val):
           #hours / ore
           for h in range(self.HourStart.val, self.HourEnd.val+1, self.HourStep.val):
              for minute in range(self.MinuteStart.val, self.MinuteEnd.val+1, self.MinuteStep.val):
                 self.TotalFrames += 1
                 #print y, m, d, h, m, self.TotalFrames

      self.TotalFrames *= self.InBetweenFrames.val

    def updateDateTime(self, frame):
        TotalFrames = 0
        #years / anni
        for y in range(self.YearStart.val, self.YearEnd.val+1, self.YearStep.val):
         #months / mesi
         MonthEnd=self.MonthEnd.val
         MonthStart=self.MonthStart.val
         if y<self.YearEnd.val:
            MonthEnd=12
         if y>self.YearStart.val:
            MonthStart=1
         if calendar.isleap(y)==1:
          days = [0,
            31, #jan
            29, #feb
            31, #mar
            30, #apr
            31, #may
            30, #jun
            31, #jul
            31, #aug
            30, #sep
            31, #oct
            30, #nov
            31  #dec
         ]
         else:
          days = [0,
            31, #jan
            28, #feb
            31, #mar
            30, #apr
            31, #may
            30, #jun
            31, #jul
            31, #aug
            30, #sep
            31, #oct
            30, #nov
            31  #dec
         ]
         for m in range(MonthStart, MonthEnd+1, self.MonthStep.val):
          if self.DayEnd.val>days[m] and m==self.MonthEnd.val and y==self.YearEnd.val:
            #print y, m, days[m], self.DayEnd.val
            self.DayEnd.val=days[m]
          if self.DayStart.val>days[m] and m==self.MonthStart.val and y==self.YearStart.val:
            self.DayStart.val=days[m]
          DayEnd=self.DayEnd.val
          DayStart=self.DayStart.val
          if DayEnd>days[m]:
           #correction for last day of each month / correzione per l'ultimo del mese
           DayEnd=days[m]
           #days / giorni
          if m<MonthEnd:
             DayEnd=days[m]
          if m==12:
             DayEnd=days[m]
          if m>MonthStart:
             DayStart=1
          for d in range(DayStart, DayEnd+1, self.DayStep.val):
             #hours / ore
             for h in range(self.HourStart.val, self.HourEnd.val+1, self.HourStep.val):
                for minute in range(self.MinuteStart.val, self.MinuteEnd.val+1, self.MinuteStep.val):
                   TotalFrames += 1*self.InBetweenFrames.val
                   #print y, m, d, h, m, self.TotalFrames
                   if (TotalFrames) >= frame:
                      self.y=y
                      self.m=m
                      self.d=d
                      self.h=h
                      self.minute=minute
                      return

    def getYear(self):
       return self.y

    def getMonth(self):
       if self.m!=0:
         return self.m
       else:
         return 1

    def getDay(self):
       if self.d!=0:
         return self.d
       else:
         return 1

    def getHour(self):
       return self.h

    def getMinute(self):
       return self.minute



