#!BPY

""" Registration info for Blender menus:
Name: 'brad (Blended RADiance)'
Blender: 236
Group: 'Misc'
Tip: 'Export to Radiance ray tracer and manage Radiance simulations.'
"""

__author__ = "Francesco Anselmo"
__url__ = ["http://www.bozzograo.net/radiance/"]
__version__ = "0.2"

__bpydoc__ = """\
[brad] is a lighting design add-on for Blender.
It enables export of still scenes and animations
to Radiance and allows the user to setup and control
the Radiance simulation.

Usage:

Run this script and mess around with the menus and windows!
"""

# brad.py
# (copyleft) 2005 by Francesco Anselmo

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


global X, Y, firstrun, lang, config_path, editor_path, export_path, debug, scripts_path, brad_path, radiance_binaries_path, radiance_library_path, configparserok

# import Blender and Python modules
import Blender, os, os.path, sys, string

try:
  import ConfigParser
  configparserok = 1
except:
  print "Error in importing the ConfigParser module"

# ------initial configuration wizard: begin    # currently not working, yet
from Blender import Draw, BGL

def configgui():
  global lang, editor_path, config_path, export_path, debug, brad_path, radiance_binaries_path, radiance_library_path
  BGL.glClearColor(1,1,1,1)
  BGL.glClear(BGL.GL_COLOR_BUFFER_BIT)
  BGL.glColor3f(1,1,1)
  BGL.glRasterPos2i(20, 150)
  Draw.Text("Blender RADiance GUI")
  firstrun = 1

def configbevent(evt):
  global HELPME

  if evt == 1:
    #write configuration variables - to do
    #update blender registry - to do
    firstrun = 1
    Draw.Redraw(1)
  elif evt == 2:
    #exit
    Draw.Exit()
    return

def configevent(evt, val):
  if not val: return
  if evt == Draw.ESCKEY:
    Draw.Exit()
    return
  else: return
  Draw.Register(configgui, configevent, configbevent)

# ------initial configuration wizard: end

#if string.find(sys.path[len(sys.path)-1],"brad")>0:
#scripts_path = sys.path[len(sys.path)-1]
scripts_path = Blender.Get('scriptsdir')
config_path  = os.path.split(scripts_path)[0]
# set brad directory, by "guessing" it from python path
# (use the last directory in the Python path)
brad_path = scripts_path
# shouldn't it work, the user may specify it directly
# uncommenting the next line
#brad_path = "/opt/blender/.blender/scripts/brad"   # for unix systems, change directory according to your settings
#brad_path = "C:\\BLENDER\\.blender\\scripts\\brad" # for windows systems, change directory according to your settings


# main
# check whether the config file exists
if not os.path.exists(os.path.join(config_path,"bpydata","brad.cfg")) or not configparserok:
  # user configurable options: begin
  print "No existing configuration file: using default configuration."

  # edit the following options according to your needs
  # (no config file parser at the moment ...)
  global lang, editor_path, config_path, export_path, debug, brad_path, radiance_binaries_path, radiance_library_path, configparserok


  if sys.platform=='win32':
    # initial configuration for windows systems
    # for future reference, there is a useful function in os.path, normpath(), that under windows
    # converts forward slashes to backward slashes
    lang="en"
    editor_path="wordpad"
    convert_path="convert" #this is useful for textures conversion and only works if using cygwin with ImageMagick
    export_path="c:\\brad"
    radiance_binaries_path="C:\\RADIANCE\\BIN;C:\\CYGWIN\\OPT\\RADIANCE\\BIN"
    radiance_library_path=os.path.join(brad_path,"brad","radiance","cal")+";"+os.path.join(brad_path,"brad","radiance","sky")+";C:\\RADIANCE\\LIB;C:\\CYGWIN\\OPT\\RADIANCE\\LIB"
    debug = 0
  else:
    # initial configuration for unix systems
    lang="en"
    editor_path="/usr/bin/kwrite"
    convert_path="/usr/bin/convert"
    export_path="/opt/blender/export/radiance"
    radiance_binaries_path=".:/opt/radiance/bin:/usr/local/bin:/usr/bin:/usr/lib/radiance/bin"
    radiance_library_path=".:"+os.path.join(brad_path,"brad","radiance","cal")+":"+os.path.join(brad_path,"brad","radiance","sky")+":/opt/radiance/lib:/opt/radiance/cal"
    debug = 0

  # user configurable options: end

  Draw.Register(configgui, configevent, configbevent)

else:
  #retrieve configuration from config file
  print "Retrieving previously saved configuration."
  global lang, editor_path, config_path, export_path, debug, brad_path, radiance_binaries_path, radiance_library_path, configparserok
  cfg = ConfigParser.ConfigParser()
  cfg.read(os.path.join(config_path,"bpydata","brad.cfg"))
  if cfg.has_section('Preferences'):
     export_path = cfg.get('Preferences', 'export_path')
     editor_path = cfg.get('Preferences', 'editor_path')
     convert_path = cfg.get('Preferences', 'convert_path')
     lang = cfg.get('Preferences', 'lang')
     debug = cfg.get('Preferences', 'debug')
     radiance_binaries_path = cfg.get('Preferences', 'radiance_binaries_path')
     radiance_library_path = cfg.get('Preferences', 'radiance_library_path')


# register the global variables in the Blender Registry
# for later use within the same Blender Session
registered_data = Blender.Registry.GetKey('brad')
if not registered_data:
   data = {}
   data['brad_path']              = brad_path
   data['blender_file_name']      = os.path.splitext(os.path.basename(Blender.Get('filename')))[0]
   data['blender_file_path']      = os.path.dirname(Blender.Get('filename'))
   data['export_path']            = export_path
   data['editor_path']            = editor_path
   data['convert_path']           = convert_path
   data['lang']                   = lang
   data['debug']                  = debug
   data['radiance_binaries_path'] = radiance_binaries_path
   data['radiance_library_path']  = radiance_library_path
   data['configparserok']         = configparserok

   Blender.Registry.SetKey('brad', data)

# modules paths: begin
#lib3d_path = os.path.join(brad_path,"brad","3d")
gui_path = os.path.join(brad_path,"brad","gui")
bradlib_path = os.path.join(brad_path,"brad","brad")
#reportlab_path = os.path.join(brad_path,"brad","reportlab")
if debug:
   print "brad path: ", brad_path
#   print "lib3d path: ", lib3d_path
   print "gui path: ", gui_path
   print "bradlib path: ", bradlib_path
#   print "reportlab path: ", reportlab_path
# append modules directories to path
sys.path.append(brad_path)
#sys.path.append(lib3d_path)
sys.path.append(gui_path)
sys.path.append(bradlib_path)
#try:
#   sys.path.append(reportlab_path)
#except:
#   pass
# modules paths: end

# export Radiance related environment variables
PREVPATH=os.getenv("PATH")
if sys.platform=='win32':
  os.putenv("PATH",radiance_binaries_path+";"+PREVPATH)
  os.putenv("RAYPATH",radiance_library_path)
else:
  os.putenv("PATH",radiance_binaries_path+":"+PREVPATH)
  os.putenv("RAYPATH",radiance_library_path)

# import brad modules: begin
#try:
from brad_i18n     import *
from brad_ies      import *
from brad_io       import *
from brad_lib      import *
from brad_obj      import *
from brad_radiance import *
from brad_sun      import *
#try:
#   from reportlab import *
#except:
#   pass
#except:
#   raise "cannot load brad modules, sorry."
# import brad modules: end

""" reportlab test
from reportlab.lib import colors
from reportlab.graphics.shapes import *
d = Drawing(400, 200)
d.add(Rect(50, 50, 300, 100, fillColor=colors.yellow))
d.add(String(150,100, 'Hello World', fontSize=18, fillColor=colors.red))
from reportlab.graphics import renderPDF
renderPDF.drawToFile(d, 'example1.pdf', 'My First Drawing')
"""

# gui: begin

from Blender.Draw import *

# import widget modules: begin
from Background import *
from Buttonwin import *
from CalculateSettingswin import *
from ExportSettingswin import *
from Importwin import *
from Libwin import *
from LumLibwin import *
from Locationwin import *
from Menuwin import *
from Messagewin import *
from Mousewin import *
from MultilineMessagewin import *
from Parameterswin import *
from ProgPreferenceswin import *
from Questionwin import *
from RadParameterswin import *
from SimTimewin import *
from SkyWeatherwin import *
from Statuswin import *
# import widget modules: end

# ------gui variables: begin

# --------- get python window dimensions: begin
pythonwinsize = Buffer(GL_FLOAT,4);
# pythonwinsize = [x,y,width,height]
glGetFloatv(GL_SCISSOR_BOX,pythonwinsize)
# --------- get python window dimensions: end

# define a background
bg = Background()
# define window with mouse dragging capabilities
mouse= Mousewin()

# --- gui windows definitions: begin

# --------- menu: begin
mwidth = 610
mheight = 60
m = Menuwin( 5,
             int(pythonwinsize[3] - mheight/5),
             mwidth,
             mheight,
             4,
             msg_Title,
             0)
# to center the menu use (pythonwinsize[2]/2 - mwidth/2)

# item for the menu: x1 return a val=1, x2 val=2 etc...
m.menuItem[0]="%s %s0|%s %s1|%s %s2|%s %s3|%s %s4" % (msg_Program, "%x",msg_Preferences, "%x",  msg_Help, "%x", msg_About, "%x", msg_Quit, "%x")
m.menuItem[1]="%s %s0|%s %s1|%s %s2|%s %s3|%s %s4|%s %s5|%s %s6|%s %s7" % (msg_Export, "%x", msg_Settings, "%x", msg_ExportFrame, "%x", msg_ExportAnimation, "%x", msg_CameraSettings, "%x", msg_ExportVtkPolydata, "%x", msg_ExportGrid, "%x", msg_ImportRad, "%x")
 #|%s %s8
 #, msg_ExportSelectedFixturesPositions, "%x")
m.menuItem[2]="%s %s0|%s %s1|%s %s2" % (msg_Libraries, "%x", msg_ModLib, "%x", msg_LumLib, "%x")
 #|%s %s3|%s %s4|%s %s5
 #, msg_ObjInstLib, "%x", msg_ParObjLib, "%x", msg_WeatherLib, "%x")
m.menuItem[3]="%s %s0|%s %s1|%s %s2|%s %s3|%s %s4|%s %s5|%s %s6|" % (msg_Simulation, "%x",  msg_Location, "%x", msg_Time, "%x", msg_Weather, "%x", msg_Settings, "%x", msg_StartInteractive, "%x", msg_StartNumbers, "%x")
 #%s %s7|%s %s8|%s %s9
 #, msg_StartPicture, "%x", msg_StartDC, "%x", msg_StartHD, "%x")
 #m.menuItem[4]="%s %s0|%s %s1|%s %s2|%s %s3|%s %s4" % (msg_Analysis, "%x",  msg_GetInfo, "%x", msg_FalseColour, "%x", msg_Glare, "%x", msg_PicConversion, "%x")
# events for the menu
m.menuEvent[0]=1
m.menuEvent[1]=2
m.menuEvent[2]=3
m.menuEvent[3]=4
#m.menuEvent[4]=5
# values for the menu
#m.menuValue[0]=0
# titles for the menu
m.menuTitle[0]= msg_Program
m.menuTitle[1]= msg_Export
m.menuTitle[2]= msg_Libraries
m.menuTitle[3]= msg_Simulation
#m.menuTitle[4]= msg_Analysis
# --------- menu: end

# --------- exitwindow: begin
#You can see the index of button in the defaul label
#Button(LocX, LocY, Width, Heigth, Row, Column, title, Decoration)#
#to move the widget to the center of the window, use: int(pythonwinsize[2]/2 - ewwidth/2)
exitwintitle = msg_Quit + "?"
ewwidth = 150
ewheight = 90
exitwindow=Buttonwin(5,
                     int(pythonwinsize[3]/2),
                     ewwidth,
                     ewheight,
                     1,
                     2,
                     exitwintitle,
                     0)
exitwindow.eventList[0][0]=10 #Event of first button of first row
exitwindow.eventList[0][1]=11 #Event of second button of first row
exitwindow.tooltipList[0][0]="%s" % (msg_Yes)
exitwindow.captionList[0][0]="%s" % (msg_Yes)
exitwindow.tooltipList[0][1]="%s" % (msg_No)
exitwindow.captionList[0][1]="%s" % (msg_No)
# --------- exitwindow: end

# --------- statuswindow: begin
statuswintitle = msg_Status
swwidth = 250
swheight = 50
statuswindow = Statuswin(5, int(swheight + 5), swwidth, swheight, msg_Ready, statuswintitle,0)
# --------- statuswindow: end

# --------- aboutwindow: begin
aboutwintitle = msg_About
awwidth = 330
awheight = 200
aboutwindow = MultilineMessagewin(5,
                                  int(pythonwinsize[3]/2 + awheight/2),
                                  awwidth,
                                  awheight,
                                  msg_AboutMsg,
                                  aboutwintitle,
                                  12,
                                  0)
# --------- aboutwindow: end

# --------- missingfeaturewindow: begin
missingfeaturewintitle = msg_Alert
awwidth = 330
awheight = 80
missingfeaturewindow = Messagewin(5,
                                  int(pythonwinsize[3]/2 + awheight/2),
                                  awwidth,
                                  awheight,
                                  msg_MissingFeature,
                                  missingfeaturewintitle,
                                  13,
                                  0)
# --------- missingfeaturewindow: end

# --------- libwindow: begin
#Libwin(LocX, LocY, Width, Height, numLines, Files, Title, okEvent, escEvent, upEvent, downEvent, modifyEvent, showEvent, Deco):
modlibwintitle = msg_ModLib
mlwwidth = 400
mlwheight = 300
modlist = loadRadLib(os.path.join(brad_path, "brad", "radiance", "mod"))
try:
   modlist.sort()
except:
   pass
numLines = 3
modlibwindow = Libwin(5,
                      int(pythonwinsize[3]/2 + mlwheight/2),
                      mlwwidth,
                      mlwheight,
                      numLines,
                      os.path.join("brad","radiance","mod"),
                      modlibwintitle,
                      14,
                      "",
                      15,
                      16,
                      10000,
                      11000,
                      12000,
                      0)
#okEvent = 14
#escEvent =
#upEvent = 15
#downEvent = 16
#base showEvent = 10000
#base addEvent =11000
#base modifyEvent =12000
# --------- libwindow: end

# --------- parameterswindow: begin
parwintitle = msg_Parameters
pwwidth = 400
pwheight = 300
parwindow = Parameterswin(5,
                          int(pythonwinsize[3]/2 + pwheight/2),
                          pwwidth,
                          pwheight,
                          parwintitle,
                          17,
                          0,
                          0)
# --------- parameterswindow: end

# --------- radparameterswindow: begin
radparwintitle = msg_RadPar
radpwwidth = 400
radpwheight = 300
radparwindow = RadParameterswin(5,
                                int(pythonwinsize[3]/2 + radpwheight/2),
                                radpwwidth,
                                radpwheight,
                                radparwintitle,
                                18,
                                0,
                                0)
# --------- radparameterswindow: end

# --------- exportwindow: begin
exportwintitle = msg_ExportSettings
exportwidth = 400
exportwheight = 350
exportwindow = ExportSettingswin(5,
                                 int(pythonwinsize[3]/2 + exportwheight/2),
                                 int(exportwidth),
                                 int(exportwheight),
                                 exportwintitle,
                                 25,
                                 0,
                                 0)
# --------- exportwindow: end

# --------- questionwindow: begin
# this window is an empty container for any question the gui may have to ask
qwwidth = 500
qwheight = 100
questionwindow = Questionwin(5,
                             int(pythonwinsize[3]/2 + qwheight/2),
                             qwwidth,
                             qwheight,
                             [""],
                             "",
                             0, "",
                             0, "",
                             0, "",
                             0)
# --------- questionwindow: end

# --------- locationwindow: begin
lwwidth = 500
lwheight = 200
locationwindow = Locationwin(5,
                             int(pythonwinsize[3]/2 + lwheight/2),
                             lwwidth,
                             lwheight,
                             msg_Location,
                             34,
                             0)
# --------- locationwindow: end

# --------- timewindow: begin
twwidth = 500
twheight = 200
timewindow = SimTimewin(5,
                        int(pythonwinsize[3]/2 + twheight/2),
                        twwidth,
                        twheight,
                        msg_Time,
                        36,
                        0)
# --------- timewindow: end

# --------- skyweatherwindow: begin
swwidth = 500
swheight = 360
skyweatherwindow = SkyWeatherwin(5,
                                 int(pythonwinsize[3]/2 + swheight/2),
                                 swwidth,
                                 swheight,
                                 msg_Weather,
                                 39,
                                 0,
                                 locationwindow,
                                 timewindow)
# --------- skyweatherwindow: end

# --------- progprefwindow: begin
ppwwidth = 500
ppwheight = 270
progprefwindow = ProgPreferenceswin(5,
                                    int(pythonwinsize[3]/2 + ppwheight/2),
                                    ppwwidth,
                                    ppwheight,
                                    msg_Preferences,
                                    44,
                                    0)
# --------- progprefwindow: end

# --------- calculatewindow: begin
calculatewintitle = msg_StartNumbers
calculatewidth = 400
calculatewheight = 200
calculatewindow = CalculateSettingswin(5,
                                       int(pythonwinsize[3]/2 + calculatewheight/2),
                                       calculatewidth,
                                       calculatewheight,
                                       calculatewintitle,
                                       45,
                                       46,
                                       0)
# --------- calculatewindow: end

# --------- importwindow: begin
importwintitle = msg_ImportRad
importwidth = 400
importwheight = 120
importwindow = Importwin(5,
                         int(pythonwinsize[3]/2 + importwheight/2),
                         importwidth,
                         importwheight,
                         importwintitle,
                         47,
                         48,
                         53,
                         0)
# --------- importwindow: end

# --------- lumlibwindow: begin
#LumLibwin(LocX, LocY, Width, Heigth, numLines, libdir, Title, okEvent, escEvent, upEvent, downEvent, showEvent, addEvent, modifyEvent, Deco)
modlibwintitle = msg_LumLib
mlwwidth = 400
mlwheight = 300
lumlist = loadRadLib(os.path.join(brad_path, "brad", "radiance", "lum"))
try:
   lumlist.sort()
except:
   pass
numLines = 3
lumlibwindow = LumLibwin(5,
                      int(pythonwinsize[3]/2 + mlwheight/2),
                      mlwwidth,
                      mlwheight,
                      numLines,
                      os.path.join("brad","radiance","lum"),
                      modlibwintitle,
                      49,
                      "",
                      50,
                      51,
                      13000,
                      14000,
                      15000,
                      0)
#okEvent = 14
#escEvent =
#upEvent = 15
#downEvent = 16
#base showEvent = 10000
#base addEvent =11000
#base modifyEvent =12000
# --------- lumlibwindow: end

# --- gui windows definitions: end

# --- gui functions: begin
def setImportName(filename):
    importwindow.importfilename.val = filename

def setEditor(filename):
    progprefwindow.EditorPath.val = filename
    registered_data = Blender.Registry.GetKey('brad')
    registered_data['editor_path'] = filename
    Blender.Registry.SetKey('brad', registered_data)

def updateEditor():
    registered_data = Blender.Registry.GetKey('brad')
    registered_data['editor_path'] = progprefwindow.EditorPath.val
    Blender.Registry.SetKey('brad', registered_data)

def setTextureConverter(filename):
    progprefwindow.TextureConverterPath.val = filename
    registered_data = Blender.Registry.GetKey('brad')
    registered_data['convert_path'] = filename
    Blender.Registry.SetKey('brad', registered_data)

def updateTextureConverter():
    registered_data = Blender.Registry.GetKey('brad')
    registered_data['convert_path'] = progprefwindow.TextureConverterPath.val
    Blender.Registry.SetKey('brad', registered_data)

def updateDebug():
    registered_data = Blender.Registry.GetKey('brad')
    registered_data['debug'] = progprefwindow.Debug.val
    Blender.Registry.SetKey('brad', registered_data)

def setLanguage():
    registered_data = Blender.Registry.GetKey('brad')
    registered_data['lang'] = msg_LanguagesIDs[progprefwindow.Language.val]
    Blender.Registry.SetKey('brad', registered_data)
    #from brad_i18n import *

def updatePrefs():
    registered_data = Blender.Registry.GetKey('brad')
    registered_data['debug'] = progprefwindow.Debug.val
    registered_data['convert_path'] = progprefwindow.TextureConverterPath.val
    registered_data['editor_path'] = progprefwindow.EditorPath.val
    registered_data['lang'] = msg_LanguagesIDs[progprefwindow.Language.val]
    registered_data['radiance_binaries_path'] = progprefwindow.RadianceBinariesPath.val
    registered_data['radiance_library_path']  = progprefwindow.RadianceLibraryPath.val
    registered_data['export_path'] = progprefwindow.ExportPath.val
    Blender.Registry.SetKey('brad', registered_data)

def saveConfiguration():
  try:
    if configparserok:
       registered_data = Blender.Registry.GetKey('brad')
       cfg = ConfigParser.ConfigParser()
       cfg.add_section('Preferences')
       for k, v in registered_data.iteritems():
          # do not save runtime variables
          if k!='blender_file_path' and k!='blender_file_name' and k!='configparserok' and k!='brad_path':
             cfg.set('Preferences',str(k),str(v))
       if debug:
          print "Writing configuration to file ",os.path.join(config_path,"bpydata","brad.cfg")
       cfgfile = open(os.path.join(config_path,"bpydata","brad.cfg"), "w+")
       cfg.write(cfgfile)
       statuswindow.msg = msg_ConfigFileWritten
  except:
    statuswindow.msg = msg_ConfigFileNotWritten

def getStatuswindow():
    return statuswindow

def guiList():
    global listWind
    # append the windows to the list of objects to be drawn
    listWind.append(m)
    listWind.append(statuswindow)
    listWind.append(progprefwindow)
    listWind.append(exportwindow)
    listWind.append(modlibwindow)
    listWind.append(lumlibwindow)
    listWind.append(parwindow)
    listWind.append(radparwindow)
    listWind.append(locationwindow)
    listWind.append(timewindow)
    listWind.append(skyweatherwindow)
    listWind.append(calculatewindow)
    listWind.append(importwindow)
    listWind.append(aboutwindow)
    listWind.append(questionwindow)
    listWind.append(missingfeaturewindow)
    listWind.append(exitwindow)

def maingui():
    global listWind
    bg.setBGColor(0.75,0.80,0.75)
    for wind in listWind:
        if wind.isSelected == 1:
            wind.LocX=X+deltaX
            wind.LocY=Y+deltaY
            wind.detailVisibility=0
        else:
            wind.detailVisibility=1
    for wind in listWind:
        wind.drawIt()

def mainguievent(evt, val):
    global X,Y,deltaX,deltaY,refresh_time,refreshOnOff
    if (evt == ESCKEY and not val):
            listWind[listWind.index(exitwindow)].Visibility=1
            Draw()
    if evt == LEFTMOUSE:
            lastClick=0
            if val == 1:
                l=mouse.testAndMove(listWind,X,Y)
                if l: deltaX=l[0]; deltaY=l[1]
                refreshOnOff=1;Draw()
                mouse.alreadyDeselect=0
            if val == 0:
                mouse.deselectAll(listWind)
                refreshOnOff=0
    if evt == RIGHTMOUSE:
            if val == 1:
                r=mouse.expandTest(listWind,X,Y)
                Draw()
    if evt == MOUSEX:
                global X
                refresh_time=refresh_time+1;
                if refresh_time >= REFRESH_MAX_VAL and refreshOnOff==1:refresh_time=0;Draw()
                X = mouse.CalcXMousePos(val)
    if evt == MOUSEY:
                global Y
                refresh_time=refresh_time+1;
                if refresh_time >= REFRESH_MAX_VAL and refreshOnOff==1:refresh_time=0;Draw()
                Y=mouse.CalcYMousePos(val)

# events associated with commands
def mainguibevent(evt):
    global listWind
    # simply execute the Blender draw routine
    if   (evt == 0):
            Draw()
    # menu commands events: begin
    if   (evt == 1):
            # check the val of the first menu: program
            if m.menuList[0].val==1:
                #preferences
                listWind[listWind.index(progprefwindow)].Visibility=1
                Draw()
            if m.menuList[0].val==2:
                #help
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[0].val==3:
                #about
                listWind[listWind.index(aboutwindow)].Visibility=1
                Draw()
            if m.menuList[0].val==4:
                #quit
                listWind[listWind.index(exitwindow)].Visibility=1
                Draw()
    if   (evt == 2):
            # check the val of the second menu: export
            if m.menuList[1].val==1:
                #export settings
                listWind[listWind.index(exportwindow)].Visibility=1
                Draw()
            if m.menuList[1].val==2:
                #export current frame, according to the export settings
                rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                     statuswindow,
                                     exportwindow,
                                     parwindow,
                                     radparwindow,
                                     timewindow,
                                     locationwindow,
                                     skyweatherwindow,
                                     calculatewindow,
                                     importwindow)
                scene = Blender.Scene.getCurrent()
                rad.exportCurrentFrame(scene)
                Draw()

                # export selected camera, but if the selected object is not
                # a camera, export _current_ camera
                #rad = Radiance(blender_data[2], blender_data[0], statuswindow, exportwindow, parwindow, radparwindow)
                #probablecameras = Blender.Object.GetSelected()
                #cameratype = probablecameras[0].getType()
                #if cameratype == "Camera":
                #   camera = probablecameras[0]
                #else:
                #   camera = Blender.Scene.getCurrent().getCurrentCamera()
                #rad.writeSelectedCamera(camera)

            if m.menuList[1].val==3:
                #export animation (selected frame interval), according to the export settings
                rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                     statuswindow,
                                     exportwindow,
                                     parwindow,
                                     radparwindow,
                                     timewindow,
                                     locationwindow,
                                     skyweatherwindow,
                                     calculatewindow,
                                     importwindow)
                scene = Blender.Scene.getCurrent()
                rad.exportAnimation(scene)
                Draw()
            if m.menuList[1].val==4:
                # camera settings
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[1].val==5:
                #export the selected item as VTK PolyData
                rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                     statuswindow,
                                     exportwindow,
                                     parwindow,
                                     radparwindow,
                                     timewindow,
                                     locationwindow,
                                     skyweatherwindow,
                                     calculatewindow,
                                     importwindow)
                object = Blender.Object.GetSelected()[0]
                if object.getType() == "Mesh":
                   meshdata = object.getData()
                   mesh = Blender.NMesh.GetRaw(meshdata.name)
                   rad.writeVtkPolydata(mesh, object)
                Draw()
            if m.menuList[1].val==6:
                #export the selected item as a Radiance grid of points
                rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                     statuswindow,
                                     exportwindow,
                                     parwindow,
                                     radparwindow,
                                     timewindow,
                                     locationwindow,
                                     skyweatherwindow,
                                     calculatewindow,
                                     importwindow)
                object = Blender.Object.GetSelected()[0]
                if object.getType() == "Mesh":
                   rad.writeGrid(object)
                Draw()
            if m.menuList[1].val==7:
                #import .rad file
                listWind[listWind.index(importwindow)].Visibility=1
                Draw()
            if m.menuList[1].val==8:
                #export selected luminaires
                rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                     statuswindow,
                                     exportwindow,
                                     parwindow,
                                     radparwindow,
                                     timewindow,
                                     locationwindow,
                                     skyweatherwindow,
                                     calculatewindow,
                                     importwindow)
                objects = Blender.Object.GetSelected()
                rad.exportLuminairesPositionsDXF(objects)
                Draw()

    if   (evt == 3):
            # check the val of the third menu: libraries
            if m.menuList[2].val==1:
                #modifiers library
                listWind[listWind.index(modlibwindow)].Visibility=1
                Draw()
            if m.menuList[2].val==2:
                #lamps library
                listWind[listWind.index(lumlibwindow)].Visibility=1
                Draw()
            if m.menuList[2].val==3:
                #object instances library
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[2].val==4:
                #parametric objects library
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[2].val==5:
                #weather library
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
    if   (evt == 4):
            # check the val of the fourth menu: simulation
            if m.menuList[3].val==1:
                #set location
                listWind[listWind.index(locationwindow)].Visibility=1
                Draw()
            if m.menuList[3].val==2:
                #set simulation time
                listWind[listWind.index(timewindow)].Visibility=1
                Draw()
            if m.menuList[3].val==3:
                #set weather (sky+ground)
                listWind[listWind.index(skyweatherwindow)].Visibility=1
                Draw()
            if m.menuList[3].val==4:
                #simulation parameters
                listWind[listWind.index(parwindow)].Visibility=1
                Draw()
            if m.menuList[3].val==5:
                #start interactive rendering (rview)
                #show question window
                """
                questionwindow.title=msg_StartInteractive
                questionwindow.msg[0]=msg_ExportCurrentFrameQuestion
                questionwindow.yesE=31
                questionwindow.noE=32
                questionwindow.cancelE=33
                questionwindow.yesL=msg_ExportRender
                questionwindow.noL=msg_Render
                questionwindow.cancelL=msg_Cancel
                listWind[listWind.index(questionwindow)].Visibility=1
                #listWind[listWind.index(missingfeaturewindow)].Visibility=1
                """
                options = msg_ExportCurrentFrameQuestion+"%t|"+msg_Yes+"%x31|" +msg_No+"%x32|" +msg_Cancel+"%x33|"
                result = Blender.Draw.PupMenu(options)
                if result==31:
                  # export the scene and launch interactive rendering
                  #listWind[listWind.index(questionwindow)].Visibility=0
                  rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                 statuswindow,
                                 exportwindow,
                                 parwindow,
                                 radparwindow,
                                 timewindow,
                                 locationwindow,
                                 skyweatherwindow,
                                 calculatewindow,
                                 importwindow)
                  scene = Blender.Scene.getCurrent()
                  rad.renderInteractive(scene, 1)

                if result==32:
                  # launch interactive rendering without exporting the scene
                  #listWind[listWind.index(questionwindow)].Visibility=0
                  rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                 statuswindow,
                                 exportwindow,
                                 parwindow,
                                 radparwindow,
                                 timewindow,
                                 locationwindow,
                                 skyweatherwindow,
                                 calculatewindow,
                                 importwindow)
                  scene = Blender.Scene.getCurrent()
                  rad.renderInteractive(scene, 0)
                Draw()

            if m.menuList[3].val==6:
                #show calculate window
                listWind[listWind.index(calculatewindow)].Visibility=1
                Draw()
            if m.menuList[3].val==7:
                #start picture rendering (rpict)
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[3].val==8:
                #start daylight coefficients calculation
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[3].val==9:
                #start holodeck rendering (rholo)
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
    if   (evt == 5):
            # check the val of the fifth menu: analisys
            if m.menuList[4].val==1:
                #getinfo
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[4].val==2:
                #falsecolour
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[4].val==3:
                #glare
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
            if m.menuList[4].val==4:
                #picture conversion
                listWind[listWind.index(missingfeaturewindow)].Visibility=1
                Draw()
    # menu commands events: end

    # exit from program
    if   (evt == 10):
            # delete the listWind array and exit from program
            del listWind
            Exit()

    if   (evt == 11):
            # don't exit from program and hide exit window
            listWind[listWind.index(exitwindow)].Visibility=0
            Draw()

    if   (evt == 12):
            # hide about window
            listWind[listWind.index(aboutwindow)].Visibility=0
            Draw()
    if   (evt == 13):
            # hide missingfeature window
            listWind[listWind.index(missingfeaturewindow)].Visibility=0
            Draw()
    if   (evt == 14):
            # hide modifier library window
            listWind[listWind.index(modlibwindow)].Visibility=0
            Draw()
    if   (evt == 15):
            # scroll up modifier library window
            modlibwindow.scrollUp()
            Draw()
    if   (evt == 16):
            # scroll down modifier library window
            modlibwindow.scrollDown()
            Draw()
    if   (evt == 17):
            # hide simulation parameters window
            listWind[listWind.index(parwindow)].Visibility=0
            Draw()
    if   (evt == 18):
            # hide rad parameters window
            listWind[listWind.index(radparwindow)].Visibility=0
            # show simulation parameters window
            listWind[listWind.index(parwindow)].Visibility=1
            Draw()
    if   (evt == 19):
            # hide simulation parameters window
            listWind[listWind.index(parwindow)].Visibility=0
            # show rad parameters window
            listWind[listWind.index(radparwindow)].Visibility=1
            Draw()
    if   (evt == 20):
            # hide rad zone parameters
            # to be written
            pass
    if   (evt == 21):
            # toggle basic rendering
            parwindow.enableRad()
            Draw()
    if   (evt == 22):
            # toggle advanced rendering
            parwindow.enableMake()
            Draw()
    if   (evt == 23):
            # toggle export selected
            exportwindow.enableExportSelected()
            Draw()
    if   (evt == 24):
            # toggle export layers
            exportwindow.enableExportLayers()
            Draw()
    if   (evt == 25):
            # hide export window
            listWind[listWind.index(exportwindow)].Visibility=0
            Draw()
    if   (evt == 26):
            # select all layers
            exportwindow.selectAllLayers()
            Draw()
    if   (evt == 27):
            # unselect all layers
            exportwindow.unselectAllLayers()
            Draw()
    if   (evt == 28):
            # select export static geometry
            exportwindow.enableExportStaticGeometry()
            Draw()
    if   (evt == 29):
            # select export dynamic geometry
            exportwindow.enableExportDynamicGeometry()
            Draw()
    if   (evt == 30):
            # get bounding box from selected object
            try:
               object = Blender.Object.GetSelected()[0]
               getBBox(object, parwindow, statuswindow)
            except:
               statuswindow.msg=msg_NoSelectedObject
            Draw()
    if   (evt == 31):
            # export the scene and launch interactive rendering
            listWind[listWind.index(questionwindow)].Visibility=0
            rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                 statuswindow,
                                 exportwindow,
                                 parwindow,
                                 radparwindow,
                                 timewindow,
                                 locationwindow,
                                 skyweatherwindow,
                                 calculatewindow,
                                 importwindow)
            scene = Blender.Scene.getCurrent()
            rad.renderInteractive(scene, 1)

    if   (evt == 32):
            # launch interactive rendering without exporting the scene
            listWind[listWind.index(questionwindow)].Visibility=0
            rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                 statuswindow,
                                 exportwindow,
                                 parwindow,
                                 radparwindow,
                                 timewindow,
                                 locationwindow,
                                 skyweatherwindow,
                                 calculatewindow,
                                 importwindow)
            scene = Blender.Scene.getCurrent()
            rad.renderInteractive(scene, 0)

    if   (evt == 33):
            # hide question window
            listWind[listWind.index(questionwindow)].Visibility=0
            Draw()

    if   (evt == 34):
            # hide location window
            listWind[listWind.index(locationwindow)].Visibility=0
            Draw()

    if   (evt == 35):
            # update location according to menu selection
            locationwindow.updateLocation()
            Draw()

    if   (evt == 36):
            # hide simulationtime window
            listWind[listWind.index(timewindow)].Visibility=0
            Draw()

    if   (evt == 37):
            # update number of frames in simulationtime window
            timewindow.updateFrames()
            Draw()

    if   (evt == 38):
            # select a specific modifier
            modlibwindow.selectItem()
            Draw()

    if   (evt == 39):
            # hide skyweather window
            listWind[listWind.index(skyweatherwindow)].Visibility=0
            Draw()

    if   (evt == 40):
            # update colours
            skyweatherwindow.updateColours()
            Draw()

    if   (evt == 41):
            # normalise sky colour
            skyweatherwindow.normaliseSkyColour()
            Draw()

    if   (evt == 42):
            # normalise ground color
            skyweatherwindow.normaliseGroundColour()
            Draw()

    if   (evt == 43):
            # test sky
            skyweatherwindow.testSky()
            Draw()

    if   (evt == 44):
            # hide program preferences window
            listWind[listWind.index(progprefwindow)].Visibility=0
            Draw()

    if   (evt == 45):
            # calculate grids
            #start quantitative rendering (rtrace)
            rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                 statuswindow,
                                 exportwindow,
                                 parwindow,
                                 radparwindow,
                                 timewindow,
                                 locationwindow,
                                 skyweatherwindow,
                                 calculatewindow,
                                 importwindow)
            scene = Blender.Scene.getCurrent()
            if (listWind[listWind.index(calculatewindow)].calculationType.val==0):
               # calculate scalar values
               rad.calculateGrids(scene)
               rad.updateGrids(scene)
            elif (listWind[listWind.index(calculatewindow)].calculationType.val==1):
               # calculate vector values
               rad.calculateGridsVectors(scene)
            listWind[listWind.index(calculatewindow)].Visibility=0
            Draw()


    if   (evt == 46):
            # hide calculate window
            listWind[listWind.index(calculatewindow)].Visibility=0
            Draw()

    if   (evt == 47):
            # import file
            rad = Radiance(progprefwindow.ExportPath.val, exportwindow.ExportFilename.val,
                                     statuswindow,
                                     exportwindow,
                                     parwindow,
                                     radparwindow,
                                     timewindow,
                                     locationwindow,
                                     skyweatherwindow,
                                     calculatewindow,
                                     importwindow)
            rad.importRad()
            listWind[listWind.index(importwindow)].Visibility=0
            Draw()

    if   (evt == 48):
            # hide import window
            listWind[listWind.index(importwindow)].Visibility=0
            Draw()

    if   (evt == 49):
            # hide luminaires library window
            listWind[listWind.index(lumlibwindow)].Visibility=0
            Draw()
    if   (evt == 50):
            # scroll up luminaires library window
            lumlibwindow.scrollUp()
            Draw()
    if   (evt == 51):
            # scroll down luminaires library window
            lumlibwindow.scrollDown()
            Draw()

    if   (evt == 52):
            # select a specific luminaire
            lumlibwindow.selectItem()
            Draw()

    if   (evt == 53):
            # select a rad file to be imported
            Blender.Window.FileSelector(setImportName, msg_ImportRad, importwindow.importfilename.val)

    if   (evt == 54):
            # select the editor command
            Blender.Window.FileSelector(setEditor, msg_EditorPath, progprefwindow.EditorPath.val)

    if   (evt == 55):
            # select language
            setLanguage()

    if   (evt == 56):
            # select the texture converter program
            Blender.Window.FileSelector(setTextureConverter, msg_TextureConverterPath, progprefwindow.TextureConverterPath.val)

    if   (evt == 57):
            # save configuration
            saveConfiguration()

    if   (evt == 58):
            # update preferences in Blender registry
            updatePrefs()


    if   (evt >= 10000) and (evt <= 10999):
            # modlib show events
            createModPreview(os.path.join(brad_path, "brad", "radiance", "mod"), str(modlist[evt-10000]))
    if   (evt >= 11000) and (evt <= 11999):
            # modlib add events
            addMod(os.path.join(brad_path, "brad", "radiance", "mod"), str(modlist[evt-11000]))
    if   (evt >= 12000) and (evt <= 12999):
            # modlib modify events
            os.system(progprefwindow.EditorPath.val + " " + os.path.join(brad_path, "brad", "radiance", "mod", str(modlist[evt-12000]), str(modlist[evt-12000]) + ".rad"))
            Draw()
            #print "modify " + str(modlist[evt-12000])

    if   (evt >= 13000) and (evt <= 13999):
            # modlib show events
            #createLumPreview(os.path.join(brad_path, "brad", "radiance", "lum"), str(lumlist[evt-13000]))
            pass
    if   (evt >= 14000) and (evt <= 14999):
            # lumlib add events
            addLum(os.path.join(brad_path, "brad", "radiance", "lum"), str(lumlist[evt-14000]))
            pass
    if   (evt >= 15000) and (evt <= 15999):
            # lumlib modify events
            if os.path.exists(os.path.join(brad_path, "brad", "radiance", "lum", str(lumlist[evt-15000]), str(lumlist[evt-15000]) + ".rad")):
               os.system(progprefwindow.EditorPath.val + " " + os.path.join(brad_path, "brad", "radiance", "lum", str(lumlist[evt-15000]), str(lumlist[evt-15000]) + ".rad"))
            if os.path.exists(os.path.join(brad_path, "brad", "radiance", "lum", str(lumlist[evt-15000]), str(lumlist[evt-15000]) + ".dat")):
               os.system(progprefwindow.EditorPath.val + " " + os.path.join(brad_path, "brad", "radiance", "lum", str(lumlist[evt-15000]), str(lumlist[evt-15000]) + ".dat"))
            if os.path.exists(os.path.join(brad_path, "brad", "radiance", "lum", str(lumlist[evt-15000]), str(lumlist[evt-15000]) + ".ies")):
               os.system(progprefwindow.EditorPath.val + " " + os.path.join(brad_path, "brad", "radiance", "lum", str(lumlist[evt-15000]), str(lumlist[evt-15000]) + ".ies"))
            Draw()
            #print "modify " + str(modlist[evt-12000])

# --- gui functions: end

# gui: end

if not 0:
  # read config data and set global variables according to them
  try:
      print "\n --- blended_radiance v%s --- \n" % msg_Version

      # import psyco
      try:
        import psyco
        psyco.full()
      except ImportError:
        print "failed to initialise psyco"

      global X,Y,refresh_time,listWind
      global REFRESH_MAX_VAL;REFRESH_MAX_VAL=10
      X,Y,refresh_time,refreshOnOff=0,0,0,0
      deltaX,deltaY=0,0
      listWind=[]

      # build the window list
      guiList()
      # register the user interface
      Register(maingui, mainguievent, mainguibevent)
      # set windows initial visibility
      listWind[listWind.index(exitwindow)].Visibility=0
      listWind[listWind.index(aboutwindow)].Visibility=0
      listWind[listWind.index(missingfeaturewindow)].Visibility=0
      listWind[listWind.index(modlibwindow)].Visibility=0
      listWind[listWind.index(lumlibwindow)].Visibility=0
      listWind[listWind.index(parwindow)].Visibility=0
      listWind[listWind.index(radparwindow)].Visibility=0
      listWind[listWind.index(locationwindow)].Visibility=0
      listWind[listWind.index(timewindow)].Visibility=0
      listWind[listWind.index(skyweatherwindow)].Visibility=0
      listWind[listWind.index(calculatewindow)].Visibility=0
      listWind[listWind.index(importwindow)].Visibility=0
      listWind[listWind.index(exportwindow)].Visibility=0
      listWind[listWind.index(progprefwindow)].Visibility=0
      listWind[listWind.index(questionwindow)].Visibility=0
  except:
      raise "internal error, sorry."
      Blender.ReleaseGlobalDict()

