""" brad: Radiance calculation settings
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import os.path

import Blender
from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *

class CalculateSettingswin(BaseWindowClass):

   def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, escEvent, Deco):

      BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

      self.type="CalculateSettingsWin"

      #self.Height = 110
      self.okE=okEvent
      self.escE=escEvent
      self.decoration=Deco
      self.title=Title

      self.valuesName = Create("illuminance")
      self.calculationType = Create(0)
      self.rtraceOptions = Create("-I+ -ab 0")
      self.postProcessOptions = Create("$1=($1*.265+$2*.67+$3*.065)*179")


   #-------------------------------------------#
   #    DRAWING THE BUTTONS                    #
   #-------------------------------------------#

   def drawIt(self):

      if self.Visibility==1:
         if self.decoration == 0:
            self.drawBox()
         else:
            self.drawBoxS()

         #values name
         rhb = 67 #button row vertical position
         self.valuesName = String(msg_valuesName+": ",21,self.LocX + 10, self.LocY-rhb,self.Width-30, 20,self.valuesName.val,256,msg_valuesName)
         #calculation type
         rhb = 91 #button row vertical position
         self.calculationType = Toggle(msg_calculationType[self.calculationType.val],0,self.LocX+10, self.LocY-rhb,(self.Width-30), 20,self.calculationType.val,msg_calculationType[self.calculationType.val])
         #rtrace options
         rhb = 115 #button row vertical position
         self.rtraceOptions = String(msg_rtraceOptions+": ",21,self.LocX + 10, self.LocY-rhb,self.Width-30, 20,self.rtraceOptions.val,256,msg_rtraceOptions)
         rhb = 139 #button row vertical position
         self.postProcessOptions = String(msg_postProcessOptions+": ",21,self.LocX + 10, self.LocY-rhb,self.Width-30, 20,self.postProcessOptions.val,256,msg_postProcessOptions)

         #calculate button
         Button(msg_StartNumbers,self.okE,self.LocX+10,self.LocY-self.Height+10,self.Width/3-6,20)

         #cancel button
         Button(msg_Cancel,self.escE,self.LocX+10+2*(self.Width/3-6),self.LocY-self.Height+10,self.Width/3-16,20)

         self.drawTitle(self.title)
         if self.isSelected == 1:
            self.drawBoxHF()


