""" brad: library browsing input

This class provides a movable window with a
custom number of string buttons and two default extra buttons
OK end ESC (you can set the okEvent and the escEvent in
the class declaration). After the window creation, the user
can access the single string by the self.string list.
For example, if you want a value of second string, you
write name_of_istance.string[1].val
The default tooltip is the index of string: you can use it
to access the string value.
Use this for string input. The numString is the number of string that you want
to see in the input windows. The Deco is a decoration type. Actually you can use
only 0 for simple and 1 for sketch style.
The buttons show the names of the items in the library.

"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import os.path
import string

from Blender.Draw import *

from BaseWindowClass import BaseWindowClass
from Picture import *

from brad_lib import *
from brad_i18n import *

registered_data = Blender.Registry.GetKey('brad')
if registered_data:
  brad_path  = registered_data['brad_path']

class Libwin(BaseWindowClass):


    def __init__(self, LocX, LocY, Width, Heigth, numLines, libdir, Title, okEvent, escEvent, upEvent, downEvent, showEvent, addEvent, modifyEvent, Deco):

        BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

        self.type="LibWin"

        self.libdir = os.path.join(brad_path, libdir)
        modlist = loadRadLib(os.path.join(brad_path, libdir))
        #print dir(modlist)
        modlist.sort()
        self.files=modlist
        self.numLines = numLines
        self.Height = 130+self.numLines*66
        self.okE=okEvent
        self.escE=escEvent
        self.upE=upEvent
        self.downE=downEvent
        self.decoration=Deco
        self.title=Title
        self.startItem = 0
        self.endItem = numLines
        self.showBaseE=showEvent
        self.modifyBaseE=modifyEvent
        self.addBaseE=addEvent
        self.showE = []
        self.modifyE = []
        self.addE = []

        if self.numLines > len(self.files):
            self.numLines=len(self.files)

        for i in range(len(self.files)):
                    evt = self.showBaseE+i
                    self.showE.append(self.showBaseE+i)

        for i in range(len(self.files)):
                    evt = self.modifyBaseE+i
                    self.modifyE.append(self.modifyBaseE+i)

        for i in range(len(self.files)):
                    evt = self.addBaseE+i
                    self.addE.append(self.addBaseE+i)

        self.SelectedItem = Create(0)

    #-------------------------------------------#
    #    DRAWING THE BUTTONS                    #
    #-------------------------------------------#

    def drawIt(self):

        if self.Visibility==1:
            if self.decoration == 0:
                self.drawBox()
            else:
                self.drawBoxS()

            #select
            rh = 50
            lib_list_string = self.formatItems(self.files)
            self.SelectedItem = Menu(self.title+" %t|"+lib_list_string, 38, self.LocX + 10, self.LocY-rh, self.Width/3-20, 20, self.SelectedItem.val, self.title)

            #upbutton
            Button("/\\",self.upE,self.LocX+10,self.LocY-70,self.Width-20,16)

            button_dy = 90
            j = 0
            dy = 66
            for i in range(self.startItem, self.endItem):
                modpicture = os.path.join(self.libdir, self.files[i], self.files[i]+".tga")
                try:
                  if os.path.exists(modpicture):
                                   pic = Picture(self.LocX+10,self.LocY-90-46-dy*j,modpicture, 64)
                                   pic.Alpha=0
                                   pic.Zoom=1
                                   pic.drawIt()
                except:
                  pass
                Button(self.files[i],
                    self.showE[i],
                    self.LocX+10+64+5,
                    self.LocY-90-47-dy*j,
                    self.Width-90-64-5,
                    dy-2, msg_UpdateModPreview)
                    #msg_UpdateModPreview+self.files[i])
                Button("+",
                    self.addE[i],
                    self.LocX+10+64+5 + self.Width-80-64-5 + 15,
                    self.LocY-90-47-dy*j,
                    20,
                    dy-2, msg_Add)
                    #msg_Select+self.files[i])
                Button(msg_Mod,
                    self.modifyE[i],
                    self.LocX+10+64+5 + self.Width-80-64-5 + 40,
                    self.LocY-90-47-dy*j,
                    20,
                    dy-2, msg_Modify)
                    #msg_Modify+self.files[i])
                button_dy += dy
                j += 1

            Button("\\/",self.downE,self.LocX+10,self.LocY-button_dy+2,self.Width-20,16)
            Button("OK",self.okE,self.LocX+10,self.LocY-button_dy-25,self.Width/3,20)
            if self.escE!="":
                Button("ESC",self.escE,self.LocX+self.Width-20-self.Width/3,self.LocY-button_dy-25,self.Width/3,20)
            else:
                self.drawText(self.LocX+self.Width-20-self.Width/3,
                    self.LocY-button_dy-20,
                    0,
                    0,
                    0,
                    "::"+str(len(self.files))+"::")

            self.drawTitle(self.title)
            if self.isSelected == 1:
                self.drawBoxHF()


    def scrollUp(self):
        if self.startItem > 0 :
            self.startItem -= 1
            self.endItem -= 1


    def scrollDown(self):
        if self.endItem < len(self.files) :
            self.startItem += 1
            self.endItem += 1

    def formatItems(self, itemlist):
       i=0
       itemmenu = ""
       for item in itemlist:
          itemmenu += string.split(item)[0] + " %x"+ str(i)+"|"
          i+=1
       return itemmenu

    def selectItem(self):
       #event 38
       if self.SelectedItem.val+2 < len(self.files) :
          self.startItem = self.SelectedItem.val-1
          self.endItem = self.SelectedItem.val+2
       else:
          self.startItem = self.SelectedItem.val-2
          self.endItem = self.SelectedItem.val+1

