""" set Radiance simulation parameters
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import os.path

from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *

class Parameterswin(BaseWindowClass):

	def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, escEvent, Deco):

		BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

		self.type="ParametersWin"

		#self.Height = 110
		self.okE=okEvent
		self.escE=escEvent
		self.decoration=Deco
		self.title=Title

                self.RenderMake = Create(0)
                self.RenderRad = Create(1)

                self.ZoneInterior = Create(1)
                self.ZoneMinX = Create(-1.0)
                self.ZoneMaxX = Create(1.0)
                self.ZoneMinY = Create(-1.0)
                self.ZoneMaxY = Create(1.0)
                self.ZoneMinZ = Create(-1.0)
                self.ZoneMaxZ = Create(1.0)

                self.Quality = Create(0)
                self.Variability = Create(0)
                self.Detail = Create(0)

                self.Penumbras = Create(0)
                self.Indirect = Create(0)
                self.PictureResolutionX = Create(512)
                self.PictureResolutionY = Create(512)

	#-------------------------------------------#
	#    DRAWING THE BUTTONS                    #
	#-------------------------------------------#

	def drawIt(self):

		if self.Visibility==1:
			if self.decoration == 0:
				self.drawBox()
			else:
				self.drawBoxS()

			#render process type (makefile or rad)
                        """
                        rht = 45 #text row vertical position
                        rhb = 67 #button row vertical position
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_BasicRendering)
                        self.RenderRad = Toggle("",21,self.LocX + 10, self.LocY-rhb,(self.Width-20)/2-6, 20,self.RenderRad.val,msg_BasicRendering)
                        self.drawText(self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rht, 0, 0, 0, msg_AdvancedRendering)
                        self.RenderMake=Toggle("",22,self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rhb,(self.Width-20)/2-6, 20,self.RenderMake.val,msg_AdvancedRendering)
                        """

                        #parameters buttons
                        rht = 70
                        rhb = 92
                        if self.RenderRad.val:
                           #Button(msg_RadZone,20,self.LocX+10,self.LocY-rhb,self.Width/3-6,20,msg_RadZone)
                           self.drawText(self.LocX+10,self.LocY-rhb+5, 0, 0, 0, msg_RadZone)
                           Button(msg_RadPar,19,self.LocX+10 + (self.Width-20)/2-2,self.LocY-rhb,(self.Width-20)/2-6,20,msg_RadPar)
                           self.ZoneInterior = Toggle(msg_ZoneInterior[self.ZoneInterior.val],0,self.LocX+10, self.LocY-rhb-30,(self.Width-20)/3-6, 20,self.ZoneInterior.val,msg_ZoneInterior[self.ZoneInterior.val])

                           self.ZoneMinX = Number(msg_ZoneMinX,0,self.LocX+10, self.LocY-rhb-55,(self.Width-20)/3-6, 18,self.ZoneMinX.val,-65536.0,65536.0,msg_ZoneMinX)
                           self.ZoneMaxX = Number(msg_ZoneMaxX,0,self.LocX+10+(self.Width-20)/3-2, self.LocY-rhb-55,(self.Width-20)/3-6, 18,self.ZoneMaxX.val,-65536.0,65536.0,msg_ZoneMaxX)
                           Button(msg_GetBBox,30,self.LocX+10 + 2*((self.Width-20)/3-2),self.LocY-rhb-55,(self.Width-20)/3-6,18,msg_GetBBoxHint)
                           self.ZoneMinY = Number(msg_ZoneMinY,0,self.LocX+10, self.LocY-rhb-75,(self.Width-20)/3-6, 18,self.ZoneMinY.val,-65536.0,65536.0,msg_ZoneMinY)
                           self.ZoneMaxY = Number(msg_ZoneMaxY,0,self.LocX+10+(self.Width-20)/3-2, self.LocY-rhb-75,(self.Width-20)/3-6, 18,self.ZoneMaxY.val,-65536.0,65536.0,msg_ZoneMaxY)
                           self.ZoneMinZ = Number(msg_ZoneMinZ,0,self.LocX+10, self.LocY-rhb-95,(self.Width-20)/3-6, 18,self.ZoneMinZ.val,-65536.0,65536.0,msg_ZoneMinZ)
                           self.ZoneMaxZ = Number(msg_ZoneMaxZ,0,self.LocX+10+(self.Width-20)/3-2, self.LocY-rhb-95,(self.Width-20)/3-6, 18,self.ZoneMaxZ.val,-65536.0,65536.0,msg_ZoneMaxZ)

                           #quality variability detail menus
                           rht = 205 #text row vertical position
                           rhb = 227 #button row vertical position
                           self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_Quality)
                           self.Quality = Menu(msg_Quality+" %t|"+msg_High+" %x2|"+msg_Medium+" %x1|"+msg_Low+" %x0|", 0, self.LocX + 10, self.LocY-rhb, (self.Width-20)/3-6, 20, self.Quality.val, msg_Quality)
                           self.drawText(self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rht, 0, 0, 0, msg_Variability)
                           self.Variability = Menu(msg_Variability+" %t|"+msg_High+" %x2|"+msg_Medium+" %x1|"+msg_Low+" %x0|", 0, self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rhb, (self.Width-20)/3-6, 20, self.Variability.val, msg_Variability)
                           self.drawText(self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rht, 0, 0, 0, msg_Detail)
                           self.Detail = Menu(msg_Detail+" %t|"+msg_High+" %x2|"+msg_Medium+" %x1|"+msg_Low+" %x0|", 0, self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rhb, (self.Width-20)/3-6, 20, self.Detail.val, msg_Detail)

                           #penumbra menu + resolution and indirect textbuttons
                           rht = 239 #+12
                           rhb = 261 #+22
                           self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_Penumbras)
                           self.Penumbras=Toggle(msg_YesNo[self.Penumbras.val],0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/3-6, 20,self.Penumbras.val,msg_Penumbras)
                           #self.Penumbras = Menu(msg_Penumbras+" %t|"+msg_Yes+" %x1|"+msg_No+" %x0|", 0, self.LocX + 10, self.LocY-125, (self.Width-20)/3-6, 20, Penumbras, msg_Penumbras)
                           self.drawText(self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rht, 0, 0, 0, msg_Indirect)
                           self.Indirect=Number("",0,self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rhb,(self.Width-20)/3-6, 20,self.Indirect.val,0,8,msg_Indirect)
                           self.drawText(self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rht, 0, 0, 0, msg_Resolution)
                           self.PictureResolutionX=Number("x:",0,self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rhb,((self.Width-20)/3-6)/2, 20,self.PictureResolutionX.val,1,4096,msg_Resolution)
                           self.PictureResolutionY=Number("y:",0,self.LocX + 10 + 2*((self.Width-20)/3-2) + ((self.Width-20)/3-6)/2, self.LocY-rhb,((self.Width-20)/3-6)/2, 20,self.PictureResolutionY.val,1,4096,msg_Resolution)

                        else:
                           self.drawText(self.LocX+10,self.LocY-rhb, 0, 0, 0, msg_MissingFeature)

                        #ok button
                        Button(msg_Ok,self.okE,self.LocX+10,self.LocY-self.Height+10,self.Width/3-6,20)

			self.drawTitle(self.title)
			if self.isSelected == 1:
				self.drawBoxHF()


	def enableRad(self):
                #event 21
                if self.RenderRad.val:
                   self.RenderMake.val = 0
                else:
                   self.RenderMake.val = 1
                Draw()

        def enableMake(self):
                #event 22
                if self.RenderMake.val:
                   self.RenderRad.val = 0
                else:
                   self.RenderRad.val = 1
                Draw()
