""" brad: simulation time settings
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import os
import os.path
import string
import math
import time
import calendar

import Blender
from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *
from brad_lib import *

registered_data = Blender.Registry.GetKey('brad')
if registered_data:
  export_path  = registered_data['export_path']
  editor_path  = registered_data['editor_path']
  convert_path = registered_data['convert_path']
  lang = registered_data['lang']
  debug = registered_data['debug']
  radiance_binaries_path = registered_data['radiance_binaries_path']
  radiance_library_path = registered_data['radiance_library_path']

class ProgPreferenceswin(BaseWindowClass):

    def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, Deco):

        BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

        self.type="ProgPreferencesWin"

        #self.Height = 110
        self.okE=okEvent
        self.decoration=Deco
        self.title=Title

        self.ExportPath = Create(export_path)
        self.EditorPath = Create(editor_path)
        self.TextureConverterPath = Create(convert_path)
        self.RadianceBinariesPath = Create(radiance_binaries_path)
        self.RadianceLibraryPath = Create(radiance_library_path)

        langid=msg_LanguagesIDs.index(lang)
        self.Language = Create(langid)
        self.Debug = Create(int(debug))

    #-------------------------------------------#
    #    DRAWING THE BUTTONS                    #
    #-------------------------------------------#

    def drawIt(self):

      if self.Visibility==1:
        if self.decoration == 0:
                self.drawBox()
        else:
                self.drawBoxS()

        # export path
        rh = 50
        self.ExportPath = String(msg_ExportPath+": ",58,int(self.LocX) + 10, int(self.LocY)-rh,int(self.Width)-15, 20,self.ExportPath.val,399,msg_ExportPath)

        # radiance binaries path
        rh = 75
        self.RadianceBinariesPath = String(msg_RadianceBinariesPath+": ",58,int(self.LocX) + 10, int(self.LocY)-rh,int(self.Width)-15, 20,self.RadianceBinariesPath.val,399,msg_RadianceBinariesPath)

        # radiance libraries path
        rh = 100
        self.RadianceLibraryPath = String(msg_RadianceLibraryPath+": ",58,int(self.LocX) + 10, int(self.LocY)-rh,int(self.Width)-15, 20,self.RadianceLibraryPath.val,399,msg_RadianceLibraryPath)

        # editor path
        rh = 125
        self.EditorPath = String(msg_EditorPath+": ",58,int(self.LocX + 10), int(self.LocY-rh),int(self.Width-90), 20,self.EditorPath.val,399,msg_EditorPath)
        #browse button
        Button(msg_Browse,54,self.LocX+10 + self.Width-80 + 5,self.LocY-rh,60,20)

        # texture converter path
        rh = 150
        self.TextureConverterPath = String(msg_TextureConverterPath+": ",58,self.LocX + 10, self.LocY-rh,self.Width-90, 20,self.TextureConverterPath.val,399,msg_TextureConverterPath)
        #browse button
        Button(msg_Browse,56,self.LocX+10 + self.Width-80 + 5,self.LocY-rh,60,20)

        # language
        rh = 175
        self.Language = Menu(msg_Language+" %t|"+msg_Languages[0]+" %x0|"+msg_Languages[1]+" %x1|", 55, self.LocX + 10 , self.LocY-rh, self.Width-15, 20, self.Language.val, msg_Language)

        # debug
        rh = 200
        self.Debug = Toggle(msg_Debug[self.Debug.val],58,self.LocX + 10 , self.LocY-rh, self.Width-15, 20,self.Debug.val,"")

        #ok button
        Button(msg_Ok,self.okE,self.LocX+10,self.LocY-self.Height+10,int(self.Width/3-6),20)

        #save configuration button
        Button(msg_SaveConfiguration,57,self.LocX+10+2*int(self.Width/3-6)+5,self.LocY-self.Height+10,int(self.Width/3-6),20)

        self.drawTitle(self.title)
        if self.isSelected == 1:
            self.drawBoxHF()

